/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.preflight.PreflightCheckResult;
import com.atlassian.jira.migration.preflight.PreflightCheckResultEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u001e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/preflight/PreflightRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "createRecord", "Lcom/atlassian/jira/migration/preflight/PreflightCheckResultEntity;", "kotlin.jvm.PlatformType", "executionId", "", "checkId", "", "lastExecutionTime", "", "deletePreflightCheckResults", "", "findPreflightCheck", "findPreflightCheckResults", "", "Lcom/atlassian/jira/migration/preflight/PreflightCheckResult;", "toPreflightCheckResult", "entity", "upsertPreflightResult", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreflightRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightRepository.kt\ncom/atlassian/jira/migration/preflight/PreflightRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,89:1\n11065#2:90\n11400#2,3:91\n*S KotlinDebug\n*F\n+ 1 PreflightRepository.kt\ncom/atlassian/jira/migration/preflight/PreflightRepository\n*L\n31#1:90\n31#1:91,3\n*E\n"})
public final class PreflightRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public PreflightRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    public final void upsertPreflightResult(@NotNull String executionId, int checkId, long lastExecutionTime) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        PreflightCheckResultEntity preflightCheckResultEntity = this.findPreflightCheck(executionId, checkId);
        if (preflightCheckResultEntity != null) {
            PreflightCheckResultEntity it = preflightCheckResultEntity;
            boolean bl = false;
            it.setLastExecutionTime(lastExecutionTime);
            it.save();
        } else {
            this.createRecord(executionId, checkId, lastExecutionTime);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PreflightCheckResult> findPreflightCheckResults(@NotNull String executionId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object[] objectArray = new Object[]{executionId};
        RawEntity[] rawEntityArray = this.ao.find(PreflightCheckResultEntity.class, Query.select().where("EXECUTION_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$map$iv = rawEntityArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PreflightCheckResultEntity preflightCheckResultEntity = (PreflightCheckResultEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toPreflightCheckResult((PreflightCheckResultEntity)it));
        }
        return (List)destination$iv$iv;
    }

    public final void deletePreflightCheckResults(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object[] objectArray = new Object[]{executionId};
        this.ao.deleteWithSQL(PreflightCheckResultEntity.class, "EXECUTION_ID = ?", objectArray);
    }

    private final PreflightCheckResultEntity findPreflightCheck(String executionId, int checkId) {
        Object[] objectArray = new Object[]{executionId, checkId};
        RawEntity[] rawEntityArray = this.ao.find(PreflightCheckResultEntity.class, Query.select().where("EXECUTION_ID = ? AND CHECK_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (PreflightCheckResultEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }

    private final PreflightCheckResultEntity createRecord(String executionId, int checkId, long lastExecutionTime) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"CHECK_ID", (Object)checkId), TuplesKt.to((Object)"EXECUTION_ID", (Object)executionId), TuplesKt.to((Object)"LAST_EXECUTION_TIME", (Object)lastExecutionTime)};
        return (PreflightCheckResultEntity)this.ao.create(PreflightCheckResultEntity.class, MapsKt.mapOf((Pair[])pairArray));
    }

    private final PreflightCheckResult toPreflightCheckResult(PreflightCheckResultEntity entity) {
        return new PreflightCheckResult(entity.getCheckId(), entity.getExecutionId(), entity.getLastExecutionTime());
    }
}

