/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckExecutionStatus;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.ChecksResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.preflight.AppCheckResult;
import com.atlassian.jira.migration.preflight.AppVendorCheck;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckLookup;
import com.atlassian.jira.migration.preflight.PreflightStatusConverterKt;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J(\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0007J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\fH\u0007J*\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\"\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\"J\u0018\u0010\u001f\u001a\n \n*\u0004\u0018\u00010\f0\f2\u0006\u0010#\u001a\u00020$H\u0002J \u0010%\u001a\n \n*\u0004\u0018\u00010\f0\f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0002J\f\u0010&\u001a\u00020\u0018*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/preflight/PreflightStatusConverter;", "", "preflightCheckLookup", "Lcom/atlassian/jira/migration/preflight/PreflightCheckLookup;", "(Lcom/atlassian/jira/migration/preflight/PreflightCheckLookup;)V", "freeEditionChecks", "", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createRunningSharedEmailsCheckResult", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "getAppVendorCheckCSVFileName", "checkExecutionStatus", "Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;", "executionId", "appKey", "checkId", "getCSVFileName", "type", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "planName", "hasRunningFreeEditionCheck", "", "statuses", "isVisibleForClient", "checkResultDto", "toAppVendorCheckCSVMap", "", "toCSVMap", "toCheckResultDto", "Lcom/atlassian/cmpt/check/dto/ChecksResultDto;", "checksToOverride", "Ljava/util/EnumSet;", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "transformCheckToDto", "isRemovable", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreflightStatusConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightStatusConverter.kt\ncom/atlassian/jira/migration/preflight/PreflightStatusConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1549#2:151\n1620#2,3:152\n766#2:155\n857#2,2:156\n2634#2:158\n288#2,2:160\n288#2,2:163\n288#2,2:165\n288#2,2:167\n288#2,2:169\n1#3:159\n1#3:162\n*S KotlinDebug\n*F\n+ 1 PreflightStatusConverter.kt\ncom/atlassian/jira/migration/preflight/PreflightStatusConverter\n*L\n36#1:151\n36#1:152,3\n37#1:155\n37#1:156,2\n38#1:158\n48#1:160,2\n55#1:163,2\n79#1:165,2\n85#1:167,2\n115#1:169,2\n38#1:159\n*E\n"})
public final class PreflightStatusConverter {
    @NotNull
    private final PreflightCheckLookup preflightCheckLookup;
    @NotNull
    private final List<String> freeEditionChecks;
    private final Logger log;

    @Inject
    public PreflightStatusConverter(@NotNull PreflightCheckLookup preflightCheckLookup) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckLookup, (String)"preflightCheckLookup");
        this.preflightCheckLookup = preflightCheckLookup;
        Object[] objectArray = new String[]{"CloudFreeUserLimit", "JsmCloudFreeAgentLimit"};
        this.freeEditionChecks = CollectionsKt.listOf((Object[])objectArray);
        this.log = LoggerFactory.getLogger(PreflightStatusConverter.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChecksResultDto toCheckResultDto(@NotNull CheckExecutionStatus statuses, @NotNull EnumSet<CheckType> checksToOverride) {
        void $this$onEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        CheckResultDto it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)statuses, (String)"statuses");
        Intrinsics.checkNotNullParameter(checksToOverride, (String)"checksToOverride");
        List list = statuses.statuses;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statuses");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CheckStatus checkStatus = (CheckStatus)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.transformCheckToDto(statuses, (CheckStatus)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CheckResultDto p0 = (CheckResultDto)element$iv$iv;
            boolean bl = false;
            if (!this.isVisibleForClient(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = var6_5 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            it = (CheckResultDto)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            PreflightStatusConverterKt.updateOverrideStatus(it, checksToOverride);
        }
        List checks = (List)var6_5;
        return new ChecksResultDto(checks);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Map<String, Object> toCSVMap(@NotNull CheckExecutionStatus checkExecutionStatus, @NotNull CheckType type) {
        Object object;
        Object v1;
        Map<String, Object> map;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)checkExecutionStatus, (String)"checkExecutionStatus");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            List list = checkExecutionStatus.statuses;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statuses");
            map = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CheckStatus it = (CheckStatus)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.checkType, (Object)type.name())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        CheckStatus checkStatus = v1;
        if (checkStatus != null) {
            CheckStatus it = checkStatus;
            boolean bl = false;
            map = this.preflightCheckLookup.get(type).buildCSVMap(it);
            if (map != null) {
                object = map;
                return object;
            }
        }
        object = MapsKt.emptyMap();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> toAppVendorCheckCSVMap(@NotNull CheckExecutionStatus checkExecutionStatus, @NotNull String appKey, @NotNull String checkId) {
        Object object;
        block13: {
            block10: {
                AppCheckResult appCheckResult;
                Map checkIdMap;
                CheckStatus it;
                Object it2;
                block12: {
                    block11: {
                        Object v1;
                        block9: {
                            void $this$firstOrNull$iv;
                            Intrinsics.checkNotNullParameter((Object)checkExecutionStatus, (String)"checkExecutionStatus");
                            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
                            Intrinsics.checkNotNullParameter((Object)checkId, (String)"checkId");
                            List list = checkExecutionStatus.statuses;
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statuses");
                            Iterable iterable = list;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it2 = (CheckStatus)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it2.checkType, (Object)"AppVendorCheck")) continue;
                                v1 = element$iv;
                                break block9;
                            }
                            v1 = null;
                        }
                        if ((object = (CheckStatus)v1) == null) break block10;
                        it = object;
                        boolean bl = false;
                        if (it.checkResult == null) break block11;
                        CheckResult checkResult = it.checkResult;
                        Intrinsics.checkNotNull((Object)checkResult, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult");
                        if (((NotBlockingCheckResult)checkResult).getHasWarnings() && !it.checkResult.details.isEmpty()) break block12;
                    }
                    return MapsKt.emptyMap();
                }
                it2 = it.checkResult.details.get(appKey);
                Map map = checkIdMap = it2 instanceof Map ? (Map)it2 : null;
                if (checkIdMap == null) {
                    this.log.warn("Unable to generate AppVendorCheck csv map for non-existent appKey: {}", (Object)appKey);
                }
                Map map2 = checkIdMap;
                AppCheckResult appCheckResult2 = appCheckResult = map2 != null ? (AppCheckResult)map2.get(checkId) : null;
                if (appCheckResult == null) {
                    this.log.warn("Unable to generate AppVendorCheck csv map for appKey: {} with non-existent checkId: {}", (Object)appKey, (Object)checkId);
                    return MapsKt.emptyMap();
                }
                PreflightCheck<? extends CheckResult> preflightCheck = this.preflightCheckLookup.get(CheckType.AppVendorCheck);
                Intrinsics.checkNotNull(preflightCheck, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.preflight.AppVendorCheck");
                Map<String, Object> map3 = ((AppVendorCheck)preflightCheck).buildCSVMap(appCheckResult);
                object = map3;
                if (map3 != null) break block13;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String getCSVFileName(@NotNull CheckExecutionStatus checkExecutionStatus, @NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Object v1;
        Object object;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)checkExecutionStatus, (String)"checkExecutionStatus");
            Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            List list = checkExecutionStatus.statuses;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statuses");
            object = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CheckStatus it = (CheckStatus)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.checkType, (Object)type.name())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        CheckStatus checkStatus = v1;
        if (checkStatus == null) return "";
        CheckStatus it = checkStatus;
        boolean bl = false;
        object = this.preflightCheckLookup.get(type).getCSVFileName(executionId, type, planName);
        if (object == null) return "";
        Object object2 = object;
        return object2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getAppVendorCheckCSVFileName(@NotNull CheckExecutionStatus checkExecutionStatus, @NotNull String executionId, @NotNull String appKey, @NotNull String checkId) {
        Object object;
        Object v1;
        Object object2;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)checkExecutionStatus, (String)"checkExecutionStatus");
            Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            Intrinsics.checkNotNullParameter((Object)checkId, (String)"checkId");
            List list = checkExecutionStatus.statuses;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statuses");
            object2 = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CheckStatus it = (CheckStatus)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.checkType, (Object)"AppVendorCheck")) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        CheckStatus checkStatus = v1;
        if (checkStatus != null) {
            CheckStatus it = checkStatus;
            boolean bl = false;
            PreflightCheck<? extends CheckResult> preflightCheck = this.preflightCheckLookup.get(CheckType.AppVendorCheck);
            Intrinsics.checkNotNull(preflightCheck, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.preflight.AppVendorCheck");
            object2 = ((AppVendorCheck)preflightCheck).getCSVFileName(executionId, appKey, checkId);
            if (object2 != null) {
                object = object2;
                return object;
            }
        }
        object = executionId + "-AppVendorCheck.csv";
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final CheckResultDto transformCheckToDto(CheckExecutionStatus statuses, CheckStatus checkStatus) {
        CheckResultDto checkResultDto;
        if (this.hasRunningFreeEditionCheck(statuses)) {
            String string = checkStatus.checkType;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
            if (CheckType.valueOf(string) == CheckType.SharedEmails) {
                checkResultDto = this.createRunningSharedEmailsCheckResult();
                return checkResultDto;
            }
        }
        checkResultDto = this.toCheckResultDto(checkStatus);
        return checkResultDto;
    }

    @VisibleForTesting
    public final boolean isVisibleForClient(@NotNull CheckResultDto checkResultDto) {
        Intrinsics.checkNotNullParameter((Object)checkResultDto, (String)"checkResultDto");
        return !this.freeEditionChecks.contains(checkResultDto.getCheckType()) || checkResultDto.getStatus() != Status.RUNNING && (checkResultDto.getStatus() != Status.SUCCESS || !this.isRemovable(checkResultDto));
    }

    @VisibleForTesting
    public final boolean hasRunningFreeEditionCheck(@NotNull CheckExecutionStatus statuses) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)statuses, (String)"statuses");
            List list = statuses.statuses;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statuses");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CheckStatus it = (CheckStatus)element$iv;
                boolean bl = false;
                if (!(this.freeEditionChecks.contains(it.checkType) && it.checkResult == null)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1 != null;
    }

    private final CheckResultDto toCheckResultDto(CheckStatus checkStatus) {
        String string = checkStatus.checkType;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkType");
        return this.preflightCheckLookup.get(CheckType.valueOf(string)).map(checkStatus);
    }

    private final CheckResultDto createRunningSharedEmailsCheckResult() {
        CheckResultDto checkResultDto;
        CheckResultDto $this$createRunningSharedEmailsCheckResult_u24lambda_u2411 = checkResultDto = new CheckResultDto();
        boolean bl = false;
        $this$createRunningSharedEmailsCheckResult_u24lambda_u2411.setCheckType("SharedEmails");
        $this$createRunningSharedEmailsCheckResult_u24lambda_u2411.setDescription("Checking for duplicate email addresses");
        $this$createRunningSharedEmailsCheckResult_u24lambda_u2411.setStatus(Status.RUNNING);
        $this$createRunningSharedEmailsCheckResult_u24lambda_u2411.setDetails(null);
        return checkResultDto;
    }

    private final boolean isRemovable(CheckResultDto $this$isRemovable) {
        boolean bl;
        Object object = $this$isRemovable.getDetails();
        if (object != null && (object = object.getInfo()) != null && (object = object.get("REMOVABLE")) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = (Boolean)it;
        } else {
            bl = false;
        }
        return bl;
    }
}

