/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.domain.Edition;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.migrationservice.CloudSiteRequestEntry;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.migrationservice.SiteDetailsRequest;
import com.atlassian.jira.migration.migrationservice.SiteDetailsResponse;
import com.atlassian.jira.migration.migrationservice.SiteDetailsWithCloudId;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import java.io.Serializable;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000bB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/preflight/PremiumLicenseService;", "", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "(Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;)V", "getCurrentSiteDetails", "Lcom/atlassian/jira/migration/migrationservice/SiteDetailsResponse;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "EditionResult", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPremiumLicenseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PremiumLicenseService.kt\ncom/atlassian/jira/migration/preflight/PremiumLicenseService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n288#2,2:53\n*S KotlinDebug\n*F\n+ 1 PremiumLicenseService.kt\ncom/atlassian/jira/migration/preflight/PremiumLicenseService\n*L\n27#1:53,2\n*E\n"})
public final class PremiumLicenseService {
    @NotNull
    private final MigrationServiceClient migrationServiceClient;

    @Inject
    public PremiumLicenseService(@NotNull MigrationServiceClient migrationServiceClient) {
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        this.migrationServiceClient = migrationServiceClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Object v0;
        boolean bl;
        String string;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
            SiteDetailsWithCloudId currentSiteDetails = (SiteDetailsWithCloudId)CollectionsKt.first(this.getCurrentSiteDetails(checkRequest).getSites());
            Iterable iterable = currentSiteDetails.getProducts();
            string = "RESULT_KEY";
            bl = true;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TcsProductInfo product = (TcsProductInfo)element$iv;
                boolean bl2 = false;
                if (!(product.getProductKey() == Product.JIRA_SOFTWARE)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var11_11 = v0;
        TcsProductInfo tcsProductInfo = var11_11;
        Edition edition = tcsProductInfo != null ? tcsProductInfo.getEdition() : null;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)new EditionResult(edition)));
        boolean bl3 = bl;
        return new CheckResult(bl3, map);
    }

    private final SiteDetailsResponse getCurrentSiteDetails(CheckRequest checkRequest) {
        if (checkRequest.parameters == null) {
            boolean bl = false;
            String string = "Free Edition preflight check request parameter not found.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.migrationServiceClient.fetchSiteDetails(PreflightCheckKt.getContainerToken(checkRequest), new SiteDetailsRequest(SetsKt.setOf((Object)new CloudSiteRequestEntry(PreflightCheckKt.getCloudId(checkRequest), SetsKt.setOfNotNull((Object)Product.JIRA_SOFTWARE)))));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/preflight/PremiumLicenseService$EditionResult;", "Ljava/io/Serializable;", "jiraSoftwareEdition", "Lcom/atlassian/cmpt/domain/Edition;", "(Lcom/atlassian/cmpt/domain/Edition;)V", "getJiraSoftwareEdition", "()Lcom/atlassian/cmpt/domain/Edition;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class EditionResult
    implements Serializable {
        @Nullable
        private final Edition jiraSoftwareEdition;

        public EditionResult(@Nullable Edition jiraSoftwareEdition) {
            this.jiraSoftwareEdition = jiraSoftwareEdition;
        }

        @Nullable
        public final Edition getJiraSoftwareEdition() {
            return this.jiraSoftwareEdition;
        }

        @Nullable
        public final Edition component1() {
            return this.jiraSoftwareEdition;
        }

        @NotNull
        public final EditionResult copy(@Nullable Edition jiraSoftwareEdition) {
            return new EditionResult(jiraSoftwareEdition);
        }

        public static /* synthetic */ EditionResult copy$default(EditionResult editionResult, Edition edition, int n, Object object) {
            if ((n & 1) != 0) {
                edition = editionResult.jiraSoftwareEdition;
            }
            return editionResult.copy(edition);
        }

        @NotNull
        public String toString() {
            return "EditionResult(jiraSoftwareEdition=" + this.jiraSoftwareEdition + ')';
        }

        public int hashCode() {
            return this.jiraSoftwareEdition == null ? 0 : this.jiraSoftwareEdition.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EditionResult)) {
                return false;
            }
            EditionResult editionResult = (EditionResult)other;
            return this.jiraSoftwareEdition == editionResult.jiraSoftwareEdition;
        }
    }
}

