/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.cmpt.check.email.EmailDuplicateChecker;
import com.atlassian.cmpt.validation.IdentityAcceptedEmailValidator;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.MigrationScopeContext;
import com.atlassian.jira.migration.email.EmailsSource;
import com.atlassian.jira.migration.email.IncorrectEmailAtomicMutateService;
import com.atlassian.jira.migration.email.InvalidEmailService;
import com.atlassian.jira.migration.email.NoValidEmailsException;
import com.atlassian.jira.migration.email.UserBaseScanService;
import com.atlassian.jira.migration.email.model.AtomicMutateResult;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.UserBaseScanFailed;
import com.atlassian.jira.migration.events.UserBaseScanFinished;
import com.atlassian.jira.migration.events.UserBaseScanStarted;
import com.atlassian.jira.migration.plan.JsdCustomersMigrationOption;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.preflight.PrepareUserBaseService;
import com.atlassian.jira.migration.preflight.UsersGroupsAndCustomerService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.utility.JsmUtility;
import com.atlassian.jira.migration.utils.CompletableFutureUtil;
import com.atlassian.jira.migration.utils.EmailValidityCheckerUtil;
import com.atlassian.jira.migration.utils.UDCConverterKt;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.udc.common.model.context.Context;
import com.atlassian.migration.udc.common.model.userbasescan.ScanStatus;
import com.atlassian.migration.udc.common.model.userbasescan.UserBaseScan;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingException;
import com.atlassian.migration.udc.email.MostFrequentDomainService;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 T2\u00020\u0001:\u0002TUB_\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J$\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002JF\u0010!\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0#\u0012\u0004\u0012\u00020&0\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0002JF\u0010!\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0#0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0002JX\u0010.\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0#0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u0010\u001f\u001a\u00020 2\f\u00102\u001a\b\u0012\u0004\u0012\u00020-0,2\b\b\u0002\u00103\u001a\u000204H\u0002J$\u00105\u001a\b\u0012\u0004\u0012\u00020%0#2\u0006\u00106\u001a\u00020(2\f\u00107\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u00106\u001a\u00020(H\u0002J\u0014\u00109\u001a\u0002042\n\u0010:\u001a\u00060;j\u0002`<H\u0003J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010>\u001a\u00020-H\u0002J2\u0010?\u001a\u001e\u0012\f\u0012\n A*\u0004\u0018\u00010\u001e0\u001e\u0012\f\u0012\n A*\u0004\u0018\u00010\u001e0\u001e0@2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002Jx\u0010C\u001a>\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0#0\u001a\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0#0\u001a0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u0010\u001f\u001a\u00020 2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020-0,2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J\u001a\u0010F\u001a\u00020G2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u00100\u001a\u0004\u0018\u000101J%\u0010H\u001a\u00020I2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\bJJ\u001e\u0010K\u001a\u0002042\f\u00102\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u00103\u001a\u000204H\u0002J\u001a\u0010L\u001a\u00020M2\u0006\u0010\u001f\u001a\u00020 2\b\u00100\u001a\u0004\u0018\u000101H\u0002J \u0010N\u001a\u00020G2\u0006\u0010O\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020Q2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010R\u001a\u00020SH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/atlassian/jira/migration/preflight/PrepareUserBaseService;", "", "userBaseScanService", "Lcom/atlassian/jira/migration/email/UserBaseScanService;", "incorrectEmailService", "Lcom/atlassian/jira/migration/email/IncorrectEmailAtomicMutateService;", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "jsmUtility", "Lcom/atlassian/jira/migration/utility/JsmUtility;", "clock", "Ljava/time/Clock;", "invalidEmailService", "Lcom/atlassian/jira/migration/email/InvalidEmailService;", "usersGroupsAndCustomerService", "Lcom/atlassian/jira/migration/preflight/UsersGroupsAndCustomerService;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "mostFrequentDomainService", "Lcom/atlassian/migration/udc/email/MostFrequentDomainService;", "udcScanDelegate", "Lcom/atlassian/migration/udc/scan/UserBaseScanService;", "(Lcom/atlassian/jira/migration/email/UserBaseScanService;Lcom/atlassian/jira/migration/email/IncorrectEmailAtomicMutateService;Lcom/atlassian/beehive/ClusterLockService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/utility/JsmUtility;Ljava/time/Clock;Lcom/atlassian/jira/migration/email/InvalidEmailService;Lcom/atlassian/jira/migration/preflight/UsersGroupsAndCustomerService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/migration/udc/email/MostFrequentDomainService;Lcom/atlassian/migration/udc/scan/UserBaseScanService;)V", "establishUserBaseScan", "Lkotlin/Pair;", "Lcom/atlassian/migration/udc/common/model/userbasescan/UserBaseScan;", "", "scanId", "", "startedByUser", "Lcom/atlassian/jira/user/ApplicationUser;", "getIncorrectCustomers", "Lkotlin/Triple;", "", "Lcom/atlassian/cmpt/check/email/EmailData;", "Lcom/atlassian/cmpt/check/email/EmailDuplicate;", "Lcom/atlassian/jira/migration/email/model/AtomicMutateResult;", "emailCheckContext", "Lcom/atlassian/cmpt/check/email/EmailCheckContext;", "migrationScopeContext", "Lcom/atlassian/jira/migration/common/MigrationScopeContext;", "customersFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "getIncorrectUsersWithUMS", "migrationScopeId", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "usersAndGroupsFuture", "jsmCustomersValidation", "", "getUsersWithDuplicateEmails", "checkContext", "invalidEmailData", "getUsersWithInvalidEmails", "isExceptionNoValidEmailsException", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "mapResultsToEmailData", "usersAndGroups", "mapUserNamesToEmails", "", "kotlin.jvm.PlatformType", "usersEmailDataList", "runUsersAndCustomersValidation", "usersExtractionResultFuture", "customersExtractionResultFuture", "safelyStartUserBaseScan", "", "scanUserBaseForIncorrectEmailsWithUMS", "Lcom/atlassian/jira/migration/preflight/PrepareUserBaseService$IncorrectEmails;", "scanUserBaseForIncorrectEmailsWithUMS$jira_migration_plugin", "shouldSkipEmailValidation", "startUserBaseScanWithClusterLock", "Ljava/lang/Runnable;", "updateScanOnFinish", "userBaseScan", "userBaseScanFinishedEvent", "Lcom/atlassian/jira/migration/events/UserBaseScanFinished;", "usersGroupsAndCustomersExceptMemberships", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "Companion", "IncorrectEmails", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPrepareUserBaseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrepareUserBaseService.kt\ncom/atlassian/jira/migration/preflight/PrepareUserBaseService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,413:1\n1179#2,2:414\n1253#2,4:416\n1549#2:420\n1620#2,3:421\n1549#2:424\n1620#2,3:425\n819#2:428\n847#2,2:429\n1#3:431\n*S KotlinDebug\n*F\n+ 1 PrepareUserBaseService.kt\ncom/atlassian/jira/migration/preflight/PrepareUserBaseService\n*L\n381#1:414,2\n381#1:416,4\n395#1:420\n395#1:421,3\n404#1:424\n404#1:425,3\n405#1:428\n405#1:429,2\n*E\n"})
public final class PrepareUserBaseService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserBaseScanService userBaseScanService;
    @NotNull
    private final IncorrectEmailAtomicMutateService incorrectEmailService;
    @NotNull
    private final ClusterLockService clusterLockService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final JsmUtility jsmUtility;
    @NotNull
    private final Clock clock;
    @NotNull
    private final InvalidEmailService invalidEmailService;
    @NotNull
    private final UsersGroupsAndCustomerService usersGroupsAndCustomerService;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final MostFrequentDomainService mostFrequentDomainService;
    @NotNull
    private final com.atlassian.migration.udc.scan.UserBaseScanService udcScanDelegate;
    @NotNull
    public static final String USER_BASE_SCAN_LOCK = "jcma.preflight.userbase.scan";
    private static final Logger log = LoggerFactory.getLogger(PrepareUserBaseService.class);

    @Inject
    public PrepareUserBaseService(@NotNull UserBaseScanService userBaseScanService, @NotNull IncorrectEmailAtomicMutateService incorrectEmailService, @NotNull ClusterLockService clusterLockService, @NotNull MigrationEventBus migrationEventBus, @NotNull JsmUtility jsmUtility, @NotNull Clock clock, @NotNull InvalidEmailService invalidEmailService, @NotNull UsersGroupsAndCustomerService usersGroupsAndCustomerService, @NotNull MigrationScopeManager migrationScopeManager, @NotNull MostFrequentDomainService mostFrequentDomainService, @NotNull com.atlassian.migration.udc.scan.UserBaseScanService udcScanDelegate) {
        Intrinsics.checkNotNullParameter((Object)userBaseScanService, (String)"userBaseScanService");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailService, (String)"incorrectEmailService");
        Intrinsics.checkNotNullParameter((Object)clusterLockService, (String)"clusterLockService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)jsmUtility, (String)"jsmUtility");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)invalidEmailService, (String)"invalidEmailService");
        Intrinsics.checkNotNullParameter((Object)usersGroupsAndCustomerService, (String)"usersGroupsAndCustomerService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)mostFrequentDomainService, (String)"mostFrequentDomainService");
        Intrinsics.checkNotNullParameter((Object)udcScanDelegate, (String)"udcScanDelegate");
        this.userBaseScanService = userBaseScanService;
        this.incorrectEmailService = incorrectEmailService;
        this.clusterLockService = clusterLockService;
        this.migrationEventBus = migrationEventBus;
        this.jsmUtility = jsmUtility;
        this.clock = clock;
        this.invalidEmailService = invalidEmailService;
        this.usersGroupsAndCustomerService = usersGroupsAndCustomerService;
        this.migrationScopeManager = migrationScopeManager;
        this.mostFrequentDomainService = mostFrequentDomainService;
        this.udcScanDelegate = udcScanDelegate;
    }

    public final void safelyStartUserBaseScan(@NotNull ApplicationUser startedByUser, @Nullable CloudSite cloudSite2) {
        Intrinsics.checkNotNullParameter((Object)startedByUser, (String)"startedByUser");
        new Thread(this.startUserBaseScanWithClusterLock(startedByUser, cloudSite2), "JCMA user base scan").start();
    }

    public static /* synthetic */ void safelyStartUserBaseScan$default(PrepareUserBaseService prepareUserBaseService, ApplicationUser applicationUser, CloudSite cloudSite2, int n, Object object) {
        if ((n & 2) != 0) {
            cloudSite2 = null;
        }
        prepareUserBaseService.safelyStartUserBaseScan(applicationUser, cloudSite2);
    }

    private final Runnable startUserBaseScanWithClusterLock(ApplicationUser startedByUser, CloudSite cloudSite2) {
        return () -> PrepareUserBaseService.startUserBaseScanWithClusterLock$lambda$1(startedByUser, this, cloudSite2);
    }

    private final Triple<List<EmailData>, List<EmailDuplicate>, AtomicMutateResult> getIncorrectCustomers(String scanId, EmailCheckContext emailCheckContext, ApplicationUser startedByUser, MigrationScopeContext migrationScopeContext) {
        List<EmailData> invalidCustomerEmails = this.getUsersWithInvalidEmails(emailCheckContext);
        AtomicMutateResult upsertCustomerResults = this.incorrectEmailService.deleteAndUpsertInvalidEmails(scanId, invalidCustomerEmails, startedByUser, CheckType.InvalidJsmCustomerEmails, migrationScopeContext);
        log.info("Found " + invalidCustomerEmails.size() + " Customers with invalid emails for " + scanId);
        List list = emailCheckContext.emails;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"emails");
        Map<String, String> userNameToEmailMap = this.mapUserNamesToEmails(list);
        List<EmailDuplicate> duplicateCustomerEmails = this.getUsersWithDuplicateEmails(emailCheckContext, invalidCustomerEmails);
        upsertCustomerResults = upsertCustomerResults.plus(this.incorrectEmailService.deleteAndUpsertDuplicateEmails(userNameToEmailMap, scanId, duplicateCustomerEmails, startedByUser, CheckType.SharedJsmCustomerEmails, migrationScopeContext));
        log.info("Found " + duplicateCustomerEmails.size() + " Customers with duplicate emails for " + scanId);
        return new Triple(invalidCustomerEmails, duplicateCustomerEmails, (Object)upsertCustomerResults);
    }

    private final List<EmailData> getUsersWithInvalidEmails(EmailCheckContext checkContext) {
        CheckResult checkResult = EmailValidityCheckerUtil.INSTANCE.check(checkContext);
        Map map = checkResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
        return EmailValidityCheckerUtil.INSTANCE.getInvalidEmails(map);
    }

    private final UsersGroupsMigrationOption usersGroupsAndCustomersExceptMemberships() {
        return this.jsmUtility.isJsmInstalled() ? UsersGroupsMigrationOption.copy$default(UsersGroupsMigrationOption.Companion.getALL_EXCEPT_MEMBERSHIPS(), null, false, false, false, JsdCustomersMigrationOption.Companion.getALL(), 15, null) : UsersGroupsMigrationOption.Companion.getALL_EXCEPT_MEMBERSHIPS();
    }

    private final Pair<UserBaseScan, Long> establishUserBaseScan(String scanId, ApplicationUser startedByUser) {
        log.info("Started user base scan " + scanId + " triggered by " + startedByUser.getKey());
        long startTime = System.nanoTime();
        UserBaseScan userBaseScan = this.userBaseScanService.insertUserBaseScan(new UserBaseScan(ScanStatus.IN_PROGRESS, this.clock.instant().toEpochMilli(), 0L, 0L, 0L, 0L, 0L, scanId, 124, null), startedByUser);
        return new Pair((Object)userBaseScan, (Object)startTime);
    }

    @VisibleForTesting
    @NotNull
    public final IncorrectEmails scanUserBaseForIncorrectEmailsWithUMS$jira_migration_plugin(@NotNull String scanId, @NotNull CloudSite cloudSite2, @NotNull ApplicationUser startedByUser) {
        Intrinsics.checkNotNullParameter((Object)scanId, (String)"scanId");
        Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
        Intrinsics.checkNotNullParameter((Object)startedByUser, (String)"startedByUser");
        Pair<UserBaseScan, Long> pair = this.establishUserBaseScan(scanId, startedByUser);
        UserBaseScan userBaseScan = (UserBaseScan)pair.component1();
        long startTime = ((Number)pair.component2()).longValue();
        Pair pair2 = UsersGroupsAndCustomerService.getUsersGroupsAndCustomers$default(this.usersGroupsAndCustomerService, this.usersGroupsAndCustomersExceptMemberships(), scanId, startedByUser, CollectionsKt.emptyList(), ProjectDataMigrationMode.ALL, MigrationType.CLASSIC, CollectionsKt.emptyList(), null, null, null, null, 1792, null);
        CompletableFuture usersAndGroupsFuture = (CompletableFuture)pair2.component1();
        CompletableFuture customersFuture = (CompletableFuture)pair2.component2();
        Pair<Pair<List<EmailData>, List<EmailDuplicate>>, Pair<List<EmailData>, List<EmailDuplicate>>> pair3 = this.runUsersAndCustomersValidation(scanId, cloudSite2, startedByUser, usersAndGroupsFuture, customersFuture);
        Pair incorrectUsersPair = (Pair)pair3.component1();
        Pair incorrectCustomersPair = (Pair)pair3.component2();
        List invalidUserEmails = (List)incorrectUsersPair.component1();
        List duplicateUserEmails = (List)incorrectUsersPair.component2();
        List invalidCustomerEmails = (List)incorrectCustomersPair.component1();
        List duplicateCustomerEmails = (List)incorrectCustomersPair.component2();
        List invalidCustomerEmailsTrimmed = CollectionsKt.minus((Iterable)invalidCustomerEmails, (Iterable)CollectionsKt.toSet((Iterable)invalidUserEmails));
        List duplicateCustomerEmailsTrimmed = CollectionsKt.minus((Iterable)duplicateCustomerEmails, (Iterable)CollectionsKt.toSet((Iterable)duplicateUserEmails));
        int totalDuplicatedUserAccounts2 = duplicateUserEmails.stream().mapToInt(arg_0 -> PrepareUserBaseService.scanUserBaseForIncorrectEmailsWithUMS$lambda$2(scanUserBaseForIncorrectEmailsWithUMS.totalDuplicatedUserAccounts.1.INSTANCE, arg_0)).sum();
        int totalDuplicatedCustomerAccounts2 = duplicateCustomerEmailsTrimmed.stream().mapToInt(arg_0 -> PrepareUserBaseService.scanUserBaseForIncorrectEmailsWithUMS$lambda$3(scanUserBaseForIncorrectEmailsWithUMS.totalDuplicatedCustomerAccounts.1.INSTANCE, arg_0)).sum();
        IncorrectEmails incorrectEmails = new IncorrectEmails(invalidUserEmails, duplicateUserEmails, invalidCustomerEmailsTrimmed, duplicateCustomerEmailsTrimmed, totalDuplicatedUserAccounts2, totalDuplicatedCustomerAccounts2);
        String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(cloudSite2);
        this.udcScanDelegate.createAllUsersCsv(invalidUserEmails, duplicateUserEmails, invalidCustomerEmailsTrimmed, duplicateCustomerEmailsTrimmed, UDCConverterKt.toUDCUsers(CollectionsKt.toList((Iterable)((UsersGroupsExtractionResult)CompletableFutureUtil.INSTANCE.getCompletedValue((Future)usersAndGroupsFuture)).getUsers())), UDCConverterKt.toUDCUsers(CollectionsKt.toList((Iterable)((UsersGroupsExtractionResult)CompletableFutureUtil.INSTANCE.getCompletedValue((Future)customersFuture)).getUsers())), (Context)new Context.CloudContext(cloudSite2.getContainerToken(), migrationScopeId2));
        this.updateScanOnFinish(UserBaseScan.copy$default((UserBaseScan)userBaseScan, (ScanStatus)ScanStatus.FINISHED, (long)0L, (long)this.clock.instant().toEpochMilli(), (long)invalidUserEmails.size(), (long)totalDuplicatedUserAccounts2, (long)invalidCustomerEmailsTrimmed.size(), (long)totalDuplicatedCustomerAccounts2, null, (int)130, null), new UserBaseScanFinished(scanId, ((UsersGroupsExtractionResult)CompletableFutureUtil.INSTANCE.getCompletedValue((Future)usersAndGroupsFuture)).getUsers().size(), ((UsersGroupsExtractionResult)CompletableFutureUtil.INSTANCE.getCompletedValue((Future)customersFuture)).getUsers().size(), invalidUserEmails.size(), totalDuplicatedUserAccounts2, invalidCustomerEmailsTrimmed.size(), totalDuplicatedCustomerAccounts2, (System.nanoTime() - startTime) / (long)1000000), startedByUser);
        return incorrectEmails;
    }

    private final void updateScanOnFinish(UserBaseScan userBaseScan, UserBaseScanFinished userBaseScanFinishedEvent, ApplicationUser startedByUser) {
        this.userBaseScanService.updateUserBaseScan(userBaseScan, startedByUser);
        log.info("Finished user base scan " + userBaseScan.getId() + " triggered by " + startedByUser.getKey());
        this.migrationEventBus.post(userBaseScanFinishedEvent);
    }

    private final Pair<Pair<List<EmailData>, List<EmailDuplicate>>, Pair<List<EmailData>, List<EmailDuplicate>>> runUsersAndCustomersValidation(String scanId, CloudSite cloudSite2, ApplicationUser startedByUser, CompletableFuture<UsersGroupsExtractionResult> usersExtractionResultFuture, CompletableFuture<UsersGroupsExtractionResult> customersExtractionResultFuture) {
        String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(cloudSite2);
        CompletableFuture<Pair> incorrectUsersFuture = CompletableFuture.supplyAsync(() -> PrepareUserBaseService.runUsersAndCustomersValidation$lambda$4(this, scanId, migrationScopeId2, cloudSite2, startedByUser, usersExtractionResultFuture));
        CompletableFuture<Pair> incorrectCustomersFuture = CompletableFuture.supplyAsync(() -> PrepareUserBaseService.runUsersAndCustomersValidation$lambda$5(this, scanId, customersExtractionResultFuture, startedByUser, cloudSite2, migrationScopeId2));
        Intrinsics.checkNotNull(incorrectUsersFuture);
        Object object = CompletableFutureUtil.INSTANCE.getCompletedValue((Future)incorrectUsersFuture);
        Intrinsics.checkNotNull(incorrectCustomersFuture);
        return new Pair(object, CompletableFutureUtil.INSTANCE.getCompletedValue((Future)incorrectCustomersFuture));
    }

    private final Pair<List<EmailData>, List<EmailDuplicate>> getIncorrectCustomers(String scanId, CompletableFuture<UsersGroupsExtractionResult> customersFuture, ApplicationUser startedByUser, MigrationScopeContext migrationScopeContext) {
        if (this.shouldSkipEmailValidation(customersFuture, true)) {
            return new Pair((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.emptyList());
        }
        Object object = CompletableFutureUtil.INSTANCE.getCompletedValue((Future)customersFuture);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCompletedValue(...)");
        List<EmailData> jsmCustomers = this.mapResultsToEmailData((UsersGroupsExtractionResult)object);
        Triple<List<EmailData>, List<EmailDuplicate>, AtomicMutateResult> triple = this.getIncorrectCustomers(scanId, new EmailCheckContext(jsmCustomers), startedByUser, migrationScopeContext);
        List invalidCustomerEmails = (List)triple.component1();
        List duplicateCustomerEmails = (List)triple.component2();
        AtomicMutateResult upsertCustomerResults = (AtomicMutateResult)triple.component3();
        if (upsertCustomerResults instanceof AtomicMutateResult.Failed) {
            throw ((AtomicMutateResult.Failed)upsertCustomerResults).getError();
        }
        return new Pair((Object)invalidCustomerEmails, (Object)duplicateCustomerEmails);
    }

    private final Pair<List<EmailData>, List<EmailDuplicate>> getIncorrectUsersWithUMS(String scanId, String migrationScopeId2, CloudSite cloudSite2, ApplicationUser startedByUser, CompletableFuture<UsersGroupsExtractionResult> usersAndGroupsFuture, boolean jsmCustomersValidation) {
        if (this.shouldSkipEmailValidation(usersAndGroupsFuture, jsmCustomersValidation)) {
            return new Pair((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.emptyList());
        }
        CheckResult invalidEmailsCheckResult = this.invalidEmailService.validate(scanId, cloudSite2.getContainerToken(), migrationScopeId2, usersAndGroupsFuture);
        MigrationScopeContext migrationScopeContext = new MigrationScopeContext(cloudSite2.getContainerToken(), migrationScopeId2);
        Map map = invalidEmailsCheckResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
        List invalidUsersEmails = EmailValidityCheckerUtil.INSTANCE.getInvalidEmails(map);
        UsersGroupsExtractionResult usersAndGroupsResult = (UsersGroupsExtractionResult)CompletableFutureUtil.INSTANCE.getCompletedValue((Future)usersAndGroupsFuture);
        if (!this.mostFrequentDomainService.isMostFrequentDomainNameCached()) {
            this.mostFrequentDomainService.getMostFrequentDomainName((Function0)new Function0<Sequence<? extends String>>(usersAndGroupsResult){
                final /* synthetic */ UsersGroupsExtractionResult $usersAndGroupsResult;
                {
                    this.$usersAndGroupsResult = $usersAndGroupsResult;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Sequence<String> invoke() {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = this.$usersAndGroupsResult.getUsers();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JiraUser jiraUser = (JiraUser)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getEmail());
                    }
                    return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
                }
            }, UDCConverterKt.toUDC(EmailsSource.PREFETCHED), (Context)new Context.CloudContext(cloudSite2.getContainerToken(), migrationScopeId2));
        }
        AtomicMutateResult upsertUsersResults = this.incorrectEmailService.deleteAndUpsertInvalidEmails(scanId, invalidUsersEmails, startedByUser, jsmCustomersValidation ? CheckType.InvalidJsmCustomerEmails : CheckType.InvalidEmails, migrationScopeContext);
        log.info("Found " + invalidUsersEmails.size() + ' ' + (jsmCustomersValidation ? "Customers" : "Users") + " with invalid emails for " + scanId);
        Intrinsics.checkNotNull((Object)usersAndGroupsResult);
        List<EmailData> usersEmailDataList = this.mapResultsToEmailData(usersAndGroupsResult);
        Map<String, String> userNameToEmailMap = this.mapUserNamesToEmails(usersEmailDataList);
        List<EmailDuplicate> duplicateUsersEmails = this.getUsersWithDuplicateEmails(new EmailCheckContext(usersEmailDataList), invalidUsersEmails);
        upsertUsersResults = upsertUsersResults.plus(this.incorrectEmailService.deleteAndUpsertDuplicateEmails(userNameToEmailMap, scanId, duplicateUsersEmails, startedByUser, jsmCustomersValidation ? CheckType.SharedJsmCustomerEmails : CheckType.SharedEmails, migrationScopeContext));
        log.info("Found " + duplicateUsersEmails.size() + ' ' + (jsmCustomersValidation ? "Customers" : "Users") + " with duplicate emails for " + scanId);
        if (upsertUsersResults instanceof AtomicMutateResult.Failed) {
            throw ((AtomicMutateResult.Failed)upsertUsersResults).getError();
        }
        return new Pair((Object)invalidUsersEmails, duplicateUsersEmails);
    }

    static /* synthetic */ Pair getIncorrectUsersWithUMS$default(PrepareUserBaseService prepareUserBaseService, String string, String string2, CloudSite cloudSite2, ApplicationUser applicationUser, CompletableFuture completableFuture, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return prepareUserBaseService.getIncorrectUsersWithUMS(string, string2, cloudSite2, applicationUser, completableFuture, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> mapUserNamesToEmails(List<? extends EmailData> usersEmailDataList) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = usersEmailDataList;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            EmailData it = (EmailData)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.id, (Object)it.email);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private final boolean shouldSkipEmailValidation(CompletableFuture<UsersGroupsExtractionResult> usersAndGroupsFuture, boolean jsmCustomersValidation) {
        if (jsmCustomersValidation && !this.jsmUtility.isJsmInstalled()) {
            return true;
        }
        return Intrinsics.areEqual((Object)CompletableFutureUtil.INSTANCE.getCompletedValue((Future)usersAndGroupsFuture), (Object)UsersGroupsExtractionResult.Companion.getEMPTY());
    }

    /*
     * WARNING - void declaration
     */
    private final List<EmailData> mapResultsToEmailData(UsersGroupsExtractionResult usersAndGroups) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = usersAndGroups.getUsers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void user;
            JiraUser jiraUser = (JiraUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new EmailData(user.getUserName(), IdentityAcceptedEmailValidator.cleanse((String)user.getEmail())));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EmailDuplicate> getUsersWithDuplicateEmails(EmailCheckContext checkContext, List<? extends EmailData> invalidEmailData) {
        void $this$filterNotTo$iv$iv;
        EmailDuplicate it;
        Iterable $this$mapTo$iv$iv;
        CheckResult checkResult = new EmailDuplicateChecker().check(checkContext);
        List duplicateEmails = EmailDuplicateChecker.retrieveEmailDuplicates((Map)checkResult.details);
        Iterable $this$map$iv = invalidEmailData;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            EmailData emailData = (EmailData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.email);
        }
        Set invalidEmails = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)duplicateEmails);
        Iterable $this$filterNot$iv = duplicateEmails;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (EmailDuplicate)element$iv$iv;
            boolean bl = false;
            if (invalidEmails.contains(it.email)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @VisibleForTesting
    private final boolean isExceptionNoValidEmailsException(Exception ex) {
        return ExceptionUtils.getRootCause((Throwable)ex) instanceof NoValidEmailsException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startUserBaseScanWithClusterLock$lambda$1(ApplicationUser $startedByUser, PrepareUserBaseService this$0, CloudSite $cloudSite) {
        Intrinsics.checkNotNullParameter((Object)$startedByUser, (String)"$startedByUser");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        log.debug("Attempting to start a user base scan triggered by " + $startedByUser.getKey());
        ClusterLock lock = this$0.clusterLockService.getLockForName(USER_BASE_SCAN_LOCK);
        if (lock.tryLock()) {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String scanId = string;
            log.debug("Obtained a cluster lock for " + scanId);
            try {
                this$0.migrationEventBus.post(new UserBaseScanStarted(scanId));
                if ($cloudSite == null) {
                    boolean $i$a$-requireNotNull-PrepareUserBaseService$startUserBaseScanWithClusterLock$1$22 = false;
                    String $i$a$-requireNotNull-PrepareUserBaseService$startUserBaseScanWithClusterLock$1$22 = "Destination cloud site is required to run email validation in User Assessment";
                    throw new IllegalArgumentException($i$a$-requireNotNull-PrepareUserBaseService$startUserBaseScanWithClusterLock$1$22.toString());
                }
                this$0.scanUserBaseForIncorrectEmailsWithUMS$jira_migration_plugin(scanId, $cloudSite, $startedByUser);
            }
            catch (Exception ex) {
                ScanStatus status;
                ScanStatus scanStatus;
                if (ex instanceof UserMappingException) {
                    log.error(((UserMappingException)ex).getType().getMessage(), (Throwable)ex);
                    scanStatus = ScanStatus.FAILED;
                } else if (this$0.isExceptionNoValidEmailsException(ex)) {
                    log.warn("No valid emails found in the user base for " + scanId, (Throwable)ex);
                    scanStatus = ScanStatus.NO_VALID_EMAILS;
                } else {
                    log.error("Exception during a user base scan " + scanId, (Throwable)ex);
                    scanStatus = status = ScanStatus.FAILED;
                }
                if (status == ScanStatus.FAILED) {
                    this$0.migrationEventBus.post(new UserBaseScanFailed(scanId));
                }
                this$0.userBaseScanService.updateStatus(scanId, status, $startedByUser);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static final int scanUserBaseForIncorrectEmailsWithUMS$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int scanUserBaseForIncorrectEmailsWithUMS$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final Pair runUsersAndCustomersValidation$lambda$4(PrepareUserBaseService this$0, String $scanId, String $migrationScopeId, CloudSite $cloudSite, ApplicationUser $startedByUser, CompletableFuture $usersExtractionResultFuture) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$scanId, (String)"$scanId");
        Intrinsics.checkNotNullParameter((Object)$migrationScopeId, (String)"$migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)$cloudSite, (String)"$cloudSite");
        Intrinsics.checkNotNullParameter((Object)$startedByUser, (String)"$startedByUser");
        Intrinsics.checkNotNullParameter((Object)$usersExtractionResultFuture, (String)"$usersExtractionResultFuture");
        return PrepareUserBaseService.getIncorrectUsersWithUMS$default(this$0, $scanId, $migrationScopeId, $cloudSite, $startedByUser, $usersExtractionResultFuture, false, 32, null);
    }

    private static final Pair runUsersAndCustomersValidation$lambda$5(PrepareUserBaseService this$0, String $scanId, CompletableFuture $customersExtractionResultFuture, ApplicationUser $startedByUser, CloudSite $cloudSite, String $migrationScopeId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$scanId, (String)"$scanId");
        Intrinsics.checkNotNullParameter((Object)$customersExtractionResultFuture, (String)"$customersExtractionResultFuture");
        Intrinsics.checkNotNullParameter((Object)$startedByUser, (String)"$startedByUser");
        Intrinsics.checkNotNullParameter((Object)$cloudSite, (String)"$cloudSite");
        Intrinsics.checkNotNullParameter((Object)$migrationScopeId, (String)"$migrationScopeId");
        return this$0.getIncorrectCustomers($scanId, $customersExtractionResultFuture, $startedByUser, new MigrationScopeContext($cloudSite.getContainerToken(), $migrationScopeId));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/preflight/PrepareUserBaseService$Companion;", "", "()V", "USER_BASE_SCAN_LOCK", "", "getUSER_BASE_SCAN_LOCK$annotations", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getUSER_BASE_SCAN_LOCK$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BY\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J]\u0010\u001b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/preflight/PrepareUserBaseService$IncorrectEmails;", "", "invalidUserEmails", "", "Lcom/atlassian/cmpt/check/email/EmailData;", "duplicateUserEmails", "Lcom/atlassian/cmpt/check/email/EmailDuplicate;", "invalidCustomerEmails", "duplicateCustomerEmails", "totalDuplicatedUserAccounts", "", "totalDuplicatedCustomerAccounts", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;II)V", "getDuplicateCustomerEmails", "()Ljava/util/List;", "getDuplicateUserEmails", "getInvalidCustomerEmails", "getInvalidUserEmails", "getTotalDuplicatedCustomerAccounts", "()I", "getTotalDuplicatedUserAccounts", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "jira-migration-plugin"})
    public static final class IncorrectEmails {
        @NotNull
        private final List<EmailData> invalidUserEmails;
        @NotNull
        private final List<EmailDuplicate> duplicateUserEmails;
        @NotNull
        private final List<EmailData> invalidCustomerEmails;
        @NotNull
        private final List<EmailDuplicate> duplicateCustomerEmails;
        private final int totalDuplicatedUserAccounts;
        private final int totalDuplicatedCustomerAccounts;

        public IncorrectEmails(@NotNull List<? extends EmailData> invalidUserEmails, @NotNull List<? extends EmailDuplicate> duplicateUserEmails, @NotNull List<? extends EmailData> invalidCustomerEmails, @NotNull List<? extends EmailDuplicate> duplicateCustomerEmails, int totalDuplicatedUserAccounts2, int totalDuplicatedCustomerAccounts2) {
            Intrinsics.checkNotNullParameter(invalidUserEmails, (String)"invalidUserEmails");
            Intrinsics.checkNotNullParameter(duplicateUserEmails, (String)"duplicateUserEmails");
            Intrinsics.checkNotNullParameter(invalidCustomerEmails, (String)"invalidCustomerEmails");
            Intrinsics.checkNotNullParameter(duplicateCustomerEmails, (String)"duplicateCustomerEmails");
            this.invalidUserEmails = invalidUserEmails;
            this.duplicateUserEmails = duplicateUserEmails;
            this.invalidCustomerEmails = invalidCustomerEmails;
            this.duplicateCustomerEmails = duplicateCustomerEmails;
            this.totalDuplicatedUserAccounts = totalDuplicatedUserAccounts2;
            this.totalDuplicatedCustomerAccounts = totalDuplicatedCustomerAccounts2;
        }

        public /* synthetic */ IncorrectEmails(List list, List list2, List list3, List list4, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n3 & 2) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n3 & 4) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            if ((n3 & 8) != 0) {
                list4 = CollectionsKt.emptyList();
            }
            if ((n3 & 0x10) != 0) {
                n = 0;
            }
            if ((n3 & 0x20) != 0) {
                n2 = 0;
            }
            this(list, list2, list3, list4, n, n2);
        }

        @NotNull
        public final List<EmailData> getInvalidUserEmails() {
            return this.invalidUserEmails;
        }

        @NotNull
        public final List<EmailDuplicate> getDuplicateUserEmails() {
            return this.duplicateUserEmails;
        }

        @NotNull
        public final List<EmailData> getInvalidCustomerEmails() {
            return this.invalidCustomerEmails;
        }

        @NotNull
        public final List<EmailDuplicate> getDuplicateCustomerEmails() {
            return this.duplicateCustomerEmails;
        }

        public final int getTotalDuplicatedUserAccounts() {
            return this.totalDuplicatedUserAccounts;
        }

        public final int getTotalDuplicatedCustomerAccounts() {
            return this.totalDuplicatedCustomerAccounts;
        }

        @NotNull
        public final List<EmailData> component1() {
            return this.invalidUserEmails;
        }

        @NotNull
        public final List<EmailDuplicate> component2() {
            return this.duplicateUserEmails;
        }

        @NotNull
        public final List<EmailData> component3() {
            return this.invalidCustomerEmails;
        }

        @NotNull
        public final List<EmailDuplicate> component4() {
            return this.duplicateCustomerEmails;
        }

        public final int component5() {
            return this.totalDuplicatedUserAccounts;
        }

        public final int component6() {
            return this.totalDuplicatedCustomerAccounts;
        }

        @NotNull
        public final IncorrectEmails copy(@NotNull List<? extends EmailData> invalidUserEmails, @NotNull List<? extends EmailDuplicate> duplicateUserEmails, @NotNull List<? extends EmailData> invalidCustomerEmails, @NotNull List<? extends EmailDuplicate> duplicateCustomerEmails, int totalDuplicatedUserAccounts2, int totalDuplicatedCustomerAccounts2) {
            Intrinsics.checkNotNullParameter(invalidUserEmails, (String)"invalidUserEmails");
            Intrinsics.checkNotNullParameter(duplicateUserEmails, (String)"duplicateUserEmails");
            Intrinsics.checkNotNullParameter(invalidCustomerEmails, (String)"invalidCustomerEmails");
            Intrinsics.checkNotNullParameter(duplicateCustomerEmails, (String)"duplicateCustomerEmails");
            return new IncorrectEmails(invalidUserEmails, duplicateUserEmails, invalidCustomerEmails, duplicateCustomerEmails, totalDuplicatedUserAccounts2, totalDuplicatedCustomerAccounts2);
        }

        public static /* synthetic */ IncorrectEmails copy$default(IncorrectEmails incorrectEmails, List list, List list2, List list3, List list4, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                list = incorrectEmails.invalidUserEmails;
            }
            if ((n3 & 2) != 0) {
                list2 = incorrectEmails.duplicateUserEmails;
            }
            if ((n3 & 4) != 0) {
                list3 = incorrectEmails.invalidCustomerEmails;
            }
            if ((n3 & 8) != 0) {
                list4 = incorrectEmails.duplicateCustomerEmails;
            }
            if ((n3 & 0x10) != 0) {
                n = incorrectEmails.totalDuplicatedUserAccounts;
            }
            if ((n3 & 0x20) != 0) {
                n2 = incorrectEmails.totalDuplicatedCustomerAccounts;
            }
            return incorrectEmails.copy(list, list2, list3, list4, n, n2);
        }

        @NotNull
        public String toString() {
            return "IncorrectEmails(invalidUserEmails=" + this.invalidUserEmails + ", duplicateUserEmails=" + this.duplicateUserEmails + ", invalidCustomerEmails=" + this.invalidCustomerEmails + ", duplicateCustomerEmails=" + this.duplicateCustomerEmails + ", totalDuplicatedUserAccounts=" + this.totalDuplicatedUserAccounts + ", totalDuplicatedCustomerAccounts=" + this.totalDuplicatedCustomerAccounts + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.invalidUserEmails).hashCode();
            result2 = result2 * 31 + ((Object)this.duplicateUserEmails).hashCode();
            result2 = result2 * 31 + ((Object)this.invalidCustomerEmails).hashCode();
            result2 = result2 * 31 + ((Object)this.duplicateCustomerEmails).hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.totalDuplicatedUserAccounts);
            result2 = result2 * 31 + Integer.hashCode(this.totalDuplicatedCustomerAccounts);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IncorrectEmails)) {
                return false;
            }
            IncorrectEmails incorrectEmails = (IncorrectEmails)other;
            if (!Intrinsics.areEqual(this.invalidUserEmails, incorrectEmails.invalidUserEmails)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.duplicateUserEmails, incorrectEmails.duplicateUserEmails)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.invalidCustomerEmails, incorrectEmails.invalidCustomerEmails)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.duplicateCustomerEmails, incorrectEmails.duplicateCustomerEmails)) {
                return false;
            }
            if (this.totalDuplicatedUserAccounts != incorrectEmails.totalDuplicatedUserAccounts) {
                return false;
            }
            return this.totalDuplicatedCustomerAccounts == incorrectEmails.totalDuplicatedCustomerAccounts;
        }

        public IncorrectEmails() {
            this(null, null, null, null, 0, 0, 63, null);
        }
    }
}

