/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.common.Constants;
import com.atlassian.jira.migration.migration.MigrationIncrementService;
import com.atlassian.jira.migration.migrationservice.CloudProject;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.ProjectConflict;
import com.atlassian.jira.migration.publicapi.service.PlanExternalMappingService;
import com.atlassian.jira.migration.validation.PlanValidation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B/\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fBS\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J2\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0002J\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0$2\b\u0010%\u001a\u0004\u0018\u00010\u001fH\u0002J$\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J0\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010,\u001a\u00020-2\b\u0010%\u001a\u0004\u0018\u00010\u001fH\u0002J\u000e\u0010.\u001a\u00020(2\u0006\u0010)\u001a\u00020*J6\u0010.\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010,\u001a\u00020-2\b\u0010%\u001a\u0004\u0018\u00010\u001f2\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u000202H\u0007J\"\u00103\u001a\u0002002\u0006\u00104\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\b\u0010%\u001a\u0004\u0018\u00010\u001fH\u0002J\"\u00105\u001a\u0002002\u0006\u00104\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\b\u0010%\u001a\u0004\u0018\u00010\u001fH\u0002J\"\u00106\u001a\u0002002\u0006\u00104\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\b\u0010%\u001a\u0004\u0018\u00010\u001fH\u0002R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/atlassian/jira/migration/preflight/ProjectConflictService;", "", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "planValidation", "Lcom/atlassian/jira/migration/validation/PlanValidation;", "migrationIncrementService", "Lcom/atlassian/jira/migration/migration/MigrationIncrementService;", "planExternalMappingService", "Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService;", "(Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/validation/PlanValidation;Lcom/atlassian/jira/migration/migration/MigrationIncrementService;Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService;)V", "executorFactory", "Lkotlin/Function1;", "", "Ljava/util/concurrent/ForkJoinPool;", "projectConflictRequestChunkSize", "projectConflictTimeoutInMillis", "", "(Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lkotlin/jvm/functions/Function1;IJLcom/atlassian/jira/migration/validation/PlanValidation;Lcom/atlassian/jira/migration/migration/MigrationIncrementService;Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService;)V", "executor", "buildProjectConflict", "Lcom/atlassian/jira/migration/preflight/ProjectConflict;", "serverProject", "Lcom/atlassian/jira/project/Project;", "cloudProject", "Lcom/atlassian/jira/migration/migrationservice/CloudProject;", "getConflictingCloudProjects", "Ljava/util/stream/Stream;", "containerToken", "", "serverProjectKeys", "", "serverProjectNames", "getMappedProjectKeys", "", "planId", "getProjectsNotInCloud", "performCloudExistenceCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "projectKeys", "migrationType", "Lcom/atlassian/jira/migration/plan/MigrationType;", "performProjectKeyNameConflictCheck", "isBlockingMigrationCheck", "", "preDestroy", "", "projectCancelled", "projectKey", "shouldPerformCloudExistenceCheck", "shouldPerformProjectKeyNameConflictCheck", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectConflictService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectConflictService.kt\ncom/atlassian/jira/migration/preflight/ProjectConflictService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1603#2,9:295\n1855#2:304\n1856#2:306\n1612#2:307\n819#2:308\n847#2,2:309\n1549#2:311\n1620#2,3:312\n1549#2:315\n1620#2,3:316\n1549#2:319\n1620#2,3:320\n1549#2:323\n1620#2,3:324\n766#2:327\n857#2,2:328\n819#2:330\n847#2,2:331\n766#2:333\n857#2,2:334\n766#2:336\n857#2,2:337\n819#2:339\n847#2,2:340\n766#2:342\n857#2,2:343\n1#3:305\n*S KotlinDebug\n*F\n+ 1 ProjectConflictService.kt\ncom/atlassian/jira/migration/preflight/ProjectConflictService\n*L\n81#1:295,9\n81#1:304\n81#1:306\n81#1:307\n92#1:308\n92#1:309,2\n202#1:311\n202#1:312,3\n203#1:315\n203#1:316,3\n257#1:319\n257#1:320,3\n258#1:323\n258#1:324,3\n125#1:327\n125#1:328,2\n126#1:330\n126#1:331,2\n127#1:333\n127#1:334,2\n152#1:336\n152#1:337,2\n153#1:339\n153#1:340,2\n154#1:342\n154#1:343,2\n81#1:305\n*E\n"})
public final class ProjectConflictService {
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    private final int projectConflictRequestChunkSize;
    private final long projectConflictTimeoutInMillis;
    @NotNull
    private final PlanValidation planValidation;
    @NotNull
    private final MigrationIncrementService migrationIncrementService;
    @NotNull
    private final PlanExternalMappingService planExternalMappingService;
    @NotNull
    private final ForkJoinPool executor;

    @VisibleForTesting
    public ProjectConflictService(@NotNull ProjectManager projectManager, @NotNull MigrationServiceClient migrationServiceClient, @NotNull Function1<? super Integer, ? extends ForkJoinPool> executorFactory, int projectConflictRequestChunkSize, long projectConflictTimeoutInMillis, @NotNull PlanValidation planValidation, @NotNull MigrationIncrementService migrationIncrementService, @NotNull PlanExternalMappingService planExternalMappingService) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter(executorFactory, (String)"executorFactory");
        Intrinsics.checkNotNullParameter((Object)planValidation, (String)"planValidation");
        Intrinsics.checkNotNullParameter((Object)migrationIncrementService, (String)"migrationIncrementService");
        Intrinsics.checkNotNullParameter((Object)planExternalMappingService, (String)"planExternalMappingService");
        this.projectManager = projectManager;
        this.migrationServiceClient = migrationServiceClient;
        this.projectConflictRequestChunkSize = projectConflictRequestChunkSize;
        this.projectConflictTimeoutInMillis = projectConflictTimeoutInMillis;
        this.planValidation = planValidation;
        this.migrationIncrementService = migrationIncrementService;
        this.planExternalMappingService = planExternalMappingService;
        this.executor = (ForkJoinPool)executorFactory.invoke((Object)5);
    }

    @Inject
    public ProjectConflictService(@NotNull ProjectManager projectManager, @NotNull MigrationServiceClient migrationServiceClient, @NotNull PlanValidation planValidation, @NotNull MigrationIncrementService migrationIncrementService, @NotNull PlanExternalMappingService planExternalMappingService) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)planValidation, (String)"planValidation");
        Intrinsics.checkNotNullParameter((Object)migrationIncrementService, (String)"migrationIncrementService");
        Intrinsics.checkNotNullParameter((Object)planExternalMappingService, (String)"planExternalMappingService");
        this(projectManager, migrationServiceClient, (Function1<? super Integer, ? extends ForkJoinPool>)((Function1)1.INSTANCE), 20, 300000L, planValidation, migrationIncrementService, planExternalMappingService);
    }

    @PreDestroy
    public final void preDestroy() {
        this.executor.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getMappedProjectKeys(String planId) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.planExternalMappingService.getMappedProjectIdsForPlanId(planId);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            long it = ((Number)element$iv$iv).longValue();
            boolean bl2 = false;
            Project project = this.projectManager.getProjectObj(Long.valueOf(it));
            if ((project != null ? project.getKey() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult performProjectKeyNameConflictCheck(@NotNull CheckRequest checkRequest) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        Set<String> mappedProjectKeys = this.getMappedProjectKeys(PreflightCheckKt.getPlanId(checkRequest));
        Iterable $this$filterNot$iv = PreflightCheckKt.getProjectKeys(checkRequest);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (mappedProjectKeys.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List projectKeys = (List)destination$iv$iv;
        String containerToken = PreflightCheckKt.getContainerToken(checkRequest);
        MigrationType migrationType = PreflightCheckKt.getMigrationType(checkRequest);
        String planId = PreflightCheckKt.getPlanId(checkRequest);
        return this.performProjectKeyNameConflictCheck(containerToken, projectKeys, migrationType, planId, true);
    }

    @NotNull
    public final CheckResult performCloudExistenceCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        List<String> projectKeys = PreflightCheckKt.getProjectKeys(checkRequest);
        String containerToken = PreflightCheckKt.getContainerToken(checkRequest);
        MigrationType migrationType = PreflightCheckKt.getMigrationType(checkRequest);
        String planId = PreflightCheckKt.getPlanId(checkRequest);
        return this.performCloudExistenceCheck(containerToken, projectKeys, migrationType, planId);
    }

    @NotNull
    public final CheckResult performProjectKeyNameConflictCheck(@NotNull String containerToken, @NotNull List<String> projectKeys, @NotNull MigrationType migrationType, @Nullable String planId, boolean isBlockingMigrationCheck) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationType), (String)"migrationType");
        List projectConflicts2 = (List)((ForkJoinTask)this.executor.submit(() -> ProjectConflictService.performProjectKeyNameConflictCheck$lambda$5(projectKeys, this, migrationType, planId, containerToken))).get(this.projectConflictTimeoutInMillis, TimeUnit.MILLISECONDS);
        return projectConflicts2.isEmpty() ? new CheckResult(true) : new CheckResult(!isBlockingMigrationCheck, MapsKt.mapOf((Pair)TuplesKt.to((Object)"projectConflicts", (Object)projectConflicts2)));
    }

    private final CheckResult performCloudExistenceCheck(String containerToken, List<String> projectKeys, MigrationType migrationType, String planId) {
        List projectsNotInCloud2 = (List)((ForkJoinTask)this.executor.submit(() -> ProjectConflictService.performCloudExistenceCheck$lambda$10(projectKeys, this, migrationType, planId, containerToken))).get(this.projectConflictTimeoutInMillis, TimeUnit.MILLISECONDS);
        return projectsNotInCloud2.isEmpty() ? new CheckResult(true) : new CheckResult(false, MapsKt.mapOf((Pair)TuplesKt.to((Object)"projectConflicts", (Object)projectsNotInCloud2)));
    }

    private final boolean shouldPerformProjectKeyNameConflictCheck(String projectKey, MigrationType migrationType, String planId) {
        return migrationType != MigrationType.INCREMENTAL || !this.shouldPerformCloudExistenceCheck(projectKey, migrationType, planId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldPerformCloudExistenceCheck(String projectKey, MigrationType migrationType, String planId) {
        if (migrationType != MigrationType.INCREMENTAL) return false;
        if (planId == null) return false;
        Long l = this.projectManager.getProjectObjByKeyIgnoreCase(projectKey).getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        if (!this.migrationIncrementService.hasSuccessfulIncrements(((Number)l).longValue(), planId)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean projectCancelled(String projectKey, MigrationType migrationType, String planId) {
        if (migrationType != MigrationType.INCREMENTAL) return false;
        if (planId == null) return false;
        Long l = this.projectManager.getProjectObjByKeyIgnoreCase(projectKey).getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        if (!this.migrationIncrementService.lastIncrementWasCancelled(((Number)l).longValue(), planId)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Stream<ProjectConflict> getConflictingCloudProjects(String containerToken, List<String> serverProjectKeys, List<String> serverProjectNames) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List<CloudProject> conflictCloudProjects = this.migrationServiceClient.getConflictingCloudProjects(containerToken, serverProjectKeys, serverProjectNames);
        Iterable $this$map$iv = serverProjectKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = p0.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(string2);
        }
        List serverProjectKeysInLowerCase = (List)destination$iv$iv;
        Iterable $this$map$iv2 = serverProjectNames;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = p0.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        List serverProjectNamesInLowerCase = (List)destination$iv$iv2;
        return StreamsKt.asStream((Sequence)SequencesKt.distinct((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super ProjectConflict>, Continuation<? super Unit>, Object>(conflictCloudProjects, (List<String>)serverProjectKeysInLowerCase, this, (List<String>)serverProjectNamesInLowerCase, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ List<CloudProject> $conflictCloudProjects;
            final /* synthetic */ List<String> $serverProjectKeysInLowerCase;
            final /* synthetic */ ProjectConflictService this$0;
            final /* synthetic */ List<String> $serverProjectNamesInLowerCase;
            {
                this.$conflictCloudProjects = $conflictCloudProjects;
                this.$serverProjectKeysInLowerCase = $serverProjectKeysInLowerCase;
                this.this$0 = $receiver;
                this.$serverProjectNamesInLowerCase = $serverProjectNamesInLowerCase;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var3_4 = this.$conflictCloudProjects.iterator();
lbl7:
                        // 2 sources

                        while (var3_4.hasNext()) {
                            cloudProj = (CloudProject)var3_4.next();
                            Intrinsics.checkNotNullExpressionValue((Object)cloudProj.getKey().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)cloudProj.getName().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                            if (this.$serverProjectKeysInLowerCase.contains(cloudProjectKey)) {
                                var7_8 = ProjectConflictService.access$getProjectManager$p(this.this$0).getProjectObjByKeyIgnoreCase(cloudProjectKey);
                                Intrinsics.checkNotNullExpressionValue((Object)var7_8, (String)"getProjectObjByKeyIgnoreCase(...)");
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = cloudProj;
                                this.L$3 = cloudProjectName;
                                this.label = 1;
                                v0 = $this$sequence.yield((Object)ProjectConflictService.access$buildProjectConflict(this.this$0, var7_8, cloudProj), (Continuation)this);
                                if (v0 == var11_2) {
                                    return var11_2;
                                }
                            }
                            ** GOTO lbl31
                        }
                        break;
                    }
                    case 1: {
                        cloudProjectName = (String)this.L$3;
                        cloudProj = (CloudProject)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl31:
                        // 2 sources

                        if (this.$serverProjectNamesInLowerCase.contains(cloudProjectName)) {
                            var7_8 = ProjectConflictService.access$getProjectManager$p(this.this$0).getProjectObjByName(cloudProjectName);
                            Intrinsics.checkNotNullExpressionValue((Object)var7_8, (String)"getProjectObjByName(...)");
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = cloudProj;
                            this.L$3 = null;
                            this.label = 2;
                            v1 = $this$sequence.yield((Object)ProjectConflictService.access$buildProjectConflict(this.this$0, var7_8, cloudProj), (Continuation)this);
                            if (v1 == var11_2) {
                                return var11_2;
                            }
                        }
                        ** GOTO lbl49
                    }
                    case 2: {
                        cloudProj = (CloudProject)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl49:
                        // 2 sources

                        var7_8 = cloudProj.getPreviousKeys().iterator();
lbl50:
                        // 4 sources

                        while (var7_8.hasNext()) {
                            prevKey = var7_8.next();
                            Intrinsics.checkNotNullExpressionValue((Object)prevKey.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                            if (!this.$serverProjectKeysInLowerCase.contains(prevKeyInLowerCase)) continue;
                            var10_11 = ProjectConflictService.access$getProjectManager$p(this.this$0).getProjectObjByKeyIgnoreCase(prevKeyInLowerCase);
                            Intrinsics.checkNotNullExpressionValue((Object)var10_11, (String)"getProjectObjByKeyIgnoreCase(...)");
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = cloudProj;
                            this.L$3 = var7_8;
                            this.label = 3;
                            v2 = $this$sequence.yield((Object)ProjectConflictService.access$buildProjectConflict(this.this$0, var10_11, cloudProj), (Continuation)this);
                            if (v2 != var11_2) continue;
                            return var11_2;
                        }
                        ** GOTO lbl7
                    }
                    case 3: {
                        var7_8 = (Project)this.L$3;
                        cloudProj = (CloudProject)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl50
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super ProjectConflict>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super ProjectConflict> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }))));
    }

    /*
     * WARNING - void declaration
     */
    private final Stream<ProjectConflict> getProjectsNotInCloud(String containerToken, List<String> serverProjectKeys) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.migrationServiceClient.getConflictingCloudProjects(containerToken, serverProjectKeys, CollectionsKt.emptyList());
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CloudProject cloudProject = (CloudProject)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = ((CloudProject)((Object)it)).getKey().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        Set cloudProjectKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = serverProjectKeys;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = p0.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        return StreamsKt.asStream((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.subtract((Iterable)((List)destination$iv$iv), (Iterable)cloudProjectKeys)), (Function1)((Function1)new Function1<String, ProjectConflict>(this){
            final /* synthetic */ ProjectConflictService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ProjectConflict invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Project project = ProjectConflictService.access$getProjectManager$p(this.this$0).getProjectObjByKeyIgnoreCase(it);
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProjectObjByKeyIgnoreCase(...)");
                return ProjectConflictService.access$buildProjectConflict(this.this$0, project, null);
            }
        }))));
    }

    private final ProjectConflict buildProjectConflict(Project serverProject, CloudProject cloudProject) {
        Object object;
        Project $this$buildProjectConflict_u24lambda_u2415 = serverProject;
        boolean bl = false;
        String string = $this$buildProjectConflict_u24lambda_u2415.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        String string2 = $this$buildProjectConflict_u24lambda_u2415.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = Constants.buildPageUrl$default(Constants.INSTANCE, "browse/" + serverProject.getKey(), null, 2, null);
        Object object2 = cloudProject;
        if (object2 == null || (object2 = ((CloudProject)object2).getName()) == null) {
            object2 = "Doesn't exist";
        }
        if ((object = cloudProject) == null || (object = ((CloudProject)object).getUrl()) == null) {
            object = "";
        }
        return new ProjectConflict(string, string2, string3, (String)object2, (String)object);
    }

    private static final Stream performProjectKeyNameConflictCheck$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List performProjectKeyNameConflictCheck$lambda$5(List $projectKeys, ProjectConflictService this$0, MigrationType $migrationType, String $planId, String $containerToken) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$projectKeys, (String)"$projectKeys");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$migrationType), (String)"$migrationType");
        Intrinsics.checkNotNullParameter((Object)$containerToken, (String)"$containerToken");
        Iterable iterable = $projectKeys;
        PlanValidation planValidation = this$0.planValidation;
        boolean $i$f$filter22 = false;
        void var8_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!planValidation.validateProjectKey(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        void $i$f$filter22 = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (this$0.projectCancelled(it, $migrationType, $planId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!this$0.shouldPerformProjectKeyNameConflictCheck(it, $migrationType, $planId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return CollectionsKt.chunked((Iterable)((List)destination$iv$iv2), (int)this$0.projectConflictRequestChunkSize).parallelStream().flatMap(arg_0 -> ProjectConflictService.performProjectKeyNameConflictCheck$lambda$5$lambda$4((Function1)new Function1<List<? extends String>, Stream<? extends ProjectConflict>>(this$0, $containerToken){
            final /* synthetic */ ProjectConflictService this$0;
            final /* synthetic */ String $containerToken;
            {
                this.this$0 = $receiver;
                this.$containerToken = $containerToken;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Stream<? extends ProjectConflict> invoke(List<String> serverProjectKeys) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNull(serverProjectKeys);
                Iterable iterable = serverProjectKeys;
                ProjectConflictService projectConflictService = this.this$0;
                boolean $i$f$map = false;
                void var6_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ProjectConflictService.access$getProjectManager$p(projectConflictService).getProjectObjByKeyIgnoreCase((String)it).getName());
                }
                List serverProjectNames = (List)destination$iv$iv;
                return ProjectConflictService.access$getConflictingCloudProjects(this.this$0, this.$containerToken, serverProjectKeys, serverProjectNames);
            }
        }, arg_0)).collect(Collectors.toList());
    }

    private static final Stream performCloudExistenceCheck$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List performCloudExistenceCheck$lambda$10(List $projectKeys, ProjectConflictService this$0, MigrationType $migrationType, String $planId, String $containerToken) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$projectKeys, (String)"$projectKeys");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$migrationType), (String)"$migrationType");
        Intrinsics.checkNotNullParameter((Object)$containerToken, (String)"$containerToken");
        Iterable iterable = $projectKeys;
        PlanValidation planValidation = this$0.planValidation;
        boolean $i$f$filter22 = false;
        void var8_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!planValidation.validateProjectKey(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        void $i$f$filter22 = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (this$0.projectCancelled(it, $migrationType, $planId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!this$0.shouldPerformCloudExistenceCheck(it, $migrationType, $planId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return CollectionsKt.chunked((Iterable)((List)destination$iv$iv2), (int)this$0.projectConflictRequestChunkSize).parallelStream().flatMap(arg_0 -> ProjectConflictService.performCloudExistenceCheck$lambda$10$lambda$9((Function1)new Function1<List<? extends String>, Stream<? extends ProjectConflict>>(this$0, $containerToken){
            final /* synthetic */ ProjectConflictService this$0;
            final /* synthetic */ String $containerToken;
            {
                this.this$0 = $receiver;
                this.$containerToken = $containerToken;
                super(1);
            }

            public final Stream<? extends ProjectConflict> invoke(List<String> keys) {
                Intrinsics.checkNotNull(keys);
                return ProjectConflictService.access$getProjectsNotInCloud(this.this$0, this.$containerToken, keys);
            }
        }, arg_0)).collect(Collectors.toList());
    }

    public static final /* synthetic */ ProjectConflict access$buildProjectConflict(ProjectConflictService $this, Project serverProject, CloudProject cloudProject) {
        return $this.buildProjectConflict(serverProject, cloudProject);
    }

    public static final /* synthetic */ ProjectManager access$getProjectManager$p(ProjectConflictService $this) {
        return $this.projectManager;
    }

    public static final /* synthetic */ Stream access$getConflictingCloudProjects(ProjectConflictService $this, String containerToken, List serverProjectKeys, List serverProjectNames) {
        return $this.getConflictingCloudProjects(containerToken, serverProjectKeys, serverProjectNames);
    }

    public static final /* synthetic */ Stream access$getProjectsNotInCloud(ProjectConflictService $this, String containerToken, List serverProjectKeys) {
        return $this.getProjectsNotInCloud(containerToken, serverProjectKeys);
    }
}

