/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.ProjectConflictService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/preflight/ProjectKeyAndNameConflictCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "projectConflictService", "Lcom/atlassian/jira/migration/preflight/ProjectConflictService;", "(Lcom/atlassian/jira/migration/preflight/ProjectConflictService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "jira-migration-plugin"})
public final class ProjectKeyAndNameConflictCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final ProjectConflictService projectConflictService;
    @NotNull
    private final CheckType checkType;

    @Inject
    public ProjectKeyAndNameConflictCheck(@NotNull ProjectConflictService projectConflictService) {
        Intrinsics.checkNotNullParameter((Object)projectConflictService, (String)"projectConflictService");
        this.projectConflictService = projectConflictService;
        this.checkType = CheckType.ProjectKeyAndNameConflict;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"migrationType", (Object)((Object)ctx.getMigrationType())), TuplesKt.to((Object)"planId", (Object)ctx.getPlanId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.projectConflictService.performProjectKeyNameConflictCheck(checkRequest);
    }

    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        block7: {
            List projectConflicts2;
            String string;
            Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
            Status status = dto.getStatus();
            Intrinsics.checkNotNull((Object)status);
            switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    string = "Checking for projects in your cloud site";
                    break;
                }
                case 2: {
                    string = "There are no conflicting projects";
                    break;
                }
                case 3: {
                    string = "Projects already exist in your cloud site";
                    break;
                }
                case 4: 
                case 5: {
                    string = "We couldn't check for projects in your cloud site";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            dto.setDescription(string);
            CheckResult checkResult2 = checkResult;
            if (checkResult2 == null) break block7;
            CheckResult it = checkResult2;
            boolean bl = false;
            Object v = it.details.get("projectConflicts");
            List list = projectConflicts2 = v instanceof List ? (List)v : null;
            if (list != null) {
                List $this$inject_u24lambda_u241_u24lambda_u240 = list;
                boolean bl2 = false;
                CheckDetailsDto details2 = new CheckDetailsDto();
                details2.setListOfOccurrences($this$inject_u24lambda_u241_u24lambda_u240);
                dto.setNumberOfOccurrences(Integer.valueOf($this$inject_u24lambda_u241_u24lambda_u240.size()));
                dto.setDetails(details2);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

