/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.migration.email.DuplicatedEmailsConfig;
import com.atlassian.jira.migration.email.GlobalEmailFixesConfigService;
import com.atlassian.jira.migration.email.InvalidEmailsConfig;
import com.atlassian.jira.migration.email.UserBaseScanService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.ScanSummary;
import com.atlassian.migration.udc.common.model.userbasescan.ScanStatus;
import com.atlassian.migration.udc.common.model.userbasescan.UserBaseScan;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingConfigDTO;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/preflight/ScanSummaryService;", "", "userBaseScanService", "Lcom/atlassian/jira/migration/email/UserBaseScanService;", "globalEmailFixesConfigService", "Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "udcDelegate", "Lcom/atlassian/migration/udc/scan/UserBaseScanService;", "(Lcom/atlassian/jira/migration/email/UserBaseScanService;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/beehive/ClusterLockService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/migration/udc/scan/UserBaseScanService;)V", "getLatestStartedScan", "Lcom/atlassian/migration/udc/common/model/userbasescan/UserBaseScan;", "getScan", "scanId", "", "getScanSummary", "Lcom/atlassian/jira/migration/preflight/ScanSummary;", "validateScanStatus", "scan", "jira-migration-plugin"})
public final class ScanSummaryService {
    @NotNull
    private final UserBaseScanService userBaseScanService;
    @NotNull
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;
    @NotNull
    private final ClusterLockService clusterLockService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final com.atlassian.migration.udc.scan.UserBaseScanService udcDelegate;

    @Inject
    public ScanSummaryService(@NotNull UserBaseScanService userBaseScanService, @NotNull GlobalEmailFixesConfigService globalEmailFixesConfigService, @NotNull ClusterLockService clusterLockService, @NotNull MigrationFeatures migrationFeatures, @NotNull com.atlassian.migration.udc.scan.UserBaseScanService udcDelegate) {
        Intrinsics.checkNotNullParameter((Object)userBaseScanService, (String)"userBaseScanService");
        Intrinsics.checkNotNullParameter((Object)globalEmailFixesConfigService, (String)"globalEmailFixesConfigService");
        Intrinsics.checkNotNullParameter((Object)clusterLockService, (String)"clusterLockService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)udcDelegate, (String)"udcDelegate");
        this.userBaseScanService = userBaseScanService;
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
        this.clusterLockService = clusterLockService;
        this.migrationFeatures = migrationFeatures;
        this.udcDelegate = udcDelegate;
    }

    @NotNull
    public final ScanSummary getScanSummary(@Nullable String scanId) {
        UserBaseScan userBaseScan;
        if (this.migrationFeatures.getUseUDCLibraryForUserBaseScan()) {
            userBaseScan = this.udcDelegate.findLatestOrGivenScanWitStatusRefreshed(scanId);
        } else {
            String string = scanId;
            userBaseScan = string != null ? this.getScan(string) : this.getLatestStartedScan();
        }
        UserBaseScan latestStartedScan = userBaseScan;
        DuplicatedEmailsConfig duplicatedEmailsConfig = this.globalEmailFixesConfigService.getDuplicatedEmailsConfig();
        InvalidEmailsConfig invalidEmailsConfig = this.globalEmailFixesConfigService.getInvalidEmailsConfig();
        Pair pair = new Pair((Object)this.globalEmailFixesConfigService.getUserMappingConfig(), (Object)this.globalEmailFixesConfigService.getConfirmedUdcModeConfig());
        UserMappingConfigDTO userMappingConfig = (UserMappingConfigDTO)pair.component1();
        UDCMode udcMode = (UDCMode)pair.component2();
        return latestStartedScan != null ? new ScanSummary(latestStartedScan.getStatus(), latestStartedScan.getStartedAt(), latestStartedScan.getFinishedAt(), latestStartedScan.getInvalidUsersCount(), latestStartedScan.getDuplicatedUsersCount(), latestStartedScan.getInvalidCustomersCount(), latestStartedScan.getDuplicatedCustomersCount(), duplicatedEmailsConfig, invalidEmailsConfig, userMappingConfig, udcMode, latestStartedScan.getId()) : new ScanSummary(null, null, null, null, null, null, null, duplicatedEmailsConfig, invalidEmailsConfig, userMappingConfig, udcMode, null, 2175, null);
    }

    public static /* synthetic */ ScanSummary getScanSummary$default(ScanSummaryService scanSummaryService, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return scanSummaryService.getScanSummary(string);
    }

    private final UserBaseScan getScan(String scanId) {
        UserBaseScan scan = this.userBaseScanService.getScan(scanId);
        return this.validateScanStatus(scan);
    }

    private final UserBaseScan getLatestStartedScan() {
        UserBaseScan latestStartedScan = this.userBaseScanService.getLatestStarted();
        return this.validateScanStatus(latestStartedScan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UserBaseScan validateScanStatus(UserBaseScan scan) {
        ClusterLock lock;
        UserBaseScan userBaseScan = scan;
        if ((userBaseScan != null ? userBaseScan.getStatus() : null) == ScanStatus.IN_PROGRESS && (lock = this.clusterLockService.getLockForName("jcma.preflight.userbase.scan")).tryLock(1L, TimeUnit.SECONDS)) {
            try {
                UserBaseScan stateWithLock;
                UserBaseScan userBaseScan2 = stateWithLock = this.userBaseScanService.getScan(scan.getId());
                UserBaseScan userBaseScan3 = (userBaseScan2 != null ? userBaseScan2.getStatus() : null) == ScanStatus.IN_PROGRESS ? UserBaseScan.copy$default((UserBaseScan)stateWithLock, (ScanStatus)ScanStatus.FAILED, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, null, (int)254, null) : stateWithLock;
                return userBaseScan3;
            }
            finally {
                lock.unlock();
            }
        }
        return scan;
    }
}

