/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.assessment.AppAggregatorResponse;
import com.atlassian.jira.migration.assessment.AppAssessmentService;
import com.atlassian.jira.migration.assessment.PluginManager;
import com.atlassian.jira.migration.events.AppCheckEvent;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.ServerAppsOutdatedCheckResult;
import com.atlassian.jira.migration.preflight.ServerAppsOutdatedCheckService;
import com.atlassian.migration.app.AppCloudCapability;
import com.atlassian.plugin.Plugin;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/preflight/ServerAppsOutdatedCheckService;", "", "appAggregatorClient", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "appAssessmentService", "Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "pluginManager", "Lcom/atlassian/jira/migration/assessment/PluginManager;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;Lcom/atlassian/jira/migration/assessment/AppAssessmentService;Lcom/atlassian/jira/migration/assessment/PluginManager;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nServerAppsOutdatedCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerAppsOutdatedCheckService.kt\ncom/atlassian/jira/migration/preflight/ServerAppsOutdatedCheckService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1045#2:104\n*S KotlinDebug\n*F\n+ 1 ServerAppsOutdatedCheckService.kt\ncom/atlassian/jira/migration/preflight/ServerAppsOutdatedCheckService\n*L\n62#1:104\n*E\n"})
public final class ServerAppsOutdatedCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppAggregatorClient appAggregatorClient;
    @NotNull
    private final AppAssessmentService appAssessmentService;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private static final Logger log = LoggerFactory.getLogger(ServerAppsOutdatedCheckService.class);

    @Inject
    public ServerAppsOutdatedCheckService(@NotNull AppAggregatorClient appAggregatorClient, @NotNull AppAssessmentService appAssessmentService, @NotNull PluginManager pluginManager, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)appAggregatorClient, (String)"appAggregatorClient");
        Intrinsics.checkNotNullParameter((Object)appAssessmentService, (String)"appAssessmentService");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.appAggregatorClient = appAggregatorClient;
        this.appAssessmentService = appAssessmentService;
        this.pluginManager = pluginManager;
        this.migrationEventBus = migrationEventBus;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        Iterable iterable = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)PreflightCheckKt.getAppKeys(checkRequest)), (Function1)((Function1)new Function1<String, Plugin>(this){
            final /* synthetic */ ServerAppsOutdatedCheckService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Plugin invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Plugin plugin = ServerAppsOutdatedCheckService.access$getPluginManager$p(this.this$0).getPlugin(it);
                if (plugin == null) {
                    ServerAppsOutdatedCheckService.access$getLog$cp().warn("Plugin with key " + it + " not found");
                }
                return plugin;
            }
        }))), (Function1)((Function1)new Function1<Plugin, Pair<? extends Plugin, ? extends AppAggregatorResponse>>(this){
            final /* synthetic */ ServerAppsOutdatedCheckService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Pair<Plugin, AppAggregatorResponse> invoke(@NotNull Plugin it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AppAggregatorClient appAggregatorClient = ServerAppsOutdatedCheckService.access$getAppAggregatorClient$p(this.this$0);
                String string = it.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                return new Pair((Object)it, (Object)appAggregatorClient.getServerAppData(string));
            }
        })), (Function1)((Function1)new Function1<Pair<? extends Plugin, ? extends AppAggregatorResponse>, Boolean>(this){
            final /* synthetic */ ServerAppsOutdatedCheckService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<? extends Plugin, AppAggregatorResponse> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ServerAppsOutdatedCheckService.access$getAppAssessmentService$p(this.this$0).getState((Plugin)it.getFirst(), (AppAggregatorResponse)it.getSecond()) == AppCloudCapability.upgrade;
            }
        })), (Function1)performCheck.serverAppsOutdated.4.INSTANCE));
        boolean $i$f$sortedBy = false;
        List serverAppsOutdated2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ServerAppsOutdatedCheckResult it = (ServerAppsOutdatedCheckResult)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ServerAppsOutdatedCheckResult)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        CheckResult checkResult = new CheckResult(serverAppsOutdated2.isEmpty(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"serverAppsOutdated", (Object)serverAppsOutdated2)));
        long endTime = System.nanoTime();
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        this.migrationEventBus.post(new AppCheckEvent("serverAppsOutdatedCheck", string, string2, (endTime - startTime) / (long)1000000, checkResult.success, ExportStatistics.Companion.getEMPTY(), PreflightCheckKt.getAppKeys(checkRequest).size(), serverAppsOutdated2.size()));
        return checkResult;
    }

    public static final /* synthetic */ PluginManager access$getPluginManager$p(ServerAppsOutdatedCheckService $this) {
        return $this.pluginManager;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ AppAggregatorClient access$getAppAggregatorClient$p(ServerAppsOutdatedCheckService $this) {
        return $this.appAggregatorClient;
    }

    public static final /* synthetic */ AppAssessmentService access$getAppAssessmentService$p(ServerAppsOutdatedCheckService $this) {
        return $this.appAssessmentService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/ServerAppsOutdatedCheckService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

