/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.jira.migration.preflight.AbstractSharedEmailCheck;
import com.atlassian.jira.migration.preflight.BulkImportCompatibilityWithUdcService;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.DuplicateEmailCheckService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.migration.udc.common.model.user.AccountType;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/preflight/SharedEmailsCheck;", "Lcom/atlassian/jira/migration/preflight/AbstractSharedEmailCheck;", "emailCheckService", "Lcom/atlassian/jira/migration/preflight/DuplicateEmailCheckService;", "bulkImportCompatibilityWithUdcService", "Lcom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService;", "(Lcom/atlassian/jira/migration/preflight/DuplicateEmailCheckService;Lcom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService;)V", "accountType", "Lcom/atlassian/migration/udc/common/model/user/AccountType;", "getAccountType", "()Lcom/atlassian/migration/udc/common/model/user/AccountType;", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "jira-migration-plugin"})
public final class SharedEmailsCheck
extends AbstractSharedEmailCheck {
    @NotNull
    private final CheckType checkType;
    @NotNull
    private final AccountType accountType;

    @Inject
    public SharedEmailsCheck(@NotNull DuplicateEmailCheckService emailCheckService, @NotNull BulkImportCompatibilityWithUdcService bulkImportCompatibilityWithUdcService) {
        Intrinsics.checkNotNullParameter((Object)emailCheckService, (String)"emailCheckService");
        Intrinsics.checkNotNullParameter((Object)bulkImportCompatibilityWithUdcService, (String)"bulkImportCompatibilityWithUdcService");
        super(emailCheckService, bulkImportCompatibilityWithUdcService);
        this.checkType = CheckType.SharedEmails;
        this.accountType = AccountType.USER;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public AccountType getAccountType() {
        return this.accountType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"usersAndGroups", ctx.getUsersAndGroups()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"loggedUser", (Object)ctx.getLoggedUser()), TuplesKt.to((Object)"singlePathMode", (Object)((Object)ctx.getSinglePathMode())), TuplesKt.to((Object)"umsPreflightCheckDetails", (Object)ctx.getUmsPreflightCheckDetails()), TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"migrationScopeId", (Object)ctx.getMigrationScopeId()), TuplesKt.to((Object)"usersFixedData", ctx.getUsersFixedData())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        this.getEmailDuplicateMapper().inject(dto, checkResult);
        this.getBulkImportCompatibilityWithUdcService().injectBiCompatibilityWithUdcInfo(dto, checkResult);
        this.handleExtractionError(dto, checkResult, "Check for duplicate email addresses could not be completed");
    }
}

