/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.jira.migration.preflight.ConnectivityTester;
import com.atlassian.jira.migration.preflight.model.ConnectionStatus;
import com.atlassian.jira.migration.preflight.model.ConnectionStatusType;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/preflight/SocketConnectivityTester;", "Lcom/atlassian/jira/migration/preflight/ConnectivityTester;", "()V", "isReachable", "Lcom/atlassian/jira/migration/preflight/model/ConnectionStatus;", "url", "", "headersToCheck", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSocketConnectivityTester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketConnectivityTester.kt\ncom/atlassian/jira/migration/preflight/SocketConnectivityTester\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,55:1\n167#2,3:56\n*S KotlinDebug\n*F\n+ 1 SocketConnectivityTester.kt\ncom/atlassian/jira/migration/preflight/SocketConnectivityTester\n*L\n24#1:56,3\n*E\n"})
public final class SocketConnectivityTester
implements ConnectivityTester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int TIMEOUT_IN_MILLIS = 5000;
    private static final Logger log = LoggerFactory.getLogger(SocketConnectivityTester.class);
    @NotNull
    private static final String GET = "GET";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ConnectionStatus isReachable(@NotNull String url, @Nullable Map<String, String> headersToCheck) {
        ConnectionStatus connectionStatus;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpURLConnection connection = null;
        try {
            ConnectionStatus connectionStatus2;
            boolean headersMatch;
            block15: {
                boolean bl;
                URL siteUrl = new URL(url);
                URLConnection uRLConnection = siteUrl.openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                connection = (HttpURLConnection)uRLConnection;
                connection.setRequestMethod(GET);
                connection.setConnectTimeout(5000);
                connection.connect();
                Map<String, List<String>> connectionHeaders = connection.getHeaderFields();
                Map<String, String> map = headersToCheck;
                if (map != null) {
                    Map<String, String> $this$all$iv = map;
                    boolean $i$f$all = false;
                    if ($this$all$iv.isEmpty()) {
                        bl = true;
                    } else {
                        Iterator<Map.Entry<String, String>> iterator2 = $this$all$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<String, String> element$iv;
                            Map.Entry<String, String> entry = element$iv = iterator2.next();
                            boolean bl2 = false;
                            String key = entry.getKey();
                            String value = entry.getValue();
                            List<String> list = connectionHeaders.get(key);
                            if (list != null ? list.contains(value) : false) continue;
                            bl = false;
                            break block15;
                        }
                        bl = true;
                    }
                } else {
                    bl = headersMatch = true;
                }
            }
            if (headersMatch) {
                connectionStatus2 = new ConnectionStatus(true, ConnectionStatusType.SUCCESS);
            } else {
                log.warn("Error to validate headers at " + url + ": {}", headersToCheck);
                connectionStatus2 = new ConnectionStatus(false, ConnectionStatusType.ERROR);
            }
            connectionStatus = connectionStatus2;
            connection.disconnect();
        }
        catch (IOException ex) {
            ConnectionStatus connectionStatus3;
            boolean isPKIXFailure;
            String string = ex.getMessage();
            boolean bl = isPKIXFailure = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"PKIX path building failed", (boolean)false, (int)2, null) : false;
            if (isPKIXFailure) {
                log.warn("Error opening connection PKIX at " + url + ':', (Throwable)ex);
                connectionStatus3 = new ConnectionStatus(false, ConnectionStatusType.PKIX);
            } else {
                log.warn("Error opening connection at " + url + ':', (Throwable)ex);
                connectionStatus3 = new ConnectionStatus(false, ConnectionStatusType.ERROR);
            }
            connectionStatus = connectionStatus3;
        }
        finally {
            HttpURLConnection httpURLConnection = connection;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return connectionStatus;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/preflight/SocketConnectivityTester$Companion;", "", "()V", "GET", "", "TIMEOUT_IN_MILLIS", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

