/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.domain.Edition;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PremiumLicenseService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u001a\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/preflight/StandardLicenseCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "premiumLicenseService", "Lcom/atlassian/jira/migration/preflight/PremiumLicenseService;", "(Lcom/atlassian/jira/migration/preflight/PremiumLicenseService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "handleSuccess", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "result", "inject", "performCheck", "checkRequest", "jira-migration-plugin"})
public final class StandardLicenseCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final PremiumLicenseService premiumLicenseService;
    @NotNull
    private final CheckType checkType;

    @Inject
    public StandardLicenseCheck(@NotNull PremiumLicenseService premiumLicenseService) {
        Intrinsics.checkNotNullParameter((Object)premiumLicenseService, (String)"premiumLicenseService");
        this.premiumLicenseService = premiumLicenseService;
        this.checkType = CheckType.StandardLicenseCheck;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.premiumLicenseService.performCheck(checkRequest);
    }

    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult result2) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        dto.setNumberOfOccurrences(Integer.valueOf(0));
        dto.setDetails(new CheckDetailsDto());
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                CheckResult checkResult = result2;
                Intrinsics.checkNotNull((Object)checkResult);
                this.handleSuccess(dto, checkResult);
                break;
            }
            case 2: {
                dto.setDescription("Checking subscription on cloud");
                break;
            }
            case 3: {
                dto.setStatus(Status.EXECUTION_ERROR);
                dto.setDescription("We couldn\u2019t check your subscription in cloud");
            }
        }
    }

    private final void handleSuccess(CheckResultDto dto, CheckResult result2) {
        Object v = result2.details.get("RESULT_KEY");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.preflight.PremiumLicenseService.EditionResult");
        PremiumLicenseService.EditionResult $this$handleSuccess_u24lambda_u240 = (PremiumLicenseService.EditionResult)v;
        boolean bl = false;
        if ($this$handleSuccess_u24lambda_u240.getJiraSoftwareEdition() == Edition.PREMIUM) {
            dto.setStatus(Status.SUCCESS);
            dto.setDescription("Your current subscription supports Advanced Roadmaps");
        } else {
            dto.setStatus(Status.WARNING);
            dto.setDescription("Your cloud subscription doesn't support Advanced Roadmaps");
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

