/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.TriggerUserBaseScanEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.PrepareUserBaseService;
import com.atlassian.jira.migration.utils.UDCConverterKt;
import com.atlassian.migration.udc.common.model.cloud.CloudSite;
import com.atlassian.migration.udc.scan.UserBaseScanRunner;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/preflight/TriggerUserBaseScanEventHandler;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "prepareUserBaseService", "Lcom/atlassian/jira/migration/preflight/PrepareUserBaseService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "udcBaseScanRunner", "Lcom/atlassian/migration/udc/scan/UserBaseScanRunner;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/preflight/PrepareUserBaseService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/migration/udc/scan/UserBaseScanRunner;)V", "postConstruct", "", "preDestroy", "receive", "event", "Lcom/atlassian/jira/migration/common/TriggerUserBaseScanEvent;", "jira-migration-plugin"})
public final class TriggerUserBaseScanEventHandler {
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final PrepareUserBaseService prepareUserBaseService;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final UserBaseScanRunner udcBaseScanRunner;

    @Inject
    public TriggerUserBaseScanEventHandler(@NotNull MigrationEventBus migrationEventBus, @NotNull PrepareUserBaseService prepareUserBaseService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull UserBaseScanRunner udcBaseScanRunner) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)prepareUserBaseService, (String)"prepareUserBaseService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)udcBaseScanRunner, (String)"udcBaseScanRunner");
        this.migrationEventBus = migrationEventBus;
        this.prepareUserBaseService = prepareUserBaseService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationFeatures = migrationFeatures;
        this.udcBaseScanRunner = udcBaseScanRunner;
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
    }

    @Subscribe
    public final void receive(@NotNull TriggerUserBaseScanEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.migrationFeatures.getUseUDCLibraryForUserBaseScan()) {
            com.atlassian.jira.migration.cloud.CloudSite cloudSite2 = this.cloudSiteRepository.getSite(event.getCloudId());
            this.udcBaseScanRunner.safelyStartUserBaseScan(UDCConverterKt.toUDC(event.getLoggedInUser()), (CloudSite)(cloudSite2 != null ? UDCConverterKt.toUDC(cloudSite2) : null));
        } else {
            this.prepareUserBaseService.safelyStartUserBaseScan(event.getLoggedInUser(), this.cloudSiteRepository.getSite(event.getCloudId()));
        }
    }

    @PreDestroy
    public final void preDestroy() {
        this.migrationEventBus.unregister(this);
    }
}

