/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.jira.migration.common.ResourceInputFactory;
import com.atlassian.jira.migration.email.EmailTrustedDomainService;
import com.atlassian.jira.migration.email.model.EmailTrustedDomain;
import com.atlassian.jira.migration.email.model.EmailTrustedDomainCsvEntry;
import com.atlassian.jira.migration.email.model.ModelKt;
import com.atlassian.jira.migration.preflight.TrustedDomainsCsvZipException;
import com.atlassian.migration.udc.file.LocalFileDataOutput;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ParseEnum;
import org.supercsv.cellprocessor.Trim;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.constraint.StrMinMax;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.io.CsvBeanWriter;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u001a\u0010\u001a\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/preflight/TrustedDomainsCsvZipService;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "emailTrustedDomainService", "Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;", "resourceInputFactory", "Lcom/atlassian/jira/migration/common/ResourceInputFactory;", "csvBeanWriterFactory", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "Lorg/supercsv/io/CsvBeanWriter;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/email/EmailTrustedDomainService;Lcom/atlassian/jira/migration/common/ResourceInputFactory;Lkotlin/jvm/functions/Function1;)V", "createEmptyDomainsCsv", "Ljava/io/File;", "fileTimestamp", "", "writeDomainsCsv", "", "csvFile", "domainEntries", "", "Lcom/atlassian/jira/migration/email/model/EmailTrustedDomain;", "writeDomainsCsvZip", "outputStream", "writeDomainsZip", "writeCsvEntries", "", "Lcom/atlassian/jira/migration/email/model/EmailTrustedDomainCsvEntry;", "csvWriter", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTrustedDomainsCsvZipService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrustedDomainsCsvZipService.kt\ncom/atlassian/jira/migration/preflight/TrustedDomainsCsvZipService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1#2:146\n1549#3:147\n1620#3,3:148\n1855#3,2:151\n*S KotlinDebug\n*F\n+ 1 TrustedDomainsCsvZipService.kt\ncom/atlassian/jira/migration/preflight/TrustedDomainsCsvZipService\n*L\n104#1:147\n104#1:148,3\n114#1:151,2\n*E\n"})
public final class TrustedDomainsCsvZipService {
    @org.jetbrains.annotations.NotNull
    public static final Companion Companion = new Companion(null);
    @org.jetbrains.annotations.NotNull
    private final com.atlassian.jira.migration.common.LocalFileDataOutput localFileDataOutput;
    @org.jetbrains.annotations.NotNull
    private final EmailTrustedDomainService emailTrustedDomainService;
    @org.jetbrains.annotations.NotNull
    private final ResourceInputFactory resourceInputFactory;
    @org.jetbrains.annotations.NotNull
    private final Function1<OutputStream, CsvBeanWriter> csvBeanWriterFactory;
    public static final long minCsvEntryLength = 1L;
    public static final long maxCsvEntryLength = 255L;

    @Inject
    public TrustedDomainsCsvZipService(@org.jetbrains.annotations.NotNull com.atlassian.jira.migration.common.LocalFileDataOutput localFileDataOutput, @org.jetbrains.annotations.NotNull EmailTrustedDomainService emailTrustedDomainService, @org.jetbrains.annotations.NotNull ResourceInputFactory resourceInputFactory, @org.jetbrains.annotations.NotNull Function1<? super OutputStream, ? extends CsvBeanWriter> csvBeanWriterFactory2) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)emailTrustedDomainService, (String)"emailTrustedDomainService");
        Intrinsics.checkNotNullParameter((Object)resourceInputFactory, (String)"resourceInputFactory");
        Intrinsics.checkNotNullParameter(csvBeanWriterFactory2, (String)"csvBeanWriterFactory");
        this.localFileDataOutput = localFileDataOutput;
        this.emailTrustedDomainService = emailTrustedDomainService;
        this.resourceInputFactory = resourceInputFactory;
        this.csvBeanWriterFactory = csvBeanWriterFactory2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeDomainsCsvZip(@org.jetbrains.annotations.NotNull OutputStream outputStream, long fileTimestamp) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        File csvFile = null;
        try {
            csvFile = this.createEmptyDomainsCsv(fileTimestamp);
            List domainEntries = CollectionsKt.sorted((Iterable)this.emailTrustedDomainService.getNotBlockedDomains());
            this.writeDomainsCsv(csvFile, domainEntries);
            this.writeDomainsZip(csvFile, outputStream);
        }
        finally {
            File file2 = csvFile;
            if (file2 != null) {
                file2.delete();
            }
        }
    }

    private final File createEmptyDomainsCsv(long fileTimestamp) {
        Comparable<Path> comparable;
        try {
            Comparable<Path> comparable2;
            Path dir = this.localFileDataOutput.migrationDomainsDirectory();
            boolean bl = false;
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            Path p0 = comparable2 = dir.resolve("trusted-domains-" + fileTimestamp + ".csv");
            boolean bl2 = false;
            Files.deleteIfExists(p0);
            p0 = comparable2;
            boolean bl3 = false;
            p0 = Files.createFile(p0, new FileAttribute[0]);
            boolean bl4 = false;
            p0 = comparable2 = p0.toFile();
            boolean bl5 = false;
            ((File)((Object)p0)).deleteOnExit();
            comparable = comparable2;
            Intrinsics.checkNotNull((Object)comparable);
        }
        catch (Exception e) {
            throw new TrustedDomainsCsvZipException(TrustedDomainsCsvZipException.Type.COULD_NOT_CREATE_CSV, (Throwable)e);
        }
        return comparable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeDomainsCsv(File csvFile, List<EmailTrustedDomain> domainEntries) {
        try {
            Closeable closeable = new FileOutputStream(csvFile);
            Throwable throwable = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)this.csvBeanWriterFactory.invoke((Object)output);
                Throwable throwable2 = null;
                try {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    CsvBeanWriter csvWriter = (CsvBeanWriter)closeable2;
                    boolean bl2 = false;
                    Object object = new String[]{ModelKt.getDomainFileHeaders()[0], ModelKt.getDomainFileHeaders()[1]};
                    csvWriter.writeHeader(object);
                    object = domainEntries;
                    TrustedDomainsCsvZipService trustedDomainsCsvZipService = this;
                    boolean $i$f$map = false;
                    void var14_19 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        EmailTrustedDomain emailTrustedDomain = (EmailTrustedDomain)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(ModelKt.toCsvEntry((EmailTrustedDomain)p0));
                    }
                    trustedDomainsCsvZipService.writeCsvEntries((List)destination$iv$iv, csvWriter);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new TrustedDomainsCsvZipException(TrustedDomainsCsvZipException.Type.COULD_NOT_WRITE_CSV, (Throwable)e);
        }
    }

    private final void writeCsvEntries(Iterable<EmailTrustedDomainCsvEntry> $this$writeCsvEntries, CsvBeanWriter csvWriter) {
        Iterable<EmailTrustedDomainCsvEntry> $this$forEach$iv = $this$writeCsvEntries;
        boolean $i$f$forEach = false;
        Iterator<EmailTrustedDomainCsvEntry> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            EmailTrustedDomainCsvEntry element$iv;
            EmailTrustedDomainCsvEntry entry = element$iv = iterator2.next();
            boolean bl = false;
            CellProcessorAdaptor[] cellProcessorAdaptorArray = new CellProcessorAdaptor[]{new EmailTrustedDomainService.NotBlank((CellProcessor)new NotNull((CellProcessor)new StrMinMax(1L, 255L))), new NotNull((CellProcessor)new Trim((StringCellProcessor)new ParseEnum(EmailTrustedDomain.DomainNameRule.class)))};
            csvWriter.write((Object)entry, ModelKt.getDomainFileHeaders(), (CellProcessor[])cellProcessorAdaptorArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeDomainsZip(File csvFile, OutputStream outputStream) {
        try {
            Closeable closeable = new ZipOutputStream(new BufferedOutputStream(outputStream));
            Throwable throwable = null;
            try {
                Unit unit;
                ZipOutputStream zipOut = (ZipOutputStream)closeable;
                boolean bl = false;
                LocalFileDataOutput localFileDataOutput = this.localFileDataOutput;
                Path path = csvFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                LocalFileDataOutput.addToZip$default((LocalFileDataOutput)localFileDataOutput, (ZipOutputStream)zipOut, (Path)path, null, (int)4, null);
                InputStream inputStream = this.resourceInputFactory.domainsReadme();
                if (inputStream != null) {
                    Closeable closeable2 = inputStream;
                    Throwable throwable2 = null;
                    try {
                        InputStream it = (InputStream)closeable2;
                        boolean bl2 = false;
                        this.localFileDataOutput.addToZip(zipOut, "readme.txt", it);
                        Unit unit2 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit3 = unit;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new TrustedDomainsCsvZipException(TrustedDomainsCsvZipException.Type.COULD_NOT_WRITE_ZIP, (Throwable)e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/TrustedDomainsCsvZipService$Companion;", "", "()V", "maxCsvEntryLength", "", "minCsvEntryLength", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

