/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.domain.Edition;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migrationservice.TcsProductInfo;
import com.atlassian.jira.migration.preflight.JiraProductInCloudRequestParams;
import com.atlassian.jira.migration.preflight.JiraProductInCloudResultParams;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.ums.exceptions.UmsPreflightCheckException;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckDetails;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckType;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightResponse;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.usersmigrationservice.MismatchedProduct;
import com.atlassian.jira.migration.usersmigrationservice.ProductMismatchCheckResponse;
import com.atlassian.jira.migration.usersmigrationservice.ProductMismatchCheckResult;
import com.atlassian.jira.migration.utils.CompletableFutureUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0019*\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/atlassian/jira/migration/preflight/UMSProductMismatchService;", "", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "checkIfProductInstallationIsRequired", "", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "isProductInstalled", "cloudProductKey", "Lcom/atlassian/cmpt/domain/Product;", "isProjectPresentForProduct", "projectKeys", "", "", "productKey", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "jiraProductInCloudRequestParams", "Lcom/atlassian/jira/migration/preflight/JiraProductInCloudRequestParams;", "redirectLinkToAddJWMProduct", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "redirectLinkToAddJiraProduct", "removeProductFromCloudSite", "", "cloudSiteDetails", "getProducts", "Lcom/atlassian/jira/migration/migrationservice/TcsProductInfo;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUMSProductMismatchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UMSProductMismatchService.kt\ncom/atlassian/jira/migration/preflight/UMSProductMismatchService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,147:1\n1747#2,3:148\n2624#2,3:151\n223#2,2:154\n766#2:156\n857#2,2:157\n1#3:159\n58#4:160\n51#4:161\n*S KotlinDebug\n*F\n+ 1 UMSProductMismatchService.kt\ncom/atlassian/jira/migration/preflight/UMSProductMismatchService\n*L\n33#1:148,3\n74#1:151,3\n78#1:154,2\n124#1:156\n124#1:157,2\n140#1:160\n140#1:161\n*E\n"})
public abstract class UMSProductMismatchService {
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ObjectMapper mapper;
    private final Logger log;

    @Inject
    public UMSProductMismatchService(@NotNull ProjectManager projectManager, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.projectManager = projectManager;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationFeatures = migrationFeatures;
        this.mapper = objectMapperFactory.createObjectMapper();
        this.log = LoggerFactory.getLogger(UMSProductMismatchService.class);
    }

    public final boolean isProjectPresentForProduct(@NotNull List<String> projectKeys, @NotNull String productKey) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
            Intrinsics.checkNotNullParameter((Object)productKey, (String)"productKey");
            Iterable $this$any$iv = projectKeys;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Project project = this.projectManager.getProjectObjByKey(it);
                    if (!Intrinsics.areEqual((Object)(project != null && (project = project.getProjectTypeKey()) != null ? project.getKey() : null), (Object)productKey)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public abstract boolean checkIfProductInstallationIsRequired(@NotNull CheckRequest var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProductInstalled(CheckRequest checkRequest, Product cloudProductKey) {
        Object element$iv;
        MismatchedProduct it;
        boolean isProductInstalled;
        MismatchedProduct it2;
        if (Intrinsics.areEqual((Object)PreflightCheckKt.getUsersAndGroups(checkRequest), (Object)UsersGroupsExtractionResult.Companion.getEMPTY())) {
            return true;
        }
        UmsPreflightCheckDetails umsPreflightCheckDetails = PreflightCheckKt.getUmsPreflightCheckDetails(checkRequest);
        CompletableFutureUtil.INSTANCE.getCompletedValue((Future)umsPreflightCheckDetails.getFileId());
        UmsPreflightResponse umsPreflightResponse = umsPreflightCheckDetails.getUmsPreflightCheckResults().get((Object)UmsPreflightCheckType.ProductMismatch);
        Intrinsics.checkNotNull((Object)umsPreflightResponse);
        UmsPreflightResponse umsProductMismatchCheckResults = umsPreflightResponse;
        Object object = CompletableFutureUtil.INSTANCE.getCompletedValue((Future)umsProductMismatchCheckResults.getResult());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.usersmigrationservice.ProductMismatchCheckResponse");
        ProductMismatchCheckResponse productMismatchCheckResponse = (ProductMismatchCheckResponse)object;
        if (!((Collection)productMismatchCheckResponse.getErrors()).isEmpty()) {
            throw new UmsPreflightCheckException(checkRequest.checkType + " Ums ProductMismatchCheckResponse has the following error:" + productMismatchCheckResponse.getErrors());
        }
        ProductMismatchCheckResult productMismatchCheckResult = productMismatchCheckResponse.getProductsCheckResult();
        Intrinsics.checkNotNull((Object)productMismatchCheckResult);
        ProductMismatchCheckResult productMismatchData = productMismatchCheckResult;
        if (productMismatchData.getMismatchedProductsCount() == 0) return true;
        List<MismatchedProduct> list = productMismatchData.getMismatchedProducts();
        Intrinsics.checkNotNull(list);
        Iterable $this$none$iv = list;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv2 = iterator2.next();
            it2 = (MismatchedProduct)element$iv2;
            boolean bl = false;
        } while (!(it2.getProduct() == cloudProductKey));
        boolean bl = false;
        if (bl) {
            return true;
        }
        boolean bl2 = isProductInstalled = false;
        if (isProductInstalled) {
            return true;
        }
        List<MismatchedProduct> list2 = productMismatchData.getMismatchedProducts();
        Intrinsics.checkNotNull(list2);
        Iterable $this$first$iv = list2;
        boolean $i$f$first = false;
        Iterator iterator3 = $this$first$iv.iterator();
        do {
            if (!iterator3.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
            element$iv = iterator3.next();
            it = (MismatchedProduct)element$iv;
            boolean bl3 = false;
        } while (!(it.getProduct() == cloudProductKey));
        int mismatchedGroupCount = ((MismatchedProduct)element$iv).getGroupsCount();
        if (mismatchedGroupCount > 0) {
            return false;
        }
        if (this.checkIfProductInstallationIsRequired(checkRequest)) return false;
        return true;
    }

    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest, @NotNull JiraProductInCloudRequestParams jiraProductInCloudRequestParams) {
        boolean isJiraCoreProduct;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        Intrinsics.checkNotNullParameter((Object)jiraProductInCloudRequestParams, (String)"jiraProductInCloudRequestParams");
        CloudSite savedCloudSiteDetails = jiraProductInCloudRequestParams.getJiraProductsCloudFreeUserLimitPreflightService().getSavedCloudDetails(checkRequest);
        boolean isProductInstalled = this.isProductInstalled(checkRequest, jiraProductInCloudRequestParams.getCloudProductKey());
        boolean bl = isJiraCoreProduct = jiraProductInCloudRequestParams.getCloudProductKey() == Product.JIRA_CORE;
        if (!isProductInstalled) {
            this.removeProductFromCloudSite(savedCloudSiteDetails, jiraProductInCloudRequestParams.getCloudProductKey());
        }
        return new CheckResult(isProductInstalled, MapsKt.mapOf((Pair)TuplesKt.to((Object)"RESULT_PARAMS", (Object)new JiraProductInCloudResultParams(isProductInstalled, !isProductInstalled, isJiraCoreProduct && !this.migrationFeatures.getDisableRequestParameterInRequestUrlForSpork() ? this.redirectLinkToAddJWMProduct(savedCloudSiteDetails) : this.redirectLinkToAddJiraProduct(savedCloudSiteDetails)))));
    }

    /*
     * WARNING - void declaration
     */
    private final void removeProductFromCloudSite(CloudSite cloudSiteDetails, Product cloudProductKey) {
        void $this$filterTo$iv$iv;
        CloudSite $this$removeProductFromCloudSite_u24lambda_u244 = cloudSiteDetails;
        boolean bl = false;
        List<TcsProductInfo> allProducts = this.getProducts($this$removeProductFromCloudSite_u24lambda_u244);
        Iterable $this$filter$iv = allProducts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TcsProductInfo it = (TcsProductInfo)element$iv$iv;
            boolean bl2 = false;
            if (!(!Intrinsics.areEqual((Object)it.getProductKey().getKey(), (Object)cloudProductKey.getKey()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List actualProducts = (List)destination$iv$iv;
        if (actualProducts.size() != allProducts.size()) {
            this.log.warn("Removing product " + cloudProductKey.getKey() + " from cloud site " + $this$removeProductFromCloudSite_u24lambda_u244.getCloudId());
            Edition edition = $this$removeProductFromCloudSite_u24lambda_u244.getCloudEdition();
            this.cloudSiteRepository.saveOrUpdate($this$removeProductFromCloudSite_u24lambda_u244.getCloudId(), $this$removeProductFromCloudSite_u24lambda_u244.getCloudUrl(), $this$removeProductFromCloudSite_u24lambda_u244.getContainerToken(), edition != null ? edition.getKey() : null, actualProducts, $this$removeProductFromCloudSite_u24lambda_u244.getCloudType());
        }
    }

    private final List<TcsProductInfo> getProducts(CloudSite $this$getProducts) {
        Object object;
        block3: {
            block2: {
                object = $this$getProducts.getProductsJson();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                ObjectMapper $this$readValue$iv = this.mapper;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef = false;
                List list = (List)$this$readValue$iv.readValue(it, (TypeReference)new TypeReference<List<? extends TcsProductInfo>>(){});
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final String redirectLinkToAddJiraProduct(CloudSite cloudSite2) {
        return cloudSite2.getCloudUrl() + "/admin/billing/applications";
    }

    private final String redirectLinkToAddJWMProduct(CloudSite cloudSite2) {
        return cloudSite2.getCloudUrl() + "/admin/billing/addapplication?source=migration";
    }
}

