/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.ObjectMapperService;
import com.atlassian.jira.migration.platform.DownloadedFile;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.ums.exceptions.UmsPreflightCheckException;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckDetails;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckType;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightResponse;
import com.atlassian.jira.migration.s3.S3FileDownloader;
import com.atlassian.jira.migration.s3.exception.S3FileReadException;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.usersmigrationservice.EmailCheckStatusResponse;
import com.atlassian.jira.migration.usersmigrationservice.EmailValidationResult;
import com.atlassian.jira.migration.usersmigrationservice.InvalidEmailDetails;
import com.atlassian.jira.migration.usersmigrationservice.InvalidEmails;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceErrorResponse;
import com.atlassian.jira.migration.utils.CompletableFutureUtil;
import com.atlassian.jira.migration.utils.FileUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/preflight/UmsInvalidEmailChecker;", "", "s3FileDownloader", "Lcom/atlassian/jira/migration/s3/S3FileDownloader;", "objectMapperService", "Lcom/atlassian/jira/migration/common/ObjectMapperService;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "(Lcom/atlassian/jira/migration/s3/S3FileDownloader;Lcom/atlassian/jira/migration/common/ObjectMapperService;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;)V", "buildMap", "", "", "invalidEmails", "", "Lcom/atlassian/cmpt/check/email/EmailData;", "check", "Lcom/atlassian/cmpt/check/base/CheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "deleteFile", "", "downloadedFileContent", "Lcom/atlassian/jira/migration/platform/DownloadedFile;", "getCheckStatusResponse", "Lcom/atlassian/jira/migration/usersmigrationservice/EmailCheckStatusResponse;", "getInvalidEmailDetails", "Lcom/atlassian/jira/migration/usersmigrationservice/InvalidEmailDetails;", "fileId", "handleEmailViolations", "emailValidationResult", "Lcom/atlassian/jira/migration/usersmigrationservice/EmailValidationResult;", "readFileContents", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUmsInvalidEmailChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UmsInvalidEmailChecker.kt\ncom/atlassian/jira/migration/preflight/UmsInvalidEmailChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,164:1\n1549#2:165\n1620#2,3:166\n1477#2:169\n1502#2,3:170\n1505#2,3:180\n1238#2,2:185\n1549#2:187\n1620#2,3:188\n1241#2:191\n819#2:192\n847#2,2:193\n1549#2:195\n1620#2,3:196\n372#3,7:173\n453#3:183\n403#3:184\n*S KotlinDebug\n*F\n+ 1 UmsInvalidEmailChecker.kt\ncom/atlassian/jira/migration/preflight/UmsInvalidEmailChecker\n*L\n43#1:165\n43#1:166,3\n69#1:169\n69#1:170,3\n69#1:180,3\n69#1:185,2\n69#1:187\n69#1:188,3\n69#1:191\n73#1:192\n73#1:193,2\n76#1:195\n76#1:196,3\n69#1:173,7\n69#1:183\n69#1:184\n*E\n"})
public final class UmsInvalidEmailChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final S3FileDownloader s3FileDownloader;
    @NotNull
    private final ObjectMapperService objectMapperService;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    private static final Logger log = LoggerFactory.getLogger(UmsInvalidEmailChecker.class);
    @NotNull
    public static final String VIOLATIONS_KEY = "violations";
    @NotNull
    private static final String FAILED_TO_FETCH_ERROR_MESSAGE = "Failed to fetch UMS preflight check response.";
    @NotNull
    private static final String CHECK_EXECUTION_ERROR_MESSAGE = "Error occurred while executing emails preflight check.";
    @NotNull
    private static final String S3_ERROR_MESSAGE = "Error occurred while reading contents of S3 file. Error details: {}";
    @NotNull
    private static final String S3_FILE_FETCH_ERROR_MESSAGE = "Error occurred while fetching file from S3. Error details: {}";
    @NotNull
    private static final String FILE_SUFFIX = "invalidEmails.json";

    @Inject
    public UmsInvalidEmailChecker(@NotNull S3FileDownloader s3FileDownloader, @NotNull ObjectMapperService objectMapperService, @NotNull LocalFileDataOutput localFileDataOutput) {
        Intrinsics.checkNotNullParameter((Object)s3FileDownloader, (String)"s3FileDownloader");
        Intrinsics.checkNotNullParameter((Object)objectMapperService, (String)"objectMapperService");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        this.s3FileDownloader = s3FileDownloader;
        this.objectMapperService = objectMapperService;
        this.localFileDataOutput = localFileDataOutput;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult check(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        if (Intrinsics.areEqual((Object)PreflightCheckKt.getUsersAndGroups(checkRequest), (Object)UsersGroupsExtractionResult.Companion.getEMPTY())) {
            return new CheckResult(true, this.buildMap(CollectionsKt.emptyList()));
        }
        EmailCheckStatusResponse checkStatusResponse = this.getCheckStatusResponse(checkRequest);
        if (!((Collection)checkStatusResponse.getErrors()).isEmpty()) {
            void $this$mapTo$iv$iv;
            log.error(FAILED_TO_FETCH_ERROR_MESSAGE);
            Iterable $this$map$iv = checkStatusResponse.getErrors();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UsersMigrationServiceErrorResponse usersMigrationServiceErrorResponse = (UsersMigrationServiceErrorResponse)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getMessage());
            }
            String string = ((List)destination$iv$iv).toString();
            throw new UmsPreflightCheckException(string);
        }
        if (checkStatusResponse.getEmailValidationResult() != null) {
            if (checkStatusResponse.getEmailValidationResult().getInvalidEmailsCount() == 0) {
                log.info("UMS email preflight check was successful with no invalid emails");
                checkResult = new CheckResult(true, this.buildMap(CollectionsKt.emptyList()));
            } else {
                log.info("Found " + checkStatusResponse.getEmailValidationResult().getInvalidEmailsCount() + " invalid emails with UMS email preflight check");
                checkResult = this.handleEmailViolations(checkRequest, checkStatusResponse.getEmailValidationResult());
            }
        } else {
            throw new UmsPreflightCheckException(CHECK_EXECUTION_ERROR_MESSAGE);
        }
        return checkResult;
    }

    /*
     * WARNING - void declaration
     */
    private final CheckResult handleEmailViolations(CheckRequest checkRequest, EmailValidationResult emailValidationResult) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        String it;
        Object object;
        Iterable $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Map $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        if (emailValidationResult.getFileId() == null) {
            throw new UmsPreflightCheckException(CHECK_EXECUTION_ERROR_MESSAGE);
        }
        InvalidEmailDetails invalidEmailDetails = this.getInvalidEmailDetails(checkRequest, emailValidationResult.getFileId());
        Object $this$groupBy$iv = PreflightCheckKt.getUsersAndGroups(checkRequest).getUsers();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            JiraUser it2 = (JiraUser)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it2.getEmail();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            Iterator list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                JiraUser jiraUser = (JiraUser)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it3.getUserName());
            }
            List list = (List)destination$iv$iv2;
            object.put(k, list);
        }
        Map emailToUserNames = destination$iv$iv;
        ArrayList violations = new ArrayList();
        $this$mapValuesTo$iv$iv = CollectionsKt.toSet((Iterable)invalidEmailDetails.getInvalidEmails());
        boolean $i$f$filterNot = false;
        void $i$f$mapValuesTo22 = $this$filterNot$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            InvalidEmails it4 = (InvalidEmails)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it4.getEmail(), (String)"udcGeneratedEmail_", (boolean)false, (int)2, null)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        for (InvalidEmails invalidEmail : (List)destination$iv$iv3) {
            void $this$mapTo$iv$iv;
            List userNames2;
            List list = userNames2 = (List)emailToUserNames.get(invalidEmail.getEmail());
            if (list == null) continue;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable list$iv$iv = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void userName;
                it = (String)item$iv$iv;
                object = destination$iv$iv4;
                boolean bl = false;
                object.add(new EmailData((String)userName, invalidEmail.getEmail()));
            }
            List it5 = (List)destination$iv$iv4;
            boolean bl = false;
            violations.addAll(it5);
        }
        return violations.isEmpty() ? new CheckResult(true, this.buildMap(CollectionsKt.emptyList())) : new CheckResult(false, this.buildMap(violations));
    }

    private final EmailCheckStatusResponse getCheckStatusResponse(CheckRequest checkRequest) {
        try {
            UmsPreflightCheckDetails umsPreflightCheckDetails = PreflightCheckKt.getUmsPreflightCheckDetails(checkRequest);
            CompletableFutureUtil.INSTANCE.getCompletedValue((Future)umsPreflightCheckDetails.getFileId());
            UmsPreflightResponse umsPreflightResponse = umsPreflightCheckDetails.getUmsPreflightCheckResults().get((Object)UmsPreflightCheckType.InvalidEmails);
            if (umsPreflightResponse == null) {
                throw new UmsPreflightCheckException(FAILED_TO_FETCH_ERROR_MESSAGE);
            }
            UmsPreflightResponse umsPreflightResponse2 = umsPreflightResponse;
            Object object = CompletableFutureUtil.INSTANCE.getCompletedValue((Future)umsPreflightResponse2.getResult());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.usersmigrationservice.EmailCheckStatusResponse");
            return (EmailCheckStatusResponse)object;
        }
        catch (InterruptedException e) {
            log.error(FAILED_TO_FETCH_ERROR_MESSAGE, (Object)checkRequest.checkType, (Object)e);
            throw new UmsPreflightCheckException(FAILED_TO_FETCH_ERROR_MESSAGE, e);
        }
        catch (ExecutionException e) {
            log.error(FAILED_TO_FETCH_ERROR_MESSAGE, (Object)checkRequest.checkType, (Object)e);
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)e);
            throw new UmsPreflightCheckException("Failed to fetch UMS preflight check response. root cause : " + (throwable != null ? throwable.getMessage() : null), e);
        }
    }

    private final Map<String, Object> buildMap(List<? extends EmailData> invalidEmails) {
        return Collections.singletonMap(VIOLATIONS_KEY, invalidEmails);
    }

    private final InvalidEmailDetails readFileContents(DownloadedFile downloadedFileContent) {
        try {
            File file2 = downloadedFileContent.getPath().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            File file3 = file2;
            return this.objectMapperService.parse(new FileInputStream(file3), InvalidEmailDetails.class);
        }
        catch (IOException e) {
            String string = S3_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{e};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            log.error(string2);
            string = S3_ERROR_MESSAGE;
            objectArray = new Object[]{e};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new UmsPreflightCheckException(string3, e);
        }
        catch (JsonProcessingException e) {
            String string = S3_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{e};
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            log.error(string4);
            string = S3_ERROR_MESSAGE;
            objectArray = new Object[]{e};
            String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            throw new UmsPreflightCheckException(string5, e);
        }
    }

    private final void deleteFile(DownloadedFile downloadedFileContent) {
        FileUtil.INSTANCE.tryDeleteFile(downloadedFileContent.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InvalidEmailDetails getInvalidEmailDetails(CheckRequest checkRequest, String fileId) {
        Path path = FileUtil.INSTANCE.createNewFile(this.localFileDataOutput.umsInvalidEmailResponseDirectory(), PreflightCheckKt.getPreflightCheckExecutionId(checkRequest), FILE_SUFFIX);
        DownloadedFile downloadedFile = new DownloadedFile(path);
        try {
            downloadedFile = this.s3FileDownloader.downloadFileFromS3(PreflightCheckKt.getContainerToken(checkRequest), PreflightCheckKt.getMigrationScopeId(checkRequest), fileId, path);
            InvalidEmailDetails invalidEmailDetails = this.readFileContents(downloadedFile);
            return invalidEmailDetails;
        }
        catch (S3FileReadException e) {
            String string = S3_FILE_FETCH_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{e};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            log.error(string2);
            string = S3_FILE_FETCH_ERROR_MESSAGE;
            objectArray = new Object[]{e};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new UmsPreflightCheckException(string3, e);
        }
        finally {
            this.deleteFile(downloadedFile);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/preflight/UmsInvalidEmailChecker$Companion;", "", "()V", "CHECK_EXECUTION_ERROR_MESSAGE", "", "FAILED_TO_FETCH_ERROR_MESSAGE", "FILE_SUFFIX", "S3_ERROR_MESSAGE", "S3_FILE_FETCH_ERROR_MESSAGE", "VIOLATIONS_KEY", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

