/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.email.InvalidEmailService;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.preflight.UmsInvalidEmailChecker;
import com.atlassian.jira.migration.preflight.ums.UmsPreflightService;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckDetails;
import com.atlassian.jira.migration.serverdataextractors.usergroup.GroupsWithReferences;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersWithReferences;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/preflight/UmsInvalidEmailService;", "Lcom/atlassian/jira/migration/email/InvalidEmailService;", "umsPreflightService", "Lcom/atlassian/jira/migration/preflight/ums/UmsPreflightService;", "umsInvalidEmailChecker", "Lcom/atlassian/jira/migration/preflight/UmsInvalidEmailChecker;", "(Lcom/atlassian/jira/migration/preflight/ums/UmsPreflightService;Lcom/atlassian/jira/migration/preflight/UmsInvalidEmailChecker;)V", "validate", "Lcom/atlassian/cmpt/check/base/CheckResult;", "executionId", "", "containerToken", "migrationScopeId", "usersFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "users", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "jira-migration-plugin"})
public final class UmsInvalidEmailService
implements InvalidEmailService {
    @NotNull
    private final UmsPreflightService umsPreflightService;
    @NotNull
    private final UmsInvalidEmailChecker umsInvalidEmailChecker;

    @Inject
    public UmsInvalidEmailService(@NotNull UmsPreflightService umsPreflightService, @NotNull UmsInvalidEmailChecker umsInvalidEmailChecker) {
        Intrinsics.checkNotNullParameter((Object)umsPreflightService, (String)"umsPreflightService");
        Intrinsics.checkNotNullParameter((Object)umsInvalidEmailChecker, (String)"umsInvalidEmailChecker");
        this.umsPreflightService = umsPreflightService;
        this.umsInvalidEmailChecker = umsInvalidEmailChecker;
    }

    @Override
    @NotNull
    public CheckResult validate(@NotNull String executionId, @NotNull String containerToken, @NotNull String migrationScopeId2, @NotNull CompletableFuture<UsersGroupsExtractionResult> usersFuture) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter(usersFuture, (String)"usersFuture");
        UmsPreflightCheckDetails umsPreflightCheckDetails = new UmsPreflightCheckDetails(null, null, 3, null);
        String checkExecutionId = executionId + '-' + UUID.randomUUID();
        this.umsPreflightService.executeInvalidEmailsUmsCheck(checkExecutionId, containerToken, usersFuture, migrationScopeId2, umsPreflightCheckDetails);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"usersAndGroups", usersFuture), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)checkExecutionId), TuplesKt.to((Object)"umsPreflightCheckDetails", (Object)umsPreflightCheckDetails), TuplesKt.to((Object)"containerToken", (Object)containerToken), TuplesKt.to((Object)"migrationScopeId", (Object)migrationScopeId2)};
        return this.umsInvalidEmailChecker.check(new CheckRequest("InvalidEmails", MapsKt.mapOf((Pair[])pairArray)));
    }

    @Override
    @NotNull
    public CheckResult validate(@NotNull String executionId, @NotNull String containerToken, @NotNull String migrationScopeId2, @NotNull List<JiraUser> users2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter(users2, (String)"users");
        CompletableFuture<UsersGroupsExtractionResult> completableFuture = CompletableFuture.completedFuture(new UsersGroupsExtractionResult(new UsersWithReferences(users2), GroupsWithReferences.Companion.getEMPTY(), MapsKt.emptyMap(), ExportStatistics.Companion.getEMPTY(), false));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        CompletableFuture<UsersGroupsExtractionResult> usersFuture = completableFuture;
        return this.validate(executionId, containerToken, migrationScopeId2, usersFuture);
    }
}

