/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.email.DuplicatedEmailsConfig;
import com.atlassian.jira.migration.email.FixAllEmailsResult;
import com.atlassian.jira.migration.email.GlobalEmailFixesConfigService;
import com.atlassian.jira.migration.email.InvalidEmailsConfig;
import com.atlassian.jira.migration.email.NoValidEmailsException;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.EmailCheckService;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.PrepareUserBaseService;
import com.atlassian.jira.migration.preflight.UmsInvalidEmailService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.utils.EmailValidityCheckerUtil;
import com.atlassian.jira.migration.utils.UDCConverterKt;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.udc.common.model.context.Context;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.atlassian.migration.udc.email.MostFrequentDomainService;
import com.atlassian.migration.udc.scan.UserBaseScanRunner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 92\u00020\u0001:\u00019B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J&\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010 \u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\"H\u0002J0\u0010'\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J4\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010-\u001a\u00020*2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010.\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J4\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020*2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0001022\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u00103\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u00107\u001a\u00020*2\f\u00108\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/atlassian/jira/migration/preflight/UnsupportedUserHandler;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "configService", "Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;", "prepareUserBaseService", "Lcom/atlassian/jira/migration/preflight/PrepareUserBaseService;", "umsInvalidEmailService", "Lcom/atlassian/jira/migration/preflight/UmsInvalidEmailService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "mostFrequentDomainService", "Lcom/atlassian/migration/udc/email/MostFrequentDomainService;", "udcBaseScnaRunner", "Lcom/atlassian/migration/udc/scan/UserBaseScanRunner;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/email/GlobalEmailFixesConfigService;Lcom/atlassian/jira/migration/preflight/PrepareUserBaseService;Lcom/atlassian/jira/migration/preflight/UmsInvalidEmailService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/migration/udc/email/MostFrequentDomainService;Lcom/atlassian/migration/udc/scan/UserBaseScanRunner;)V", "checkDuplicateEmailsResolutionStatus", "Lcom/atlassian/cmpt/check/base/CheckResult;", "executionId", "", "checkResult", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "checkIfValidDomainsWereGenerated", "onMigration", "Lcom/atlassian/jira/migration/email/InvalidEmailsConfig$OnMigration;", "udcMode", "Lcom/atlassian/migration/udc/common/model/usermapping/model/UDCMode;", "checkInvalidEmailsResolutionStatus", "checkValidDomainForNewEmails", "getFixResult", "Lcom/atlassian/jira/migration/email/FixAllEmailsResult;", "getNewEmailsForInvalid", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "fixResult", "handleCsvDuplicateMerge", "Lcom/atlassian/jira/migration/email/DuplicatedEmailsConfig$OnMigration;", "isCsvValid", "", "faultyEmailsCollection", "emailsToValidate", "isJsmCustomerCheckType", "isUserMappingInUse", "returnUpdatedCheckResult", "success", "details", "", "shouldCheckValidDomainForNewEmailsExist", "startUserBaseScanIfCheckOrDeduplicationIsNotSuccessful", "", "deduplicationCheckResult", "validateEmailsFromCsv", "emails", "Companion", "jira-migration-plugin"})
public final class UnsupportedUserHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final GlobalEmailFixesConfigService configService;
    @NotNull
    private final PrepareUserBaseService prepareUserBaseService;
    @NotNull
    private final UmsInvalidEmailService umsInvalidEmailService;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MostFrequentDomainService mostFrequentDomainService;
    @NotNull
    private final UserBaseScanRunner udcBaseScnaRunner;
    private static final Logger log = LoggerFactory.getLogger(UnsupportedUserHandler.class);
    @NotNull
    private static final String INFO_ERROR_REASON = "info_errorReason";
    @NotNull
    private static final String NO_VALID_DOMAINS_ERROR = "NO_VALID_DOMAINS";

    @Inject
    public UnsupportedUserHandler(@NotNull MigrationFeatures migrationFeatures, @NotNull GlobalEmailFixesConfigService configService, @NotNull PrepareUserBaseService prepareUserBaseService, @NotNull UmsInvalidEmailService umsInvalidEmailService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MostFrequentDomainService mostFrequentDomainService, @NotNull UserBaseScanRunner udcBaseScnaRunner) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)prepareUserBaseService, (String)"prepareUserBaseService");
        Intrinsics.checkNotNullParameter((Object)umsInvalidEmailService, (String)"umsInvalidEmailService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)mostFrequentDomainService, (String)"mostFrequentDomainService");
        Intrinsics.checkNotNullParameter((Object)udcBaseScnaRunner, (String)"udcBaseScnaRunner");
        this.migrationFeatures = migrationFeatures;
        this.configService = configService;
        this.prepareUserBaseService = prepareUserBaseService;
        this.umsInvalidEmailService = umsInvalidEmailService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.mostFrequentDomainService = mostFrequentDomainService;
        this.udcBaseScnaRunner = udcBaseScnaRunner;
    }

    @NotNull
    public final CheckResult checkDuplicateEmailsResolutionStatus(@NotNull String executionId, @NotNull CheckResult checkResult, @NotNull ApplicationUser user, @NotNull CheckRequest checkRequest) {
        CheckResult checkResult2;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)checkResult, (String)"checkResult");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        log.info("Resolving duplicated emails started for executionId=" + executionId);
        DuplicatedEmailsConfig config2 = this.configService.getDuplicatedEmailsConfig();
        DuplicatedEmailsConfig.OnMigration onMigration = config2.getOnMigration();
        UDCMode udcMode = this.configService.getUdcModeConfig();
        if (onMigration == DuplicatedEmailsConfig.OnMigration.USE_CSV || this.isUserMappingInUse(udcMode)) {
            checkResult2 = this.handleCsvDuplicateMerge(checkRequest, executionId, checkResult, onMigration, udcMode);
        } else if (!checkResult.success && onMigration == DuplicatedEmailsConfig.OnMigration.DO_NOTHING) {
            FixAllEmailsResult fixResult = this.getFixResult(checkRequest);
            boolean bl = fixResult.getDuplicate().isEmpty();
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            checkResult2 = this.returnUpdatedCheckResult(bl, map, (Object)onMigration, udcMode);
        } else {
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            checkResult2 = this.returnUpdatedCheckResult(true, map, (Object)onMigration, udcMode);
        }
        CheckResult deduplicationCheckResult = checkResult2;
        this.startUserBaseScanIfCheckOrDeduplicationIsNotSuccessful(deduplicationCheckResult, checkResult, checkRequest, user);
        log.info("Resolving duplicated emails finished for executionId=" + executionId + ". Status: action on duplicate email=" + (Object)((Object)onMigration) + ", success=" + deduplicationCheckResult.success);
        return deduplicationCheckResult;
    }

    private final CheckResult handleCsvDuplicateMerge(CheckRequest checkRequest, String executionId, CheckResult checkResult, DuplicatedEmailsConfig.OnMigration onMigration, UDCMode udcMode) {
        FixAllEmailsResult fixResult = this.getFixResult(checkRequest);
        List<JiraUser> newMails = fixResult.getNewMailForDuplicate();
        boolean success = this.isCsvValid(fixResult.getDuplicate(), newMails, executionId, checkRequest);
        Map map = checkResult.details;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
        return this.returnUpdatedCheckResult(success, map, (Object)onMigration, udcMode);
    }

    private final CheckResult returnUpdatedCheckResult(boolean success, Map<String, ? extends Object> details2, Object onMigration, UDCMode udcMode) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"configOption", (Object)onMigration), TuplesKt.to((Object)"udcMode", (Object)udcMode)};
        return new CheckResult(success, MapsKt.plus(details2, (Map)MapsKt.mapOf((Pair[])pairArray)));
    }

    private final FixAllEmailsResult getFixResult(CheckRequest checkRequest) {
        return PreflightCheckKt.getUsersFixedData(checkRequest).getFixAllEmailsResult();
    }

    @NotNull
    public final CheckResult checkInvalidEmailsResolutionStatus(@NotNull String executionId, @NotNull CheckResult checkResult, @NotNull ApplicationUser user, @NotNull CheckRequest checkRequest) {
        CheckResult checkResult2;
        boolean success;
        List<JiraUser> newMails;
        FixAllEmailsResult fixResult;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)checkResult, (String)"checkResult");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        log.info("Resolving invalid emails started for executionId=" + executionId);
        InvalidEmailsConfig config2 = this.configService.getInvalidEmailsConfig();
        InvalidEmailsConfig.OnMigration onMigration = config2.getOnMigration();
        UDCMode udcMode = this.configService.getUdcModeConfig();
        if (this.isUserMappingInUse(udcMode)) {
            fixResult = this.getFixResult(checkRequest);
            newMails = this.getNewEmailsForInvalid(fixResult);
            success = this.isCsvValid(fixResult.getInvalid(), CollectionsKt.plus((Collection)newMails, (Iterable)fixResult.getNewMailForValid()), executionId, checkRequest);
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            checkResult2 = this.returnUpdatedCheckResult(success, map, (Object)onMigration, udcMode);
        } else if (!checkResult.success && onMigration == InvalidEmailsConfig.OnMigration.DO_NOTHING) {
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            checkResult2 = this.returnUpdatedCheckResult(false, map, (Object)onMigration, udcMode);
        } else if (onMigration == InvalidEmailsConfig.OnMigration.USE_CSV) {
            fixResult = this.getFixResult(checkRequest);
            newMails = this.getNewEmailsForInvalid(fixResult);
            success = this.isCsvValid(fixResult.getInvalid(), newMails, executionId, checkRequest);
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            checkResult2 = this.returnUpdatedCheckResult(success, map, (Object)onMigration, udcMode);
        } else if (this.shouldCheckValidDomainForNewEmailsExist(onMigration)) {
            checkResult2 = this.checkIfValidDomainsWereGenerated(checkRequest, checkResult, onMigration, udcMode);
        } else {
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            checkResult2 = this.returnUpdatedCheckResult(true, map, (Object)onMigration, udcMode);
        }
        CheckResult invalidEmailCheckResult = checkResult2;
        log.info("Resolving invalid emails finished for executionId=" + executionId + ". Status: action on invalid email=" + (Object)((Object)onMigration) + ", success=" + invalidEmailCheckResult.success);
        this.startUserBaseScanIfCheckOrDeduplicationIsNotSuccessful(invalidEmailCheckResult, checkResult, checkRequest, user);
        return invalidEmailCheckResult;
    }

    private final void startUserBaseScanIfCheckOrDeduplicationIsNotSuccessful(CheckResult deduplicationCheckResult, CheckResult checkResult, CheckRequest checkRequest, ApplicationUser user) {
        if (!deduplicationCheckResult.success || !checkResult.success) {
            CloudSite cloudSite2 = this.cloudSiteRepository.getSiteByContainerToken(PreflightCheckKt.getContainerToken(checkRequest));
            if (this.migrationFeatures.getUseUDCLibraryForUserBaseScan()) {
                this.udcBaseScnaRunner.safelyStartUserBaseScan(UDCConverterKt.toUDC(user), UDCConverterKt.toUDC(cloudSite2));
            } else {
                this.prepareUserBaseService.safelyStartUserBaseScan(user, cloudSite2);
            }
        }
    }

    private final CheckResult checkIfValidDomainsWereGenerated(CheckRequest checkRequest, CheckResult checkResult, InvalidEmailsConfig.OnMigration onMigration, UDCMode udcMode) {
        CheckResult checkResult2;
        FixAllEmailsResult fixResult = PreflightCheckKt.getUsersFixedData(checkRequest).getFixAllEmailsResult();
        if (!((Collection)fixResult.getInvalid()).isEmpty()) {
            log.error("There are no available valid domains to fix the invalid users' e-mail addresses.");
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)INFO_ERROR_REASON, (Object)NO_VALID_DOMAINS_ERROR), TuplesKt.to((Object)"configOption", (Object)((Object)onMigration)), TuplesKt.to((Object)"udcMode", (Object)udcMode)};
            CheckResult checkResult3 = new CheckResult(false, MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair[])pairArray)));
            checkResult2 = checkResult3;
        } else {
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            checkResult2 = this.returnUpdatedCheckResult(true, map, (Object)onMigration, udcMode);
        }
        return checkResult2;
    }

    private final List<JiraUser> getNewEmailsForInvalid(FixAllEmailsResult fixResult) {
        return fixResult.getNewMailForInvalid();
    }

    private final boolean isCsvValid(List<JiraUser> faultyEmailsCollection, List<JiraUser> emailsToValidate, String executionId, CheckRequest checkRequest) {
        return faultyEmailsCollection.isEmpty() && this.validateEmailsFromCsv(emailsToValidate, executionId, checkRequest);
    }

    private final boolean isUserMappingInUse(UDCMode udcMode) {
        boolean isUserMergeEnabled = udcMode == UDCMode.ADVANCED;
        log.info("User merge is enabled: " + isUserMergeEnabled);
        return isUserMergeEnabled;
    }

    private final CheckResult checkValidDomainForNewEmails(CheckRequest checkRequest, CheckResult checkResult, InvalidEmailsConfig.OnMigration onMigration, UDCMode udcMode) {
        CheckResult checkResult2;
        try {
            this.mostFrequentDomainService.invalidateCache();
            this.mostFrequentDomainService.getMostFrequentDomainName((Context)new Context.CloudContext(PreflightCheckKt.getContainerToken(checkRequest), PreflightCheckKt.getMigrationScopeId(checkRequest)));
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            checkResult2 = this.returnUpdatedCheckResult(true, map, (Object)onMigration, udcMode);
        }
        catch (Exception e) {
            if (!(ExceptionUtils.getRootCause((Throwable)e) instanceof NoValidEmailsException)) {
                throw e;
            }
            log.error("There are no available valid domains to fix the invalid users' e-mail addresses.", e.getCause());
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)INFO_ERROR_REASON, (Object)NO_VALID_DOMAINS_ERROR), TuplesKt.to((Object)"configOption", (Object)((Object)onMigration)), TuplesKt.to((Object)"udcMode", (Object)udcMode)};
            checkResult2 = new CheckResult(false, MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair[])pairArray)));
        }
        return checkResult2;
    }

    private final boolean shouldCheckValidDomainForNewEmailsExist(InvalidEmailsConfig.OnMigration onMigration) {
        return onMigration == InvalidEmailsConfig.OnMigration.USE_NEW_EMAILS || onMigration == InvalidEmailsConfig.OnMigration.TOMBSTONE_BEFORE_CUT_OFF_DATE;
    }

    private final boolean validateEmailsFromCsv(List<JiraUser> emails, String executionId, CheckRequest checkRequest) {
        return this.isJsmCustomerCheckType(checkRequest) ? EmailCheckService.Companion.performSimplifiedMainCheck((Checker<EmailCheckContext>)((Checker)EmailValidityCheckerUtil.INSTANCE), emails).success : this.umsInvalidEmailService.validate((String)executionId, (String)PreflightCheckKt.getContainerToken((CheckRequest)checkRequest), (String)PreflightCheckKt.getMigrationScopeId((CheckRequest)checkRequest), emails).success;
    }

    private final boolean isJsmCustomerCheckType(CheckRequest checkRequest) {
        return Intrinsics.areEqual((Object)checkRequest.checkType, (Object)"SharedJsmCustomerEmails") || Intrinsics.areEqual((Object)checkRequest.checkType, (Object)"InvalidJsmCustomerEmails");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/preflight/UnsupportedUserHandler$Companion;", "", "()V", "INFO_ERROR_REASON", "", "NO_VALID_DOMAINS_ERROR", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

