/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.SocketConnectivityTester;
import com.atlassian.jira.migration.preflight.model.ConnectionStatus;
import com.atlassian.jira.migration.preflight.model.MigrationAllowUrlName;
import com.atlassian.jira.migration.preflight.model.ResourceDetail;
import com.atlassian.jira.migration.preflight.model.WhitelistUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00112\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/preflight/UrlAccessibilityCheckService;", "", "connectivityTester", "Lcom/atlassian/jira/migration/preflight/SocketConnectivityTester;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/SocketConnectivityTester;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "checkForBlockingURL", "", "notReachableResources", "", "Lcom/atlassian/jira/migration/preflight/model/ResourceDetail;", "checkResource", "Lcom/atlassian/jira/migration/preflight/UrlAccessibilityCheckService$ReachableResource;", "whitelistUrl", "Lcom/atlassian/jira/migration/preflight/model/WhitelistUrl;", "replaceUrlsWithWildcards", "", "", "Companion", "ReachableResource", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUrlAccessibilityCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlAccessibilityCheckService.kt\ncom/atlassian/jira/migration/preflight/UrlAccessibilityCheckService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n125#2:51\n152#2,3:52\n1747#3,3:55\n*S KotlinDebug\n*F\n+ 1 UrlAccessibilityCheckService.kt\ncom/atlassian/jira/migration/preflight/UrlAccessibilityCheckService\n*L\n17#1:51\n17#1:52,3\n25#1:55,3\n*E\n"})
public class UrlAccessibilityCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SocketConnectivityTester connectivityTester;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private static final Regex MRC_S3_URL_REGEX = new Regex("^https:\\/\\/micros--prod-.*--migration-report-center--report-data\\.s3\\..*\\.amazonaws.com\\/?$");
    @NotNull
    public static final String MRC_S3_URL_WILDCARD = "https://micros--*--migration-report-center--report-data.s3.*.amazonaws.com";

    @Autowired
    public UrlAccessibilityCheckService(@NotNull SocketConnectivityTester connectivityTester, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)connectivityTester, (String)"connectivityTester");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.connectivityTester = connectivityTester;
        this.migrationFeatures = migrationFeatures;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, ResourceDetail> replaceUrlsWithWildcards(@NotNull Map<WhitelistUrl, ResourceDetail> notReachableResources2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(notReachableResources2, (String)"notReachableResources");
        Map<WhitelistUrl, ResourceDetail> $this$map$iv = notReachableResources2;
        boolean $i$f$map = false;
        Map<WhitelistUrl, ResourceDetail> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MRC_S3_URL_REGEX.matches((CharSequence)((WhitelistUrl)it.getKey()).getUrl()) ? new Pair((Object)MRC_S3_URL_WILDCARD, (Object)new ResourceDetail(MRC_S3_URL_WILDCARD, ((ResourceDetail)it.getValue()).getBlocking(), ((ResourceDetail)it.getValue()).getMessage())) : new Pair((Object)((WhitelistUrl)it.getKey()).getUrl(), it.getValue()));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public boolean checkForBlockingURL(@NotNull Collection<ResourceDetail> notReachableResources2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(notReachableResources2, (String)"notReachableResources");
            Iterable $this$any$iv = notReachableResources2;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ResourceDetail it = (ResourceDetail)element$iv;
                    boolean bl2 = false;
                    if (!it.getBlocking()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public ReachableResource checkResource(@NotNull WhitelistUrl whitelistUrl) {
        Intrinsics.checkNotNullParameter((Object)whitelistUrl, (String)"whitelistUrl");
        Map headers = this.migrationFeatures.getEnableNetworkConnectivityHeaderCheck() && StringsKt.contains$default((CharSequence)whitelistUrl.getUrl(), (CharSequence)"atlassian.com", (boolean)false, (int)2, null) ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"Server", (Object)"AtlassianEdge")) : null;
        ConnectionStatus reachable = this.connectivityTester.isReachable(whitelistUrl.getUrl(), headers);
        return new ReachableResource(whitelistUrl.getUrl(), reachable, whitelistUrl.getName().isBlocking(), whitelistUrl.getName());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/preflight/UrlAccessibilityCheckService$Companion;", "", "()V", "MRC_S3_URL_REGEX", "Lkotlin/text/Regex;", "MRC_S3_URL_WILDCARD", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/preflight/UrlAccessibilityCheckService$ReachableResource;", "", "url", "", "isReachable", "Lcom/atlassian/jira/migration/preflight/model/ConnectionStatus;", "isBlocking", "", "migrationAllowUrlName", "Lcom/atlassian/jira/migration/preflight/model/MigrationAllowUrlName;", "(Ljava/lang/String;Lcom/atlassian/jira/migration/preflight/model/ConnectionStatus;ZLcom/atlassian/jira/migration/preflight/model/MigrationAllowUrlName;)V", "()Z", "()Lcom/atlassian/jira/migration/preflight/model/ConnectionStatus;", "getMigrationAllowUrlName", "()Lcom/atlassian/jira/migration/preflight/model/MigrationAllowUrlName;", "getUrl", "()Ljava/lang/String;", "toString", "jira-migration-plugin"})
    public static final class ReachableResource {
        @NotNull
        private final String url;
        @NotNull
        private final ConnectionStatus isReachable;
        private final boolean isBlocking;
        @NotNull
        private final MigrationAllowUrlName migrationAllowUrlName;

        public ReachableResource(@NotNull String url, @NotNull ConnectionStatus isReachable, boolean isBlocking, @NotNull MigrationAllowUrlName migrationAllowUrlName) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)isReachable, (String)"isReachable");
            Intrinsics.checkNotNullParameter((Object)((Object)migrationAllowUrlName), (String)"migrationAllowUrlName");
            this.url = url;
            this.isReachable = isReachable;
            this.isBlocking = isBlocking;
            this.migrationAllowUrlName = migrationAllowUrlName;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final ConnectionStatus isReachable() {
            return this.isReachable;
        }

        public final boolean isBlocking() {
            return this.isBlocking;
        }

        @NotNull
        public final MigrationAllowUrlName getMigrationAllowUrlName() {
            return this.migrationAllowUrlName;
        }

        @NotNull
        public String toString() {
            return "ReachableResource{url=" + this.url + ", isReachable=" + this.isReachable.isSuccessful() + '}';
        }
    }
}

