/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.UserDefinedCustomFieldService;
import com.atlassian.jira.migration.preflight.UserDefinedCustomFieldsCheckKt;
import com.atlassian.jira.migration.preflight.csv.UserDefinedCustomFieldsCSVData;
import com.atlassian.jira.migration.preflight.model.CheckType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0011H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/preflight/UserDefinedCustomFieldsCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "customFieldService", "Lcom/atlassian/jira/migration/preflight/UserDefinedCustomFieldService;", "(Lcom/atlassian/jira/migration/preflight/UserDefinedCustomFieldService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getCSVFileName", "executionId", "type", "planName", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUserDefinedCustomFieldsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserDefinedCustomFieldsCheck.kt\ncom/atlassian/jira/migration/preflight/UserDefinedCustomFieldsCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1#2:120\n1855#3,2:121\n*S KotlinDebug\n*F\n+ 1 UserDefinedCustomFieldsCheck.kt\ncom/atlassian/jira/migration/preflight/UserDefinedCustomFieldsCheck\n*L\n88#1:121,2\n*E\n"})
public final class UserDefinedCustomFieldsCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final UserDefinedCustomFieldService customFieldService;
    @NotNull
    private final CheckType checkType;

    @Inject
    public UserDefinedCustomFieldsCheck(@NotNull UserDefinedCustomFieldService customFieldService) {
        Intrinsics.checkNotNullParameter((Object)customFieldService, (String)"customFieldService");
        this.customFieldService = customFieldService;
        this.checkType = CheckType.UserDefinedCustomFields;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"advancedRoadmapsPlanIds", ctx.getAdvancedRoadmapsPlanIds()), TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"isCustomFieldsDeleted", (Object)ctx.isUserDefinedCustomFieldDeleted()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.customFieldService.performCheck(checkRequest);
    }

    /*
     * WARNING - void declaration
     */
    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                string = "Checking if all user-defined custom fields are supported";
                break;
            }
            case 2: {
                string = "All user-defined custom fields are supported";
                break;
            }
            case 3: {
                string = "Some user-defined custom fields added to your Advanced Roadmaps plans aren't supported in cloud";
                break;
            }
            case 4: {
                string = "We couldn't check if user-defined custom fields are supported";
                break;
            }
            case 5: {
                string = "Some user-defined custom fields added to your Advanced Roadmaps plans aren't supported in cloud";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        dto.setDescription(string);
        CheckResult checkResult2 = checkResult;
        if (checkResult2 != null) {
            CheckResult it = checkResult2;
            boolean bl = false;
            if (dto.getStatus() != Status.EXECUTION_ERROR) {
                Map customFields;
                Map map = it.details;
                Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.List<kotlin.String>>");
                Map $this$inject_u24lambda_u242_u24lambda_u241 = customFields = map;
                boolean bl2 = false;
                CheckDetailsDto details2 = new CheckDetailsDto();
                Iterable iterable = $this$inject_u24lambda_u242_u24lambda_u241.entrySet();
                int n = 0;
                for (Object t : iterable) {
                    void entry;
                    Map.Entry entry2 = (Map.Entry)t;
                    int n2 = n;
                    boolean bl3 = false;
                    int n3 = ((List)entry.getValue()).size();
                    n = n2 + n3;
                }
                int length = n;
                details2.setInfo(MapsKt.mapOf((Pair)TuplesKt.to((Object)"numberOfCustomFields", (Object)length)));
                details2.setListOfOccurrences(CollectionsKt.listOf((Object)$this$inject_u24lambda_u242_u24lambda_u241));
                if (length <= 10) {
                    dto.setNumberOfOccurrences(Integer.valueOf(length));
                }
                dto.setDetails(details2);
            }
        }
        this.handleExtractionError(dto, checkResult, "Check for presence of user custom fields could not be completed");
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm-ss");
        String dateTime = formatter.format(LocalDateTime.now());
        String string = planName;
        if (string == null) {
            string = executionId;
        }
        String migrationName = string;
        return migrationName + "_Pre-migration_checks_Plans_User-defined_custom_fields_Jira_" + dateTime + "_result.csv";
    }

    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        if (checkStatus.checkResult == null || checkStatus.checkResult.success) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)UserDefinedCustomFieldsCheckKt.getCUSTOM_FIELD_MIGRATION_HEADERS()));
        }
        Map map = checkStatus.checkResult.details;
        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.List<kotlin.String>>");
        Map customFields = map;
        List beans = new ArrayList();
        Map $this$buildCSVMap_u24lambda_u244 = customFields;
        boolean bl = false;
        for (Map.Entry i : $this$buildCSVMap_u24lambda_u244.entrySet()) {
            Iterable $this$forEach$iv = (Iterable)i.getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name = (String)element$iv;
                boolean bl2 = false;
                beans.add(new UserDefinedCustomFieldsCSVData((String)i.getKey(), name));
            }
        }
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"headers", (Object)UserDefinedCustomFieldsCheckKt.getCUSTOM_FIELD_MIGRATION_HEADERS());
        String[] stringArray = new String[]{"customFieldType", "customFieldName"};
        pairArray[1] = TuplesKt.to((Object)"mappings", (Object)stringArray);
        pairArray[2] = TuplesKt.to((Object)"beans", (Object)beans);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

