/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.csv;

import com.atlassian.jira.migration.preflight.csv.UnableToWriteCsvException;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bJ\"\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/preflight/csv/PreflightCSVWriter;", "", "()V", "writeAppVendorCheckResultsInStream", "", "outputStream", "Ljava/io/OutputStream;", "csvMapping", "", "", "writeResultsInStream", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreflightCSVWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightCSVWriter.kt\ncom/atlassian/jira/migration/preflight/csv/PreflightCSVWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,58:1\n1855#2,2:59\n1855#2,2:63\n37#3,2:61\n*S KotlinDebug\n*F\n+ 1 PreflightCSVWriter.kt\ncom/atlassian/jira/migration/preflight/csv/PreflightCSVWriter\n*L\n24#1:59,2\n43#1:63,2\n39#1:61,2\n*E\n"})
public final class PreflightCSVWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeResultsInStream(@NotNull OutputStream outputStream, @NotNull Map<String, ? extends Object> csvMapping) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter(csvMapping, (String)"csvMapping");
        try {
            Closeable closeable = (Closeable)new CsvBeanWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), CsvPreference.STANDARD_PREFERENCE);
            Throwable throwable = null;
            try {
                CsvBeanWriter beanWriter = (CsvBeanWriter)closeable;
                boolean bl = false;
                String[] stringArray = new String[]{""};
                Object object = csvMapping.getOrDefault("headers", (Object)stringArray);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                Object[] headers = (Object[])object;
                Intrinsics.checkNotNull((Object)headers, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                String[] stringArray2 = (String[])headers;
                beanWriter.writeHeader(Arrays.copyOf(stringArray2, stringArray2.length));
                if (csvMapping.containsKey("beans") && csvMapping.containsKey("mappings")) {
                    Object object2 = csvMapping.get("mappings");
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.String>");
                    String[] mappings = (String[])object2;
                    Object object3 = csvMapping.get("beans");
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                    List beans = (List)object3;
                    Iterable $this$forEach$iv = beans;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv;
                        Object it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        beanWriter.write(it, Arrays.copyOf(mappings, mappings.length));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new UnableToWriteCsvException("Unable to write beans to csv", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeAppVendorCheckResultsInStream(@NotNull OutputStream outputStream, @NotNull Map<String, ? extends Object> csvMapping) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter(csvMapping, (String)"csvMapping");
        try {
            Closeable closeable = (Closeable)new CsvListWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), CsvPreference.STANDARD_PREFERENCE);
            Throwable throwable = null;
            try {
                CsvListWriter beanWriter = (CsvListWriter)closeable;
                boolean bl = false;
                List headers = (List)csvMapping.get("headers");
                String[] stringArray = (String[])headers;
                if (!(stringArray == null || stringArray.isEmpty())) {
                    Collection $this$toTypedArray$iv = headers;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    stringArray = thisCollection$iv.toArray(new String[0]);
                    beanWriter.writeHeader(Arrays.copyOf(stringArray, stringArray.length));
                }
                if (csvMapping.containsKey("beans")) {
                    Object object = csvMapping.get("beans");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.List<kotlin.String>>");
                    List beans = (List)object;
                    Iterable $this$forEach$iv = beans;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        List it = (List)element$iv;
                        boolean bl2 = false;
                        beanWriter.write(it);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new UnableToWriteCsvException("Unable to write beans to csv", e);
        }
    }
}

