/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.dryrun;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.events.CrossProjectReportErrorCheckEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.ReportExportOutcome;
import com.atlassian.jira.migration.log.MigrationLogsService;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.dryrun.ReportExportOutcomeCheckResult;
import com.atlassian.jira.migration.preflight.model.CheckExecutionResult;
import com.atlassian.jira.migration.preflight.reports.PreMigrationReportsService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/CrossProjectReportErrorService;", "", "preMigrationReportsService", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService;", "migrationLogsService", "Lcom/atlassian/jira/migration/log/MigrationLogsService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService;Lcom/atlassian/jira/migration/log/MigrationLogsService;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "getFailedCrossProjectDetails", "", "", "failedCrossProjectKeys", "", "performCheck", "Lcom/atlassian/jira/migration/preflight/dryrun/ReportExportOutcomeCheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCrossProjectReportErrorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossProjectReportErrorService.kt\ncom/atlassian/jira/migration/preflight/dryrun/CrossProjectReportErrorService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n526#2:106\n511#2,6:107\n1271#3,2:113\n1285#3,4:115\n*S KotlinDebug\n*F\n+ 1 CrossProjectReportErrorService.kt\ncom/atlassian/jira/migration/preflight/dryrun/CrossProjectReportErrorService\n*L\n69#1:106\n69#1:107,6\n97#1:113,2\n97#1:115,4\n*E\n"})
public final class CrossProjectReportErrorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PreMigrationReportsService preMigrationReportsService;
    @NotNull
    private final MigrationLogsService migrationLogsService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private static final Logger log = LoggerFactory.getLogger(CrossProjectReportErrorService.class);
    @NotNull
    private static final String filePath = "*-crossProjectEntity-export.log";

    @Inject
    public CrossProjectReportErrorService(@NotNull PreMigrationReportsService preMigrationReportsService, @NotNull MigrationLogsService migrationLogsService, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)preMigrationReportsService, (String)"preMigrationReportsService");
        Intrinsics.checkNotNullParameter((Object)migrationLogsService, (String)"migrationLogsService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.preMigrationReportsService = preMigrationReportsService;
        this.migrationLogsService = migrationLogsService;
        this.migrationEventBus = migrationEventBus;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ReportExportOutcomeCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        ReportExportOutcomeCheckResult reportExportOutcomeCheckResult;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        log.info("Starting cross project report error check with executionId " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest));
        long startTime = System.currentTimeMillis();
        this.migrationLogsService.deleteExistingPreflightExecutionLogs(PreflightCheckKt.getPreflightCheckExecutionId(checkRequest), filePath);
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        UsersGroupsMigrationOption usersGroupsMigrationOption = PreflightCheckKt.getUsersGroupsMigrationOption(checkRequest);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        PreMigrationReportsService.UsersData usersData = new PreMigrationReportsService.UsersData(usersGroupsMigrationOption, completableFuture, null, PreflightCheckKt.getLoggedUser(checkRequest));
        ListenableFuture listenableFuture = Futures.immediateFuture(null);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
        PreMigrationReportsService.MigrationData migrationData = new PreMigrationReportsService.MigrationData((ListenableFuture<List<CheckExecutionResult>>)listenableFuture, PreflightCheckKt.getCloudId(checkRequest), PreflightCheckKt.getMigrationType(checkRequest), "", "");
        List<String> list = PreflightCheckKt.getProjectKeys(checkRequest);
        ProjectDataMigrationMode projectDataMigrationMode = PreflightCheckKt.getProjectDataMigrationMode(checkRequest);
        SinglePathMode singlePathMode = PreflightCheckKt.getSinglePathMode(checkRequest);
        List list2 = PreflightCheckKt.getAdvancedRoadmapsPlanIds(checkRequest);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        ReportExportOutcome reportsData = this.preMigrationReportsService.gatherReportsDataFromCrossProject(string, usersData, migrationData, new PreMigrationReportsService.ProjectsData(list, projectDataMigrationMode, singlePathMode, list2, PreflightCheckKt.getCrossProjectConfig(checkRequest), PreflightCheckKt.getMigrateArchivedIssues(checkRequest), PreflightCheckKt.getDataFilterContext(checkRequest)));
        Map<String, Boolean> $this$filter$iv = reportsData.getExportErrors();
        boolean $i$f$filter = false;
        Map<String, Boolean> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((Boolean)it.getValue()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set<String> failedCrossProjectKey = destination$iv$iv.keySet();
        Map<String, String> failedCrossProjectDetails = this.getFailedCrossProjectDetails(failedCrossProjectKey);
        long endTime = System.currentTimeMillis();
        String string2 = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string3 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string3 == null) {
            string3 = "";
        }
        this.migrationEventBus.post(new CrossProjectReportErrorCheckEvent(string2, string3, endTime - startTime, failedCrossProjectKey.isEmpty()));
        log.info("Finished cross project report error check with executionId " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest) + " in " + (endTime - startTime) + "ms");
        if (failedCrossProjectKey.isEmpty()) {
            reportExportOutcomeCheckResult = new ReportExportOutcomeCheckResult(reportsData, new CheckResult(true));
        } else {
            log.info("In the preflight with executionId " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest) + ", the crossProjectKey " + failedCrossProjectKey + " had export failures");
            reportExportOutcomeCheckResult = new ReportExportOutcomeCheckResult(reportsData, new CheckResult(false, MapsKt.mapOf((Pair)TuplesKt.to((Object)"failedCrossProjectDetails", failedCrossProjectDetails))));
        }
        return reportExportOutcomeCheckResult;
    }

    @NotNull
    public final Map<String, String> getFailedCrossProjectDetails(@NotNull Set<String> failedCrossProjectKeys) {
        Intrinsics.checkNotNullParameter(failedCrossProjectKeys, (String)"failedCrossProjectKeys");
        Iterable $this$associateWith$iv = failedCrossProjectKeys;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string2 = "CROSS-PROJECT-DATA";
            map.put(t, string2);
        }
        return result$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/CrossProjectReportErrorService$Companion;", "", "()V", "filePath", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

