/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.dryrun;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.dryrun.CrossProjectReportErrorService;
import com.atlassian.jira.migration.preflight.dryrun.DryRunPreflightService;
import com.atlassian.jira.migration.preflight.dryrun.PostDryRunPreflightService;
import com.atlassian.jira.migration.preflight.dryrun.ProjectReportErrorService;
import com.atlassian.jira.migration.preflight.dryrun.ReportExportOutcomeCheckResult;
import com.atlassian.jira.migration.preflight.utils.PreflightUtils;
import com.atlassian.jira.migration.serverdataextractors.RelatedEntitiesDataReader;
import com.atlassian.jira.migration.utils.ProjectKeysProcessor;
import com.atlassian.jira.migration.utils.SegregatedProjectKeys;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u0014\u001a\u00020\u00102\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/DryRunPreflightService;", "", "projectReportErrorService", "Lcom/atlassian/jira/migration/preflight/dryrun/ProjectReportErrorService;", "crossProjectReportErrorService", "Lcom/atlassian/jira/migration/preflight/dryrun/CrossProjectReportErrorService;", "postDryRunPreflightService", "Lcom/atlassian/jira/migration/preflight/dryrun/PostDryRunPreflightService;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "relatedEntitiesDataReader", "Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;", "(Lcom/atlassian/jira/migration/preflight/dryrun/ProjectReportErrorService;Lcom/atlassian/jira/migration/preflight/dryrun/CrossProjectReportErrorService;Lcom/atlassian/jira/migration/preflight/dryrun/PostDryRunPreflightService;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;)V", "fetchCheckResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "segregatedProjectKeys", "Lcom/atlassian/jira/migration/utils/SegregatedProjectKeys;", "performCheck", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "segregateKeys", "advancedRoadmapsPlanIds", "", "", "failedKeys", "", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDryRunPreflightService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DryRunPreflightService.kt\ncom/atlassian/jira/migration/preflight/dryrun/DryRunPreflightService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n526#2:126\n511#2,6:127\n3190#3,10:133\n3190#3,10:143\n*S KotlinDebug\n*F\n+ 1 DryRunPreflightService.kt\ncom/atlassian/jira/migration/preflight/dryrun/DryRunPreflightService\n*L\n57#1:126\n57#1:127,6\n95#1:133,10\n98#1:143,10\n*E\n"})
public final class DryRunPreflightService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectReportErrorService projectReportErrorService;
    @NotNull
    private final CrossProjectReportErrorService crossProjectReportErrorService;
    @NotNull
    private final PostDryRunPreflightService postDryRunPreflightService;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final RelatedEntitiesDataReader relatedEntitiesDataReader;
    private static final Logger logger = Logger.getLogger(DryRunPreflightService.class);

    @Inject
    public DryRunPreflightService(@NotNull ProjectReportErrorService projectReportErrorService, @NotNull CrossProjectReportErrorService crossProjectReportErrorService, @NotNull PostDryRunPreflightService postDryRunPreflightService, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull RelatedEntitiesDataReader relatedEntitiesDataReader) {
        Intrinsics.checkNotNullParameter((Object)projectReportErrorService, (String)"projectReportErrorService");
        Intrinsics.checkNotNullParameter((Object)crossProjectReportErrorService, (String)"crossProjectReportErrorService");
        Intrinsics.checkNotNullParameter((Object)postDryRunPreflightService, (String)"postDryRunPreflightService");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)relatedEntitiesDataReader, (String)"relatedEntitiesDataReader");
        this.projectReportErrorService = projectReportErrorService;
        this.crossProjectReportErrorService = crossProjectReportErrorService;
        this.postDryRunPreflightService = postDryRunPreflightService;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.relatedEntitiesDataReader = relatedEntitiesDataReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.currentTimeMillis();
        logger.info((Object)("DryRunPreflightService perform check has started for " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest)));
        ExecutorService executor = Executors.newFixedThreadPool(PreflightUtils.Companion.getParallelDryRunThreadPoolSize(), new GroupedThreadFactory("DryRunPreflightService"));
        Object[] objectArray = new Callable[2];
        Logger logger2 = logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        objectArray[0] = JiraExtensionsKt.wrap(this.jiraThreadLocalUtil, logger2, (Function0)new Function0<Callable<ReportExportOutcomeCheckResult>>(this, checkRequest){
            final /* synthetic */ DryRunPreflightService this$0;
            final /* synthetic */ CheckRequest $checkRequest;
            {
                this.this$0 = $receiver;
                this.$checkRequest = $checkRequest;
                super(0);
            }

            @NotNull
            public final Callable<ReportExportOutcomeCheckResult> invoke() {
                return () -> performCheck.taskList.1.invoke$lambda$0(this.this$0, this.$checkRequest);
            }

            private static final ReportExportOutcomeCheckResult invoke$lambda$0(DryRunPreflightService this$0, CheckRequest $checkRequest) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$checkRequest, (String)"$checkRequest");
                return DryRunPreflightService.access$getProjectReportErrorService$p(this$0).performCheck($checkRequest);
            }
        });
        Logger logger3 = logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"logger");
        objectArray[1] = JiraExtensionsKt.wrap(this.jiraThreadLocalUtil, logger3, (Function0)new Function0<Callable<ReportExportOutcomeCheckResult>>(this, checkRequest){
            final /* synthetic */ DryRunPreflightService this$0;
            final /* synthetic */ CheckRequest $checkRequest;
            {
                this.this$0 = $receiver;
                this.$checkRequest = $checkRequest;
                super(0);
            }

            @NotNull
            public final Callable<ReportExportOutcomeCheckResult> invoke() {
                return () -> performCheck.taskList.2.invoke$lambda$0(this.this$0, this.$checkRequest);
            }

            private static final ReportExportOutcomeCheckResult invoke$lambda$0(DryRunPreflightService this$0, CheckRequest $checkRequest) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$checkRequest, (String)"$checkRequest");
                return DryRunPreflightService.access$getCrossProjectReportErrorService$p(this$0).performCheck($checkRequest);
            }
        });
        List taskList2 = CollectionsKt.listOf((Object[])objectArray);
        try {
            void $this$filterTo$iv$iv;
            List futures2 = executor.invokeAll(taskList2);
            ReportExportOutcomeCheckResult reportExportOutcomeCheckResult = new ReportExportOutcomeCheckResult();
            for (Future future : futures2) {
                Object t = future.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                reportExportOutcomeCheckResult = reportExportOutcomeCheckResult.plus((ReportExportOutcomeCheckResult)t);
            }
            CheckResult $this$filter$iv = reportExportOutcomeCheckResult.getReportExportOutcome().getExportErrors();
            boolean $i$f$filter = false;
            CheckResult checkResult = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!((Boolean)it.getValue()).booleanValue()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Set<String> failedKeys = destination$iv$iv.keySet();
            SegregatedProjectKeys segregatedKeys = this.segregateKeys(PreflightCheckKt.getAdvancedRoadmapsPlanIds(checkRequest), failedKeys);
            String failedKeysAsString = ProjectKeysProcessor.INSTANCE.mergeKeys(segregatedKeys);
            logger.info((Object)("DryRunPreflightService perform check has finished for " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest) + " in " + (System.currentTimeMillis() - startTime) + "ms"));
            this.postDryRunPreflightService.updatePreMigrationReportExportOutcome(reportExportOutcomeCheckResult.getReportExportOutcome());
            this.postDryRunPreflightService.uploadDataPreparationZipToMCS(checkRequest, failedKeysAsString);
            checkResult = !((Collection)failedKeys).isEmpty() ? this.fetchCheckResult(segregatedKeys) : reportExportOutcomeCheckResult.getCheckResult();
            return checkResult;
        }
        catch (ExecutionException e) {
            logger.error((Object)"Failed to perform dry run preflight check in parallel");
            throw e;
        }
        finally {
            executor.shutdown();
        }
    }

    @NotNull
    public final SegregatedProjectKeys segregateKeys(@Nullable List<Long> advancedRoadmapsPlanIds, @NotNull Set<String> failedKeys) {
        Intrinsics.checkNotNullParameter(failedKeys, (String)"failedKeys");
        if (this.postDryRunPreflightService.skipCrossProjectExportErrors()) {
            return new SegregatedProjectKeys(CollectionsKt.toList((Iterable)failedKeys), CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        Set arPlanProjectKeys = null;
        arPlanProjectKeys = SetsKt.emptySet();
        Collection collection = advancedRoadmapsPlanIds;
        if (!(collection == null || collection.isEmpty())) {
            arPlanProjectKeys = CollectionsKt.toSet((Iterable)this.relatedEntitiesDataReader.getProjectKeysFromPlanIds(advancedRoadmapsPlanIds));
        }
        Iterable $this$partition$iv = failedKeys;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (arPlanProjectKeys.contains(it) || Intrinsics.areEqual((Object)it, (Object)"CROSS-PROJECT-DATA")) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        collection = new Pair(first$iv, second$iv);
        List failedArPlanOrCrossProjectKeys = (List)collection.component1();
        List failedProjectKeys = (List)collection.component2();
        Iterable $this$partition$iv2 = failedArPlanOrCrossProjectKeys;
        boolean $i$f$partition2 = false;
        ArrayList first$iv2 = new ArrayList();
        ArrayList second$iv2 = new ArrayList();
        for (Object element$iv : $this$partition$iv2) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)"CROSS-PROJECT-DATA")) {
                first$iv2.add(element$iv);
                continue;
            }
            second$iv2.add(element$iv);
        }
        Pair pair = new Pair(first$iv2, second$iv2);
        List failedArPlanKeys = (List)pair.component1();
        List failedCrossProjectKey = (List)pair.component2();
        return new SegregatedProjectKeys(failedProjectKeys, failedArPlanKeys, failedCrossProjectKey);
    }

    @NotNull
    public final CheckResult fetchCheckResult(@NotNull SegregatedProjectKeys segregatedProjectKeys) {
        Intrinsics.checkNotNullParameter((Object)segregatedProjectKeys, (String)"segregatedProjectKeys");
        Map<String, String> failedProjectDetails = this.projectReportErrorService.getFailedProjectDetails(CollectionsKt.toSet((Iterable)segregatedProjectKeys.getProjectKeys()));
        Map failedArPlanOrCrossProjectDetails = MapsKt.plus(this.projectReportErrorService.getFailedProjectDetails(CollectionsKt.toSet((Iterable)segregatedProjectKeys.getArPlanProjectKeys())), this.crossProjectReportErrorService.getFailedCrossProjectDetails(CollectionsKt.toSet((Iterable)segregatedProjectKeys.getCrossProjectKey())));
        Map failedDetailsKeyValuePair = MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"failedProjectDetails", failedProjectDetails)), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"failedArPlanOrCrossProjectDetails", (Object)failedArPlanOrCrossProjectDetails)));
        return new CheckResult(false, failedDetailsKeyValuePair);
    }

    public static final /* synthetic */ ProjectReportErrorService access$getProjectReportErrorService$p(DryRunPreflightService $this) {
        return $this.projectReportErrorService;
    }

    public static final /* synthetic */ CrossProjectReportErrorService access$getCrossProjectReportErrorService$p(DryRunPreflightService $this) {
        return $this.crossProjectReportErrorService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/DryRunPreflightService$Companion;", "", "()V", "logger", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

