/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.dryrun;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.execution.DryRunExecutionService;
import com.atlassian.jira.migration.export.ReportExportOutcome;
import com.atlassian.jira.migration.export.ReportExportOutcomeSerializer;
import com.atlassian.jira.migration.migration.MigrationPreflightRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.polly.MigrationPoller;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.dryrun.DryRunPreflightService;
import com.atlassian.jira.migration.preflight.dryrun.PostDryRunPreflightService;
import com.atlassian.jira.migration.preflight.dryrun.ReportExportOutcomeCheckResult;
import com.atlassian.jira.migration.utils.ProjectKeysProcessor;
import com.atlassian.jira.migration.utils.SegregatedProjectKeys;
import com.atlassian.migration.api.MigrationId;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/MultiNodeDryRunPreflightService;", "", "postDryRunPreflightService", "Lcom/atlassian/jira/migration/preflight/dryrun/PostDryRunPreflightService;", "dryRunExecutionService", "Lcom/atlassian/jira/migration/execution/DryRunExecutionService;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "dryRunPreflightService", "Lcom/atlassian/jira/migration/preflight/dryrun/DryRunPreflightService;", "migrationPoller", "Lcom/atlassian/jira/migration/polly/MigrationPoller;", "migrationPreflightRepository", "Lcom/atlassian/jira/migration/migration/MigrationPreflightRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "(Lcom/atlassian/jira/migration/preflight/dryrun/PostDryRunPreflightService;Lcom/atlassian/jira/migration/execution/DryRunExecutionService;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/preflight/dryrun/DryRunPreflightService;Lcom/atlassian/jira/migration/polly/MigrationPoller;Lcom/atlassian/jira/migration/migration/MigrationPreflightRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;)V", "findPlanId", "", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "readAllReports", "Lcom/atlassian/jira/migration/export/ReportExportOutcome;", "migrationId", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMultiNodeDryRunPreflightService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiNodeDryRunPreflightService.kt\ncom/atlassian/jira/migration/preflight/dryrun/MultiNodeDryRunPreflightService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n526#2:109\n511#2,6:110\n11065#3:116\n11400#3,3:117\n1789#4,3:120\n*S KotlinDebug\n*F\n+ 1 MultiNodeDryRunPreflightService.kt\ncom/atlassian/jira/migration/preflight/dryrun/MultiNodeDryRunPreflightService\n*L\n64#1:109\n64#1:110,6\n85#1:116\n85#1:117,3\n86#1:120,3\n*E\n"})
public final class MultiNodeDryRunPreflightService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostDryRunPreflightService postDryRunPreflightService;
    @NotNull
    private final DryRunExecutionService dryRunExecutionService;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final DryRunPreflightService dryRunPreflightService;
    @NotNull
    private final MigrationPoller migrationPoller;
    @NotNull
    private final MigrationPreflightRepository migrationPreflightRepository;
    @NotNull
    private final PlanRepository planRepository;
    private static final Logger log = Logger.getLogger(MultiNodeDryRunPreflightService.class);
    private static final Duration pollForCompletionInterval = Duration.ofSeconds(30L);

    @Inject
    public MultiNodeDryRunPreflightService(@NotNull PostDryRunPreflightService postDryRunPreflightService, @NotNull DryRunExecutionService dryRunExecutionService, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull DryRunPreflightService dryRunPreflightService, @NotNull MigrationPoller migrationPoller, @NotNull MigrationPreflightRepository migrationPreflightRepository, @NotNull PlanRepository planRepository) {
        Intrinsics.checkNotNullParameter((Object)postDryRunPreflightService, (String)"postDryRunPreflightService");
        Intrinsics.checkNotNullParameter((Object)dryRunExecutionService, (String)"dryRunExecutionService");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)dryRunPreflightService, (String)"dryRunPreflightService");
        Intrinsics.checkNotNullParameter((Object)migrationPoller, (String)"migrationPoller");
        Intrinsics.checkNotNullParameter((Object)migrationPreflightRepository, (String)"migrationPreflightRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        this.postDryRunPreflightService = postDryRunPreflightService;
        this.dryRunExecutionService = dryRunExecutionService;
        this.localFileDataOutput = localFileDataOutput;
        this.dryRunPreflightService = dryRunPreflightService;
        this.migrationPoller = migrationPoller;
        this.migrationPreflightRepository = migrationPreflightRepository;
        this.planRepository = planRepository;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        String string = this.findPlanId(checkRequest);
        String string2 = PreflightCheckKt.getLoggedUser(checkRequest).getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
        MigrationId migrationId = this.dryRunExecutionService.startDryRun(string, string2);
        String string3 = migrationId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        this.migrationPoller.startPolling(string3);
        while (true) {
            String string4 = PreflightCheckKt.getContainerToken(checkRequest);
            String string5 = migrationId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            if (!this.dryRunExecutionService.isMigrationRunning(string4, string5)) break;
            log.info((Object)("Waiting for preflight orchestration to complete for migration " + migrationId));
            Thread.sleep(pollForCompletionInterval.toMillis());
        }
        String string6 = migrationId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        this.migrationPoller.stopPolling(string6);
        log.info((Object)("Dry run migration " + migrationId + " completed"));
        String string7 = migrationId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
        ReportExportOutcome reportOutcome = this.readAllReports(string7);
        if (!((Collection)reportOutcome.getUnexpectedErrors()).isEmpty()) {
            log.error((Object)("Unexpected errors: " + reportOutcome.getUnexpectedErrors()));
            throw new IllegalStateException(("Unexpected export errors during dry run: " + CollectionsKt.joinToString$default((Iterable)reportOutcome.getUnexpectedErrors(), null, null, null, (int)0, null, null, (int)63, null)).toString());
        }
        ReportExportOutcomeCheckResult reportExportOutcomeCheckResult = new ReportExportOutcomeCheckResult(reportOutcome, new CheckResult(true));
        Map<String, Boolean> $this$filter$iv = reportExportOutcomeCheckResult.getReportExportOutcome().getExportErrors();
        boolean $i$f$filter = false;
        Map<String, Boolean> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((Boolean)it.getValue()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set<String> failedKeys = destination$iv$iv.keySet();
        SegregatedProjectKeys segregatedKeys = this.dryRunPreflightService.segregateKeys(PreflightCheckKt.getAdvancedRoadmapsPlanIds(checkRequest), failedKeys);
        String failedKeysAsString = ProjectKeysProcessor.INSTANCE.mergeKeys(segregatedKeys);
        this.postDryRunPreflightService.updatePreMigrationReportExportOutcome(reportExportOutcomeCheckResult.getReportExportOutcome());
        this.postDryRunPreflightService.uploadDataPreparationZipToMCS(checkRequest, failedKeysAsString);
        return !((Collection)failedKeys).isEmpty() ? this.dryRunPreflightService.fetchCheckResult(segregatedKeys) : reportExportOutcomeCheckResult.getCheckResult();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final ReportExportOutcome readAllReports(String migrationId) {
        ReportExportOutcome reportExportOutcome2;
        Path path = this.localFileDataOutput.migrationDryRunReportDirectory(migrationId);
        File[] fileArray = path.toFile().listFiles();
        if (fileArray != null) {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            File[] fileArray2 = fileArray;
            boolean $i$f$map22 = false;
            File[] fileArray3 = fileArray2;
            Collection destination$iv$iv = new ArrayList(fileArray2.length);
            boolean $i$f$mapTo = false;
            for (ReportExportOutcome item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void var12_18 = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ReportExportOutcomeSerializer.INSTANCE.deserializeFromJsonArray(FilesKt.readText$default((File)it, null, (int)1, null)));
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            ReportExportOutcome initial$iv = ReportExportOutcome.Companion.getEMPTY();
            boolean $i$f$fold = false;
            ReportExportOutcome accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void reportExportOutcome3;
                ReportExportOutcome item$iv$iv;
                item$iv$iv = (ReportExportOutcome)element$iv;
                ReportExportOutcome acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc.plus((ReportExportOutcome)reportExportOutcome3);
            }
            ReportExportOutcome reportExportOutcome4 = accumulator$iv;
            if (reportExportOutcome4 != null) {
                reportExportOutcome2 = reportExportOutcome4;
                return reportExportOutcome2;
            }
        }
        reportExportOutcome2 = ReportExportOutcome.Companion.getEMPTY();
        return reportExportOutcome2;
    }

    @VisibleForTesting
    @NotNull
    public final String findPlanId(@NotNull CheckRequest checkRequest) {
        String string;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        if (PreflightCheckKt.getPlanId(checkRequest) != null) {
            String string2 = PreflightCheckKt.getPlanId(checkRequest);
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            String string3;
            if (PreflightCheckKt.getPreflightId(checkRequest) != null) {
                MigrationId migrationId = PreflightCheckKt.getPreflightId(checkRequest);
                Intrinsics.checkNotNull((Object)migrationId);
                String string4 = ((UUID)migrationId.getValue()).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                string3 = this.migrationPreflightRepository.getPlanIdByPreflightId(string4);
            } else {
                string3 = string = this.migrationPreflightRepository.getPlanIdByExecutionId(PreflightCheckKt.getPreflightCheckExecutionId(checkRequest));
            }
            if (string3 == null) {
                Plan plan2 = this.planRepository.getByExecutionId(PreflightCheckKt.getPreflightCheckExecutionId(checkRequest));
                string = plan2 != null ? plan2.getId() : null;
                if (string == null) {
                    throw new IllegalStateException(("PlanId not found for preflightId: " + PreflightCheckKt.getPreflightId(checkRequest) + " and executionId: " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest)).toString());
                }
            }
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/MultiNodeDryRunPreflightService$Companion;", "", "()V", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "pollForCompletionInterval", "Ljava/time/Duration;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

