/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.dryrun;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.jira.migration.export.ReportExportOutcome;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.log.MigrationLogsProvider;
import com.atlassian.jira.migration.migrationservice.ContainerTokenTTLService;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.PlatformUploadServiceInterface;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.dryrun.CheckRequestIsNotValidException;
import com.atlassian.jira.migration.preflight.reports.PreMigrationReportsService;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationScopeId;
import java.io.File;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u000eJ\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/PostDryRunPreflightService;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "preMigrationReportsService", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migrationLogsProvider", "Lcom/atlassian/jira/migration/log/MigrationLogsProvider;", "containerTokenTTLService", "Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/log/MigrationLogsProvider;Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;)V", "checkRequestValid", "", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "migrationScopeIdIsNotDummy", "sendDataPreparationErrorZipToMCS", "", "failedKeysAsString", "", "skipCrossProjectExportErrors", "updatePreMigrationReportExportOutcome", "combinedReportExportOutcome", "Lcom/atlassian/jira/migration/export/ReportExportOutcome;", "uploadDataPreparationZipToMCS", "Companion", "jira-migration-plugin"})
public final class PostDryRunPreflightService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final PreMigrationReportsService preMigrationReportsService;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigrationLogsProvider migrationLogsProvider;
    @NotNull
    private final ContainerTokenTTLService containerTokenTTLService;
    private static final Logger log = LoggerFactory.getLogger(PostDryRunPreflightService.class);
    @NotNull
    private static final String FILENAME = "DataPreparationErrorLogs_";
    @NotNull
    private static final String FILETYPE = ".zip";

    @Inject
    public PostDryRunPreflightService(@NotNull MigrationFeatures migrationFeatures, @NotNull PreMigrationReportsService preMigrationReportsService, @NotNull PlatformService platformService, @NotNull MigrationLogsProvider migrationLogsProvider, @NotNull ContainerTokenTTLService containerTokenTTLService) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)preMigrationReportsService, (String)"preMigrationReportsService");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migrationLogsProvider, (String)"migrationLogsProvider");
        Intrinsics.checkNotNullParameter((Object)containerTokenTTLService, (String)"containerTokenTTLService");
        this.migrationFeatures = migrationFeatures;
        this.preMigrationReportsService = preMigrationReportsService;
        this.platformService = platformService;
        this.migrationLogsProvider = migrationLogsProvider;
        this.containerTokenTTLService = containerTokenTTLService;
    }

    public final void updatePreMigrationReportExportOutcome(@NotNull ReportExportOutcome combinedReportExportOutcome) {
        Intrinsics.checkNotNullParameter((Object)combinedReportExportOutcome, (String)"combinedReportExportOutcome");
        if (!this.migrationFeatures.getSkipPreflightCheckExportErrors()) {
            this.preMigrationReportsService.updatePreMigrationReportExportOutcome$jira_migration_plugin(combinedReportExportOutcome);
        }
    }

    public final void uploadDataPreparationZipToMCS(@NotNull CheckRequest checkRequest, @NotNull String failedKeysAsString) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
            Intrinsics.checkNotNullParameter((Object)failedKeysAsString, (String)"failedKeysAsString");
            Object object2 = this;
            try {
                PostDryRunPreflightService $this$uploadDataPreparationZipToMCS_u24lambda_u240 = object2;
                boolean bl = false;
                $this$uploadDataPreparationZipToMCS_u24lambda_u240.sendDataPreparationErrorZipToMCS(checkRequest, failedKeysAsString);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object error = object = throwable;
            boolean bl = false;
            log.error("Encountered failure during generation or upload of error logs zip file during Data Preparation preflight", (Throwable)error);
        }
    }

    public final boolean skipCrossProjectExportErrors() {
        return this.migrationFeatures.getSkipCrossProjectExportErrors();
    }

    private final void sendDataPreparationErrorZipToMCS(CheckRequest checkRequest, String failedKeysAsString) {
        if (!this.checkRequestValid(checkRequest)) {
            throw new CheckRequestIsNotValidException("Cannot prepare logs for sending it to UMS because containerToken or migrationScopeId is not valid.");
        }
        if (!Intrinsics.areEqual((Object)"$", (Object)failedKeysAsString)) {
            Instant time = Instant.now();
            ContainerToken containerToken = new ContainerToken(PreflightCheckKt.getContainerToken(checkRequest));
            MigrationScopeId migrationScopeId2 = new MigrationScopeId(PreflightCheckKt.getMigrationScopeId(checkRequest));
            File file2 = (File)this.migrationLogsProvider.generateExportErrorLogsZip(failedKeysAsString, PreflightCheckKt.getPreflightCheckExecutionId(checkRequest)).component1();
            PlatformUploadServiceInterface.DefaultImpls.uploadMultiPartFileByMigrationScopeId$default(this.platformService, containerToken, migrationScopeId2, FILENAME + time + FILETYPE, "logs", file2, null, 32, null);
        }
    }

    private final boolean checkRequestValid(CheckRequest checkRequest) {
        return this.containerTokenTTLService.isValidToken(PreflightCheckKt.getContainerToken(checkRequest)) && this.migrationScopeIdIsNotDummy(checkRequest);
    }

    private final boolean migrationScopeIdIsNotDummy(CheckRequest checkRequest) {
        return !Intrinsics.areEqual((Object)PreflightCheckKt.getMigrationScopeId(checkRequest), (Object)"dummyMigrationScopeId");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/PostDryRunPreflightService$Companion;", "", "()V", "FILENAME", "", "FILETYPE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

