/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.dryrun;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.dryrun.DryRunPreflightService;
import com.atlassian.jira.migration.preflight.dryrun.MultiNodeDryRunPreflightService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.utils.DiskCheckErrorCode;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0017J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u000fH\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/ProjectReportErrorCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "dryRunPreflightService", "Lcom/atlassian/jira/migration/preflight/dryrun/DryRunPreflightService;", "multiNodeDryRunPreflightService", "Lcom/atlassian/jira/migration/preflight/dryrun/MultiNodeDryRunPreflightService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/dryrun/DryRunPreflightService;Lcom/atlassian/jira/migration/preflight/dryrun/MultiNodeDryRunPreflightService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "buildCheckStatusForExecutionError", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "inject", "", "result", "performCheck", "checkRequest", "jira-migration-plugin"})
public final class ProjectReportErrorCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final DryRunPreflightService dryRunPreflightService;
    @NotNull
    private final MultiNodeDryRunPreflightService multiNodeDryRunPreflightService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final CheckType checkType;

    @Inject
    public ProjectReportErrorCheck(@NotNull DryRunPreflightService dryRunPreflightService, @NotNull MultiNodeDryRunPreflightService multiNodeDryRunPreflightService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)dryRunPreflightService, (String)"dryRunPreflightService");
        Intrinsics.checkNotNullParameter((Object)multiNodeDryRunPreflightService, (String)"multiNodeDryRunPreflightService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.dryRunPreflightService = dryRunPreflightService;
        this.multiNodeDryRunPreflightService = multiNodeDryRunPreflightService;
        this.migrationFeatures = migrationFeatures;
        this.checkType = CheckType.ProjectErrorReport;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"loggedUser", (Object)ctx.getLoggedUser()), TuplesKt.to((Object)"usersGroupsMigrationOption", (Object)ctx.getUsersGroupsMigrationOption()), TuplesKt.to((Object)"projectDataMigrationMode", (Object)((Object)ctx.getProjectDataMigrationMode())), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"advancedRoadmapsPlanIds", ctx.getAdvancedRoadmapsPlanIds()), TuplesKt.to((Object)"migrationType", (Object)((Object)ctx.getMigrationType())), TuplesKt.to((Object)"singlePathMode", (Object)((Object)ctx.getSinglePathMode())), TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"migrationScopeId", (Object)ctx.getMigrationScopeId()), TuplesKt.to((Object)"crossProjectConfig", (Object)ctx.getCrossProjectConfig()), TuplesKt.to((Object)"migrateArchivedIssues", (Object)ctx.getMigrateArchivedIssues()), TuplesKt.to((Object)"appKeys", ctx.getAppKeys()), TuplesKt.to((Object)"dataFilterContext", (Object)ctx.getDataFilterContext()), TuplesKt.to((Object)"planId", (Object)ctx.getPlanId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.migrationFeatures.getEnableMultiNodePreflights() && this.migrationFeatures.getEnablePreflightLock() ? this.multiNodeDryRunPreflightService.performCheck(checkRequest) : this.dryRunPreflightService.performCheck(checkRequest);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public void inject(@NotNull CheckResultDto dto, @Nullable CheckResult result2) {
        void $this$inject_u24lambda_u240;
        CheckDetailsDto checkDetailsDto;
        String string;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        dto.setCheckType("ProjectErrorReport");
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                string = "We're checking for errors while we prepare your data for migration";
                break;
            }
            case 2: {
                string = "There are no data preparation errors";
                break;
            }
            case 3: {
                string = "We couldn't check for errors while preparing your data for migration";
                break;
            }
            case 4: {
                string = this.buildCheckStatusForExecutionError(dto);
                break;
            }
            case 5: {
                string = "We found some errors while preparing your data for migration";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        dto.setDescription(string);
        CheckDetailsDto checkDetailsDto2 = checkDetailsDto = new CheckDetailsDto();
        CheckResultDto checkResultDto = dto;
        boolean bl = false;
        CheckResult checkResult = result2;
        $this$inject_u24lambda_u240.setInfo(checkResult != null ? checkResult.details : null);
        checkResultDto.setDetails(checkDetailsDto);
    }

    private final String buildCheckStatusForExecutionError(CheckResultDto dto) {
        Status status;
        Integer n;
        Integer n2 = n = dto.getExecutionErrorCode();
        int n3 = DiskCheckErrorCode.ACCESS_DENIED_ERR_CODE.getErrorCode();
        if (n2 != null && n2 == n3) {
            status = Status.ERROR;
        } else {
            Integer n4 = n;
            n3 = DiskCheckErrorCode.NO_SPACE_ON_DEVICE_ERR_CODE.getErrorCode();
            status = n4 != null && n4 == n3 ? Status.ERROR : Status.EXECUTION_ERROR;
        }
        dto.setStatus(status);
        return DiskCheckErrorCode.Companion.fromErrorCode(dto.getExecutionErrorCode());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

