/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.dryrun;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.ProjectReportErrorCheckEvent;
import com.atlassian.jira.migration.export.ReportExportOutcome;
import com.atlassian.jira.migration.log.MigrationLogsService;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.dryrun.ReportExportOutcomeCheckResult;
import com.atlassian.jira.migration.preflight.model.CheckExecutionResult;
import com.atlassian.jira.migration.preflight.reports.PreMigrationReportsService;
import com.atlassian.jira.project.ProjectManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/ProjectReportErrorService;", "", "preMigrationReportsService", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService;", "migrationLogsService", "Lcom/atlassian/jira/migration/log/MigrationLogsService;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService;Lcom/atlassian/jira/migration/log/MigrationLogsService;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "getFailedProjectDetails", "", "", "failedProjectKeys", "", "performCheck", "Lcom/atlassian/jira/migration/preflight/dryrun/ReportExportOutcomeCheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectReportErrorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectReportErrorService.kt\ncom/atlassian/jira/migration/preflight/dryrun/ProjectReportErrorService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n526#2:116\n511#2,6:117\n1271#3,2:123\n1285#3,4:125\n*S KotlinDebug\n*F\n+ 1 ProjectReportErrorService.kt\ncom/atlassian/jira/migration/preflight/dryrun/ProjectReportErrorService\n*L\n79#1:116\n79#1:117,6\n105#1:123,2\n105#1:125,4\n*E\n"})
public final class ProjectReportErrorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PreMigrationReportsService preMigrationReportsService;
    @NotNull
    private final MigrationLogsService migrationLogsService;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private static final Logger log = LoggerFactory.getLogger(ProjectReportErrorService.class);
    @NotNull
    private static final String FILEPATH = "*-project-export.log";

    @Inject
    public ProjectReportErrorService(@NotNull PreMigrationReportsService preMigrationReportsService, @NotNull MigrationLogsService migrationLogsService, @NotNull ProjectManager projectManager, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)preMigrationReportsService, (String)"preMigrationReportsService");
        Intrinsics.checkNotNullParameter((Object)migrationLogsService, (String)"migrationLogsService");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.preMigrationReportsService = preMigrationReportsService;
        this.migrationLogsService = migrationLogsService;
        this.projectManager = projectManager;
        this.migrationEventBus = migrationEventBus;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ReportExportOutcomeCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        ReportExportOutcomeCheckResult reportExportOutcomeCheckResult;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        log.info("Starting preflight check with executionId " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest) + " for project report errors");
        long startTime = System.currentTimeMillis();
        this.migrationLogsService.deleteExistingPreflightExecutionLogs(PreflightCheckKt.getPreflightCheckExecutionId(checkRequest), FILEPATH);
        log.info("#performCheck with executionId " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest) + " Gathering reports data for project report errors");
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        UsersGroupsMigrationOption usersGroupsMigrationOption = PreflightCheckKt.getUsersGroupsMigrationOption(checkRequest);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        PreMigrationReportsService.UsersData usersData = new PreMigrationReportsService.UsersData(usersGroupsMigrationOption, completableFuture, null, PreflightCheckKt.getLoggedUser(checkRequest));
        ListenableFuture listenableFuture = Futures.immediateFuture(null);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
        ReportExportOutcome reportsData = this.preMigrationReportsService.gatherReportsDataFromProject(string, usersData, new PreMigrationReportsService.MigrationData((ListenableFuture<List<CheckExecutionResult>>)listenableFuture, PreflightCheckKt.getCloudId(checkRequest), PreflightCheckKt.getMigrationType(checkRequest), "", ""), new PreMigrationReportsService.ProjectsData(PreflightCheckKt.getProjectKeys(checkRequest), PreflightCheckKt.getProjectDataMigrationMode(checkRequest), PreflightCheckKt.getSinglePathMode(checkRequest), CollectionsKt.emptyList(), PreflightCheckKt.getCrossProjectConfig(checkRequest), PreflightCheckKt.getMigrateArchivedIssues(checkRequest), PreflightCheckKt.getDataFilterContext(checkRequest)), new PreMigrationReportsService.AppsData(PreflightCheckKt.getAppKeys(checkRequest)));
        log.info("#performCheck executionId " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest) + " Finished gathering reports data for project report errors");
        Map<String, Boolean> $this$filter$iv = reportsData.getExportErrors();
        boolean $i$f$filter = false;
        Map<String, Boolean> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((Boolean)it.getValue()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set<String> failedProjectKeys = destination$iv$iv.keySet();
        Map<String, String> failedProjectDetails = this.getFailedProjectDetails(failedProjectKeys);
        long endTime = System.currentTimeMillis();
        String string2 = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string3 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string3 == null) {
            string3 = "";
        }
        this.migrationEventBus.post(new ProjectReportErrorCheckEvent(string2, string3, endTime - startTime, failedProjectKeys.isEmpty()));
        log.info("Finished preflight check with executionId " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest) + " for project report errors in " + (endTime - startTime) + "ms");
        if (failedProjectKeys.isEmpty()) {
            reportExportOutcomeCheckResult = new ReportExportOutcomeCheckResult(reportsData, new CheckResult(true));
        } else {
            log.info("In the preflight with executionId " + PreflightCheckKt.getPreflightCheckExecutionId(checkRequest) + ", the following projectKeys " + failedProjectKeys + " had export failures");
            reportExportOutcomeCheckResult = new ReportExportOutcomeCheckResult(reportsData, new CheckResult(false, MapsKt.mapOf((Pair)TuplesKt.to((Object)"failedProjectDetails", failedProjectDetails))));
        }
        return reportExportOutcomeCheckResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getFailedProjectDetails(@NotNull Set<String> failedProjectKeys) {
        Intrinsics.checkNotNullParameter(failedProjectKeys, (String)"failedProjectKeys");
        Iterable $this$associateWith$iv = failedProjectKeys;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string2 = this.projectManager.getProjectObjByKey((String)it).getName();
            map.put(t, string2);
        }
        return result$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/dryrun/ProjectReportErrorService$Companion;", "", "()V", "FILEPATH", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

