/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.entitycache;

import com.atlassian.jira.migration.export.db.core.JiraAttachmentReader;
import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.jira.migration.export.model.ExpectedProjectEntityTypeCount;
import com.atlassian.jira.migration.export.model.UnsupportedEntity;
import com.atlassian.jira.migration.export.model.UnsupportedEntitySerializer;
import com.atlassian.jira.migration.preflight.entitycache.PreflightEntityCachePersistenceManager;
import com.atlassian.jira.migration.preflight.entitycache.ProjectExportPreflightCheckResult;
import com.atlassian.jira.project.Project;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.core.attachment.FileAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/preflight/entitycache/MigrationEntityCountService;", "", "issueReader", "Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;", "attachmentReader", "Lcom/atlassian/jira/migration/export/db/core/JiraAttachmentReader;", "preflightEntityCachePersistenceManager", "Lcom/atlassian/jira/migration/preflight/entitycache/PreflightEntityCachePersistenceManager;", "(Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;Lcom/atlassian/jira/migration/export/db/core/JiraAttachmentReader;Lcom/atlassian/jira/migration/preflight/entitycache/PreflightEntityCachePersistenceManager;)V", "getAttachmentCount", "Lcom/atlassian/jira/migration/export/model/ExpectedProjectEntityTypeCount;", "project", "Lcom/atlassian/jira/project/Project;", "migrateArchivedIssues", "", "getIssueCount", "getSummaryCount", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationEntityCountService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationEntityCountService.kt\ncom/atlassian/jira/migration/preflight/entitycache/MigrationEntityCountService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n766#2:55\n857#2,2:56\n*S KotlinDebug\n*F\n+ 1 MigrationEntityCountService.kt\ncom/atlassian/jira/migration/preflight/entitycache/MigrationEntityCountService\n*L\n42#1:55\n42#1:56,2\n*E\n"})
public final class MigrationEntityCountService {
    @NotNull
    private final JiraIssueReader issueReader;
    @NotNull
    private final JiraAttachmentReader attachmentReader;
    @NotNull
    private final PreflightEntityCachePersistenceManager preflightEntityCachePersistenceManager;

    @Inject
    public MigrationEntityCountService(@NotNull JiraIssueReader issueReader, @NotNull JiraAttachmentReader attachmentReader, @NotNull PreflightEntityCachePersistenceManager preflightEntityCachePersistenceManager) {
        Intrinsics.checkNotNullParameter((Object)issueReader, (String)"issueReader");
        Intrinsics.checkNotNullParameter((Object)attachmentReader, (String)"attachmentReader");
        Intrinsics.checkNotNullParameter((Object)preflightEntityCachePersistenceManager, (String)"preflightEntityCachePersistenceManager");
        this.issueReader = issueReader;
        this.attachmentReader = attachmentReader;
        this.preflightEntityCachePersistenceManager = preflightEntityCachePersistenceManager;
    }

    @NotNull
    public final List<ExpectedProjectEntityTypeCount> getSummaryCount(@NotNull Project project, boolean migrateArchivedIssues) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new ExpectedProjectEntityTypeCount[]{this.getIssueCount(project, migrateArchivedIssues), this.getAttachmentCount(project, migrateArchivedIssues)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final ExpectedProjectEntityTypeCount getIssueCount(Project project, boolean migrateArchivedIssues) {
        Long l = project.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        long issueCount = this.issueReader.getIssueCountForProject(((Number)l).longValue(), migrateArchivedIssues);
        String string = project.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        return new ExpectedProjectEntityTypeCount(string, Issue.Companion.getEntityType(), issueCount);
    }

    /*
     * WARNING - void declaration
     */
    private final ExpectedProjectEntityTypeCount getAttachmentCount(Project project, boolean migrateArchivedIssues) {
        int n;
        String string;
        Long l = project.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        long attachmentsId = this.attachmentReader.getAttachmentsCountByProject(((Number)l).longValue(), migrateArchivedIssues);
        Long l2 = project.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"getId(...)");
        ProjectExportPreflightCheckResult projectExportPreflightCheckResult = this.preflightEntityCachePersistenceManager.fetchProjectExportPreflightCheckResult(((Number)l2).longValue());
        if (projectExportPreflightCheckResult != null && (string = projectExportPreflightCheckResult.getUnsupportedEntities()) != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String it = string;
            boolean bl = false;
            Iterable iterable = UnsupportedEntitySerializer.INSTANCE.deserializeFromJsonArray(it);
            boolean $i$f$filter = false;
            void var12_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UnsupportedEntity entity = (UnsupportedEntity)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)entity.getImpactedEntityName(), (Object)"Attachment")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            n = ((List)destination$iv$iv).size();
        } else {
            n = 0;
        }
        int unsupportedAttachments = n;
        String string2 = project.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
        return new ExpectedProjectEntityTypeCount(string2, FileAttachment.Companion.getEntityType(), attachmentsId - (long)unsupportedAttachments);
    }
}

