/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.entitycache;

import com.atlassian.jira.migration.preflight.entitycache.ProjectExportPreflightCacheRepository;
import com.atlassian.jira.migration.preflight.entitycache.ProjectExportPreflightCheckResult;
import com.atlassian.jira.migration.utils.PreflightLogMessage;
import com.atlassian.jira.migration.utils.PreflightLogger;
import com.atlassian.migration.base.mri.MRI;
import java.sql.SQLException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bJ4\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/preflight/entitycache/PreflightEntityCachePersistenceManager;", "", "preflightRepository", "Lcom/atlassian/jira/migration/preflight/entitycache/ProjectExportPreflightCacheRepository;", "(Lcom/atlassian/jira/migration/preflight/entitycache/ProjectExportPreflightCacheRepository;)V", "deleteProjectExportPreflightCheckResult", "", "projectId", "", "fetchProjectExportPreflightCheckResult", "Lcom/atlassian/jira/migration/preflight/entitycache/ProjectExportPreflightCheckResult;", "persistProjectExportPreflightResultInDB", "executionTime", "mris", "", "Lcom/atlassian/migration/base/mri/MRI;", "configItems", "", "unsupportedEntities", "Companion", "jira-migration-plugin"})
public final class PreflightEntityCachePersistenceManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectExportPreflightCacheRepository preflightRepository;
    private static final Logger log = LoggerFactory.getLogger(PreflightEntityCachePersistenceManager.class);

    @Inject
    public PreflightEntityCachePersistenceManager(@NotNull ProjectExportPreflightCacheRepository preflightRepository) {
        Intrinsics.checkNotNullParameter((Object)preflightRepository, (String)"preflightRepository");
        this.preflightRepository = preflightRepository;
    }

    public final void persistProjectExportPreflightResultInDB(long projectId, long executionTime, @NotNull List<MRI> mris, @NotNull String configItems, @NotNull String unsupportedEntities) {
        Intrinsics.checkNotNullParameter(mris, (String)"mris");
        Intrinsics.checkNotNullParameter((Object)configItems, (String)"configItems");
        Intrinsics.checkNotNullParameter((Object)unsupportedEntities, (String)"unsupportedEntities");
        try {
            this.preflightRepository.upsertProjectExportPreflightResult(projectId, executionTime, mris, configItems, unsupportedEntities);
            Logger logger2 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"executionTime", (Object)executionTime), TuplesKt.to((Object)"projectId", (Object)projectId)};
            PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Saving project export preflight result in db", null, null, null, MapsKt.mapOf((Pair[])pairArray), null, 46, null));
        }
        catch (SQLException t) {
            log.error("Failed to persist projectExport preflight CheckResult for projectId " + projectId, (Throwable)t);
        }
    }

    @Nullable
    public final ProjectExportPreflightCheckResult fetchProjectExportPreflightCheckResult(long projectId) {
        ProjectExportPreflightCheckResult projectExportPreflightCheckResult;
        log.debug("Fetching project export pre-flight CheckStatus for projectId=" + projectId);
        try {
            projectExportPreflightCheckResult = this.preflightRepository.findProjectExportPreflightCheckResults(projectId);
        }
        catch (SQLException t) {
            log.error("Failed to fetch project export pre-flight CheckResult for projectId " + projectId, (Throwable)t);
            projectExportPreflightCheckResult = null;
        }
        return projectExportPreflightCheckResult;
    }

    public final void deleteProjectExportPreflightCheckResult(long projectId) {
        try {
            this.preflightRepository.deleteProjectExportPreflightCheckResults(projectId);
        }
        catch (SQLException t) {
            log.error("Failed to delete pre-flight CheckResult for projectId " + projectId, (Throwable)t);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/entitycache/PreflightEntityCachePersistenceManager$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

