/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.entitycache;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.preflight.entitycache.ProjectExportPreflightCheckResult;
import com.atlassian.jira.migration.preflight.entitycache.ProjectExportPreflightCheckResultEntity;
import com.atlassian.migration.base.mri.MRI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JF\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J4\u0010\u0019\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/preflight/entitycache/ProjectExportPreflightCacheRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "createRecord", "Lcom/atlassian/jira/migration/preflight/entitycache/ProjectExportPreflightCheckResultEntity;", "kotlin.jvm.PlatformType", "projectId", "", "softRefreshTime", "hardRefreshTime", "mris", "", "Lcom/atlassian/migration/base/mri/MRI;", "configItems", "", "unsupportedEntities", "deleteProjectExportPreflightCheckResults", "", "findProjectExportPreflightCheck", "findProjectExportPreflightCheckResults", "Lcom/atlassian/jira/migration/preflight/entitycache/ProjectExportPreflightCheckResult;", "toProjectExportPreflightCheckResult", "entity", "upsertProjectExportPreflightResult", "executionTime", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectExportPreflightCacheRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectExportPreflightCacheRepository.kt\ncom/atlassian/jira/migration/preflight/entitycache/ProjectExportPreflightCacheRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,104:1\n11065#2:105\n11400#2,3:106\n*S KotlinDebug\n*F\n+ 1 ProjectExportPreflightCacheRepository.kt\ncom/atlassian/jira/migration/preflight/entitycache/ProjectExportPreflightCacheRepository\n*L\n36#1:105\n36#1:106,3\n*E\n"})
public final class ProjectExportPreflightCacheRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public ProjectExportPreflightCacheRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    public final void upsertProjectExportPreflightResult(long projectId, long executionTime, @NotNull List<MRI> mris, @NotNull String configItems, @NotNull String unsupportedEntities) {
        Intrinsics.checkNotNullParameter(mris, (String)"mris");
        Intrinsics.checkNotNullParameter((Object)configItems, (String)"configItems");
        Intrinsics.checkNotNullParameter((Object)unsupportedEntities, (String)"unsupportedEntities");
        ProjectExportPreflightCheckResultEntity projectExportPreflightCheckResultEntity = this.findProjectExportPreflightCheck(projectId);
        if (projectExportPreflightCheckResultEntity != null) {
            ProjectExportPreflightCheckResultEntity it = projectExportPreflightCheckResultEntity;
            boolean bl = false;
            it.setSoftRefreshTime(executionTime);
            it.setMris(mris.toString());
            it.setConfigItems(configItems);
            it.setUnsupportedEntities(unsupportedEntities);
            it.save();
        } else {
            this.createRecord(projectId, executionTime, executionTime, mris, configItems, unsupportedEntities);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ProjectExportPreflightCheckResult findProjectExportPreflightCheckResults(long projectId) {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Object[]{projectId};
        RawEntity[] rawEntityArray = this.ao.find(ProjectExportPreflightCheckResultEntity.class, Query.select().where("PROJECT_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$map$iv = rawEntityArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProjectExportPreflightCheckResultEntity projectExportPreflightCheckResultEntity = (ProjectExportPreflightCheckResultEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toProjectExportPreflightCheckResult((ProjectExportPreflightCheckResultEntity)it));
        }
        return (ProjectExportPreflightCheckResult)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    public final void deleteProjectExportPreflightCheckResults(long projectId) {
        Object[] objectArray = new Object[]{projectId};
        this.ao.deleteWithSQL(ProjectExportPreflightCheckResultEntity.class, "PROJECT_ID = ?", objectArray);
    }

    private final ProjectExportPreflightCheckResultEntity findProjectExportPreflightCheck(long projectId) {
        Object[] objectArray = new Object[]{projectId};
        RawEntity[] rawEntityArray = this.ao.find(ProjectExportPreflightCheckResultEntity.class, Query.select().where("PROJECT_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (ProjectExportPreflightCheckResultEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }

    private final ProjectExportPreflightCheckResultEntity createRecord(long projectId, long softRefreshTime, long hardRefreshTime, List<MRI> mris, String configItems, String unsupportedEntities) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"PROJECT_ID", (Object)projectId), TuplesKt.to((Object)"SOFT_REFRESH_TIME", (Object)softRefreshTime), TuplesKt.to((Object)"HARD_REFRESH_TIME", (Object)hardRefreshTime), TuplesKt.to((Object)"MRIS", (Object)mris.toString()), TuplesKt.to((Object)"CONFIG_ITEMS", (Object)configItems), TuplesKt.to((Object)"UNSUPPORTED_ENTITIES", (Object)unsupportedEntities)};
        return (ProjectExportPreflightCheckResultEntity)this.ao.create(ProjectExportPreflightCheckResultEntity.class, MapsKt.mapOf((Pair[])pairArray));
    }

    private final ProjectExportPreflightCheckResult toProjectExportPreflightCheckResult(ProjectExportPreflightCheckResultEntity entity) {
        return new ProjectExportPreflightCheckResult(entity.getProjectId(), entity.getSoftRefreshTime(), entity.getHardRefreshTime(), entity.getMris(), entity.getConfigItems(), entity.getUnsupportedEntities());
    }
}

