/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.entitycache;

import com.atlassian.jira.migration.preflight.entitycache.ScopedUserCacheTimeStamp;
import com.atlassian.jira.migration.preflight.entitycache.ScopedUserPreflightCacheRepositoryKt;
import com.atlassian.jira.migration.preflight.entitycache.ScopedUserPreflightCacheTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\bJ4\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J*\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\fJ4\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J,\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/preflight/entitycache/ScopedUserPreflightCacheRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "clearCache", "", "projectId", "", "getCacheTimeStamp", "Lcom/atlassian/jira/migration/preflight/entitycache/ScopedUserCacheTimeStamp;", "getGroupNames", "", "", "getUserKeys", "insertCache", "users", "", "groups", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "persistInCache", "usersKeys", "groupsNames", "updateCache", "record", "Lcom/querydsl/core/Tuple;", "upsertCache", "jira-migration-plugin"})
public final class ScopedUserPreflightCacheRepository {
    @NotNull
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public ScopedUserPreflightCacheRepository(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    public final void persistInCache(long projectId, @NotNull List<String> usersKeys, @NotNull Set<String> groupsNames) {
        Intrinsics.checkNotNullParameter(usersKeys, (String)"usersKeys");
        Intrinsics.checkNotNullParameter(groupsNames, (String)"groupsNames");
        this.upsertCache(projectId, usersKeys, groupsNames);
    }

    @NotNull
    public final Set<String> getUserKeys(long projectId) {
        Object object = this.databaseAccessor.run(arg_0 -> ScopedUserPreflightCacheRepository.getUserKeys$lambda$1(projectId, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (Set)object;
    }

    @NotNull
    public final Set<String> getGroupNames(long projectId) {
        Object object = this.databaseAccessor.run(arg_0 -> ScopedUserPreflightCacheRepository.getGroupNames$lambda$3(projectId, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (Set)object;
    }

    public final void clearCache(long projectId) {
        this.databaseAccessor.run(arg_0 -> ScopedUserPreflightCacheRepository.clearCache$lambda$4(projectId, arg_0), OnRollback.NOOP);
    }

    @Nullable
    public final ScopedUserCacheTimeStamp getCacheTimeStamp(long projectId) {
        return (ScopedUserCacheTimeStamp)this.databaseAccessor.run(arg_0 -> ScopedUserPreflightCacheRepository.getCacheTimeStamp$lambda$6(projectId, arg_0), OnRollback.NOOP);
    }

    private final void upsertCache(long projectId, List<String> users2, Set<String> groups2) {
        this.databaseAccessor.run(arg_0 -> ScopedUserPreflightCacheRepository.upsertCache$lambda$8(projectId, this, users2, groups2, arg_0), OnRollback.NOOP);
    }

    private final void insertCache(long projectId, List<String> users2, Set<String> groups2, DatabaseConnection db) {
        SQLInsertClause sQLInsertClause;
        Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
        SQLInsertClause $this$insertCache_u24lambda_u249 = sQLInsertClause = db.insert((RelationalPath)ScopedUserPreflightCacheTable.INSTANCE);
        boolean bl = false;
        $this$insertCache_u24lambda_u249.set((Path)ScopedUserPreflightCacheTable.INSTANCE.getPROJECT_ID(), (Object)projectId);
        $this$insertCache_u24lambda_u249.set((Path)ScopedUserPreflightCacheTable.INSTANCE.getUSER_KEYS(), (Object)users2.toString());
        $this$insertCache_u24lambda_u249.set((Path)ScopedUserPreflightCacheTable.INSTANCE.getGROUP_NAMES(), (Object)groups2.toString());
        $this$insertCache_u24lambda_u249.set((Path)ScopedUserPreflightCacheTable.INSTANCE.getLAST_HARD_REFRESH_TIMESTAMP(), (Object)timeStamp);
        $this$insertCache_u24lambda_u249.set((Path)ScopedUserPreflightCacheTable.INSTANCE.getLAST_SOFT_REFRESH_TIMESTAMP(), (Object)timeStamp);
        $this$insertCache_u24lambda_u249.execute();
    }

    private final void updateCache(Tuple record, List<String> users2, Set<String> groups2, DatabaseConnection db) {
        Set<String> set;
        SQLUpdateClause sQLUpdateClause;
        Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
        HashSet userKeys = null;
        userKeys = new HashSet();
        HashSet groupNames = null;
        groupNames = new HashSet();
        SQLUpdateClause $this$updateCache_u24lambda_u2412 = sQLUpdateClause = db.update((RelationalPath)ScopedUserPreflightCacheTable.INSTANCE);
        boolean bl = false;
        Set<String> it = set = ScopedUserPreflightCacheRepositoryKt.toSet((String)record.get((Expression)ScopedUserPreflightCacheTable.INSTANCE.getUSER_KEYS()));
        boolean bl2 = false;
        userKeys.addAll(it);
        userKeys.addAll(users2);
        it = set = ScopedUserPreflightCacheRepositoryKt.toSet((String)record.get((Expression)ScopedUserPreflightCacheTable.INSTANCE.getGROUP_NAMES()));
        boolean bl3 = false;
        groupNames.addAll(it);
        groupNames.addAll(groups2);
        $this$updateCache_u24lambda_u2412.set((Path)ScopedUserPreflightCacheTable.INSTANCE.getUSER_KEYS(), (Object)userKeys.toString());
        $this$updateCache_u24lambda_u2412.set((Path)ScopedUserPreflightCacheTable.INSTANCE.getGROUP_NAMES(), (Object)groupNames.toString());
        $this$updateCache_u24lambda_u2412.set((Path)ScopedUserPreflightCacheTable.INSTANCE.getLAST_SOFT_REFRESH_TIMESTAMP(), (Object)timeStamp);
        $this$updateCache_u24lambda_u2412.where((Predicate)ScopedUserPreflightCacheTable.INSTANCE.getPROJECT_ID().eq(record.get((Expression)ScopedUserPreflightCacheTable.INSTANCE.getPROJECT_ID())));
        $this$updateCache_u24lambda_u2412.execute();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Set getUserKeys$lambda$1(long $projectId, DatabaseConnection db) {
        Set<String> set;
        String string = (String)((SQLQuery)((SQLQuery)db.select((Expression)ScopedUserPreflightCacheTable.INSTANCE.getUSER_KEYS()).from((Expression)ScopedUserPreflightCacheTable.INSTANCE)).where((Predicate)ScopedUserPreflightCacheTable.INSTANCE.getPROJECT_ID().eq((Object)$projectId))).fetchFirst();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Set<String> set2 = ScopedUserPreflightCacheRepositoryKt.toSet(it);
            if (set2 != null) {
                set = set2;
                return set;
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Set getGroupNames$lambda$3(long $projectId, DatabaseConnection db) {
        Set<String> set;
        String string = (String)((SQLQuery)((SQLQuery)db.select((Expression)ScopedUserPreflightCacheTable.INSTANCE.getGROUP_NAMES()).from((Expression)ScopedUserPreflightCacheTable.INSTANCE)).where((Predicate)ScopedUserPreflightCacheTable.INSTANCE.getPROJECT_ID().eq((Object)$projectId))).fetchFirst();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Set<String> set2 = ScopedUserPreflightCacheRepositoryKt.toSet(it);
            if (set2 != null) {
                set = set2;
                return set;
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    private static final Long clearCache$lambda$4(long $projectId, DatabaseConnection db) {
        return db.delete((RelationalPath)ScopedUserPreflightCacheTable.INSTANCE).where((Predicate)ScopedUserPreflightCacheTable.INSTANCE.getPROJECT_ID().eq((Object)$projectId)).execute();
    }

    private static final ScopedUserCacheTimeStamp getCacheTimeStamp$lambda$6(long $projectId, DatabaseConnection db) {
        ScopedUserCacheTimeStamp scopedUserCacheTimeStamp;
        Expression[] expressionArray = new Expression[]{ScopedUserPreflightCacheTable.INSTANCE.getLAST_HARD_REFRESH_TIMESTAMP(), ScopedUserPreflightCacheTable.INSTANCE.getLAST_SOFT_REFRESH_TIMESTAMP()};
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)ScopedUserPreflightCacheTable.INSTANCE)).where((Predicate)ScopedUserPreflightCacheTable.INSTANCE.getPROJECT_ID().eq((Object)$projectId))).fetchFirst();
        if (tuple != null) {
            Tuple it = tuple;
            boolean bl = false;
            Object object = it.get((Expression)ScopedUserPreflightCacheTable.INSTANCE.getLAST_HARD_REFRESH_TIMESTAMP());
            Intrinsics.checkNotNull((Object)object);
            Timestamp timestamp = (Timestamp)object;
            Object object2 = it.get((Expression)ScopedUserPreflightCacheTable.INSTANCE.getLAST_SOFT_REFRESH_TIMESTAMP());
            Intrinsics.checkNotNull((Object)object2);
            scopedUserCacheTimeStamp = new ScopedUserCacheTimeStamp($projectId, timestamp, (Timestamp)object2);
        } else {
            scopedUserCacheTimeStamp = null;
        }
        return scopedUserCacheTimeStamp;
    }

    private static final Unit upsertCache$lambda$8(long $projectId, ScopedUserPreflightCacheRepository this$0, List $users, Set $groups, DatabaseConnection db) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$users, (String)"$users");
            Intrinsics.checkNotNullParameter((Object)$groups, (String)"$groups");
            Path[] pathArray = ScopedUserPreflightCacheTable.INSTANCE.all();
            Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)ScopedUserPreflightCacheTable.INSTANCE)).where((Predicate)ScopedUserPreflightCacheTable.INSTANCE.getPROJECT_ID().eq((Object)$projectId))).fetchFirst();
            if (tuple != null) {
                Tuple it = tuple;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)db);
                this$0.updateCache(it, $users, $groups, db);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            Intrinsics.checkNotNull((Object)db);
            this$0.insertCache($projectId, $users, $groups, db);
        }
        return Unit.INSTANCE;
    }
}

