/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PreMigrationReportGenerationCompletedEvent;
import com.atlassian.jira.migration.events.PreMigrationReportGenerationFailedEvent;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatus;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatusRepository;
import com.atlassian.jira.migration.preflight.reports.ReportStatusAndDate;
import com.atlassian.jira.migration.preflight.reports.ReportType;
import com.atlassian.jira.migration.preflight.reports.Status;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u0011J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\f\u001a\u00020\rJ \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH&R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/AbstractReportService;", "", "reportStatusRepository", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getMigrationEventBus", "()Lcom/atlassian/jira/migration/events/MigrationEventBus;", "reportType", "Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "getReportType", "()Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "getReportFilename", "", "executionId", "getReportStatus", "Lcom/atlassian/jira/migration/preflight/reports/ReportStatusAndDate;", "saveReportStatus", "", "status", "Lcom/atlassian/jira/migration/preflight/reports/Status;", "setReportGenerationCompleted", "setReportGenerationFailed", "throwable", "", "writeReportToStream", "outputStream", "Ljava/io/OutputStream;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractReportService.kt\ncom/atlassian/jira/migration/preflight/reports/AbstractReportService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public abstract class AbstractReportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationReportStatusRepository reportStatusRepository;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private final Logger log;
    @NotNull
    private static final DateTimeFormatter dateTimeFormat;

    public AbstractReportService(@NotNull MigrationReportStatusRepository reportStatusRepository, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)reportStatusRepository, (String)"reportStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.reportStatusRepository = reportStatusRepository;
        this.migrationEventBus = migrationEventBus;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public final MigrationEventBus getMigrationEventBus() {
        return this.migrationEventBus;
    }

    @NotNull
    protected abstract ReportType getReportType();

    public abstract void writeReportToStream(@NotNull String var1, @NotNull OutputStream var2);

    @Nullable
    public final ReportStatusAndDate getReportStatus(@NotNull String executionId) {
        ReportStatusAndDate reportStatusAndDate;
        MigrationReportStatus reportStatus;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        MigrationReportStatus migrationReportStatus = reportStatus = this.reportStatusRepository.findByExecutionIdAndReportType(executionId, this.getReportType());
        if (migrationReportStatus != null) {
            MigrationReportStatus it = migrationReportStatus;
            boolean bl = false;
            reportStatusAndDate = new ReportStatusAndDate(it.getStatus(), it.getUpdatedAt());
        } else {
            reportStatusAndDate = null;
        }
        return reportStatusAndDate;
    }

    private final void saveReportStatus(String executionId, Status status, ReportType reportType) {
        this.reportStatusRepository.saveOrReplace(new MigrationReportStatus(executionId, reportType, status, Instant.now()));
    }

    static /* synthetic */ void saveReportStatus$default(AbstractReportService abstractReportService, String string, Status status, ReportType reportType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveReportStatus");
        }
        if ((n & 4) != 0) {
            reportType = abstractReportService.getReportType();
        }
        abstractReportService.saveReportStatus(string, status, reportType);
    }

    @NotNull
    public final String getReportFilename(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        ReportStatusAndDate reportStatusAndDate = this.getReportStatus(executionId);
        Instant date = reportStatusAndDate != null ? reportStatusAndDate.getUpdatedDate() : null;
        String formattedDate = date == null ? "" : '_' + date.atZone(ZoneId.systemDefault()).format(dateTimeFormat);
        return this.getReportType().getDisplayName() + "_Jira" + formattedDate + ".csv";
    }

    public final void setReportGenerationCompleted(@NotNull String executionId, @NotNull ReportType reportType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)reportType), (String)"reportType");
        this.log.info("Pre migration report " + (Object)((Object)reportType) + " completed for execution id: " + executionId);
        this.saveReportStatus(executionId, Status.COMPLETED, reportType);
        String string = reportType.toString();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.migrationEventBus.post(new PreMigrationReportGenerationCompletedEvent(executionId, string, instant));
    }

    public static /* synthetic */ void setReportGenerationCompleted$default(AbstractReportService abstractReportService, String string, ReportType reportType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setReportGenerationCompleted");
        }
        if ((n & 2) != 0) {
            reportType = abstractReportService.getReportType();
        }
        abstractReportService.setReportGenerationCompleted(string, reportType);
    }

    public final void setReportGenerationFailed(@NotNull String executionId, @NotNull Throwable throwable, @NotNull ReportType reportType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter((Object)((Object)reportType), (String)"reportType");
        this.log.warn("Failed to generate report - " + reportType.getDisplayName(), throwable);
        this.saveReportStatus(executionId, Status.FAILED, reportType);
        String string = reportType.toString();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.migrationEventBus.post(new PreMigrationReportGenerationFailedEvent(executionId, string, instant));
    }

    public static /* synthetic */ void setReportGenerationFailed$default(AbstractReportService abstractReportService, String string, Throwable throwable, ReportType reportType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setReportGenerationFailed");
        }
        if ((n & 4) != 0) {
            reportType = abstractReportService.getReportType();
        }
        abstractReportService.setReportGenerationFailed(string, throwable, reportType);
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        dateTimeFormat = dateTimeFormatter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/AbstractReportService$Companion;", "", "()V", "dateTimeFormat", "Ljava/time/format/DateTimeFormatter;", "getDateTimeFormat", "()Ljava/time/format/DateTimeFormatter;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormatter getDateTimeFormat() {
            return dateTimeFormat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

