/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.model.ConfigItem;
import com.atlassian.jira.migration.export.model.ConfigItemType;
import com.atlassian.jira.migration.preflight.reports.AbstractReportService;
import com.atlassian.jira.migration.preflight.reports.ConfigItemRow;
import com.atlassian.jira.migration.preflight.reports.ConfigItemsReportOutput;
import com.atlassian.jira.migration.preflight.reports.ConfigItemsRepository;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatusRepository;
import com.atlassian.jira.migration.preflight.reports.ReportType;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010J\u001c\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/ConfigItemsReportService;", "Lcom/atlassian/jira/migration/preflight/reports/AbstractReportService;", "reportStatusRepository", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "configItemsRepository", "Lcom/atlassian/jira/migration/preflight/reports/ConfigItemsRepository;", "configItemsReportOutput", "Lcom/atlassian/jira/migration/preflight/reports/ConfigItemsReportOutput;", "(Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/preflight/reports/ConfigItemsRepository;Lcom/atlassian/jira/migration/preflight/reports/ConfigItemsReportOutput;)V", "reportType", "Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "getReportType", "()Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "buildConfigItemName", "", "configItem", "Lcom/atlassian/jira/migration/export/model/ConfigItem;", "deleteReportDataByExecutionId", "", "executionId", "generateReportData", "configItems", "", "writeReportToStream", "outputStream", "Ljava/io/OutputStream;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nConfigItemsReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigItemsReportService.kt\ncom/atlassian/jira/migration/preflight/reports/ConfigItemsReportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1549#2:55\n1620#2,3:56\n*S KotlinDebug\n*F\n+ 1 ConfigItemsReportService.kt\ncom/atlassian/jira/migration/preflight/reports/ConfigItemsReportService\n*L\n33#1:55\n33#1:56,3\n*E\n"})
public final class ConfigItemsReportService
extends AbstractReportService {
    @NotNull
    private final ConfigItemsRepository configItemsRepository;
    @NotNull
    private final ConfigItemsReportOutput configItemsReportOutput;
    @NotNull
    private final ReportType reportType;

    @Inject
    public ConfigItemsReportService(@NotNull MigrationReportStatusRepository reportStatusRepository, @NotNull MigrationEventBus migrationEventBus, @NotNull ConfigItemsRepository configItemsRepository, @NotNull ConfigItemsReportOutput configItemsReportOutput) {
        Intrinsics.checkNotNullParameter((Object)reportStatusRepository, (String)"reportStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)configItemsRepository, (String)"configItemsRepository");
        Intrinsics.checkNotNullParameter((Object)configItemsReportOutput, (String)"configItemsReportOutput");
        super(reportStatusRepository, migrationEventBus);
        this.configItemsRepository = configItemsRepository;
        this.configItemsReportOutput = configItemsReportOutput;
        this.reportType = ReportType.CONFIG_ITEMS;
    }

    @Override
    @NotNull
    protected ReportType getReportType() {
        return this.reportType;
    }

    public final void generateReportData(@NotNull String executionId, @NotNull Set<ConfigItem> configItems) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(configItems, (String)"configItems");
        try {
            this.configItemsRepository.saveOrReplaceAll(executionId, (Collection<ConfigItem>)configItems);
            AbstractReportService.setReportGenerationCompleted$default(this, executionId, null, 2, null);
        }
        catch (Exception e) {
            AbstractReportService.setReportGenerationFailed$default(this, executionId, e, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeReportToStream(@NotNull String executionId, @NotNull OutputStream outputStream) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        List<ConfigItem> configItems = this.configItemsRepository.findByExecutionId(executionId);
        Iterable $this$map$iv = configItems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void configItem;
            ConfigItem configItem2 = (ConfigItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = this.buildConfigItemName((ConfigItem)configItem);
            collection.add(new ConfigItemRow(configItem.getType().getTypeName(), name));
        }
        List configItemsRows = (List)destination$iv$iv;
        this.configItemsReportOutput.write(outputStream, configItemsRows);
    }

    private final String buildConfigItemName(ConfigItem configItem) {
        return configItem.getType() == ConfigItemType.WORKFLOW || configItem.getType() == ConfigItemType.ADVANCED_ROADMAPS_PLAN ? '\"' + configItem.getName() + '\"' : '\"' + configItem.getName() + "\" [" + configItem.getConfigItemId() + ']';
    }

    public final void deleteReportDataByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.configItemsRepository.deleteByExecutionId(executionId);
    }
}

