/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.TableRecordsDeletedEvent;
import com.atlassian.jira.migration.events.TableRecordsInsertedEvent;
import com.atlassian.jira.migration.export.model.ConfigItem;
import com.atlassian.jira.migration.preflight.reports.ConfigItemsTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/ConfigItemsRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "deleteByExecutionId", "", "executionId", "", "findByExecutionId", "", "Lcom/atlassian/jira/migration/export/model/ConfigItem;", "saveOrReplaceAll", "configItems", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nConfigItemsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigItemsRepository.kt\ncom/atlassian/jira/migration/preflight/reports/ConfigItemsRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1855#2,2:132\n1549#2:134\n1620#2,3:135\n*S KotlinDebug\n*F\n+ 1 ConfigItemsRepository.kt\ncom/atlassian/jira/migration/preflight/reports/ConfigItemsRepository\n*L\n38#1:132,2\n65#1:134\n65#1:135,3\n*E\n"})
public final class ConfigItemsRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private static final String ANALYTICS_TABLE_NAME = "configItems";
    private static final Logger log = LoggerFactory.getLogger(ConfigItemsRepository.class);

    @Inject
    public ConfigItemsRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.databaseAccessor = databaseAccessor;
        this.migrationEventBus = migrationEventBus;
    }

    public final void saveOrReplaceAll(@NotNull String executionId, @NotNull Collection<ConfigItem> configItems) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(configItems, (String)ANALYTICS_TABLE_NAME);
        Pair pair = (Pair)this.databaseAccessor.run(arg_0 -> ConfigItemsRepository.saveOrReplaceAll$lambda$2(executionId, configItems, arg_0), ConfigItemsRepository::saveOrReplaceAll$lambda$3);
        long numberOfRecordsDeleted = ((Number)pair.component1()).longValue();
        long numberOfRecordsInserted = ((Number)pair.component2()).longValue();
        this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsDeleted));
        this.migrationEventBus.post(new TableRecordsInsertedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsInserted));
    }

    @NotNull
    public final List<ConfigItem> findByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object object = this.databaseAccessor.run(arg_0 -> ConfigItemsRepository.findByExecutionId$lambda$4(executionId, arg_0), ConfigItemsRepository::findByExecutionId$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    public final void deleteByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        try {
            Long numberOfRecordsDeleted = (Long)this.databaseAccessor.run(arg_0 -> ConfigItemsRepository.deleteByExecutionId$lambda$6(executionId, arg_0), ConfigItemsRepository::deleteByExecutionId$lambda$7);
            Intrinsics.checkNotNull((Object)numberOfRecordsDeleted);
            this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsDeleted));
        }
        catch (RuntimeException e) {
            log.error("Could not delete config items by executionId: " + executionId + '.', (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair saveOrReplaceAll$lambda$2(String $executionId, Collection $configItems, DatabaseConnection db) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)$configItems, (String)"$configItems");
        Long l2 = db.delete((RelationalPath)ConfigItemsTable.INSTANCE).where((Predicate)ConfigItemsTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
        if ($configItems.isEmpty()) {
            l = 0L;
        } else {
            void $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241;
            SQLInsertClause sQLInsertClause = db.insert((RelationalPath)ConfigItemsTable.INSTANCE);
            Long l3 = l2;
            boolean bl = false;
            Iterable $this$forEach$iv = $configItems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConfigItem it = (ConfigItem)element$iv;
                boolean bl2 = false;
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)ConfigItemsTable.INSTANCE.getEXECUTION_ID(), (Object)$executionId);
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)ConfigItemsTable.INSTANCE.getTYPE(), (Object)it.getType().name());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)ConfigItemsTable.INSTANCE.getNAME(), (Object)it.getName());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)ConfigItemsTable.INSTANCE.getCONFIG_ITEM_ID(), (Object)it.getConfigItemId());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.addBatch();
            }
            long l4 = $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.execute();
            l2 = l3;
            l = l4;
        }
        Long l5 = l;
        Long l6 = l2;
        return new Pair((Object)l6, (Object)l5);
    }

    private static final void saveOrReplaceAll$lambda$3() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List findByExecutionId$lambda$4(String $executionId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Object object = ConfigItemsTable.INSTANCE.all();
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)ConfigItemsTable.INSTANCE)).where((Predicate)ConfigItemsTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId));
        object = new OrderSpecifier[]{ConfigItemsTable.INSTANCE.getTYPE().asc(), ConfigItemsTable.INSTANCE.getNAME().asc()};
        List list = ((SQLQuery)sQLQuery.orderBy((OrderSpecifier[])object)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = ConfigItemsTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ConfigItemsTable)((Object)object)).toConfigItem((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void findByExecutionId$lambda$5() {
    }

    private static final Long deleteByExecutionId$lambda$6(String $executionId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        return db.delete((RelationalPath)ConfigItemsTable.INSTANCE).where((Predicate)ConfigItemsTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
    }

    private static final void deleteByExecutionId$lambda$7() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/ConfigItemsRepository$Companion;", "", "()V", "ANALYTICS_TABLE_NAME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

