/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.export.ReportExportOutcome;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.platform.MaxConcurrencyPageLoopMode;
import com.atlassian.jira.migration.preflight.reports.DryRunWriteService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00112\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/DryRunWriteServiceImpl;", "Lcom/atlassian/jira/migration/preflight/reports/DryRunWriteService;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/config/util/JiraHome;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "projectExportParallelism", "", "getProjectExportParallelism", "()I", "diskThresholdCheck", "", "topProjects", "", "", "getFreeDiskSpace", "getProjectKeysByIssueCount", "projectIds", "", "getRequiredDiskSpace", "postDryRunCleanup", "", "reportExportOutcome", "Lcom/atlassian/jira/migration/export/ReportExportOutcome;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDryRunWriteServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DryRunWriteServiceImpl.kt\ncom/atlassian/jira/migration/preflight/reports/DryRunWriteServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1549#2:76\n1620#2,3:77\n1054#2:80\n1549#2:81\n1620#2,3:82\n1549#2:85\n1620#2,3:86\n1#3:89\n*S KotlinDebug\n*F\n+ 1 DryRunWriteServiceImpl.kt\ncom/atlassian/jira/migration/preflight/reports/DryRunWriteServiceImpl\n*L\n29#1:76\n29#1:77,3\n34#1:80\n34#1:81\n34#1:82,3\n41#1:85\n41#1:86,3\n*E\n"})
public final class DryRunWriteServiceImpl
implements DryRunWriteService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final JiraHome jiraHome;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final Logger logger = Logger.getLogger(DryRunWriteServiceImpl.class);
    @NotNull
    private static final String FILE_CLEAN_UP_ERROR = "Error post dry-run file clean up";
    private static final int AVERAGE_ISSUE_BYTE_SIZE = 14700;

    @Inject
    public DryRunWriteServiceImpl(@NotNull IssueManager issueManager, @NotNull JiraHome jiraHome, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.issueManager = issueManager;
        this.jiraHome = jiraHome;
        this.migrationFeatures = migrationFeatures;
    }

    public final int getProjectExportParallelism() {
        return MaxConcurrencyPageLoopMode.INSTANCE.getProjectExportParallelism(Runtime.getRuntime().availableProcessors());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Long> getProjectKeysByIssueCount(@NotNull List<Long> projectIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        Iterable $this$map$iv2 = CollectionsKt.filterNotNull((Iterable)projectIds);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            long l = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv;
            boolean bl = false;
            long issueCount = this.issueManager.getIssueCountForProject(Long.valueOf((long)it));
            collection.add(new Pair((Object)((long)it), (Object)issueCount));
        }
        List issueCountOfProjects = (List)destination$iv$iv;
        int subListSize = this.getProjectExportParallelism() > projectIds.size() ? projectIds.size() : this.getProjectExportParallelism();
        Iterable $this$sortedByDescending$iv = issueCountOfProjects;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Long)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getSecond()));
            }
        });
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((Number)it.getFirst()).longValue());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv2).subList(0, subListSize));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postDryRunCleanup(@NotNull ReportExportOutcome reportExportOutcome2) {
        Intrinsics.checkNotNullParameter((Object)reportExportOutcome2, (String)"reportExportOutcome");
        try {
            if (!((Collection)reportExportOutcome2.getDryRunWriteFiles()).isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = reportExportOutcome2.getDryRunWriteFiles();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.delete());
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
        }
        catch (Exception exception) {
            logger.warn((Object)("Error post dry-run file clean up -->  " + exception));
        }
    }

    @Override
    public boolean diskThresholdCheck(@NotNull Set<Long> topProjects) {
        Intrinsics.checkNotNullParameter(topProjects, (String)"topProjects");
        return this.getFreeDiskSpace() > this.getRequiredDiskSpace(topProjects);
    }

    /*
     * WARNING - void declaration
     */
    public final long getRequiredDiskSpace(@NotNull Set<Long> topProjects) {
        long l;
        Intrinsics.checkNotNullParameter(topProjects, (String)"topProjects");
        Iterable iterable = topProjects;
        double d = this.migrationFeatures.getDiskCheckThresholdFactor() * (double)14700;
        long l2 = 0L;
        for (Object t : iterable) {
            void it;
            Long l3 = (Long)t;
            l = l2;
            boolean bl = false;
            long l4 = this.issueManager.getIssueCountForProject((Long)it);
            l2 = l + l4;
        }
        l = l2;
        return MathKt.roundToLong((double)(d * (double)l));
    }

    private final long getFreeDiskSpace() {
        long freeDiskSpace = 0L;
        try {
            Path jiraHomePath = Paths.get(this.jiraHome.getHome().getAbsolutePath(), new String[0]);
            freeDiskSpace = Files.getFileStore(jiraHomePath).getUsableSpace();
        }
        catch (IOException ioException) {
            logger.warn((Object)("Error Encountered diskThresholdCheck |" + ioException + '|'));
        }
        return freeDiskSpace;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/DryRunWriteServiceImpl$Companion;", "", "()V", "AVERAGE_ISSUE_BYTE_SIZE", "", "FILE_CLEAN_UP_ERROR", "", "logger", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

