/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.analytics.ReconEventHandler;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.duplicates.configOnly.CloudEntityType;
import com.atlassian.jira.migration.duplicates.configOnly.ConfigEntity;
import com.atlassian.jira.migration.duplicates.configOnly.ConfigOnlyContext;
import com.atlassian.jira.migration.duplicates.configOnly.ConfigSource;
import com.atlassian.jira.migration.duplicates.configOnly.EntityType;
import com.atlassian.jira.migration.duplicates.configOnly.ServerCloudDataProvider;
import com.atlassian.jira.migration.duplicates.configOnly.comparer.EntityComparer;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.ReconEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.reports.AbstractReportService;
import com.atlassian.jira.migration.preflight.reports.ComparisonType;
import com.atlassian.jira.migration.preflight.reports.DuplicateEntitiesReportOutput;
import com.atlassian.jira.migration.preflight.reports.DuplicateEntityRow;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatusRepository;
import com.atlassian.jira.migration.preflight.reports.ReportType;
import com.atlassian.jira.migration.recon.ReconFileOutput;
import com.atlassian.jira.migration.recon.service.MonitorService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.base.ContainerEntity;
import com.atlassian.migration.base.IdentifiableEntity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J,\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010$\u001a\u00020 J\u000e\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001cJ,\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010$\u001a\u00020 J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001e2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010#\u001a\u00020\u001cH\u0002J2\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001e2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020(02H\u0002J8\u00103\u001a\b\u0012\u0004\u0012\u0002040\u001e2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020(022\u0006\u0010)\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002000\u001eH\u0002JF\u00103\u001a\b\u0012\u0004\u0012\u0002040\u001e2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020(022\u0006\u0010)\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002000\u001e2\f\u00107\u001a\b\u0012\u0004\u0012\u00020(0\u001eH\u0002J.\u00108\u001a\b\u0012\u0004\u0012\u0002040\u001e2\u001e\u00109\u001a\u001a\u0012\u0004\u0012\u00020;\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020,0:0:H\u0007J\u0018\u0010<\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020.H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportService;", "Lcom/atlassian/jira/migration/preflight/reports/AbstractReportService;", "reportStatusRepository", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "serverCloudDataProvider", "Lcom/atlassian/jira/migration/duplicates/configOnly/ServerCloudDataProvider;", "reportOutput", "Lcom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportOutput;", "monitorService", "Lcom/atlassian/jira/migration/recon/service/MonitorService;", "reconFileOutput", "Lcom/atlassian/jira/migration/recon/ReconFileOutput;", "reconEventHandler", "Lcom/atlassian/jira/migration/analytics/ReconEventHandler;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/duplicates/configOnly/ServerCloudDataProvider;Lcom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportOutput;Lcom/atlassian/jira/migration/recon/service/MonitorService;Lcom/atlassian/jira/migration/recon/ReconFileOutput;Lcom/atlassian/jira/migration/analytics/ReconEventHandler;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "reportType", "Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "getReportType", "()Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "contextOf", "Lcom/atlassian/jira/migration/duplicates/configOnly/ConfigOnlyContext;", "cloudId", "", "projectKeys", "", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "createDuplicateEntitiesReport", "", "executionId", "currentUser", "deleteReportDataByExecutionId", "generateReportData", "getCloudEntities", "Lcom/atlassian/jira/migration/duplicates/configOnly/ConfigEntity;", "entityType", "Lcom/atlassian/jira/migration/duplicates/configOnly/EntityType;", "exportFilePath", "Ljava/nio/file/Path;", "getDuplicateEntityFileOutput", "Ljava/io/OutputStream;", "getServerEntities", "Lcom/atlassian/migration/base/IdentifiableEntity;", "comparer", "Lcom/atlassian/jira/migration/duplicates/configOnly/comparer/EntityComparer;", "identifyDuplicateEntities", "Lcom/atlassian/jira/migration/preflight/reports/DuplicateEntityRow;", "Lcom/atlassian/jira/migration/duplicates/configOnly/CloudEntityType;", "serverEntities", "cloudEntities", "parseReportData", "executionExportStore", "", "Lcom/atlassian/jira/migration/duplicates/configOnly/ConfigSource;", "writeReportToStream", "outputStream", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDuplicateEntitiesReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateEntitiesReportService.kt\ncom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1855#2:221\n1855#2,2:222\n1856#2:224\n766#2:225\n857#2,2:226\n1360#2:229\n1446#2,5:230\n1864#2,2:235\n1855#2,2:237\n1866#2:239\n1#3:228\n*S KotlinDebug\n*F\n+ 1 DuplicateEntitiesReportService.kt\ncom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportService\n*L\n73#1:221\n74#1:222,2\n73#1:224\n93#1:225\n93#1:226,2\n95#1:229\n95#1:230,5\n109#1:235,2\n110#1:237,2\n109#1:239\n*E\n"})
public final class DuplicateEntitiesReportService
extends AbstractReportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final ServerCloudDataProvider serverCloudDataProvider;
    @NotNull
    private final DuplicateEntitiesReportOutput reportOutput;
    @NotNull
    private final MonitorService monitorService;
    @NotNull
    private final ReconFileOutput reconFileOutput;
    @NotNull
    private final ReconEventHandler reconEventHandler;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ReportType reportType;
    @NotNull
    private static final Logger log;

    @Inject
    public DuplicateEntitiesReportService(@NotNull MigrationReportStatusRepository reportStatusRepository, @NotNull MigrationEventBus migrationEventBus, @NotNull DiscoveryService discoveryService, @NotNull ServerCloudDataProvider serverCloudDataProvider, @NotNull DuplicateEntitiesReportOutput reportOutput, @NotNull MonitorService monitorService, @NotNull ReconFileOutput reconFileOutput, @NotNull ReconEventHandler reconEventHandler, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)reportStatusRepository, (String)"reportStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)serverCloudDataProvider, (String)"serverCloudDataProvider");
        Intrinsics.checkNotNullParameter((Object)reportOutput, (String)"reportOutput");
        Intrinsics.checkNotNullParameter((Object)monitorService, (String)"monitorService");
        Intrinsics.checkNotNullParameter((Object)reconFileOutput, (String)"reconFileOutput");
        Intrinsics.checkNotNullParameter((Object)reconEventHandler, (String)"reconEventHandler");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        super(reportStatusRepository, migrationEventBus);
        this.discoveryService = discoveryService;
        this.serverCloudDataProvider = serverCloudDataProvider;
        this.reportOutput = reportOutput;
        this.monitorService = monitorService;
        this.reconFileOutput = reconFileOutput;
        this.reconEventHandler = reconEventHandler;
        this.migrationFeatures = migrationFeatures;
        this.reportType = ReportType.DUPLICATE_ENTITIES;
    }

    @Override
    @NotNull
    protected ReportType getReportType() {
        return this.reportType;
    }

    public final void generateReportData(@NotNull String executionId, @NotNull String cloudId2, @NotNull List<String> projectKeys, @NotNull ApplicationUser currentUser) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
            Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
            Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
            Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
            Object object2 = this;
            try {
                DuplicateEntitiesReportService $this$generateReportData_u24lambda_u240 = object2;
                boolean bl = false;
                ConfigOnlyContext context = $this$generateReportData_u24lambda_u240.contextOf(cloudId2, projectKeys, currentUser);
                ServerCloudDataProvider.exportData$default($this$generateReportData_u24lambda_u240.serverCloudDataProvider, executionId, context, false, 4, null);
                AbstractReportService.setReportGenerationCompleted$default($this$generateReportData_u24lambda_u240, executionId, null, 2, null);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            AbstractReportService.setReportGenerationFailed$default(this, executionId, (Throwable)it, null, 4, null);
        }
    }

    @Override
    public void writeReportToStream(@NotNull String executionId, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Map<ConfigSource, Map<EntityType, Path>> executionExportStore = this.serverCloudDataProvider.getExecutionStore(executionId);
        List<DuplicateEntityRow> duplicateEntityRows = this.parseReportData(executionExportStore);
        this.reportOutput.write(outputStream, duplicateEntityRows);
    }

    @VisibleForTesting
    @NotNull
    public final List<DuplicateEntityRow> parseReportData(@NotNull Map<ConfigSource, ? extends Map<EntityType, ? extends Path>> executionExportStore) {
        List duplicateEntityRows;
        block2: {
            Intrinsics.checkNotNullParameter(executionExportStore, (String)"executionExportStore");
            duplicateEntityRows = new ArrayList();
            Map<EntityType, ? extends Path> map = executionExportStore.get((Object)ConfigSource.Server);
            if (map == null || (map = map.entrySet()) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)((Object)map);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                EntityType serverEntityType = (EntityType)entry.getKey();
                Path serverExportFilePath = (Path)entry.getValue();
                Map<EntityType, ? extends Path> map2 = executionExportStore.get((Object)ConfigSource.Cloud);
                if (map2 == null || (map2 = map2.entrySet()) == null) continue;
                Iterable $this$forEach$iv2 = (Iterable)((Object)map2);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Map.Entry entry2 = (Map.Entry)element$iv2;
                    boolean bl2 = false;
                    EntityType cloudEntityType = (EntityType)entry2.getKey();
                    Path cloudExportFilePath = (Path)entry2.getValue();
                    Intrinsics.checkNotNull((Object)cloudEntityType, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.duplicates.configOnly.CloudEntityType");
                    EntityComparer<IdentifiableEntity, ConfigEntity> comparer = EntityComparer.Companion.getByEntityType((CloudEntityType)cloudEntityType, this.migrationFeatures);
                    List<IdentifiableEntity> serverEntities = this.getServerEntities(serverEntityType, serverExportFilePath, comparer);
                    List<ConfigEntity> cloudEntities = this.getCloudEntities(cloudEntityType, cloudExportFilePath);
                    duplicateEntityRows.addAll((Collection)this.identifyDuplicateEntities(comparer, (CloudEntityType)cloudEntityType, serverEntities, cloudEntities));
                    if (!comparer.isComparingServerEntities()) continue;
                    duplicateEntityRows.addAll((Collection)this.identifyDuplicateEntities(comparer, (CloudEntityType)cloudEntityType, serverEntities));
                }
            }
        }
        return duplicateEntityRows;
    }

    public final void deleteReportDataByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.serverCloudDataProvider.deleteData(executionId);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IdentifiableEntity> getServerEntities(EntityType entityType, Path exportFilePath, EntityComparer<? super IdentifiableEntity, ? super ConfigEntity> comparer) {
        List list;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List<?> list2 = this.serverCloudDataProvider.parseExportFile(entityType, exportFilePath);
        Intrinsics.checkNotNull(list2, (String)"null cannot be cast to non-null type kotlin.collections.List<com.atlassian.migration.base.IdentifiableEntity>");
        Iterable iterable = list2;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IdentifiableEntity it = (IdentifiableEntity)element$iv$iv;
            boolean bl = false;
            if (!comparer.isServerEntity(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entities = (List)destination$iv$iv;
        boolean bl = false;
        if (comparer.isContainer()) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = entities;
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ContainerEntity it = (ContainerEntity)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it.getElements();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = entities;
        }
        return list;
    }

    private final List<ConfigEntity> getCloudEntities(EntityType entityType, Path exportFilePath) {
        List<ConfigEntity> list = this.serverCloudDataProvider.parseExportFile(entityType, exportFilePath);
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<com.atlassian.jira.migration.duplicates.configOnly.ConfigEntity>");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DuplicateEntityRow> identifyDuplicateEntities(EntityComparer<? super IdentifiableEntity, ? super ConfigEntity> comparer, CloudEntityType entityType, List<? extends IdentifiableEntity> serverEntities) {
        List duplicateEntityRows = new ArrayList();
        Iterable $this$forEachIndexed$iv = serverEntities;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IdentifiableEntity identifiableEntity = (IdentifiableEntity)item$iv;
            int index1 = n;
            boolean bl = false;
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)serverEntities, (int)(index1 + 1));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void serverEntity1;
                IdentifiableEntity serverEntity2 = (IdentifiableEntity)element$iv;
                boolean bl2 = false;
                if (!comparer.equals((IdentifiableEntity)serverEntity1, (IdentifiableEntity)serverEntity2)) continue;
                duplicateEntityRows.add(new DuplicateEntityRow(entityType.name(), comparer.comparedProperties(serverEntity2), ComparisonType.SERVER_TO_SERVER, comparer.toComparable((ConfigEntity)serverEntity1), comparer.toComparable((ConfigEntity)serverEntity2)));
            }
        }
        return duplicateEntityRows;
    }

    private final List<DuplicateEntityRow> identifyDuplicateEntities(EntityComparer<? super IdentifiableEntity, ? super ConfigEntity> comparer, CloudEntityType entityType, List<? extends IdentifiableEntity> serverEntities, List<? extends ConfigEntity> cloudEntities) {
        List duplicateEntityRows = new ArrayList();
        for (IdentifiableEntity identifiableEntity : serverEntities) {
            for (ConfigEntity configEntity : cloudEntities) {
                if (!comparer.equals((IdentifiableEntity)identifiableEntity, (IdentifiableEntity)configEntity)) continue;
                duplicateEntityRows.add(new DuplicateEntityRow(entityType.name(), comparer.comparedProperties(configEntity), ComparisonType.SERVER_TO_CLOUD, comparer.toComparable((ConfigEntity)identifiableEntity), comparer.toComparable(configEntity)));
            }
        }
        return duplicateEntityRows;
    }

    private final ConfigOnlyContext contextOf(String cloudId2, List<String> projectKeys, ApplicationUser user) {
        CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(cloudId2);
        return new ConfigOnlyContext(cloudSite2, projectKeys, user);
    }

    public final void createDuplicateEntitiesReport(@NotNull String executionId, @NotNull String cloudId2, @NotNull List<String> projectKeys, @NotNull ApplicationUser currentUser) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
            Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
            Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
            Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
            this.reconEventHandler.sendReconEvent(new ReconEvent(cloudId2, executionId, ReconEvent.STATE.START_DUP_GEN.getValue(), ReconEvent.STATUS.CREATED.getValue(), null, 0L, 48, null));
            this.monitorService.generateCache(executionId, cloudId2);
            Object object2 = this;
            try {
                DuplicateEntitiesReportService $this$createDuplicateEntitiesReport_u24lambda_u249 = object2;
                boolean bl = false;
                ConfigOnlyContext context = $this$createDuplicateEntitiesReport_u24lambda_u249.contextOf(cloudId2, projectKeys, currentUser);
                $this$createDuplicateEntitiesReport_u24lambda_u249.serverCloudDataProvider.exportData(executionId, context, true);
                OutputStream outputStream = $this$createDuplicateEntitiesReport_u24lambda_u249.getDuplicateEntityFileOutput(executionId);
                $this$createDuplicateEntitiesReport_u24lambda_u249.writeReportToStream(executionId, outputStream);
                $this$createDuplicateEntitiesReport_u24lambda_u249.reconEventHandler.sendReconEvent(new ReconEvent(cloudId2, executionId, ReconEvent.STATE.START_DUP_GEN.getValue(), ReconEvent.STATUS.SUCCESS.getValue(), null, 0L, 48, null));
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            this.reconEventHandler.sendReconEvent(new ReconEvent(cloudId2, executionId, ReconEvent.STATE.START_DUP_GEN.getValue(), ReconEvent.STATUS.FAILURE.getValue(), null, 0L, 48, null));
            log.info("Failed to generate duplicate entities report for execution ID " + executionId, (Throwable)it);
        }
    }

    private final OutputStream getDuplicateEntityFileOutput(String executionId) {
        File file2 = this.reconFileOutput.createDuplicateEntityMappingFile(executionId);
        return new FileOutputStream(file2);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(DuplicateEntitiesReportService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

