/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.TableRecordsDeletedEvent;
import com.atlassian.jira.migration.events.TableRecordsInsertedEvent;
import com.atlassian.jira.migration.preflight.reports.ExpectedMigrationCounts;
import com.atlassian.jira.migration.preflight.reports.ExpectedMigrationCountsTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/ExpectedMigrationCountsRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "getMigrationEventBus", "()Lcom/atlassian/jira/migration/events/MigrationEventBus;", "deleteByExecutionId", "", "executionId", "", "findByExecutionId", "", "Lcom/atlassian/jira/migration/preflight/reports/ExpectedMigrationCounts;", "saveOrReplaceAll", "expectedMigrationCounts", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExpectedMigrationCountsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectedMigrationCountsRepository.kt\ncom/atlassian/jira/migration/preflight/reports/ExpectedMigrationCountsRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1855#2,2:132\n1549#2:134\n1620#2,3:135\n*S KotlinDebug\n*F\n+ 1 ExpectedMigrationCountsRepository.kt\ncom/atlassian/jira/migration/preflight/reports/ExpectedMigrationCountsRepository\n*L\n39#1:132,2\n65#1:134\n65#1:135,3\n*E\n"})
public final class ExpectedMigrationCountsRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private static final String ANALYTICS_TABLE_NAME = "expectedMigrationCounts";
    private static final Logger log = LoggerFactory.getLogger(ExpectedMigrationCountsRepository.class);

    @Inject
    public ExpectedMigrationCountsRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.databaseAccessor = databaseAccessor;
        this.migrationEventBus = migrationEventBus;
    }

    @NotNull
    public final MigrationEventBus getMigrationEventBus() {
        return this.migrationEventBus;
    }

    public final void saveOrReplaceAll(@NotNull String executionId, @NotNull List<ExpectedMigrationCounts> expectedMigrationCounts) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(expectedMigrationCounts, (String)ANALYTICS_TABLE_NAME);
        Ref.LongRef numberOfRecordsDeleted = new Ref.LongRef();
        Long numberOfRecordsInserted = (Long)this.databaseAccessor.run(arg_0 -> ExpectedMigrationCountsRepository.saveOrReplaceAll$lambda$2(numberOfRecordsDeleted, executionId, expectedMigrationCounts, arg_0), ExpectedMigrationCountsRepository::saveOrReplaceAll$lambda$3);
        this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsDeleted.element));
        Intrinsics.checkNotNull((Object)numberOfRecordsInserted);
        this.migrationEventBus.post(new TableRecordsInsertedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsInserted));
    }

    @NotNull
    public final List<ExpectedMigrationCounts> findByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object object = this.databaseAccessor.run(arg_0 -> ExpectedMigrationCountsRepository.findByExecutionId$lambda$4(executionId, arg_0), ExpectedMigrationCountsRepository::findByExecutionId$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    public final void deleteByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        try {
            Long numberOfRecordsDeleted = (Long)this.databaseAccessor.run(arg_0 -> ExpectedMigrationCountsRepository.deleteByExecutionId$lambda$6(executionId, arg_0), ExpectedMigrationCountsRepository::deleteByExecutionId$lambda$7);
            Intrinsics.checkNotNull((Object)numberOfRecordsDeleted);
            this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsDeleted));
        }
        catch (RuntimeException e) {
            log.error("Could not delete expected migration counts by executionId: " + executionId + '.', (Throwable)e);
        }
    }

    private static final Long saveOrReplaceAll$lambda$2(Ref.LongRef $numberOfRecordsDeleted, String $executionId, List $expectedMigrationCounts, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$numberOfRecordsDeleted, (String)"$numberOfRecordsDeleted");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)$expectedMigrationCounts, (String)"$expectedMigrationCounts");
        $numberOfRecordsDeleted.element = db.delete((RelationalPath)ExpectedMigrationCountsTable.INSTANCE).where((Predicate)ExpectedMigrationCountsTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
        if (!((Collection)$expectedMigrationCounts).isEmpty()) {
            SQLInsertClause sQLInsertClause;
            SQLInsertClause $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241 = sQLInsertClause = db.insert((RelationalPath)ExpectedMigrationCountsTable.INSTANCE);
            boolean bl = false;
            Iterable $this$forEach$iv = $expectedMigrationCounts;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExpectedMigrationCounts it = (ExpectedMigrationCounts)element$iv;
                boolean bl2 = false;
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)ExpectedMigrationCountsTable.INSTANCE.getEXECUTION_ID(), (Object)$executionId);
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)ExpectedMigrationCountsTable.INSTANCE.getPROJECT_KEY(), (Object)it.getProjectKey());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)ExpectedMigrationCountsTable.INSTANCE.getENTITY_TYPE(), (Object)it.getEntityType());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)ExpectedMigrationCountsTable.INSTANCE.getENTITY_TYPE_COUNT(), (Object)it.getEntityTypeCount());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.addBatch();
            }
            $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.execute();
        }
        return $expectedMigrationCounts.size();
    }

    private static final void saveOrReplaceAll$lambda$3() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List findByExecutionId$lambda$4(String $executionId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Object object = ExpectedMigrationCountsTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)ExpectedMigrationCountsTable.INSTANCE)).where((Predicate)ExpectedMigrationCountsTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = ExpectedMigrationCountsTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ExpectedMigrationCountsTable)((Object)object)).toExpectedMigrationCounts((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void findByExecutionId$lambda$5() {
    }

    private static final Long deleteByExecutionId$lambda$6(String $executionId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        return db.delete((RelationalPath)ExpectedMigrationCountsTable.INSTANCE).where((Predicate)ExpectedMigrationCountsTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
    }

    private static final void deleteByExecutionId$lambda$7() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/ExpectedMigrationCountsRepository$Companion;", "", "()V", "ANALYTICS_TABLE_NAME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

