/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.idMappings.IdMappingsHelper;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.platform.EnterpriseGatewayClient;
import com.atlassian.jira.migration.platform.GetIdMappingsResponse;
import com.atlassian.migration.api.ContainerToken;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0005\u001e\u001f !\"B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J \u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService;", "", "idMappingsHelper", "Lcom/atlassian/jira/migration/idMappings/IdMappingsHelper;", "enterpriseGatewayClient", "Lcom/atlassian/jira/migration/platform/EnterpriseGatewayClient;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "(Lcom/atlassian/jira/migration/idMappings/IdMappingsHelper;Lcom/atlassian/jira/migration/platform/EnterpriseGatewayClient;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/migration/MigrationRepository;)V", "downloadIDMappings", "Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$FetchIDMappingsResult;", "cloudSiteUrl", "", "invalidateCache", "", "getLastMigrationCompletedTimestamp", "Ljava/time/Instant;", "getOrCreateCsv", "Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$GetOrCreateCsvFileResult;", "migrationScopeId", "lastMigrationCompletedTimestamp", "populateCsvFile", "", "csvFilePath", "Ljava/nio/file/Path;", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "populateCsvFileAsync", "Companion", "FetchIDMappingsResult", "FetchIDMappingsStatus", "GetOrCreateCsvFileResult", "GetOrCreateCsvFileStatus", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFetchIDMappingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchIDMappingsService.kt\ncom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,289:1\n1855#2:290\n1856#2:293\n215#3,2:291\n1#4:294\n*S KotlinDebug\n*F\n+ 1 FetchIDMappingsService.kt\ncom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService\n*L\n91#1:290\n91#1:293\n104#1:291,2\n*E\n"})
public final class FetchIDMappingsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdMappingsHelper idMappingsHelper;
    @NotNull
    private final EnterpriseGatewayClient enterpriseGatewayClient;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final MigrationRepository migrationRepository;
    private static final Logger logger = LoggerFactory.getLogger(FetchIDMappingsService.class);
    public static final int ID_MAPPINGS_PAGE_SIZE = 5000;
    @NotNull
    public static final String ID_MAPPINGS_FILE_PREFIX = "id-mappings-";
    @NotNull
    public static final String ID_MAPPINGS_IN_PROGRESS_FILE_POSTFIX = "in-progress";
    @NotNull
    public static final String ID_MAPPINGS_COMPLETED_FILE_POSTFIX = "completed";
    @NotNull
    public static final String ENTITY_TYPE = "entityType";
    @NotNull
    public static final String SERVER_ID = "serverId";
    @NotNull
    public static final String CLOUD_ID = "cloudId";
    @NotNull
    private static final List<String> ID_MAPPINGS_ENTITY_TYPES;
    private static final ExecutorService executor;

    @Inject
    public FetchIDMappingsService(@NotNull IdMappingsHelper idMappingsHelper, @NotNull EnterpriseGatewayClient enterpriseGatewayClient, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull MigrationRepository migrationRepository) {
        Intrinsics.checkNotNullParameter((Object)idMappingsHelper, (String)"idMappingsHelper");
        Intrinsics.checkNotNullParameter((Object)enterpriseGatewayClient, (String)"enterpriseGatewayClient");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        this.idMappingsHelper = idMappingsHelper;
        this.enterpriseGatewayClient = enterpriseGatewayClient;
        this.localFileDataOutput = localFileDataOutput;
        this.migrationRepository = migrationRepository;
    }

    @NotNull
    public final FetchIDMappingsResult downloadIDMappings(@NotNull String cloudSiteUrl, boolean invalidateCache) {
        FetchIDMappingsResult fetchIDMappingsResult;
        ContainerToken containerToken;
        Intrinsics.checkNotNullParameter((Object)cloudSiteUrl, (String)"cloudSiteUrl");
        String string = this.idMappingsHelper.getMigrationScopeIdByCloudSiteUrl(cloudSiteUrl);
        if (string == null) {
            return new FetchIDMappingsResult(FetchIDMappingsStatus.MISSING_MIGRATION_SCOPE_ID, null);
        }
        String migrationScopeId2 = string;
        try {
            containerToken = ContainerToken.of((String)this.idMappingsHelper.getContainerTokenByMigrationScopeId(migrationScopeId2));
        }
        catch (Throwable e) {
            return new FetchIDMappingsResult(FetchIDMappingsStatus.CONTAINER_TOKEN_ERROR, null);
        }
        ContainerToken containerToken2 = containerToken;
        if (containerToken2 == null) {
            return new FetchIDMappingsResult(FetchIDMappingsStatus.CONTAINER_TOKEN_ERROR, null);
        }
        ContainerToken containerToken3 = containerToken2;
        Instant instant = this.getLastMigrationCompletedTimestamp();
        if (instant == null) {
            return new FetchIDMappingsResult(FetchIDMappingsStatus.MIGRATION_DOES_NOT_EXIST_ERROR, null);
        }
        Instant lastMigrationCompletedTimestamp = instant;
        GetOrCreateCsvFileResult csvGetOutcome = this.getOrCreateCsv(migrationScopeId2, lastMigrationCompletedTimestamp, invalidateCache);
        switch (WhenMappings.$EnumSwitchMapping$0[csvGetOutcome.getStatus().ordinal()]) {
            case 1: {
                fetchIDMappingsResult = new FetchIDMappingsResult(FetchIDMappingsStatus.CSV_FILE_ERROR, null);
                break;
            }
            case 2: {
                fetchIDMappingsResult = new FetchIDMappingsResult(FetchIDMappingsStatus.FILE_PRESENT, csvGetOutcome.getFilePath());
                break;
            }
            case 3: {
                fetchIDMappingsResult = new FetchIDMappingsResult(FetchIDMappingsStatus.ACCEPTED, csvGetOutcome.getFilePath());
                break;
            }
            case 4: {
                Path path = csvGetOutcome.getFilePath();
                Intrinsics.checkNotNull((Object)path);
                this.populateCsvFileAsync(path, containerToken3, migrationScopeId2);
                fetchIDMappingsResult = new FetchIDMappingsResult(FetchIDMappingsStatus.ACCEPTED, csvGetOutcome.getFilePath());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fetchIDMappingsResult;
    }

    private final Instant getLastMigrationCompletedTimestamp() {
        Migration migration = this.migrationRepository.findLatestCompletedMigration();
        return migration != null ? migration.getUpdated() : null;
    }

    private final void populateCsvFileAsync(Path csvFilePath, ContainerToken containerToken, String migrationScopeId2) {
        executor.submit(() -> FetchIDMappingsService.populateCsvFileAsync$lambda$0(migrationScopeId2, this, csvFilePath, containerToken));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void populateCsvFile(Path csvFilePath, ContainerToken containerToken, String migrationScopeId2) {
        Path path = csvFilePath;
        FileWriter fileWriter = new FileWriter(path != null ? ((Object)path).toString() : null);
        CsvListWriter csvWriter = new CsvListWriter((Writer)fileWriter, CsvPreference.EXCEL_PREFERENCE);
        String[] stringArray = new String[]{ENTITY_TYPE, SERVER_ID, CLOUD_ID};
        csvWriter.writeHeader(stringArray);
        try {
            Iterable $this$forEach$iv = ID_MAPPINGS_ENTITY_TYPES;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String entityType = (String)element$iv;
                boolean bl = false;
                logger.info("Starting to write id-mappings for entityType: " + entityType + " ,migrationScopeId: " + migrationScopeId2);
                boolean hasNext = true;
                String lastEntity = null;
                while (hasNext) {
                    GetIdMappingsResponse idMappingsResponse = this.enterpriseGatewayClient.getIdMappings(containerToken, migrationScopeId2, entityType, lastEntity, 5000);
                    Map<String, String> $this$forEach$iv2 = idMappingsResponse.getItems();
                    boolean $i$f$forEach2 = false;
                    Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, String> element$iv2;
                        Map.Entry<String, String> it = element$iv2 = iterator2.next();
                        boolean bl2 = false;
                        String[] stringArray2 = new String[]{entityType, it.getKey(), it.getValue()};
                        csvWriter.write(stringArray2);
                    }
                    lastEntity = idMappingsResponse.getMeta().getLastEntity();
                    hasNext = idMappingsResponse.getMeta().getHasNext();
                }
                logger.info("Finished writing id-mappings for entityType: " + entityType + " ,migrationScopeId: " + migrationScopeId2);
            }
        }
        catch (Throwable e) {
            logger.error("Unexpected exception while populating ID mappings CSV file ", e);
            return;
        }
        finally {
            csvWriter.close();
            fileWriter.close();
        }
        try {
            CopyOption[] e = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(csvFilePath, csvFilePath.getParent().resolve("id-mappings--" + migrationScopeId2 + "-completed.csv"), e);
        }
        catch (Throwable e) {
            logger.error("Unexpected exception while copying ID mappings CSV file ", e);
        }
    }

    private final GetOrCreateCsvFileResult getOrCreateCsv(String migrationScopeId2, Instant lastMigrationCompletedTimestamp, boolean invalidateCache) {
        try {
            Instant idMappingsFetchStartTime;
            Path p0;
            Path path;
            Path dir = this.localFileDataOutput.idMappingResultsDirectory(migrationScopeId2);
            boolean bl = false;
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            Path inProgressFilePath = dir.resolve("id-mappings--" + migrationScopeId2 + "-in-progress.csv");
            Path completedFilePath = dir.resolve("id-mappings--" + migrationScopeId2 + "-completed.csv");
            if (invalidateCache) {
                p0 = path = completedFilePath;
                boolean bl2 = false;
                Files.deleteIfExists(p0);
                p0 = path = inProgressFilePath;
                boolean bl3 = false;
                Files.deleteIfExists(p0);
            }
            if (!Files.exists(inProgressFilePath, new LinkOption[0])) {
                p0 = path = completedFilePath;
                boolean bl4 = false;
                Files.deleteIfExists(p0);
                p0 = path = inProgressFilePath;
                GetOrCreateCsvFileStatus getOrCreateCsvFileStatus = GetOrCreateCsvFileStatus.FILE_CREATED;
                boolean bl5 = false;
                Files.deleteIfExists(p0);
                p0 = path;
                boolean bl6 = false;
                p0 = Files.createFile(p0, new FileAttribute[0]);
                boolean bl7 = false;
                Path path2 = p0.toFile().toPath();
                GetOrCreateCsvFileStatus getOrCreateCsvFileStatus2 = getOrCreateCsvFileStatus;
                return new GetOrCreateCsvFileResult(getOrCreateCsvFileStatus2, path2);
            }
            BasicFileAttributes basicFileAttributes = Files.readAttributes(inProgressFilePath, BasicFileAttributes.class, new LinkOption[0]);
            Instant instant = idMappingsFetchStartTime = basicFileAttributes.creationTime().toInstant();
            boolean bl8 = instant != null ? instant.isBefore(lastMigrationCompletedTimestamp) : false;
            if (bl8) {
                Path path3;
                Path p02 = path3 = completedFilePath;
                boolean bl9 = false;
                Files.deleteIfExists(p02);
                p02 = path3 = inProgressFilePath;
                GetOrCreateCsvFileStatus getOrCreateCsvFileStatus = GetOrCreateCsvFileStatus.FILE_CREATED;
                boolean bl10 = false;
                Files.deleteIfExists(p02);
                p02 = path3;
                boolean bl11 = false;
                p02 = Files.createFile(p02, new FileAttribute[0]);
                boolean bl12 = false;
                Path path4 = p02.toFile().toPath();
                GetOrCreateCsvFileStatus getOrCreateCsvFileStatus3 = getOrCreateCsvFileStatus;
                return new GetOrCreateCsvFileResult(getOrCreateCsvFileStatus3, path4);
            }
            if (Files.exists(completedFilePath, new LinkOption[0])) {
                Path p03 = completedFilePath;
                GetOrCreateCsvFileStatus getOrCreateCsvFileStatus = GetOrCreateCsvFileStatus.COMPLETED_FILE_PRESENT;
                boolean bl13 = false;
                Path path5 = p03.toFile().toPath();
                GetOrCreateCsvFileStatus getOrCreateCsvFileStatus4 = getOrCreateCsvFileStatus;
                return new GetOrCreateCsvFileResult(getOrCreateCsvFileStatus4, path5);
            }
            return new GetOrCreateCsvFileResult(GetOrCreateCsvFileStatus.ID_MAPPINGS_FETCH_IN_PROGRESS, null);
        }
        catch (Throwable e) {
            return new GetOrCreateCsvFileResult(GetOrCreateCsvFileStatus.FILE_CREATE_OR_GET_ERROR, null);
        }
    }

    private static final void populateCsvFileAsync$lambda$0(String $migrationScopeId, FetchIDMappingsService this$0, Path $csvFilePath, ContainerToken $containerToken) {
        Intrinsics.checkNotNullParameter((Object)$migrationScopeId, (String)"$migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$csvFilePath, (String)"$csvFilePath");
        Intrinsics.checkNotNullParameter((Object)$containerToken, (String)"$containerToken");
        Instant startTime = Instant.now();
        logger.info("Starting to write id-mappings for migrationScopeId: " + $migrationScopeId);
        this$0.populateCsvFile($csvFilePath, $containerToken, $migrationScopeId);
        Instant endTime = Instant.now();
        logger.info("Total time to write id-mappings = " + Duration.between(startTime, endTime).toMinutes() + " minutes");
    }

    static {
        Object[] objectArray = new String[]{"jira/classic:issueType", "jira:issueLinkType", "jira:projectVersion", "jira:issue", "jira/classic/software:rapidView", "jira/classic:project", "jira:projectCategory", "jira:priorityScheme", "jira/classic:screen", "jira/classic:issueStatusList", "jira/classic:issueSecurityLevel", "jira:projectRole", "jira/classic:workflow", "jira:resolutionList", "jira/classic:customFieldOptionList", "jira/classic:customFieldOption", "jira/classic:customField", "jira/classic:workLog", "jira:portalPage", "jira:portletConfiguration", "jira:filter", "jira:priorityList", "jira:projectComponent", "jira/classic/software:sprint", "jira:issueLink", "jira:remoteLink", "jira/servicedesk:requestType", "jira/servicedesk:customerOrganization", "jira:comment", "jira:fileAttachment", "jira:mailServer", "jira:serviceConfig", "jira/classic/software:customFilter", "jira/classic/software:userSwimlaneConfig", "jira/servicedesk:servicedesk"};
        ID_MAPPINGS_ENTITY_TYPES = CollectionsKt.listOf((Object[])objectArray);
        executor = Executors.newFixedThreadPool(1, new GroupedThreadFactory("FetchIDMappingsService"));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$Companion;", "", "()V", "CLOUD_ID", "", "ENTITY_TYPE", "ID_MAPPINGS_COMPLETED_FILE_POSTFIX", "ID_MAPPINGS_ENTITY_TYPES", "", "ID_MAPPINGS_FILE_PREFIX", "ID_MAPPINGS_IN_PROGRESS_FILE_POSTFIX", "ID_MAPPINGS_PAGE_SIZE", "", "SERVER_ID", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public final ExecutorService getExecutor() {
            return executor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$FetchIDMappingsResult;", "", "fetchIDMappingsStatus", "Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$FetchIDMappingsStatus;", "filePath", "Ljava/nio/file/Path;", "(Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$FetchIDMappingsStatus;Ljava/nio/file/Path;)V", "getFetchIDMappingsStatus", "()Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$FetchIDMappingsStatus;", "getFilePath", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class FetchIDMappingsResult {
        @NotNull
        private final FetchIDMappingsStatus fetchIDMappingsStatus;
        @Nullable
        private final Path filePath;

        public FetchIDMappingsResult(@NotNull FetchIDMappingsStatus fetchIDMappingsStatus, @Nullable Path filePath) {
            Intrinsics.checkNotNullParameter((Object)((Object)fetchIDMappingsStatus), (String)"fetchIDMappingsStatus");
            this.fetchIDMappingsStatus = fetchIDMappingsStatus;
            this.filePath = filePath;
        }

        @NotNull
        public final FetchIDMappingsStatus getFetchIDMappingsStatus() {
            return this.fetchIDMappingsStatus;
        }

        @Nullable
        public final Path getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final FetchIDMappingsStatus component1() {
            return this.fetchIDMappingsStatus;
        }

        @Nullable
        public final Path component2() {
            return this.filePath;
        }

        @NotNull
        public final FetchIDMappingsResult copy(@NotNull FetchIDMappingsStatus fetchIDMappingsStatus, @Nullable Path filePath) {
            Intrinsics.checkNotNullParameter((Object)((Object)fetchIDMappingsStatus), (String)"fetchIDMappingsStatus");
            return new FetchIDMappingsResult(fetchIDMappingsStatus, filePath);
        }

        public static /* synthetic */ FetchIDMappingsResult copy$default(FetchIDMappingsResult fetchIDMappingsResult, FetchIDMappingsStatus fetchIDMappingsStatus, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                fetchIDMappingsStatus = fetchIDMappingsResult.fetchIDMappingsStatus;
            }
            if ((n & 2) != 0) {
                path = fetchIDMappingsResult.filePath;
            }
            return fetchIDMappingsResult.copy(fetchIDMappingsStatus, path);
        }

        @NotNull
        public String toString() {
            return "FetchIDMappingsResult(fetchIDMappingsStatus=" + (Object)((Object)this.fetchIDMappingsStatus) + ", filePath=" + this.filePath + ')';
        }

        public int hashCode() {
            int result2 = this.fetchIDMappingsStatus.hashCode();
            result2 = result2 * 31 + (this.filePath == null ? 0 : ((Object)this.filePath).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FetchIDMappingsResult)) {
                return false;
            }
            FetchIDMappingsResult fetchIDMappingsResult = (FetchIDMappingsResult)other;
            if (this.fetchIDMappingsStatus != fetchIDMappingsResult.fetchIDMappingsStatus) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.filePath, (Object)fetchIDMappingsResult.filePath);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$FetchIDMappingsStatus;", "", "(Ljava/lang/String;I)V", "ACCEPTED", "FILE_PRESENT", "MISSING_MIGRATION_SCOPE_ID", "CONTAINER_TOKEN_ERROR", "MIGRATION_DOES_NOT_EXIST_ERROR", "CSV_FILE_ERROR", "jira-migration-plugin"})
    public static final class FetchIDMappingsStatus
    extends Enum<FetchIDMappingsStatus> {
        public static final /* enum */ FetchIDMappingsStatus ACCEPTED = new FetchIDMappingsStatus();
        public static final /* enum */ FetchIDMappingsStatus FILE_PRESENT = new FetchIDMappingsStatus();
        public static final /* enum */ FetchIDMappingsStatus MISSING_MIGRATION_SCOPE_ID = new FetchIDMappingsStatus();
        public static final /* enum */ FetchIDMappingsStatus CONTAINER_TOKEN_ERROR = new FetchIDMappingsStatus();
        public static final /* enum */ FetchIDMappingsStatus MIGRATION_DOES_NOT_EXIST_ERROR = new FetchIDMappingsStatus();
        public static final /* enum */ FetchIDMappingsStatus CSV_FILE_ERROR = new FetchIDMappingsStatus();
        private static final /* synthetic */ FetchIDMappingsStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FetchIDMappingsStatus[] values() {
            return (FetchIDMappingsStatus[])$VALUES.clone();
        }

        public static FetchIDMappingsStatus valueOf(String value) {
            return Enum.valueOf(FetchIDMappingsStatus.class, value);
        }

        @NotNull
        public static EnumEntries<FetchIDMappingsStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fetchIDMappingsStatusArray = new FetchIDMappingsStatus[]{FetchIDMappingsStatus.ACCEPTED, FetchIDMappingsStatus.FILE_PRESENT, FetchIDMappingsStatus.MISSING_MIGRATION_SCOPE_ID, FetchIDMappingsStatus.CONTAINER_TOKEN_ERROR, FetchIDMappingsStatus.MIGRATION_DOES_NOT_EXIST_ERROR, FetchIDMappingsStatus.CSV_FILE_ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$GetOrCreateCsvFileResult;", "", "status", "Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$GetOrCreateCsvFileStatus;", "filePath", "Ljava/nio/file/Path;", "(Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$GetOrCreateCsvFileStatus;Ljava/nio/file/Path;)V", "getFilePath", "()Ljava/nio/file/Path;", "getStatus", "()Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$GetOrCreateCsvFileStatus;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class GetOrCreateCsvFileResult {
        @NotNull
        private final GetOrCreateCsvFileStatus status;
        @Nullable
        private final Path filePath;

        public GetOrCreateCsvFileResult(@NotNull GetOrCreateCsvFileStatus status, @Nullable Path filePath) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.status = status;
            this.filePath = filePath;
        }

        @NotNull
        public final GetOrCreateCsvFileStatus getStatus() {
            return this.status;
        }

        @Nullable
        public final Path getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final GetOrCreateCsvFileStatus component1() {
            return this.status;
        }

        @Nullable
        public final Path component2() {
            return this.filePath;
        }

        @NotNull
        public final GetOrCreateCsvFileResult copy(@NotNull GetOrCreateCsvFileStatus status, @Nullable Path filePath) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return new GetOrCreateCsvFileResult(status, filePath);
        }

        public static /* synthetic */ GetOrCreateCsvFileResult copy$default(GetOrCreateCsvFileResult getOrCreateCsvFileResult, GetOrCreateCsvFileStatus getOrCreateCsvFileStatus, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                getOrCreateCsvFileStatus = getOrCreateCsvFileResult.status;
            }
            if ((n & 2) != 0) {
                path = getOrCreateCsvFileResult.filePath;
            }
            return getOrCreateCsvFileResult.copy(getOrCreateCsvFileStatus, path);
        }

        @NotNull
        public String toString() {
            return "GetOrCreateCsvFileResult(status=" + (Object)((Object)this.status) + ", filePath=" + this.filePath + ')';
        }

        public int hashCode() {
            int result2 = this.status.hashCode();
            result2 = result2 * 31 + (this.filePath == null ? 0 : ((Object)this.filePath).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GetOrCreateCsvFileResult)) {
                return false;
            }
            GetOrCreateCsvFileResult getOrCreateCsvFileResult = (GetOrCreateCsvFileResult)other;
            if (this.status != getOrCreateCsvFileResult.status) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.filePath, (Object)getOrCreateCsvFileResult.filePath);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService$GetOrCreateCsvFileStatus;", "", "(Ljava/lang/String;I)V", "COMPLETED_FILE_PRESENT", "ID_MAPPINGS_FETCH_IN_PROGRESS", "FILE_CREATED", "FILE_CREATE_OR_GET_ERROR", "jira-migration-plugin"})
    public static final class GetOrCreateCsvFileStatus
    extends Enum<GetOrCreateCsvFileStatus> {
        public static final /* enum */ GetOrCreateCsvFileStatus COMPLETED_FILE_PRESENT = new GetOrCreateCsvFileStatus();
        public static final /* enum */ GetOrCreateCsvFileStatus ID_MAPPINGS_FETCH_IN_PROGRESS = new GetOrCreateCsvFileStatus();
        public static final /* enum */ GetOrCreateCsvFileStatus FILE_CREATED = new GetOrCreateCsvFileStatus();
        public static final /* enum */ GetOrCreateCsvFileStatus FILE_CREATE_OR_GET_ERROR = new GetOrCreateCsvFileStatus();
        private static final /* synthetic */ GetOrCreateCsvFileStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static GetOrCreateCsvFileStatus[] values() {
            return (GetOrCreateCsvFileStatus[])$VALUES.clone();
        }

        public static GetOrCreateCsvFileStatus valueOf(String value) {
            return Enum.valueOf(GetOrCreateCsvFileStatus.class, value);
        }

        @NotNull
        public static EnumEntries<GetOrCreateCsvFileStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = getOrCreateCsvFileStatusArray = new GetOrCreateCsvFileStatus[]{GetOrCreateCsvFileStatus.COMPLETED_FILE_PRESENT, GetOrCreateCsvFileStatus.ID_MAPPINGS_FETCH_IN_PROGRESS, GetOrCreateCsvFileStatus.FILE_CREATED, GetOrCreateCsvFileStatus.FILE_CREATE_OR_GET_ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GetOrCreateCsvFileStatus.values().length];
            try {
                nArray[GetOrCreateCsvFileStatus.FILE_CREATE_OR_GET_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetOrCreateCsvFileStatus.COMPLETED_FILE_PRESENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetOrCreateCsvFileStatus.ID_MAPPINGS_FETCH_IN_PROGRESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetOrCreateCsvFileStatus.FILE_CREATED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

