/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.PlatformUploadServiceInterface;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.MigrationScopeId;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\fJ \u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eJ2\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/preflight/reports/McsReportService;", "", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "gatherContainerTokenToSendPostReport", "", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getMigrationPostReportDirectory", "Ljava/nio/file/Path;", "executionId", "getMigrationPreReportDirectory", "preparePostReport", "Ljava/io/File;", "preparePreReport", "sendPostReportIntoMCS", "migrationId", "postReportZip", "sendPreReportIntoMCS", "preflightId", "Lcom/atlassian/migration/api/MigrationId;", "containerToken", "migrationScopeId", "preReportZipFile", "Companion", "jira-migration-plugin"})
public final class McsReportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final Logger logger = Logger.getLogger(McsReportService.class);
    @NotNull
    private static final String FILENAME_PRE_REPORT = "Pre-MigrationReports_";
    @NotNull
    private static final String FILENAME_POST_REPORT = "Post-MigrationReports_";
    @NotNull
    private static final String FILETYPE = ".zip";

    @Inject
    public McsReportService(@NotNull PlatformService platformService, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull DiscoveryService discoveryService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.platformService = platformService;
        this.localFileDataOutput = localFileDataOutput;
        this.discoveryService = discoveryService;
        this.migrationFeatures = migrationFeatures;
    }

    @Nullable
    public final File preparePreReport(@NotNull String executionId) {
        Object object;
        Object $this$preparePreReport_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object object2 = this;
        try {
            $this$preparePreReport_u24lambda_u240 = object2;
            boolean bl = false;
            Path migrationLogDir = super.getMigrationPreReportDirectory(executionId);
            Files.createDirectories(migrationLogDir, new FileAttribute[0]);
            Path preReportZipPath = migrationLogDir.resolve("pre-migration-report.zip");
            $this$preparePreReport_u24lambda_u240 = Result.constructor-impl((Object)preReportZipPath.toFile());
        }
        catch (Throwable bl) {
            $this$preparePreReport_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$preparePreReport_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable error = throwable;
            boolean bl = false;
            logger.error((Object)"Encountered failure during generation or upload of pre reports zip file during preflight checks run", error);
            object = null;
        }
        return (File)object;
    }

    @Nullable
    public final String sendPreReportIntoMCS(@NotNull String executionId, @Nullable MigrationId preflightId, @NotNull String containerToken, @NotNull String migrationScopeId2, @NotNull File preReportZipFile) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)preReportZipFile, (String)"preReportZipFile");
        Object object = this;
        try {
            McsReportService $this$sendPreReportIntoMCS_u24lambda_u242 = object;
            boolean bl = false;
            Path migrationLogDir = $this$sendPreReportIntoMCS_u24lambda_u242.getMigrationPreReportDirectory(executionId);
            Instant time = Instant.now();
            ContainerToken ctxContainerToken = new ContainerToken(containerToken);
            MigrationScopeId ctxMigrationScopeId = new MigrationScopeId(migrationScopeId2);
            String fileId = preflightId != null && $this$sendPreReportIntoMCS_u24lambda_u242.migrationFeatures.getEnablePreMigrationReportUpload() ? PlatformUploadServiceInterface.DefaultImpls.uploadMultiPart$default($this$sendPreReportIntoMCS_u24lambda_u242.platformService, ctxContainerToken, preflightId, FILENAME_PRE_REPORT + time + FILETYPE, "pre-migration-reports", preReportZipFile, 0, null, 96, null) : PlatformUploadServiceInterface.DefaultImpls.uploadMultiPartFileByMigrationScopeId$default($this$sendPreReportIntoMCS_u24lambda_u242.platformService, ctxContainerToken, ctxMigrationScopeId, FILENAME_PRE_REPORT + time + FILETYPE, "pre-migration-reports", preReportZipFile, null, 32, null);
            $this$sendPreReportIntoMCS_u24lambda_u242.localFileDataOutput.deleteDirectoryIfExists(migrationLogDir);
            return fileId;
        }
        catch (Throwable bl) {
            block2: {
                Throwable throwable;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
                if (throwable2 == null) break block2;
                Throwable error = throwable = throwable2;
                boolean bl2 = false;
                logger.error((Object)"Encountered failure during generation or upload of pre reports zip file during preflight checks run", error);
            }
            return null;
        }
    }

    @Nullable
    public final File preparePostReport(@NotNull String executionId) {
        Object object;
        Object $this$preparePostReport_u24lambda_u244;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object object2 = this;
        try {
            $this$preparePostReport_u24lambda_u244 = object2;
            boolean bl = false;
            Path migrationLogDir = super.getMigrationPostReportDirectory(executionId);
            Files.createDirectories(migrationLogDir, new FileAttribute[0]);
            Path postReportZip = migrationLogDir.resolve("post-migration-report.zip");
            $this$preparePostReport_u24lambda_u244 = Result.constructor-impl((Object)postReportZip.toFile());
        }
        catch (Throwable bl) {
            $this$preparePostReport_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$preparePostReport_u24lambda_u244;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            logger.error((Object)"An error occurred during resolving directory of post migration report", it);
            object = null;
        }
        return (File)object;
    }

    @Nullable
    public final String sendPostReportIntoMCS(@NotNull String migrationId, @NotNull File postReportZip, @NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)postReportZip, (String)"postReportZip");
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Object object = this;
        try {
            String string;
            McsReportService $this$sendPostReportIntoMCS_u24lambda_u247 = object;
            boolean bl = false;
            String executionId = plan2.getPreflightCheckExecutionId();
            Path migrationLogDir = $this$sendPostReportIntoMCS_u24lambda_u247.getMigrationPostReportDirectory(executionId);
            String containerToken = $this$sendPostReportIntoMCS_u24lambda_u247.gatherContainerTokenToSendPostReport(plan2);
            Instant time = Instant.now();
            ContainerToken finishedMigrationContainerToken = new ContainerToken(containerToken);
            MigrationId finishedMigrationMigrationId = new MigrationId(migrationId);
            String it = string = PlatformUploadServiceInterface.DefaultImpls.uploadMultiPart$default($this$sendPostReportIntoMCS_u24lambda_u247.platformService, finishedMigrationContainerToken, finishedMigrationMigrationId, FILENAME_POST_REPORT + time + FILETYPE, "post-migration-reports", postReportZip, 0, null, 96, null);
            boolean bl2 = false;
            LocalFileDataOutput.deleteHandlingExceptions$default($this$sendPostReportIntoMCS_u24lambda_u247.localFileDataOutput, migrationLogDir, null, 2, null);
            return string;
        }
        catch (Throwable bl) {
            block2: {
                Object object2;
                object = object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable == null) break block2;
                Object it = object2 = throwable;
                boolean bl3 = false;
                logger.error((Object)"An error occurred during sending post logs into MCS", (Throwable)it);
            }
            return null;
        }
    }

    private final String gatherContainerTokenToSendPostReport(Plan plan2) {
        CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(plan2.getCloudId());
        Intrinsics.checkNotNull((Object)cloudSite2);
        CloudSite cloudSite3 = cloudSite2;
        return cloudSite3.getContainerToken();
    }

    private final Path getMigrationPostReportDirectory(String executionId) {
        return this.localFileDataOutput.migrationPostReportDirectory(executionId);
    }

    private final Path getMigrationPreReportDirectory(String executionId) {
        return this.localFileDataOutput.migrationPreReportDirectory(executionId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/McsReportService$Companion;", "", "()V", "FILENAME_POST_REPORT", "", "FILENAME_PRE_REPORT", "FILETYPE", "logger", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

