/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.SinglePathMode;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/MigrationReportFeatureFlagEvaluator;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "isIncrementalMigrationOrLiftNShift", "", "migrationType", "Lcom/atlassian/jira/migration/plan/MigrationType;", "singlePathMode", "Lcom/atlassian/jira/migration/plan/SinglePathMode;", "isPostMigrationReportEnabled", "isPreMigrationReportEnabled", "validateMigrationTypeAndFeatureFlag", "", "jira-migration-plugin"})
public final class MigrationReportFeatureFlagEvaluator {
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public MigrationReportFeatureFlagEvaluator(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationFeatures = migrationFeatures;
    }

    public final boolean isPreMigrationReportEnabled(@NotNull MigrationType migrationType, @Nullable SinglePathMode singlePathMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)migrationType), (String)"migrationType");
        this.validateMigrationTypeAndFeatureFlag(migrationType, singlePathMode);
        boolean reportDisabled = this.isIncrementalMigrationOrLiftNShift(migrationType, singlePathMode);
        return reportDisabled ? false : !this.migrationFeatures.getSkipPreflightReport();
    }

    public final boolean isPostMigrationReportEnabled(@NotNull MigrationType migrationType, @Nullable SinglePathMode singlePathMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)migrationType), (String)"migrationType");
        this.validateMigrationTypeAndFeatureFlag(migrationType, singlePathMode);
        boolean reportDisabled = this.isIncrementalMigrationOrLiftNShift(migrationType, singlePathMode);
        return reportDisabled ? false : !this.migrationFeatures.getSkipPreflightReport();
    }

    private final void validateMigrationTypeAndFeatureFlag(MigrationType migrationType, SinglePathMode singlePathMode) {
        if (!this.migrationFeatures.getEnableIncrementalMigrations() && migrationType == MigrationType.INCREMENTAL) {
            throw new IllegalArgumentException("Migration type can not be set to INCREMENTAL when incremental migration dark feature flag is off.");
        }
        if (this.migrationFeatures.getDisableSinglePathMigration() && singlePathMode == SinglePathMode.LIFT_AND_SHIFT) {
            throw new IllegalArgumentException("Migration mode can not be set to LIFT_AND_SHIFT when disable single path migration dark feature flag is on.");
        }
    }

    private final boolean isIncrementalMigrationOrLiftNShift(MigrationType migrationType, SinglePathMode singlePathMode) {
        return this.migrationFeatures.getEnableIncrementalMigrations() && migrationType == MigrationType.INCREMENTAL || !this.migrationFeatures.getDisableSinglePathMigration() && singlePathMode == SinglePathMode.LIFT_AND_SHIFT;
    }
}

