/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.TableRecordsDeletedEvent;
import com.atlassian.jira.migration.events.TableRecordsInsertedEvent;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatus;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatusTable;
import com.atlassian.jira.migration.preflight.reports.ReportType;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\fJ\u001c\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "deleteByExecutionId", "", "executionId", "", "findByExecutionIdAndReportType", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatus;", "reportType", "Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "findPostMigrationByExecutionId", "", "findPreMigrationByExecutionId", "saveOrReplace", "migrationReportStatus", "saveOrReplaceAll", "migrationReportStatuses", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationReportStatusRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationReportStatusRepository.kt\ncom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1549#2:216\n1620#2,3:217\n1549#2:220\n1620#2,3:221\n1549#2:224\n1620#2,3:225\n1855#2,2:228\n*S KotlinDebug\n*F\n+ 1 MigrationReportStatusRepository.kt\ncom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository\n*L\n43#1:216\n43#1:217,3\n62#1:220\n62#1:221,3\n78#1:224\n78#1:225,3\n125#1:228,2\n*E\n"})
public final class MigrationReportStatusRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private static final Logger log = LoggerFactory.getLogger(MigrationReportStatusRepository.class);
    @NotNull
    private static final String ANALYTICS_TABLE_NAME = "migrationReportStatus";

    @Inject
    public MigrationReportStatusRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.databaseAccessor = databaseAccessor;
        this.migrationEventBus = migrationEventBus;
    }

    @Nullable
    public final MigrationReportStatus findByExecutionIdAndReportType(@NotNull String executionId, @NotNull ReportType reportType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)reportType), (String)"reportType");
        return (MigrationReportStatus)this.databaseAccessor.run(arg_0 -> MigrationReportStatusRepository.findByExecutionIdAndReportType$lambda$0(executionId, reportType, arg_0), MigrationReportStatusRepository::findByExecutionIdAndReportType$lambda$1);
    }

    @NotNull
    public final List<MigrationReportStatus> findPreMigrationByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object object = this.databaseAccessor.run(arg_0 -> MigrationReportStatusRepository.findPreMigrationByExecutionId$lambda$3(executionId, arg_0), MigrationReportStatusRepository::findPreMigrationByExecutionId$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    @NotNull
    public final List<MigrationReportStatus> findPostMigrationByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object object = this.databaseAccessor.run(arg_0 -> MigrationReportStatusRepository.findPostMigrationByExecutionId$lambda$6(executionId, arg_0), MigrationReportStatusRepository::findPostMigrationByExecutionId$lambda$7);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    public final void saveOrReplace(@NotNull MigrationReportStatus migrationReportStatus) {
        Intrinsics.checkNotNullParameter((Object)migrationReportStatus, (String)"migrationReportStatus");
        Pair pair = (Pair)this.databaseAccessor.run(arg_0 -> MigrationReportStatusRepository.saveOrReplace$lambda$8(migrationReportStatus, arg_0), MigrationReportStatusRepository::saveOrReplace$lambda$9);
        long numberOfRecordsDeleted = ((Number)pair.component1()).longValue();
        long numberOfRecordsInserted = ((Number)pair.component2()).longValue();
        this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, migrationReportStatus.getExecutionId(), numberOfRecordsDeleted));
        this.migrationEventBus.post(new TableRecordsInsertedEvent(ANALYTICS_TABLE_NAME, migrationReportStatus.getExecutionId(), numberOfRecordsInserted));
    }

    public final void saveOrReplaceAll(@NotNull String executionId, @NotNull List<MigrationReportStatus> migrationReportStatuses) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(migrationReportStatuses, (String)"migrationReportStatuses");
        try {
            Pair pair = (Pair)this.databaseAccessor.run(arg_0 -> MigrationReportStatusRepository.saveOrReplaceAll$lambda$12(executionId, migrationReportStatuses, arg_0), MigrationReportStatusRepository::saveOrReplaceAll$lambda$13);
            long numberOfRecordsDeleted = ((Number)pair.component1()).longValue();
            long numberOfRecordsInserted = ((Number)pair.component2()).longValue();
            this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsDeleted));
            this.migrationEventBus.post(new TableRecordsInsertedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsInserted));
        }
        catch (RuntimeException e) {
            log.error("Could not save migration report statuses.", (Throwable)e);
        }
    }

    public final void deleteByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        try {
            Long numberOfRecordsDeleted = (Long)this.databaseAccessor.run(arg_0 -> MigrationReportStatusRepository.deleteByExecutionId$lambda$14(executionId, arg_0), MigrationReportStatusRepository::deleteByExecutionId$lambda$15);
            Intrinsics.checkNotNull((Object)numberOfRecordsDeleted);
            this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsDeleted));
        }
        catch (RuntimeException e) {
            log.error("Could not delete migration report status by executionId: " + executionId + '.', (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final MigrationReportStatus findByExecutionIdAndReportType$lambda$0(String $executionId, ReportType $reportType, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)$reportType), (String)"$reportType");
        Object object = MigrationReportStatusTable.INSTANCE.all();
        SQLQuery sQLQuery = (SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)MigrationReportStatusTable.INSTANCE);
        object = new Predicate[]{MigrationReportStatusTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId), MigrationReportStatusTable.INSTANCE.getREPORT_TYPE().eq((Object)$reportType.toString())};
        List list = ((SQLQuery)sQLQuery.where((Predicate[])object)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = MigrationReportStatusTable.INSTANCE;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((MigrationReportStatusTable)((Object)object)).toMigrationReportStatus((Tuple)p0));
        }
        return (MigrationReportStatus)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private static final void findByExecutionIdAndReportType$lambda$1() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List findPreMigrationByExecutionId$lambda$3(String $executionId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Object object = MigrationReportStatusTable.INSTANCE.all();
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)MigrationReportStatusTable.INSTANCE)).where((Predicate)MigrationReportStatusTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId));
        object = new String[]{"REQUIRES_ATTENTION", "SUMMARY", "USERS_AND_GROUPS", "DUPLICATE_ENTITIES"};
        List list = ((SQLQuery)sQLQuery.where((Predicate)MigrationReportStatusTable.INSTANCE.getREPORT_TYPE().in((Object[])object))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = MigrationReportStatusTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((MigrationReportStatusTable)((Object)object)).toMigrationReportStatus((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void findPreMigrationByExecutionId$lambda$4() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List findPostMigrationByExecutionId$lambda$6(String $executionId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Object object = MigrationReportStatusTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)MigrationReportStatusTable.INSTANCE)).where((Predicate)MigrationReportStatusTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId))).where((Predicate)MigrationReportStatusTable.INSTANCE.getREPORT_TYPE().eq((Object)"POST_REQUIRES_ATTENTION").or((Predicate)MigrationReportStatusTable.INSTANCE.getREPORT_TYPE().eq((Object)"POST_SUMMARY")))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = MigrationReportStatusTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((MigrationReportStatusTable)((Object)object)).toMigrationReportStatus((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void findPostMigrationByExecutionId$lambda$7() {
    }

    private static final Pair saveOrReplace$lambda$8(MigrationReportStatus $migrationReportStatus, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$migrationReportStatus, (String)"$migrationReportStatus");
        Predicate[] predicateArray = new Predicate[]{MigrationReportStatusTable.INSTANCE.getEXECUTION_ID().eq((Object)$migrationReportStatus.getExecutionId()), MigrationReportStatusTable.INSTANCE.getREPORT_TYPE().eq((Object)$migrationReportStatus.getReportType().toString())};
        Long l = db.delete((RelationalPath)MigrationReportStatusTable.INSTANCE).where(predicateArray).execute();
        SQLInsertClause sQLInsertClause = db.insert((RelationalPath)MigrationReportStatusTable.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)sQLInsertClause, (String)"insert(...)");
        return new Pair((Object)l, (Object)MigrationReportStatusTable.INSTANCE.setMigrationReportStatus(sQLInsertClause, $migrationReportStatus).execute());
    }

    private static final void saveOrReplace$lambda$9() {
    }

    private static final Pair saveOrReplaceAll$lambda$12(String $executionId, List $migrationReportStatuses, DatabaseConnection db) {
        SQLInsertClause sQLInsertClause;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)$migrationReportStatuses, (String)"$migrationReportStatuses");
        long deletedCount = db.delete((RelationalPath)MigrationReportStatusTable.INSTANCE).where((Predicate)MigrationReportStatusTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
        SQLInsertClause $this$saveOrReplaceAll_u24lambda_u2412_u24lambda_u2411 = sQLInsertClause = db.insert((RelationalPath)MigrationReportStatusTable.INSTANCE);
        boolean bl = false;
        Iterable $this$forEach$iv = $migrationReportStatuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MigrationReportStatus it = (MigrationReportStatus)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)$this$saveOrReplaceAll_u24lambda_u2412_u24lambda_u2411);
            MigrationReportStatusTable.INSTANCE.setMigrationReportStatus($this$saveOrReplaceAll_u24lambda_u2412_u24lambda_u2411, it);
            $this$saveOrReplaceAll_u24lambda_u2412_u24lambda_u2411.addBatch();
        }
        $this$saveOrReplaceAll_u24lambda_u2412_u24lambda_u2411.execute();
        return new Pair((Object)deletedCount, (Object)$migrationReportStatuses.size());
    }

    private static final void saveOrReplaceAll$lambda$13() {
    }

    private static final Long deleteByExecutionId$lambda$14(String $executionId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        return db.delete((RelationalPath)MigrationReportStatusTable.INSTANCE).where((Predicate)MigrationReportStatusTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
    }

    private static final void deleteByExecutionId$lambda$15() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository$Companion;", "", "()V", "ANALYTICS_TABLE_NAME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

