/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.IDMappingsEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.preflight.reports.FetchIDMappingsService;
import com.atlassian.jira.migration.preflight.reports.MigrationReportsService;
import com.atlassian.jira.migration.preflight.reports.PostMigrationReportsService;
import com.atlassian.jira.migration.preflight.reports.PreMigrationReportsService;
import com.atlassian.jira.migration.preflight.reports.ReportStatusAndDate;
import com.atlassian.jira.migration.preflight.reports.Status;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Date;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="report")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ#\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\u00102\b\b\u0001\u0010\u0016\u001a\u00020\u0010H\u0007J\u001c\u0010\u001a\u001a\u00020\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\u00102\b\b\u0001\u0010\u0016\u001a\u00020\u0010H\u0007J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u001c\u001a\u00020\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\u0010H\u0007J\u0012\u0010\u001d\u001a\u00020\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\u0010H\u0007J\u0016\u0010\u001e\u001a\u00020\u001f*\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/MigrationReportsResource;", "", "preMigrationReportsService", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService;", "postMigrationReportsService", "Lcom/atlassian/jira/migration/preflight/reports/PostMigrationReportsService;", "fetchIDMappingsService", "Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService;Lcom/atlassian/jira/migration/preflight/reports/PostMigrationReportsService;Lcom/atlassian/jira/migration/preflight/reports/FetchIDMappingsService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "downloadIDMappings", "Ljavax/ws/rs/core/Response;", "cloudSiteUrl", "", "invalidateCache", "", "(Ljava/lang/String;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "downloadMigrationReport", "executionId", "planName", "migrationReportsService", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportsService;", "downloadPostMigrationReport", "downloadPreMigrationReport", "getReportStatusResponse", "postMigrationReportStatus", "preMigrationReportStatus", "lastModified", "", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "instant", "Ljava/time/Instant;", "jira-migration-plugin"})
public final class MigrationReportsResource {
    @NotNull
    private final PreMigrationReportsService preMigrationReportsService;
    @NotNull
    private final PostMigrationReportsService postMigrationReportsService;
    @NotNull
    private final FetchIDMappingsService fetchIDMappingsService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationEventBus migrationEventBus;

    @Inject
    public MigrationReportsResource(@NotNull PreMigrationReportsService preMigrationReportsService, @NotNull PostMigrationReportsService postMigrationReportsService, @NotNull FetchIDMappingsService fetchIDMappingsService, @NotNull MigrationFeatures migrationFeatures, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)preMigrationReportsService, (String)"preMigrationReportsService");
        Intrinsics.checkNotNullParameter((Object)postMigrationReportsService, (String)"postMigrationReportsService");
        Intrinsics.checkNotNullParameter((Object)fetchIDMappingsService, (String)"fetchIDMappingsService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.preMigrationReportsService = preMigrationReportsService;
        this.postMigrationReportsService = postMigrationReportsService;
        this.fetchIDMappingsService = fetchIDMappingsService;
        this.migrationFeatures = migrationFeatures;
        this.migrationEventBus = migrationEventBus;
    }

    @HEAD
    @Path(value="/{executionId}/pre/status")
    @NotNull
    public final Response preMigrationReportStatus(@PathParam(value="executionId") @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return this.getReportStatusResponse(executionId, this.preMigrationReportsService);
    }

    @HEAD
    @Path(value="/{executionId}/post/status")
    @NotNull
    public final Response postMigrationReportStatus(@PathParam(value="executionId") @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return this.getReportStatusResponse(executionId, this.postMigrationReportsService);
    }

    private final Response getReportStatusResponse(String executionId, MigrationReportsService migrationReportsService) {
        Response response2;
        ReportStatusAndDate reportsStatusAndDate;
        ReportStatusAndDate reportStatusAndDate = reportsStatusAndDate = migrationReportsService.getReportsStatus(executionId);
        Status status = reportStatusAndDate != null ? reportStatusAndDate.getStatus() : null;
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                Response.ResponseBuilder responseBuilder;
                Response.ResponseBuilder $this$getReportStatusResponse_u24lambda_u241 = responseBuilder = Response.ok();
                boolean bl = false;
                Object object = reportsStatusAndDate;
                if (object != null && (object = ((ReportStatusAndDate)object).getUpdatedDate()) != null) {
                    Object it = object;
                    boolean bl2 = false;
                    $this$getReportStatusResponse_u24lambda_u241.lastModified(Date.from((Instant)it));
                }
                Response response3 = responseBuilder.build();
                Intrinsics.checkNotNull((Object)response3);
                response2 = response3;
                break;
            }
            case 2: {
                response2 = ResponseUtils.INSTANCE.accepted();
                break;
            }
            case 3: {
                response2 = ResponseUtils.internalServerError$default(ResponseUtils.INSTANCE, null, 1, null);
                break;
            }
            default: {
                response2 = ResponseUtils.INSTANCE.notFound();
            }
        }
        return response2;
    }

    @GET
    @Path(value="/{executionId}/pre")
    @NotNull
    public final Response downloadPreMigrationReport(@PathParam(value="executionId") @NotNull String executionId, @QueryParam(value="planName") @NotNull String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)planName, (String)"planName");
        return this.downloadMigrationReport(executionId, planName, this.preMigrationReportsService);
    }

    @GET
    @Path(value="/id-mappings")
    @NotNull
    public final Response downloadIDMappings(@QueryParam(value="cloudSiteUrl") @NotNull String cloudSiteUrl, @QueryParam(value="invalidateCache") @Nullable Boolean invalidateCache) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)cloudSiteUrl, (String)"cloudSiteUrl");
        if (!this.migrationFeatures.getEnableIDMappingsAPI()) {
            return ResponseUtils.INSTANCE.notFound();
        }
        FetchIDMappingsService.FetchIDMappingsResult fetchIDMappingsResult = this.fetchIDMappingsService.downloadIDMappings(cloudSiteUrl, Intrinsics.areEqual((Object)invalidateCache, (Object)true));
        this.migrationEventBus.post(new IDMappingsEvent(cloudSiteUrl, invalidateCache, fetchIDMappingsResult.getFetchIDMappingsStatus()));
        switch (WhenMappings.$EnumSwitchMapping$1[fetchIDMappingsResult.getFetchIDMappingsStatus().ordinal()]) {
            case 1: {
                response2 = ResponseUtils.INSTANCE.badRequest("No migrationScopeId found for the cloudSiteUrl : " + cloudSiteUrl);
                break;
            }
            case 2: {
                response2 = ResponseUtils.INSTANCE.badRequest("Unable to fetch containerToken for the cloudSiteUrl : " + cloudSiteUrl);
                break;
            }
            case 3: {
                response2 = ResponseUtils.INSTANCE.badRequest("Unable to create id mappings CSV file for the cloudSiteUrl : " + cloudSiteUrl);
                break;
            }
            case 4: {
                response2 = ResponseUtils.INSTANCE.badRequest("No existing migration could be found for the cloudSiteUrl : " + cloudSiteUrl);
                break;
            }
            case 5: {
                response2 = ResponseUtils.INSTANCE.accepted();
                break;
            }
            case 6: {
                java.nio.file.Path path = fetchIDMappingsResult.getFilePath();
                Intrinsics.checkNotNull((Object)path);
                response2 = ResponseUtils.INSTANCE.ok(path, null, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return response2;
    }

    @GET
    @Path(value="/{executionId}/post")
    @NotNull
    public final Response downloadPostMigrationReport(@PathParam(value="executionId") @NotNull String executionId, @QueryParam(value="planName") @NotNull String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)planName, (String)"planName");
        return this.downloadMigrationReport(executionId, planName, this.postMigrationReportsService);
    }

    private final Response downloadMigrationReport(String executionId, String planName, MigrationReportsService migrationReportsService) {
        Response response2;
        ReportStatusAndDate reportsStatusAndDate;
        ReportStatusAndDate reportStatusAndDate = reportsStatusAndDate = migrationReportsService.getReportsStatus(executionId);
        Status status = reportStatusAndDate != null ? reportStatusAndDate.getStatus() : null;
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                Response.ResponseBuilder responseBuilder;
                String zipFilename = migrationReportsService.getReportsFilename(executionId, planName);
                Response.ResponseBuilder $this$downloadMigrationReport_u24lambda_u243 = responseBuilder = Response.ok(arg_0 -> MigrationReportsResource.downloadMigrationReport$lambda$2(migrationReportsService, executionId, arg_0));
                boolean bl = false;
                $this$downloadMigrationReport_u24lambda_u243.header("Content-Disposition", (Object)("attachment; filename=\"" + zipFilename + '\"'));
                Intrinsics.checkNotNull((Object)$this$downloadMigrationReport_u24lambda_u243);
                ReportStatusAndDate reportStatusAndDate2 = reportsStatusAndDate;
                this.lastModified($this$downloadMigrationReport_u24lambda_u243, reportStatusAndDate2 != null ? reportStatusAndDate2.getUpdatedDate() : null);
                Response response3 = responseBuilder.build();
                Intrinsics.checkNotNull((Object)response3);
                response2 = response3;
                break;
            }
            case 2: {
                response2 = ResponseUtils.INSTANCE.accepted();
                break;
            }
            case 3: {
                response2 = ResponseUtils.internalServerError$default(ResponseUtils.INSTANCE, null, 1, null);
                break;
            }
            default: {
                response2 = ResponseUtils.INSTANCE.notFound();
            }
        }
        return response2;
    }

    private final void lastModified(Response.ResponseBuilder $this$lastModified, Instant instant) {
        block0: {
            Instant instant2 = instant;
            if (instant2 == null) break block0;
            Instant it = instant2;
            boolean bl = false;
            $this$lastModified.lastModified(Date.from(it));
        }
    }

    private static final void downloadMigrationReport$lambda$2(MigrationReportsService $migrationReportsService, String $executionId, OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)$migrationReportsService, (String)"$migrationReportsService");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        $migrationReportsService.writeToStream($executionId, output);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.PENDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FetchIDMappingsService.FetchIDMappingsStatus.values().length];
            try {
                nArray[FetchIDMappingsService.FetchIDMappingsStatus.MISSING_MIGRATION_SCOPE_ID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FetchIDMappingsService.FetchIDMappingsStatus.CONTAINER_TOKEN_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FetchIDMappingsService.FetchIDMappingsStatus.CSV_FILE_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FetchIDMappingsService.FetchIDMappingsStatus.MIGRATION_DOES_NOT_EXIST_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FetchIDMappingsService.FetchIDMappingsStatus.ACCEPTED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FetchIDMappingsService.FetchIDMappingsStatus.FILE_PRESENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

