/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PreMigrationReportGenerationStartedEvent;
import com.atlassian.jira.migration.preflight.reports.AbstractReportService;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatus;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatusRepository;
import com.atlassian.jira.migration.preflight.reports.ReportStatusAndDate;
import com.atlassian.jira.migration.preflight.reports.ReportType;
import com.atlassian.jira.migration.preflight.reports.Status;
import com.atlassian.jira.migration.preflight.reports.ZipReportOutput;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 *2\u00020\u0001:\u0001*B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u00132\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u0016\u0010\u001a\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\fH\u0004J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H&J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u0014H&J\u0016\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\fJ\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0004J\u0018\u0010#\u001a\u0004\u0018\u00010$2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\fH\u0002J\u001e\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\fH\u0004J\u0016\u0010(\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/MigrationReportsService;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "reportStatusRepository", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;", "zipReportOutput", "Lcom/atlassian/jira/migration/preflight/reports/ZipReportOutput;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;Lcom/atlassian/jira/migration/preflight/reports/ZipReportOutput;)V", "getMigrationEventBus", "()Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migrationReportTypeServices", "", "Lcom/atlassian/jira/migration/preflight/reports/AbstractReportService;", "getMigrationReportTypeServices", "()Ljava/util/List;", "getReportStatusRepository", "()Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;", "filenamesToFileWriters", "", "", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "", "executionId", "getEnabledMigrationReportTypeServices", "getFormattedDateForFilename", "statuses", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatus;", "getReportsFilename", "planName", "getReportsStatus", "Lcom/atlassian/jira/migration/preflight/reports/ReportStatusAndDate;", "reportStatuses", "getTruncatedPlanName", "latestStatusDate", "Ljava/time/Instant;", "setReportsStatusToPending", "reportTypes", "Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "writeToStream", "outputStream", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationReportsService.kt\ncom/atlassian/jira/migration/preflight/reports/MigrationReportsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1603#2,9:86\n1855#2:95\n1856#2:97\n1612#2:98\n1549#2:99\n1620#2,3:100\n1747#2,3:103\n1747#2,3:106\n1726#2,3:109\n1603#2,9:112\n1855#2:121\n1856#2:123\n1612#2:124\n1#3:96\n1#3:122\n*S KotlinDebug\n*F\n+ 1 MigrationReportsService.kt\ncom/atlassian/jira/migration/preflight/reports/MigrationReportsService\n*L\n23#1:86,9\n23#1:95\n23#1:97\n23#1:98\n36#1:99\n36#1:100,3\n48#1:103,3\n49#1:106,3\n50#1:109,3\n78#1:112,9\n78#1:121\n78#1:123\n78#1:124\n23#1:96\n78#1:122\n*E\n"})
public abstract class MigrationReportsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final MigrationReportStatusRepository reportStatusRepository;
    @NotNull
    private final ZipReportOutput zipReportOutput;
    private static final int PLAN_NAME_MAX_LENGTH = 30;
    @NotNull
    private static final DateTimeFormatter dateTimeFormat;

    public MigrationReportsService(@NotNull MigrationEventBus migrationEventBus, @NotNull MigrationReportStatusRepository reportStatusRepository, @NotNull ZipReportOutput zipReportOutput) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)reportStatusRepository, (String)"reportStatusRepository");
        Intrinsics.checkNotNullParameter((Object)zipReportOutput, (String)"zipReportOutput");
        this.migrationEventBus = migrationEventBus;
        this.reportStatusRepository = reportStatusRepository;
        this.zipReportOutput = zipReportOutput;
    }

    @NotNull
    public final MigrationEventBus getMigrationEventBus() {
        return this.migrationEventBus;
    }

    @NotNull
    public final MigrationReportStatusRepository getReportStatusRepository() {
        return this.reportStatusRepository;
    }

    @NotNull
    protected abstract List<AbstractReportService> getMigrationReportTypeServices();

    @NotNull
    public abstract String getReportsFilename(@NotNull String var1, @NotNull String var2);

    @Nullable
    public abstract ReportStatusAndDate getReportsStatus(@NotNull String var1);

    @NotNull
    protected List<AbstractReportService> getEnabledMigrationReportTypeServices() {
        return this.getMigrationReportTypeServices();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Function1<OutputStream, Unit>> filenamesToFileWriters(String executionId) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getEnabledMigrationReportTypeServices();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AbstractReportService reportService = (AbstractReportService)element$iv$iv;
            boolean bl2 = false;
            ReportStatusAndDate reportStatusAndDate = reportService.getReportStatus(executionId);
            if (((reportStatusAndDate != null ? reportStatusAndDate.getStatus() : null) == Status.COMPLETED ? new Pair((Object)reportService.getReportFilename(executionId), (Object)new Function1<OutputStream, Unit>(reportService, executionId){
                final /* synthetic */ AbstractReportService $reportService;
                final /* synthetic */ String $executionId;
                {
                    this.$reportService = $reportService;
                    this.$executionId = $executionId;
                    super(1);
                }

                public final void invoke(@NotNull OutputStream outputStream) {
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    this.$reportService.writeReportToStream(this.$executionId, outputStream);
                }
            }) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    protected final void setReportsStatusToPending(@NotNull String executionId, @NotNull List<? extends ReportType> reportTypes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(reportTypes, (String)"reportTypes");
        Instant now = Instant.now();
        Iterable $this$map$iv = reportTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReportType reportType = (ReportType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            Intrinsics.checkNotNull((Object)now);
            this.migrationEventBus.post(new PreMigrationReportGenerationStartedEvent(executionId, string, now));
            collection.add(new MigrationReportStatus(executionId, (ReportType)it, Status.PENDING, now));
        }
        List statuses = (List)destination$iv$iv;
        this.reportStatusRepository.saveOrReplaceAll(executionId, statuses);
    }

    @Nullable
    public final ReportStatusAndDate getReportsStatus(@NotNull List<MigrationReportStatus> reportStatuses) {
        boolean bl;
        boolean isAnyPending;
        boolean isAnyFailed;
        block12: {
            boolean bl2;
            block11: {
                boolean bl3;
                block10: {
                    Intrinsics.checkNotNullParameter(reportStatuses, (String)"reportStatuses");
                    if (reportStatuses.isEmpty()) {
                        return null;
                    }
                    Iterable $this$any$iv = reportStatuses;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MigrationReportStatus status = (MigrationReportStatus)element$iv;
                            boolean bl4 = false;
                            if (!(status.getStatus() == Status.FAILED)) continue;
                            bl3 = true;
                            break block10;
                        }
                        bl3 = false;
                    }
                }
                isAnyFailed = bl3;
                Iterable $this$any$iv = reportStatuses;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MigrationReportStatus status = (MigrationReportStatus)element$iv;
                        boolean bl5 = false;
                        if (!(status.getStatus() == Status.PENDING)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
            }
            isAnyPending = bl2;
            Iterable $this$all$iv = reportStatuses;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    MigrationReportStatus status = (MigrationReportStatus)element$iv;
                    boolean bl6 = false;
                    if (status.getStatus() == Status.COMPLETED) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        boolean isAllCompleted = bl;
        Instant updatedDate = this.latestStatusDate(reportStatuses);
        return isAnyFailed ? new ReportStatusAndDate(Status.FAILED, updatedDate) : (isAnyPending ? new ReportStatusAndDate(Status.PENDING, updatedDate) : (isAllCompleted ? new ReportStatusAndDate(Status.COMPLETED, updatedDate) : null));
    }

    public final void writeToStream(@NotNull String executionId, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Map<String, Function1<OutputStream, Unit>> reportWriters = this.filenamesToFileWriters(executionId);
        this.zipReportOutput.write(outputStream, reportWriters);
    }

    @NotNull
    protected final String getTruncatedPlanName(@NotNull String planName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)planName, (String)"planName");
        if (planName.length() > 30) {
            String string2 = planName.substring(0, 30);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = planName;
        }
        return string;
    }

    @NotNull
    protected final String getFormattedDateForFilename(@NotNull List<MigrationReportStatus> statuses) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
                object = this.latestStatusDate(statuses);
                if (object == null) break block2;
                Instant it = object;
                boolean bl = false;
                String string = '_' + it.atZone(ZoneId.systemDefault()).format(dateTimeFormat);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Instant latestStatusDate(List<MigrationReportStatus> statuses) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = statuses;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Instant it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            MigrationReportStatus it = (MigrationReportStatus)element$iv$iv;
            boolean bl2 = false;
            if (it.getUpdatedAt() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (Instant)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        dateTimeFormat = dateTimeFormatter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/MigrationReportsService$Companion;", "", "()V", "PLAN_NAME_MAX_LENGTH", "", "dateTimeFormat", "Ljava/time/format/DateTimeFormatter;", "getDateTimeFormat", "()Ljava/time/format/DateTimeFormatter;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormatter getDateTimeFormat() {
            return dateTimeFormat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

