/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.export.model.UnsupportedEntity;
import com.atlassian.jira.migration.preflight.reports.ProblemType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"PROBLEM_COUNT_PLACEHOLDER", "", "PROBLEM_DETAILS_SEPARATOR", "PROBLEM_ENTITY_NAME_PLACEHOLDER_TO_REPLACE", "PROBLEM_ENTITY_TYPE_PLACEHOLDER_TO_REPLACE", "description", "Lcom/atlassian/jira/migration/export/model/UnsupportedEntity;", "getDescription", "(Lcom/atlassian/jira/migration/export/model/UnsupportedEntity;)Ljava/lang/String;", "impactedEntityDisplayName", "getImpactedEntityDisplayName", "nextSteps", "getNextSteps", "problemType", "Lcom/atlassian/jira/migration/preflight/reports/ProblemType;", "getProblemType", "(Lcom/atlassian/jira/migration/export/model/UnsupportedEntity;)Lcom/atlassian/jira/migration/preflight/reports/ProblemType;", "jira-migration-plugin"})
public final class ModelKt {
    @NotNull
    public static final String PROBLEM_DETAILS_SEPARATOR = ":";
    @NotNull
    public static final String PROBLEM_ENTITY_TYPE_PLACEHOLDER_TO_REPLACE = "@PROBLEM_ENTITY_TYPE_PLACEHOLDER@";
    @NotNull
    public static final String PROBLEM_ENTITY_NAME_PLACEHOLDER_TO_REPLACE = "@PROBLEM_ENTITY_NAME_PLACEHOLDER@";
    @NotNull
    public static final String PROBLEM_COUNT_PLACEHOLDER = "@PROBLEM_COUNT_PLACEHOLDER@";

    @NotNull
    public static final String getDescription(@NotNull UnsupportedEntity $this$description) {
        Intrinsics.checkNotNullParameter((Object)$this$description, (String)"<this>");
        String problemEntityType = StringsKt.substringAfter$default((String)$this$description.getProblemTypeAndDetails(), (String)PROBLEM_DETAILS_SEPARATOR, null, (int)2, null);
        String problemDescription = ModelKt.getProblemType($this$description).getDescription();
        problemDescription = StringsKt.replace$default((String)problemDescription, (String)PROBLEM_ENTITY_TYPE_PLACEHOLDER_TO_REPLACE, (String)problemEntityType, (boolean)false, (int)4, null);
        if ($this$description.getProblemEntityName() != null) {
            problemDescription = StringsKt.replace$default((String)problemDescription, (String)PROBLEM_ENTITY_NAME_PLACEHOLDER_TO_REPLACE, (String)$this$description.getProblemEntityName(), (boolean)false, (int)4, null);
        }
        problemDescription = StringsKt.replace$default((String)problemDescription, (String)PROBLEM_COUNT_PLACEHOLDER, (String)($this$description.getCount() != null ? $this$description.getCount() + " project issues" : "project issue"), (boolean)false, (int)4, null);
        return problemDescription;
    }

    @NotNull
    public static final ProblemType getProblemType(@NotNull UnsupportedEntity $this$problemType) {
        Intrinsics.checkNotNullParameter((Object)$this$problemType, (String)"<this>");
        return ProblemType.valueOf(StringsKt.substringBefore$default((String)$this$problemType.getProblemTypeAndDetails(), (String)PROBLEM_DETAILS_SEPARATOR, null, (int)2, null));
    }

    @NotNull
    public static final String getImpactedEntityDisplayName(@NotNull UnsupportedEntity $this$impactedEntityDisplayName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$impactedEntityDisplayName, (String)"<this>");
        switch (ModelKt.getProblemType($this$impactedEntityDisplayName).getImpactedType()) {
            case "Project": 
            case "Issue": 
            case "PortletConfiguration": {
                string = $this$impactedEntityDisplayName.getImpactedEntityName();
                break;
            }
            case "Board": 
            case "Attachment": 
            case "Custom field": {
                string = '\"' + $this$impactedEntityDisplayName.getImpactedEntityName() + "\" [" + $this$impactedEntityDisplayName.getImpactedEntityId() + ']';
                break;
            }
            default: {
                string = '\"' + $this$impactedEntityDisplayName.getImpactedEntityName() + '\"';
            }
        }
        return string;
    }

    @NotNull
    public static final String getNextSteps(@NotNull UnsupportedEntity $this$nextSteps) {
        Intrinsics.checkNotNullParameter((Object)$this$nextSteps, (String)"<this>");
        return ModelKt.getProblemType($this$nextSteps).getNextSteps();
    }
}

