/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.TableRecordsDeletedEvent;
import com.atlassian.jira.migration.events.TableRecordsInsertedEvent;
import com.atlassian.jira.migration.export.model.PMRAFailedEntity;
import com.atlassian.jira.migration.preflight.reports.PMRAFailedEntityTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PMRAFailedEntitiesRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "deleteByExecutionId", "", "executionId", "", "findByExecutionId", "", "Lcom/atlassian/jira/migration/export/model/PMRAFailedEntity;", "saveOrReplaceAll", "pmraFailedEntities", "trimDescriptionToLimit", "description", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPMRAFailedEntitiesRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PMRAFailedEntitiesRepository.kt\ncom/atlassian/jira/migration/preflight/reports/PMRAFailedEntitiesRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1855#2,2:193\n1549#2:195\n1620#2,3:196\n*S KotlinDebug\n*F\n+ 1 PMRAFailedEntitiesRepository.kt\ncom/atlassian/jira/migration/preflight/reports/PMRAFailedEntitiesRepository\n*L\n42#1:193,2\n79#1:195\n79#1:196,3\n*E\n"})
public final class PMRAFailedEntitiesRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private static final String ANALYTICS_TABLE_NAME = "pmraFailedEntity";
    private static final int DESC_LENGTH_LIMIT = 250;
    @NotNull
    private static final String TRAILING_DOTS = "...";

    @Inject
    public PMRAFailedEntitiesRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.databaseAccessor = databaseAccessor;
        this.migrationEventBus = migrationEventBus;
    }

    public final void saveOrReplaceAll(@NotNull String executionId, @NotNull List<PMRAFailedEntity> pmraFailedEntities) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(pmraFailedEntities, (String)"pmraFailedEntities");
        Ref.LongRef numberOfRecordsDeleted = new Ref.LongRef();
        Long numberOfRecordsInserted = (Long)this.databaseAccessor.run(arg_0 -> PMRAFailedEntitiesRepository.saveOrReplaceAll$lambda$2(numberOfRecordsDeleted, executionId, pmraFailedEntities, this, arg_0), PMRAFailedEntitiesRepository::saveOrReplaceAll$lambda$3);
        this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsDeleted.element));
        Intrinsics.checkNotNull((Object)numberOfRecordsInserted);
        this.migrationEventBus.post(new TableRecordsInsertedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsInserted));
    }

    private final String trimDescriptionToLimit(String description) {
        String string;
        if (description.length() > 250) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = description.substring(0, 246);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = stringBuilder.append(string2).append(TRAILING_DOTS).toString();
        } else {
            string = description;
        }
        return string;
    }

    @NotNull
    public final List<PMRAFailedEntity> findByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object object = this.databaseAccessor.run(arg_0 -> PMRAFailedEntitiesRepository.findByExecutionId$lambda$4(executionId, arg_0), PMRAFailedEntitiesRepository::findByExecutionId$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    public final void deleteByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Long numberOfRecordsDeleted = (Long)this.databaseAccessor.run(arg_0 -> PMRAFailedEntitiesRepository.deleteByExecutionId$lambda$6(executionId, arg_0), PMRAFailedEntitiesRepository::deleteByExecutionId$lambda$7);
        Intrinsics.checkNotNull((Object)numberOfRecordsDeleted);
        this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsDeleted));
    }

    private static final Long saveOrReplaceAll$lambda$2(Ref.LongRef $numberOfRecordsDeleted, String $executionId, List $pmraFailedEntities, PMRAFailedEntitiesRepository this$0, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$numberOfRecordsDeleted, (String)"$numberOfRecordsDeleted");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)$pmraFailedEntities, (String)"$pmraFailedEntities");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $numberOfRecordsDeleted.element = db.delete((RelationalPath)PMRAFailedEntityTable.INSTANCE).where((Predicate)PMRAFailedEntityTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
        if (!((Collection)$pmraFailedEntities).isEmpty()) {
            SQLInsertClause sQLInsertClause;
            SQLInsertClause $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241 = sQLInsertClause = db.insert((RelationalPath)PMRAFailedEntityTable.INSTANCE);
            boolean bl = false;
            Iterable $this$forEach$iv = $pmraFailedEntities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PMRAFailedEntity it = (PMRAFailedEntity)element$iv;
                boolean bl2 = false;
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)PMRAFailedEntityTable.INSTANCE.getEXECUTION_ID(), (Object)$executionId);
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)PMRAFailedEntityTable.INSTANCE.getCATEGORY(), (Object)it.getCategory());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)PMRAFailedEntityTable.INSTANCE.getPROJECT_ID(), (Object)it.getProjectKey());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)PMRAFailedEntityTable.INSTANCE.getENTITY_TYPE(), (Object)it.getEntityType());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)PMRAFailedEntityTable.INSTANCE.getENTITYTYPE(), (Object)it.getEntityType());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)PMRAFailedEntityTable.INSTANCE.getENTITY_NAME(), (Object)it.getEntityName());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)PMRAFailedEntityTable.INSTANCE.getPROBLEM_SUMMARY(), (Object)it.getProblemSummary());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)PMRAFailedEntityTable.INSTANCE.getDESCRIPTION(), (Object)this$0.trimDescriptionToLimit(it.getDescription()));
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)PMRAFailedEntityTable.INSTANCE.getPROBLEM_DESCRIPTION(), (Object)it.getDescription());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)PMRAFailedEntityTable.INSTANCE.getNEXT_STEPS(), (Object)it.getNextSteps());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.addBatch();
            }
            $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.execute();
        }
        return $pmraFailedEntities.size();
    }

    private static final void saveOrReplaceAll$lambda$3() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List findByExecutionId$lambda$4(String $executionId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Object object = new Expression[]{PMRAFailedEntityTable.INSTANCE.getCATEGORY(), PMRAFailedEntityTable.INSTANCE.getPROJECT_ID(), PMRAFailedEntityTable.INSTANCE.getENTITYTYPE(), PMRAFailedEntityTable.INSTANCE.getENTITY_TYPE(), PMRAFailedEntityTable.INSTANCE.getENTITY_NAME(), PMRAFailedEntityTable.INSTANCE.getPROBLEM_SUMMARY(), PMRAFailedEntityTable.INSTANCE.getPROBLEM_DESCRIPTION(), PMRAFailedEntityTable.INSTANCE.getDESCRIPTION(), PMRAFailedEntityTable.INSTANCE.getNEXT_STEPS()};
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)db.select((Expression[])object).from((Expression)PMRAFailedEntityTable.INSTANCE)).where((Predicate)PMRAFailedEntityTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId));
        object = new OrderSpecifier[]{PMRAFailedEntityTable.INSTANCE.getCATEGORY().asc(), PMRAFailedEntityTable.INSTANCE.getENTITY_TYPE().asc(), PMRAFailedEntityTable.INSTANCE.getENTITY_NAME().asc(), PMRAFailedEntityTable.INSTANCE.getDESCRIPTION().asc()};
        List list = ((SQLQuery)sQLQuery.orderBy((OrderSpecifier[])object)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = PMRAFailedEntityTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((PMRAFailedEntityTable)((Object)object)).toPMRAFailedEntity((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void findByExecutionId$lambda$5() {
    }

    private static final Long deleteByExecutionId$lambda$6(String $executionId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        return db.delete((RelationalPath)PMRAFailedEntityTable.INSTANCE).where((Predicate)PMRAFailedEntityTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
    }

    private static final void deleteByExecutionId$lambda$7() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PMRAFailedEntitiesRepository$Companion;", "", "()V", "ANALYTICS_TABLE_NAME", "", "DESC_LENGTH_LIMIT", "", "TRAILING_DOTS", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

