/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.orchestratorclient.tasks.EntityCounts;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanUtil;
import com.atlassian.jira.migration.preflight.reports.AbstractReportService;
import com.atlassian.jira.migration.preflight.reports.ActualProjectEntityTypeCounts;
import com.atlassian.jira.migration.preflight.reports.McsReportService;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatus;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatusRepository;
import com.atlassian.jira.migration.preflight.reports.MigrationReportsService;
import com.atlassian.jira.migration.preflight.reports.ReportStatusAndDate;
import com.atlassian.jira.migration.preflight.reports.ReportType;
import com.atlassian.jira.migration.preflight.reports.RequiresAttentionPostReportService;
import com.atlassian.jira.migration.preflight.reports.Status;
import com.atlassian.jira.migration.preflight.reports.SummaryPostReportService;
import com.atlassian.jira.migration.preflight.reports.ZipReportOutput;
import com.atlassian.jira.migration.publicapi.service.ArtifactService;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 12\u00020\u0001:\u00011BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014JX\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"2\b\u0010%\u001a\u0004\u0018\u00010\"2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\"0!J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001dH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010(\u001a\u00020\u001dH\u0016J\u0016\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010/\u001a\u0004\u0018\u00010\u001d2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u00100\u001a\u0004\u0018\u00010\u001d2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PostMigrationReportsService;", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportsService;", "planUtil", "Lcom/atlassian/jira/migration/plan/PlanUtil;", "summaryPostReportService", "Lcom/atlassian/jira/migration/preflight/reports/SummaryPostReportService;", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "mcsReportService", "Lcom/atlassian/jira/migration/preflight/reports/McsReportService;", "artifactService", "Lcom/atlassian/jira/migration/publicapi/service/ArtifactService;", "requiresAttentionPostReportService", "Lcom/atlassian/jira/migration/preflight/reports/RequiresAttentionPostReportService;", "reportStatusRepository", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;", "zipReportOutput", "Lcom/atlassian/jira/migration/preflight/reports/ZipReportOutput;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/plan/PlanUtil;Lcom/atlassian/jira/migration/preflight/reports/SummaryPostReportService;Lcom/atlassian/beehive/ClusterLockService;Lcom/atlassian/jira/migration/preflight/reports/McsReportService;Lcom/atlassian/jira/migration/publicapi/service/ArtifactService;Lcom/atlassian/jira/migration/preflight/reports/RequiresAttentionPostReportService;Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;Lcom/atlassian/jira/migration/preflight/reports/ZipReportOutput;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "migrationReportTypeServices", "", "Lcom/atlassian/jira/migration/preflight/reports/AbstractReportService;", "getMigrationReportTypeServices", "()Ljava/util/List;", "generateReportData", "", "migrationId", "", "actualProjectEntityTypeCounts", "Lcom/atlassian/jira/migration/preflight/reports/ActualProjectEntityTypeCounts;", "crossProjectEntityTypeCounts", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/EntityCounts;", "userCounts", "groupCounts", "customerCounts", "attachmentsUploadCounts", "getReportsFilename", "executionId", "planName", "getReportsStatus", "Lcom/atlassian/jira/migration/preflight/reports/ReportStatusAndDate;", "sendPostReport", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "sendPostReportIntoMCS", "sendPostReportIntoMCSWithClusterLock", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPostMigrationReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostMigrationReportsService.kt\ncom/atlassian/jira/migration/preflight/reports/PostMigrationReportsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class PostMigrationReportsService
extends MigrationReportsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlanUtil planUtil;
    @NotNull
    private final SummaryPostReportService summaryPostReportService;
    @NotNull
    private final ClusterLockService clusterLockService;
    @NotNull
    private final McsReportService mcsReportService;
    @NotNull
    private final ArtifactService artifactService;
    @NotNull
    private final List<AbstractReportService> migrationReportTypeServices;
    private static final Logger log = Logger.getLogger(PostMigrationReportsService.class);
    @NotNull
    public static final String POST_MIGRATION_REPORT_SEND_LOCK = "jcma.post.migration.report.send";

    @Inject
    public PostMigrationReportsService(@NotNull PlanUtil planUtil, @NotNull SummaryPostReportService summaryPostReportService, @NotNull ClusterLockService clusterLockService, @NotNull McsReportService mcsReportService, @NotNull ArtifactService artifactService, @NotNull RequiresAttentionPostReportService requiresAttentionPostReportService, @NotNull MigrationReportStatusRepository reportStatusRepository, @NotNull ZipReportOutput zipReportOutput, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)planUtil, (String)"planUtil");
        Intrinsics.checkNotNullParameter((Object)summaryPostReportService, (String)"summaryPostReportService");
        Intrinsics.checkNotNullParameter((Object)clusterLockService, (String)"clusterLockService");
        Intrinsics.checkNotNullParameter((Object)mcsReportService, (String)"mcsReportService");
        Intrinsics.checkNotNullParameter((Object)artifactService, (String)"artifactService");
        Intrinsics.checkNotNullParameter((Object)requiresAttentionPostReportService, (String)"requiresAttentionPostReportService");
        Intrinsics.checkNotNullParameter((Object)reportStatusRepository, (String)"reportStatusRepository");
        Intrinsics.checkNotNullParameter((Object)zipReportOutput, (String)"zipReportOutput");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        super(migrationEventBus, reportStatusRepository, zipReportOutput);
        this.planUtil = planUtil;
        this.summaryPostReportService = summaryPostReportService;
        this.clusterLockService = clusterLockService;
        this.mcsReportService = mcsReportService;
        this.artifactService = artifactService;
        Object[] objectArray = new AbstractReportService[]{requiresAttentionPostReportService, this.summaryPostReportService};
        this.migrationReportTypeServices = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    protected List<AbstractReportService> getMigrationReportTypeServices() {
        return this.migrationReportTypeServices;
    }

    @Override
    @Nullable
    public ReportStatusAndDate getReportsStatus(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        List<MigrationReportStatus> reportStatuses = this.getReportStatusRepository().findPostMigrationByExecutionId(executionId);
        return this.getReportsStatus(reportStatuses);
    }

    @Override
    @NotNull
    public String getReportsFilename(@NotNull String executionId, @NotNull String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)planName, (String)"planName");
        String formattedDate = this.getFormattedDateForFilename(this.getReportStatusRepository().findPostMigrationByExecutionId(executionId));
        String truncatedPlanName = this.getTruncatedPlanName(planName);
        return truncatedPlanName + '_' + executionId + "_Post-migration report_Jira" + formattedDate + ".zip";
    }

    public final void generateReportData(@NotNull String migrationId, @NotNull ActualProjectEntityTypeCounts actualProjectEntityTypeCounts, @NotNull Map<String, EntityCounts> crossProjectEntityTypeCounts, @NotNull EntityCounts userCounts, @NotNull EntityCounts groupCounts, @Nullable EntityCounts customerCounts, @NotNull Map<String, EntityCounts> attachmentsUploadCounts) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)actualProjectEntityTypeCounts, (String)"actualProjectEntityTypeCounts");
        Intrinsics.checkNotNullParameter(crossProjectEntityTypeCounts, (String)"crossProjectEntityTypeCounts");
        Intrinsics.checkNotNullParameter((Object)userCounts, (String)"userCounts");
        Intrinsics.checkNotNullParameter((Object)groupCounts, (String)"groupCounts");
        Intrinsics.checkNotNullParameter(attachmentsUploadCounts, (String)"attachmentsUploadCounts");
        Object object = this.planUtil.getPlanFromMigrationId(migrationId);
        if (object == null || (object = ((Plan)object).getPreflightCheckExecutionId()) == null) {
            return;
        }
        Object executionId = object;
        this.getReportStatusRepository().saveOrReplace(new MigrationReportStatus((String)executionId, ReportType.POST_SUMMARY, Status.PENDING, Instant.now()));
        this.summaryPostReportService.generateReportData((String)executionId, actualProjectEntityTypeCounts, crossProjectEntityTypeCounts, userCounts, groupCounts, customerCounts, attachmentsUploadCounts);
    }

    public final void sendPostReport(@NotNull Plan plan2, @NotNull String migrationId) {
        block3: {
            Object object;
            String string;
            Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
            Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
            String string2 = this.sendPostReportIntoMCSWithClusterLock(plan2, migrationId);
            if (string2 == null) break block3;
            String fileId = string = string2;
            boolean bl = false;
            Object object2 = this;
            try {
                PostMigrationReportsService $this$sendPostReport_u24lambda_u242_u24lambda_u240 = object2;
                boolean bl2 = false;
                $this$sendPostReport_u24lambda_u242_u24lambda_u240.artifactService.linkMcsArtifact(migrationId, plan2.getCloudId(), fileId, "post-migration-reports.zip");
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl3 = false;
                log.error((Object)("Error linking post migration report file to mapi artifact for migrationId: " + migrationId + ' '), (Throwable)it);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String sendPostReportIntoMCSWithClusterLock(Plan plan2, String migrationId) {
        ClusterLock lock = this.clusterLockService.getLockForName(POST_MIGRATION_REPORT_SEND_LOCK);
        if (lock.tryLock()) {
            log.debug((Object)"Obtained a cluster lock for uploading post migration report.");
            try {
                String string = this.sendPostReportIntoMCS(plan2, migrationId);
                return string;
            }
            catch (Exception e) {
                log.error((Object)"Exception during uploading post migration report with cluster lock.", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String sendPostReportIntoMCS(@NotNull Plan plan2, @NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String executionId = plan2.getPreflightCheckExecutionId();
        File file2 = this.mcsReportService.preparePostReport(executionId);
        if (file2 == null) {
            return null;
        }
        File preReportFile = file2;
        Closeable closeable = new FileOutputStream(preReportFile);
        Throwable throwable = null;
        try {
            FileOutputStream out = (FileOutputStream)closeable;
            boolean bl = false;
            this.writeToStream(executionId, out);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return this.mcsReportService.sendPostReportIntoMCS(migrationId, preReportFile, plan2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PostMigrationReportsService$Companion;", "", "()V", "POST_MIGRATION_REPORT_SEND_LOCK", "", "getPOST_MIGRATION_REPORT_SEND_LOCK$annotations", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPOST_MIGRATION_REPORT_SEND_LOCK$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

