/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.ReportExportOutcome;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.preflight.model.CheckExecutionResult;
import com.atlassian.jira.migration.preflight.reports.AbstractReportService;
import com.atlassian.jira.migration.preflight.reports.DataExtractorFromProjects;
import com.atlassian.jira.migration.preflight.reports.DuplicateEntitiesReportService;
import com.atlassian.jira.migration.preflight.reports.McsReportService;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatus;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatusRepository;
import com.atlassian.jira.migration.preflight.reports.MigrationReportsService;
import com.atlassian.jira.migration.preflight.reports.PreMigrationServicesProvider;
import com.atlassian.jira.migration.preflight.reports.ReportStatusAndDate;
import com.atlassian.jira.migration.preflight.reports.ReportType;
import com.atlassian.jira.migration.preflight.reports.Status;
import com.atlassian.jira.migration.preflight.reports.ZipReportOutput;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMapping;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingRepository;
import com.atlassian.jira.migration.publicapi.service.ArtifactService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.tracking.utils.SystemTimeProvider;
import com.atlassian.jira.migration.tracking.utils.TimeProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.api.MigrationId;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 P2\u00020\u0001:\u0006OPQRSTBY\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00180#H\u0002J\b\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)J&\u0010*\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J.\u00101\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00102\u001a\u000203J \u00104\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208J0\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\"\u0010;\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0002J(\u0010;\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u0002082\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018H\u0014J\u001e\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0002J\u0018\u0010E\u001a\u00020)2\u0006\u0010(\u001a\u00020)2\u0006\u0010F\u001a\u00020)H\u0016J\u0012\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010I\u001a\u00020!2\u0006\u0010C\u001a\u00020DH\u0002J\"\u0010J\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u0010-\u001a\u00020.H\u0002J$\u0010K\u001a\u0004\u0018\u00010)2\u0006\u0010(\u001a\u00020)2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u0010-\u001a\u00020.H\u0002J\u0015\u0010L\u001a\u00020&2\u0006\u0010M\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\bNR\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService;", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportsService;", "preMigrationServicesProvider", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationServicesProvider;", "dataExtractorFromProjects", "Lcom/atlassian/jira/migration/preflight/reports/DataExtractorFromProjects;", "mcsReportService", "Lcom/atlassian/jira/migration/preflight/reports/McsReportService;", "reportStatusRepository", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;", "zipReportOutput", "Lcom/atlassian/jira/migration/preflight/reports/ZipReportOutput;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "artifactService", "Lcom/atlassian/jira/migration/publicapi/service/ArtifactService;", "publicPlanMappingRepository", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;", "timeProvider", "Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;", "(Lcom/atlassian/jira/migration/preflight/reports/PreMigrationServicesProvider;Lcom/atlassian/jira/migration/preflight/reports/DataExtractorFromProjects;Lcom/atlassian/jira/migration/preflight/reports/McsReportService;Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;Lcom/atlassian/jira/migration/preflight/reports/ZipReportOutput;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/publicapi/service/ArtifactService;Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;)V", "alwaysAvailableReports", "", "Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "migrationReportTypeServices", "Lcom/atlassian/jira/migration/preflight/reports/AbstractReportService;", "getMigrationReportTypeServices", "()Ljava/util/List;", "preMigrationReportExportOutcome", "Lcom/atlassian/jira/migration/export/ReportExportOutcome;", "allPreflightsAreSuccessful", "", "preflightChecksResult", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/atlassian/jira/migration/preflight/model/CheckExecutionResult;", "clearPreMigrationReportOutcome", "", "deleteReportData", "executionId", "", "gatherReportsDataFromCrossProject", "usersData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$UsersData;", "migrationData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$MigrationData;", "projectsData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$ProjectsData;", "gatherReportsDataFromProject", "appsData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$AppsData;", "generateReportData", "preflightId", "Lcom/atlassian/migration/api/MigrationId;", "preMigrationReportData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$PreMigrationReportData;", "generateReports", "reportsData", "generateReportsWithDataFromPreflight", "executor", "Ljava/util/concurrent/Executor;", "getEnabledAlwaysAvailableReports", "getEnabledMigrationReportTypeServices", "getReportTypesToGenerate", "usersGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "getReportsFilename", "planName", "getReportsStatus", "Lcom/atlassian/jira/migration/preflight/reports/ReportStatusAndDate;", "isAttachmentsOnlyMode", "sendPreReport", "sendPreReportIntoMCS", "updatePreMigrationReportExportOutcome", "combinedReportExportOutcome", "updatePreMigrationReportExportOutcome$jira_migration_plugin", "AppsData", "Companion", "MigrationData", "PreMigrationReportData", "ProjectsData", "UsersData", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreMigrationReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreMigrationReportsService.kt\ncom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1#2:360\n766#3:361\n857#3,2:362\n766#3:364\n857#3,2:365\n766#3:367\n857#3,2:368\n*S KotlinDebug\n*F\n+ 1 PreMigrationReportsService.kt\ncom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService\n*L\n301#1:361\n301#1:362,2\n303#1:364\n303#1:365,2\n304#1:367\n304#1:368,2\n*E\n"})
public final class PreMigrationReportsService
extends MigrationReportsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PreMigrationServicesProvider preMigrationServicesProvider;
    @NotNull
    private final DataExtractorFromProjects dataExtractorFromProjects;
    @NotNull
    private final McsReportService mcsReportService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ArtifactService artifactService;
    @NotNull
    private final PublicPlanMappingRepository publicPlanMappingRepository;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final List<AbstractReportService> migrationReportTypeServices;
    @NotNull
    private final List<ReportType> alwaysAvailableReports;
    @Nullable
    private ReportExportOutcome preMigrationReportExportOutcome;
    private static final Logger logger = LoggerFactory.getLogger(PreMigrationReportsService.class);
    @NotNull
    private static final String FILENAME = "Pre-migration_report_Jira";
    @NotNull
    private static final String FILETYPE = ".zip";
    @NotNull
    private static final List<String> listOfBlockingPreflightsMarkedAsPassed;
    private static final long PRE_REPORT_GENERATION_WAIT_TIME = 3L;

    @Inject
    public PreMigrationReportsService(@NotNull PreMigrationServicesProvider preMigrationServicesProvider, @NotNull DataExtractorFromProjects dataExtractorFromProjects, @NotNull McsReportService mcsReportService, @NotNull MigrationReportStatusRepository reportStatusRepository, @NotNull ZipReportOutput zipReportOutput, @NotNull MigrationEventBus migrationEventBus, @NotNull MigrationFeatures migrationFeatures, @NotNull ArtifactService artifactService, @NotNull PublicPlanMappingRepository publicPlanMappingRepository, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)preMigrationServicesProvider, (String)"preMigrationServicesProvider");
        Intrinsics.checkNotNullParameter((Object)dataExtractorFromProjects, (String)"dataExtractorFromProjects");
        Intrinsics.checkNotNullParameter((Object)mcsReportService, (String)"mcsReportService");
        Intrinsics.checkNotNullParameter((Object)reportStatusRepository, (String)"reportStatusRepository");
        Intrinsics.checkNotNullParameter((Object)zipReportOutput, (String)"zipReportOutput");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)artifactService, (String)"artifactService");
        Intrinsics.checkNotNullParameter((Object)publicPlanMappingRepository, (String)"publicPlanMappingRepository");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        super(migrationEventBus, reportStatusRepository, zipReportOutput);
        this.preMigrationServicesProvider = preMigrationServicesProvider;
        this.dataExtractorFromProjects = dataExtractorFromProjects;
        this.mcsReportService = mcsReportService;
        this.migrationFeatures = migrationFeatures;
        this.artifactService = artifactService;
        this.publicPlanMappingRepository = publicPlanMappingRepository;
        this.timeProvider = timeProvider;
        Object[] objectArray = new AbstractReportService[]{this.preMigrationServicesProvider.getUsersGroupsReportService(), this.preMigrationServicesProvider.getRequiresAttentionPreReportService(), this.preMigrationServicesProvider.getSummaryReportService(), this.preMigrationServicesProvider.getConfigItemsReportService(), this.preMigrationServicesProvider.getDuplicateEntitiesReportService()};
        this.migrationReportTypeServices = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new ReportType[]{ReportType.REQUIRES_ATTENTION, ReportType.SUMMARY, ReportType.CONFIG_ITEMS, ReportType.POST_REQUIRES_ATTENTION, ReportType.DUPLICATE_ENTITIES};
        this.alwaysAvailableReports = CollectionsKt.listOf((Object[])objectArray);
    }

    public /* synthetic */ PreMigrationReportsService(PreMigrationServicesProvider preMigrationServicesProvider, DataExtractorFromProjects dataExtractorFromProjects, McsReportService mcsReportService, MigrationReportStatusRepository migrationReportStatusRepository, ZipReportOutput zipReportOutput, MigrationEventBus migrationEventBus, MigrationFeatures migrationFeatures, ArtifactService artifactService, PublicPlanMappingRepository publicPlanMappingRepository, TimeProvider timeProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            timeProvider = new SystemTimeProvider();
        }
        this(preMigrationServicesProvider, dataExtractorFromProjects, mcsReportService, migrationReportStatusRepository, zipReportOutput, migrationEventBus, migrationFeatures, artifactService, publicPlanMappingRepository, timeProvider);
    }

    @Override
    @NotNull
    protected List<AbstractReportService> getMigrationReportTypeServices() {
        return this.migrationReportTypeServices;
    }

    @Override
    @NotNull
    protected List<AbstractReportService> getEnabledMigrationReportTypeServices() {
        DuplicateEntitiesReportService duplicateEntitiesReportService;
        List list;
        List $this$getEnabledMigrationReportTypeServices_u24lambda_u241 = list = CollectionsKt.toMutableList((Collection)this.getMigrationReportTypeServices());
        boolean bl = false;
        DuplicateEntitiesReportService duplicateEntitiesReportService2 = duplicateEntitiesReportService = this.preMigrationServicesProvider.getDuplicateEntitiesReportService();
        List list2 = $this$getEnabledMigrationReportTypeServices_u24lambda_u241;
        boolean bl2 = false;
        list2.removeAll(CollectionsKt.listOfNotNull((Object)(Boolean.valueOf(this.migrationFeatures.getEnableDuplicateEntityReports()) == false ? duplicateEntitiesReportService : null)));
        return list;
    }

    private final List<ReportType> getEnabledAlwaysAvailableReports() {
        ReportType reportType;
        List list;
        List $this$getEnabledAlwaysAvailableReports_u24lambda_u243 = list = CollectionsKt.toMutableList((Collection)this.alwaysAvailableReports);
        boolean bl = false;
        ReportType reportType2 = reportType = ReportType.DUPLICATE_ENTITIES;
        List list2 = $this$getEnabledAlwaysAvailableReports_u24lambda_u243;
        boolean bl2 = false;
        list2.removeAll(CollectionsKt.listOfNotNull((Object)((Object)(Boolean.valueOf(this.migrationFeatures.getEnableDuplicateEntityReports()) == false ? reportType : null))));
        return list;
    }

    public final void generateReportData(@NotNull String executionId, @Nullable MigrationId preflightId, @NotNull PreMigrationReportData preMigrationReportData) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)preMigrationReportData, (String)"preMigrationReportData");
        logger.info("Collecting data for pre migration report generation for execution id: " + executionId);
        ReportExportOutcome reportsData = this.gatherReportsDataFromProject(executionId, preMigrationReportData.getUsersData(), preMigrationReportData.getMigrationData(), preMigrationReportData.getProjectData(), preMigrationReportData.getAppsData()).plus(this.gatherReportsDataFromCrossProject(executionId, preMigrationReportData.getUsersData(), preMigrationReportData.getMigrationData(), preMigrationReportData.getProjectData()));
        this.generateReports(reportsData, executionId, preMigrationReportData.getUsersData(), preMigrationReportData.getMigrationData(), preMigrationReportData.getProjectData());
        this.sendPreReport(executionId, preflightId, preMigrationReportData.getMigrationData());
    }

    public final void generateReportsWithDataFromPreflight(@NotNull String executionId, @Nullable MigrationId preflightId, @NotNull PreMigrationReportData preMigrationReportData, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)preMigrationReportData, (String)"preMigrationReportData");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Futures.addCallback(preMigrationReportData.getMigrationData().getPreflightChecksResult(), (FutureCallback)((FutureCallback)new FutureCallback<List<? extends CheckExecutionResult>>(this, executionId, preflightId, preMigrationReportData){
            final /* synthetic */ PreMigrationReportsService this$0;
            final /* synthetic */ String $executionId;
            final /* synthetic */ MigrationId $preflightId;
            final /* synthetic */ PreMigrationReportData $preMigrationReportData;
            {
                this.this$0 = $receiver;
                this.$executionId = $executionId;
                this.$preflightId = $preflightId;
                this.$preMigrationReportData = $preMigrationReportData;
            }

            public void onSuccess(@Nullable List<CheckExecutionResult> result2) {
                PreMigrationReportsService.access$generateReportsWithDataFromPreflight(this.this$0, this.$executionId, this.$preflightId, this.$preMigrationReportData);
            }

            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                PreMigrationReportsService.access$generateReportsWithDataFromPreflight(this.this$0, this.$executionId, this.$preflightId, this.$preMigrationReportData);
            }
        }), (Executor)executor);
    }

    private final void generateReportsWithDataFromPreflight(String executionId, MigrationId preflightId, PreMigrationReportData preMigrationReportData) {
        if (this.preMigrationReportExportOutcome != null) {
            ReportExportOutcome reportExportOutcome2 = this.preMigrationReportExportOutcome;
            Intrinsics.checkNotNull((Object)reportExportOutcome2);
            this.generateReports(reportExportOutcome2, executionId, preMigrationReportData.getUsersData(), preMigrationReportData.getMigrationData(), preMigrationReportData.getProjectData());
            this.sendPreReport(executionId, preflightId, preMigrationReportData.getMigrationData());
        } else {
            logger.info("Unable to generate pre-migration reports. Report export outcome is missing from preflight check for executionId : " + executionId);
        }
    }

    private final void generateReports(ReportExportOutcome reportsData, String executionId, UsersData usersData, MigrationData migrationData, ProjectsData projectsData) {
        logger.info("Starting pre migration report generation for execution id: " + executionId);
        List<ReportType> reportTypesToGenerate = this.getReportTypesToGenerate(usersData.getUsersGroupsMigrationOption(), projectsData.getProjectDataMigrationMode());
        this.setReportsStatusToPending(executionId, reportTypesToGenerate);
        logger.info("Pre migration reports " + reportTypesToGenerate + " set as status pending for execution id: " + executionId);
        boolean isUserGroupsIncluded = reportTypesToGenerate.contains((Object)ReportType.USERS_AND_GROUPS);
        this.preMigrationServicesProvider.generateReportData(executionId, reportsData, isUserGroupsIncluded, usersData, migrationData, projectsData);
        this.clearPreMigrationReportOutcome();
        logger.info("Finished pre migration report generation for execution id: " + executionId);
    }

    private final List<ReportType> getReportTypesToGenerate(UsersGroupsMigrationOption usersGroupsMigrationOption, ProjectDataMigrationMode projectDataMigrationMode) {
        return usersGroupsMigrationOption.getMode() == UsersGroupsMigrationOption.MigrationMode.REFERENCED ? CollectionsKt.plus((Collection)this.getEnabledAlwaysAvailableReports(), (Object)((Object)ReportType.USERS_AND_GROUPS)) : (this.isAttachmentsOnlyMode(projectDataMigrationMode) ? CollectionsKt.plus((Collection)this.getEnabledAlwaysAvailableReports(), (Object)((Object)ReportType.USERS_AND_GROUPS)) : this.getEnabledAlwaysAvailableReports());
    }

    @NotNull
    public final ReportExportOutcome gatherReportsDataFromProject(@NotNull String executionId, @NotNull UsersData usersData, @NotNull MigrationData migrationData, @NotNull ProjectsData projectsData, @NotNull AppsData appsData) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)usersData, (String)"usersData");
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        Intrinsics.checkNotNullParameter((Object)projectsData, (String)"projectsData");
        Intrinsics.checkNotNullParameter((Object)appsData, (String)"appsData");
        return this.dataExtractorFromProjects.gatherReportsDataFromProject(executionId, usersData, projectsData, migrationData, appsData);
    }

    @NotNull
    public final ReportExportOutcome gatherReportsDataFromCrossProject(@NotNull String executionId, @NotNull UsersData usersData, @NotNull MigrationData migrationData, @NotNull ProjectsData projectsData) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)usersData, (String)"usersData");
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        Intrinsics.checkNotNullParameter((Object)projectsData, (String)"projectsData");
        return this.dataExtractorFromProjects.gatherReportsDataFromCrossProject(executionId, usersData, projectsData, migrationData);
    }

    public final void updatePreMigrationReportExportOutcome$jira_migration_plugin(@NotNull ReportExportOutcome combinedReportExportOutcome) {
        Intrinsics.checkNotNullParameter((Object)combinedReportExportOutcome, (String)"combinedReportExportOutcome");
        this.preMigrationReportExportOutcome = combinedReportExportOutcome;
    }

    private final void sendPreReport(String executionId, MigrationId preflightId, MigrationData migrationData) {
        block5: {
            Object object;
            String string;
            PublicPlanMapping publicPlan = this.publicPlanMappingRepository.getByPreflightExecutionId(executionId);
            boolean preflightStatusSuccess = this.allPreflightsAreSuccessful(migrationData.getPreflightChecksResult());
            if (!this.migrationFeatures.getEnablePreMigrationReportUpload() && publicPlan == null && preflightStatusSuccess) {
                return;
            }
            ReportStatusAndDate reportStatusAndDate = this.getReportsStatus(executionId);
            if ((reportStatusAndDate != null ? reportStatusAndDate.getStatus() : null) == Status.PENDING) {
                logger.info("Some of the reports are not generated, waiting for 3 sec.");
                this.timeProvider.sleep(3L, TimeUnit.SECONDS);
            }
            String string2 = this.sendPreReportIntoMCS(executionId, preflightId, migrationData);
            if (string2 == null) break block5;
            String fileId = string = string2;
            boolean bl = false;
            Object object2 = this;
            try {
                PreMigrationReportsService $this$sendPreReport_u24lambda_u246_u24lambda_u244 = object2;
                boolean bl2 = false;
                object = Result.constructor-impl((Object)$this$sendPreReport_u24lambda_u246_u24lambda_u244.artifactService.linkMcsMigrationScopeArtifact(publicPlan, migrationData.getMigrationScopeId(), migrationData.getCloudId(), fileId, "pre-migration-reports.zip"));
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl3 = false;
                logger.error("Error linking post migration report file to mapi artifact. ", (Throwable)it);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String sendPreReportIntoMCS(String executionId, MigrationId preflightId, MigrationData migrationData) {
        logger.info("Sending pre migration report into MCS for execution id: " + executionId);
        File file2 = this.mcsReportService.preparePreReport(executionId);
        if (file2 == null) {
            return null;
        }
        File preReportZipFile = file2;
        Object object = new FileOutputStream(preReportZipFile);
        Throwable throwable = null;
        try {
            FileOutputStream out = (FileOutputStream)object;
            boolean bl = false;
            this.writeToStream(executionId, out);
            out = Unit.INSTANCE;
        }
        catch (Throwable out) {
            throwable = out;
            throw out;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Object it = object = this.mcsReportService.sendPreReportIntoMCS(executionId, preflightId, migrationData.getContainerToken(), migrationData.getMigrationScopeId(), preReportZipFile);
        boolean bl = false;
        logger.info("Finished pre migration report sending into MCS for execution id: " + executionId);
        return object;
    }

    private final boolean isAttachmentsOnlyMode(ProjectDataMigrationMode projectDataMigrationMode) {
        return projectDataMigrationMode == ProjectDataMigrationMode.ATTACHMENTS_ONLY || projectDataMigrationMode == ProjectDataMigrationMode.ATTACHMENTS_ONLY_V2;
    }

    private final void clearPreMigrationReportOutcome() {
        this.preMigrationReportExportOutcome = null;
    }

    @Override
    @Nullable
    public ReportStatusAndDate getReportsStatus(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        List<MigrationReportStatus> reportStatuses = this.getReportStatusRepository().findPreMigrationByExecutionId(executionId);
        return this.getReportsStatus(reportStatuses);
    }

    @Override
    @NotNull
    public String getReportsFilename(@NotNull String executionId, @NotNull String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)planName, (String)"planName");
        String formattedDate = this.getFormattedDateForFilename(this.getReportStatusRepository().findPreMigrationByExecutionId(executionId));
        String truncatedPlanName = this.getTruncatedPlanName(planName);
        return truncatedPlanName + '_' + executionId + "_Pre-migration_report_Jira" + formattedDate + FILETYPE;
    }

    public final void deleteReportData(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.preMigrationServicesProvider.deleteReportDataByExecutionId(executionId);
        this.getReportStatusRepository().deleteByExecutionId(executionId);
    }

    private final boolean allPreflightsAreSuccessful(ListenableFuture<List<CheckExecutionResult>> preflightChecksResult) {
        Object object;
        Object $this$allPreflightsAreSuccessful_u24lambda_u2412;
        Object object2 = this;
        try {
            CheckExecutionResult it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            $this$allPreflightsAreSuccessful_u24lambda_u2412 = object2;
            boolean bl = false;
            Object object3 = preflightChecksResult.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            Iterable iterable = (Iterable)object3;
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CheckExecutionResult)element$iv$iv;
                boolean bl2 = false;
                if (!(!it.getCheckResult().success)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CheckExecutionResult)element$iv$iv;
                boolean bl3 = false;
                if (!(!listOfBlockingPreflightsMarkedAsPassed.contains(it.getRequest().checkType))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CheckExecutionResult)element$iv$iv;
                boolean bl4 = false;
                boolean bl5 = !it.getRequest().checkType.equals("GroupNamesConflict") || it.getRequest().checkType.equals("GroupNamesConflict") && it.getCheckResult().details.keySet().contains("extractionHasErrors");
                if (!bl5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List listOfFailedPreflightChecks = (List)destination$iv$iv;
            $this$allPreflightsAreSuccessful_u24lambda_u2412 = Result.constructor-impl((Object)listOfFailedPreflightChecks.isEmpty());
        }
        catch (Throwable bl) {
            $this$allPreflightsAreSuccessful_u24lambda_u2412 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$allPreflightsAreSuccessful_u24lambda_u2412;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable error = throwable;
            boolean bl = false;
            logger.error("An error occurred during getting preflight checks result", error);
            object = false;
        }
        return (Boolean)object;
    }

    public static final /* synthetic */ void access$generateReportsWithDataFromPreflight(PreMigrationReportsService $this, String executionId, MigrationId preflightId, PreMigrationReportData preMigrationReportData) {
        $this.generateReportsWithDataFromPreflight(executionId, preflightId, preMigrationReportData);
    }

    static {
        Object[] objectArray = new String[]{"AppsReliabilityCheck", "JsmCloudEntityCreationLimits", "AppVendorCheck"};
        listOfBlockingPreflightsMarkedAsPassed = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$AppsData;", "", "serverAppKeys", "", "", "(Ljava/util/Set;)V", "getServerAppKeys", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class AppsData {
        @NotNull
        private final Set<String> serverAppKeys;

        public AppsData(@NotNull Set<String> serverAppKeys) {
            Intrinsics.checkNotNullParameter(serverAppKeys, (String)"serverAppKeys");
            this.serverAppKeys = serverAppKeys;
        }

        @NotNull
        public final Set<String> getServerAppKeys() {
            return this.serverAppKeys;
        }

        @NotNull
        public final Set<String> component1() {
            return this.serverAppKeys;
        }

        @NotNull
        public final AppsData copy(@NotNull Set<String> serverAppKeys) {
            Intrinsics.checkNotNullParameter(serverAppKeys, (String)"serverAppKeys");
            return new AppsData(serverAppKeys);
        }

        public static /* synthetic */ AppsData copy$default(AppsData appsData, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = appsData.serverAppKeys;
            }
            return appsData.copy(set);
        }

        @NotNull
        public String toString() {
            return "AppsData(serverAppKeys=" + this.serverAppKeys + ')';
        }

        public int hashCode() {
            return ((Object)this.serverAppKeys).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AppsData)) {
                return false;
            }
            AppsData appsData = (AppsData)other;
            return Intrinsics.areEqual(this.serverAppKeys, appsData.serverAppKeys);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$Companion;", "", "()V", "FILENAME", "", "FILETYPE", "PRE_REPORT_GENERATION_WAIT_TIME", "", "listOfBlockingPreflightsMarkedAsPassed", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003JI\u0010\u001a\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$MigrationData;", "", "preflightChecksResult", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "Lcom/atlassian/jira/migration/preflight/model/CheckExecutionResult;", "cloudId", "", "migrationType", "Lcom/atlassian/jira/migration/plan/MigrationType;", "containerToken", "migrationScopeId", "(Lcom/google/common/util/concurrent/ListenableFuture;Ljava/lang/String;Lcom/atlassian/jira/migration/plan/MigrationType;Ljava/lang/String;Ljava/lang/String;)V", "getCloudId", "()Ljava/lang/String;", "getContainerToken", "getMigrationScopeId", "getMigrationType", "()Lcom/atlassian/jira/migration/plan/MigrationType;", "getPreflightChecksResult", "()Lcom/google/common/util/concurrent/ListenableFuture;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class MigrationData {
        @NotNull
        private final ListenableFuture<List<CheckExecutionResult>> preflightChecksResult;
        @NotNull
        private final String cloudId;
        @Nullable
        private final MigrationType migrationType;
        @NotNull
        private final String containerToken;
        @NotNull
        private final String migrationScopeId;

        public MigrationData(@NotNull ListenableFuture<List<CheckExecutionResult>> preflightChecksResult, @NotNull String cloudId2, @Nullable MigrationType migrationType, @NotNull String containerToken, @NotNull String migrationScopeId2) {
            Intrinsics.checkNotNullParameter(preflightChecksResult, (String)"preflightChecksResult");
            Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
            Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
            Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
            this.preflightChecksResult = preflightChecksResult;
            this.cloudId = cloudId2;
            this.migrationType = migrationType;
            this.containerToken = containerToken;
            this.migrationScopeId = migrationScopeId2;
        }

        @NotNull
        public final ListenableFuture<List<CheckExecutionResult>> getPreflightChecksResult() {
            return this.preflightChecksResult;
        }

        @NotNull
        public final String getCloudId() {
            return this.cloudId;
        }

        @Nullable
        public final MigrationType getMigrationType() {
            return this.migrationType;
        }

        @NotNull
        public final String getContainerToken() {
            return this.containerToken;
        }

        @NotNull
        public final String getMigrationScopeId() {
            return this.migrationScopeId;
        }

        @NotNull
        public final ListenableFuture<List<CheckExecutionResult>> component1() {
            return this.preflightChecksResult;
        }

        @NotNull
        public final String component2() {
            return this.cloudId;
        }

        @Nullable
        public final MigrationType component3() {
            return this.migrationType;
        }

        @NotNull
        public final String component4() {
            return this.containerToken;
        }

        @NotNull
        public final String component5() {
            return this.migrationScopeId;
        }

        @NotNull
        public final MigrationData copy(@NotNull ListenableFuture<List<CheckExecutionResult>> preflightChecksResult, @NotNull String cloudId2, @Nullable MigrationType migrationType, @NotNull String containerToken, @NotNull String migrationScopeId2) {
            Intrinsics.checkNotNullParameter(preflightChecksResult, (String)"preflightChecksResult");
            Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
            Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
            Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
            return new MigrationData(preflightChecksResult, cloudId2, migrationType, containerToken, migrationScopeId2);
        }

        public static /* synthetic */ MigrationData copy$default(MigrationData migrationData, ListenableFuture listenableFuture, String string, MigrationType migrationType, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                listenableFuture = migrationData.preflightChecksResult;
            }
            if ((n & 2) != 0) {
                string = migrationData.cloudId;
            }
            if ((n & 4) != 0) {
                migrationType = migrationData.migrationType;
            }
            if ((n & 8) != 0) {
                string2 = migrationData.containerToken;
            }
            if ((n & 0x10) != 0) {
                string3 = migrationData.migrationScopeId;
            }
            return migrationData.copy(listenableFuture, string, migrationType, string2, string3);
        }

        @NotNull
        public String toString() {
            return "MigrationData(preflightChecksResult=" + this.preflightChecksResult + ", cloudId=" + this.cloudId + ", migrationType=" + (Object)((Object)this.migrationType) + ", containerToken=" + this.containerToken + ", migrationScopeId=" + this.migrationScopeId + ')';
        }

        public int hashCode() {
            int result2 = this.preflightChecksResult.hashCode();
            result2 = result2 * 31 + this.cloudId.hashCode();
            result2 = result2 * 31 + (this.migrationType == null ? 0 : this.migrationType.hashCode());
            result2 = result2 * 31 + this.containerToken.hashCode();
            result2 = result2 * 31 + this.migrationScopeId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MigrationData)) {
                return false;
            }
            MigrationData migrationData = (MigrationData)other;
            if (!Intrinsics.areEqual(this.preflightChecksResult, migrationData.preflightChecksResult)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cloudId, (Object)migrationData.cloudId)) {
                return false;
            }
            if (this.migrationType != migrationData.migrationType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.containerToken, (Object)migrationData.containerToken)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.migrationScopeId, (Object)migrationData.migrationScopeId);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$PreMigrationReportData;", "", "usersData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$UsersData;", "migrationData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$MigrationData;", "projectData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$ProjectsData;", "appsData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$AppsData;", "(Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$UsersData;Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$MigrationData;Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$ProjectsData;Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$AppsData;)V", "getAppsData", "()Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$AppsData;", "getMigrationData", "()Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$MigrationData;", "getProjectData", "()Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$ProjectsData;", "getUsersData", "()Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$UsersData;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class PreMigrationReportData {
        @NotNull
        private final UsersData usersData;
        @NotNull
        private final MigrationData migrationData;
        @NotNull
        private final ProjectsData projectData;
        @NotNull
        private final AppsData appsData;

        public PreMigrationReportData(@NotNull UsersData usersData, @NotNull MigrationData migrationData, @NotNull ProjectsData projectData, @NotNull AppsData appsData) {
            Intrinsics.checkNotNullParameter((Object)usersData, (String)"usersData");
            Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
            Intrinsics.checkNotNullParameter((Object)projectData, (String)"projectData");
            Intrinsics.checkNotNullParameter((Object)appsData, (String)"appsData");
            this.usersData = usersData;
            this.migrationData = migrationData;
            this.projectData = projectData;
            this.appsData = appsData;
        }

        @NotNull
        public final UsersData getUsersData() {
            return this.usersData;
        }

        @NotNull
        public final MigrationData getMigrationData() {
            return this.migrationData;
        }

        @NotNull
        public final ProjectsData getProjectData() {
            return this.projectData;
        }

        @NotNull
        public final AppsData getAppsData() {
            return this.appsData;
        }

        @NotNull
        public final UsersData component1() {
            return this.usersData;
        }

        @NotNull
        public final MigrationData component2() {
            return this.migrationData;
        }

        @NotNull
        public final ProjectsData component3() {
            return this.projectData;
        }

        @NotNull
        public final AppsData component4() {
            return this.appsData;
        }

        @NotNull
        public final PreMigrationReportData copy(@NotNull UsersData usersData, @NotNull MigrationData migrationData, @NotNull ProjectsData projectData, @NotNull AppsData appsData) {
            Intrinsics.checkNotNullParameter((Object)usersData, (String)"usersData");
            Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
            Intrinsics.checkNotNullParameter((Object)projectData, (String)"projectData");
            Intrinsics.checkNotNullParameter((Object)appsData, (String)"appsData");
            return new PreMigrationReportData(usersData, migrationData, projectData, appsData);
        }

        public static /* synthetic */ PreMigrationReportData copy$default(PreMigrationReportData preMigrationReportData, UsersData usersData, MigrationData migrationData, ProjectsData projectsData, AppsData appsData, int n, Object object) {
            if ((n & 1) != 0) {
                usersData = preMigrationReportData.usersData;
            }
            if ((n & 2) != 0) {
                migrationData = preMigrationReportData.migrationData;
            }
            if ((n & 4) != 0) {
                projectsData = preMigrationReportData.projectData;
            }
            if ((n & 8) != 0) {
                appsData = preMigrationReportData.appsData;
            }
            return preMigrationReportData.copy(usersData, migrationData, projectsData, appsData);
        }

        @NotNull
        public String toString() {
            return "PreMigrationReportData(usersData=" + this.usersData + ", migrationData=" + this.migrationData + ", projectData=" + this.projectData + ", appsData=" + this.appsData + ')';
        }

        public int hashCode() {
            int result2 = this.usersData.hashCode();
            result2 = result2 * 31 + this.migrationData.hashCode();
            result2 = result2 * 31 + this.projectData.hashCode();
            result2 = result2 * 31 + this.appsData.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PreMigrationReportData)) {
                return false;
            }
            PreMigrationReportData preMigrationReportData = (PreMigrationReportData)other;
            if (!Intrinsics.areEqual((Object)this.usersData, (Object)preMigrationReportData.usersData)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.migrationData, (Object)preMigrationReportData.migrationData)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.projectData, (Object)preMigrationReportData.projectData)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.appsData, (Object)preMigrationReportData.appsData);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u0010\u0010%\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0019J\t\u0010&\u001a\u00020\u0010H\u00c6\u0003Jf\u0010'\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020\u000e2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$ProjectsData;", "", "projectKeys", "", "", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "singlePathMode", "Lcom/atlassian/jira/migration/plan/SinglePathMode;", "advancedRoadmapsPlanIds", "", "crossProjectConfig", "Lcom/atlassian/jira/migration/plan/CrossProjectConfig;", "migrateArchivedIssues", "", "dataFilterContext", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "(Ljava/util/List;Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;Lcom/atlassian/jira/migration/plan/SinglePathMode;Ljava/util/List;Lcom/atlassian/jira/migration/plan/CrossProjectConfig;Ljava/lang/Boolean;Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;)V", "getAdvancedRoadmapsPlanIds", "()Ljava/util/List;", "getCrossProjectConfig", "()Lcom/atlassian/jira/migration/plan/CrossProjectConfig;", "getDataFilterContext", "()Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "getMigrateArchivedIssues", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getProjectDataMigrationMode", "()Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "getProjectKeys", "getSinglePathMode", "()Lcom/atlassian/jira/migration/plan/SinglePathMode;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/util/List;Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;Lcom/atlassian/jira/migration/plan/SinglePathMode;Ljava/util/List;Lcom/atlassian/jira/migration/plan/CrossProjectConfig;Ljava/lang/Boolean;Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;)Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$ProjectsData;", "equals", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class ProjectsData {
        @NotNull
        private final List<String> projectKeys;
        @NotNull
        private final ProjectDataMigrationMode projectDataMigrationMode;
        @Nullable
        private final SinglePathMode singlePathMode;
        @NotNull
        private final List<Long> advancedRoadmapsPlanIds;
        @Nullable
        private final CrossProjectConfig crossProjectConfig;
        @Nullable
        private final Boolean migrateArchivedIssues;
        @NotNull
        private final DataFilterContext dataFilterContext;

        public ProjectsData(@NotNull List<String> projectKeys, @NotNull ProjectDataMigrationMode projectDataMigrationMode, @Nullable SinglePathMode singlePathMode, @NotNull List<Long> advancedRoadmapsPlanIds, @Nullable CrossProjectConfig crossProjectConfig, @Nullable Boolean migrateArchivedIssues, @NotNull DataFilterContext dataFilterContext) {
            Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
            Intrinsics.checkNotNullParameter((Object)((Object)projectDataMigrationMode), (String)"projectDataMigrationMode");
            Intrinsics.checkNotNullParameter(advancedRoadmapsPlanIds, (String)"advancedRoadmapsPlanIds");
            Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
            this.projectKeys = projectKeys;
            this.projectDataMigrationMode = projectDataMigrationMode;
            this.singlePathMode = singlePathMode;
            this.advancedRoadmapsPlanIds = advancedRoadmapsPlanIds;
            this.crossProjectConfig = crossProjectConfig;
            this.migrateArchivedIssues = migrateArchivedIssues;
            this.dataFilterContext = dataFilterContext;
        }

        public /* synthetic */ ProjectsData(List list, ProjectDataMigrationMode projectDataMigrationMode, SinglePathMode singlePathMode, List list2, CrossProjectConfig crossProjectConfig, Boolean bl, DataFilterContext dataFilterContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                bl = false;
            }
            if ((n & 0x40) != 0) {
                dataFilterContext = new DataFilterContext(null, null, null, 7, null);
            }
            this(list, projectDataMigrationMode, singlePathMode, list2, crossProjectConfig, bl, dataFilterContext);
        }

        @NotNull
        public final List<String> getProjectKeys() {
            return this.projectKeys;
        }

        @NotNull
        public final ProjectDataMigrationMode getProjectDataMigrationMode() {
            return this.projectDataMigrationMode;
        }

        @Nullable
        public final SinglePathMode getSinglePathMode() {
            return this.singlePathMode;
        }

        @NotNull
        public final List<Long> getAdvancedRoadmapsPlanIds() {
            return this.advancedRoadmapsPlanIds;
        }

        @Nullable
        public final CrossProjectConfig getCrossProjectConfig() {
            return this.crossProjectConfig;
        }

        @Nullable
        public final Boolean getMigrateArchivedIssues() {
            return this.migrateArchivedIssues;
        }

        @NotNull
        public final DataFilterContext getDataFilterContext() {
            return this.dataFilterContext;
        }

        @NotNull
        public final List<String> component1() {
            return this.projectKeys;
        }

        @NotNull
        public final ProjectDataMigrationMode component2() {
            return this.projectDataMigrationMode;
        }

        @Nullable
        public final SinglePathMode component3() {
            return this.singlePathMode;
        }

        @NotNull
        public final List<Long> component4() {
            return this.advancedRoadmapsPlanIds;
        }

        @Nullable
        public final CrossProjectConfig component5() {
            return this.crossProjectConfig;
        }

        @Nullable
        public final Boolean component6() {
            return this.migrateArchivedIssues;
        }

        @NotNull
        public final DataFilterContext component7() {
            return this.dataFilterContext;
        }

        @NotNull
        public final ProjectsData copy(@NotNull List<String> projectKeys, @NotNull ProjectDataMigrationMode projectDataMigrationMode, @Nullable SinglePathMode singlePathMode, @NotNull List<Long> advancedRoadmapsPlanIds, @Nullable CrossProjectConfig crossProjectConfig, @Nullable Boolean migrateArchivedIssues, @NotNull DataFilterContext dataFilterContext) {
            Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
            Intrinsics.checkNotNullParameter((Object)((Object)projectDataMigrationMode), (String)"projectDataMigrationMode");
            Intrinsics.checkNotNullParameter(advancedRoadmapsPlanIds, (String)"advancedRoadmapsPlanIds");
            Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
            return new ProjectsData(projectKeys, projectDataMigrationMode, singlePathMode, advancedRoadmapsPlanIds, crossProjectConfig, migrateArchivedIssues, dataFilterContext);
        }

        public static /* synthetic */ ProjectsData copy$default(ProjectsData projectsData, List list, ProjectDataMigrationMode projectDataMigrationMode, SinglePathMode singlePathMode, List list2, CrossProjectConfig crossProjectConfig, Boolean bl, DataFilterContext dataFilterContext, int n, Object object) {
            if ((n & 1) != 0) {
                list = projectsData.projectKeys;
            }
            if ((n & 2) != 0) {
                projectDataMigrationMode = projectsData.projectDataMigrationMode;
            }
            if ((n & 4) != 0) {
                singlePathMode = projectsData.singlePathMode;
            }
            if ((n & 8) != 0) {
                list2 = projectsData.advancedRoadmapsPlanIds;
            }
            if ((n & 0x10) != 0) {
                crossProjectConfig = projectsData.crossProjectConfig;
            }
            if ((n & 0x20) != 0) {
                bl = projectsData.migrateArchivedIssues;
            }
            if ((n & 0x40) != 0) {
                dataFilterContext = projectsData.dataFilterContext;
            }
            return projectsData.copy(list, projectDataMigrationMode, singlePathMode, list2, crossProjectConfig, bl, dataFilterContext);
        }

        @NotNull
        public String toString() {
            return "ProjectsData(projectKeys=" + this.projectKeys + ", projectDataMigrationMode=" + (Object)((Object)this.projectDataMigrationMode) + ", singlePathMode=" + (Object)((Object)this.singlePathMode) + ", advancedRoadmapsPlanIds=" + this.advancedRoadmapsPlanIds + ", crossProjectConfig=" + this.crossProjectConfig + ", migrateArchivedIssues=" + this.migrateArchivedIssues + ", dataFilterContext=" + this.dataFilterContext + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.projectKeys).hashCode();
            result2 = result2 * 31 + this.projectDataMigrationMode.hashCode();
            result2 = result2 * 31 + (this.singlePathMode == null ? 0 : this.singlePathMode.hashCode());
            result2 = result2 * 31 + ((Object)this.advancedRoadmapsPlanIds).hashCode();
            result2 = result2 * 31 + (this.crossProjectConfig == null ? 0 : this.crossProjectConfig.hashCode());
            result2 = result2 * 31 + (this.migrateArchivedIssues == null ? 0 : ((Object)this.migrateArchivedIssues).hashCode());
            result2 = result2 * 31 + this.dataFilterContext.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectsData)) {
                return false;
            }
            ProjectsData projectsData = (ProjectsData)other;
            if (!Intrinsics.areEqual(this.projectKeys, projectsData.projectKeys)) {
                return false;
            }
            if (this.projectDataMigrationMode != projectsData.projectDataMigrationMode) {
                return false;
            }
            if (this.singlePathMode != projectsData.singlePathMode) {
                return false;
            }
            if (!Intrinsics.areEqual(this.advancedRoadmapsPlanIds, projectsData.advancedRoadmapsPlanIds)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.crossProjectConfig, (Object)projectsData.crossProjectConfig)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.migrateArchivedIssues, (Object)projectsData.migrateArchivedIssues)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dataFilterContext, (Object)projectsData.dataFilterContext);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u0011\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J?\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$UsersData;", "", "usersGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "usersAndGroups", "Ljava/util/concurrent/CompletableFuture;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "customers", "loggedInUser", "Lcom/atlassian/jira/user/ApplicationUser;", "(Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;Ljava/util/concurrent/CompletableFuture;Ljava/util/concurrent/CompletableFuture;Lcom/atlassian/jira/user/ApplicationUser;)V", "getCustomers", "()Ljava/util/concurrent/CompletableFuture;", "getLoggedInUser", "()Lcom/atlassian/jira/user/ApplicationUser;", "getUsersAndGroups", "getUsersGroupsMigrationOption", "()Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jira-migration-plugin"})
    public static final class UsersData {
        @NotNull
        private final UsersGroupsMigrationOption usersGroupsMigrationOption;
        @NotNull
        private final CompletableFuture<UsersGroupsExtractionResult> usersAndGroups;
        @Nullable
        private final CompletableFuture<UsersGroupsExtractionResult> customers;
        @NotNull
        private final ApplicationUser loggedInUser;

        public UsersData(@NotNull UsersGroupsMigrationOption usersGroupsMigrationOption, @NotNull CompletableFuture<UsersGroupsExtractionResult> usersAndGroups, @Nullable CompletableFuture<UsersGroupsExtractionResult> customers, @NotNull ApplicationUser loggedInUser) {
            Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
            Intrinsics.checkNotNullParameter(usersAndGroups, (String)"usersAndGroups");
            Intrinsics.checkNotNullParameter((Object)loggedInUser, (String)"loggedInUser");
            this.usersGroupsMigrationOption = usersGroupsMigrationOption;
            this.usersAndGroups = usersAndGroups;
            this.customers = customers;
            this.loggedInUser = loggedInUser;
        }

        @NotNull
        public final UsersGroupsMigrationOption getUsersGroupsMigrationOption() {
            return this.usersGroupsMigrationOption;
        }

        @NotNull
        public final CompletableFuture<UsersGroupsExtractionResult> getUsersAndGroups() {
            return this.usersAndGroups;
        }

        @Nullable
        public final CompletableFuture<UsersGroupsExtractionResult> getCustomers() {
            return this.customers;
        }

        @NotNull
        public final ApplicationUser getLoggedInUser() {
            return this.loggedInUser;
        }

        @NotNull
        public final UsersGroupsMigrationOption component1() {
            return this.usersGroupsMigrationOption;
        }

        @NotNull
        public final CompletableFuture<UsersGroupsExtractionResult> component2() {
            return this.usersAndGroups;
        }

        @Nullable
        public final CompletableFuture<UsersGroupsExtractionResult> component3() {
            return this.customers;
        }

        @NotNull
        public final ApplicationUser component4() {
            return this.loggedInUser;
        }

        @NotNull
        public final UsersData copy(@NotNull UsersGroupsMigrationOption usersGroupsMigrationOption, @NotNull CompletableFuture<UsersGroupsExtractionResult> usersAndGroups, @Nullable CompletableFuture<UsersGroupsExtractionResult> customers, @NotNull ApplicationUser loggedInUser) {
            Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
            Intrinsics.checkNotNullParameter(usersAndGroups, (String)"usersAndGroups");
            Intrinsics.checkNotNullParameter((Object)loggedInUser, (String)"loggedInUser");
            return new UsersData(usersGroupsMigrationOption, usersAndGroups, customers, loggedInUser);
        }

        public static /* synthetic */ UsersData copy$default(UsersData usersData, UsersGroupsMigrationOption usersGroupsMigrationOption, CompletableFuture completableFuture, CompletableFuture completableFuture2, ApplicationUser applicationUser, int n, Object object) {
            if ((n & 1) != 0) {
                usersGroupsMigrationOption = usersData.usersGroupsMigrationOption;
            }
            if ((n & 2) != 0) {
                completableFuture = usersData.usersAndGroups;
            }
            if ((n & 4) != 0) {
                completableFuture2 = usersData.customers;
            }
            if ((n & 8) != 0) {
                applicationUser = usersData.loggedInUser;
            }
            return usersData.copy(usersGroupsMigrationOption, completableFuture, completableFuture2, applicationUser);
        }

        @NotNull
        public String toString() {
            return "UsersData(usersGroupsMigrationOption=" + this.usersGroupsMigrationOption + ", usersAndGroups=" + this.usersAndGroups + ", customers=" + this.customers + ", loggedInUser=" + this.loggedInUser + ')';
        }

        public int hashCode() {
            int result2 = this.usersGroupsMigrationOption.hashCode();
            result2 = result2 * 31 + this.usersAndGroups.hashCode();
            result2 = result2 * 31 + (this.customers == null ? 0 : this.customers.hashCode());
            result2 = result2 * 31 + this.loggedInUser.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UsersData)) {
                return false;
            }
            UsersData usersData = (UsersData)other;
            if (!Intrinsics.areEqual((Object)this.usersGroupsMigrationOption, (Object)usersData.usersGroupsMigrationOption)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.usersAndGroups, usersData.usersAndGroups)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.customers, usersData.customers)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.loggedInUser, (Object)usersData.loggedInUser);
        }
    }
}

