/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.export.ReportExportOutcome;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.reports.ConfigItemsReportService;
import com.atlassian.jira.migration.preflight.reports.DuplicateEntitiesReportService;
import com.atlassian.jira.migration.preflight.reports.PreMigrationReportsService;
import com.atlassian.jira.migration.preflight.reports.RequiresAttentionPreReportService;
import com.atlassian.jira.migration.preflight.reports.SummaryReportService;
import com.atlassian.jira.migration.preflight.reports.UsersGroupsReportService;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 62\u00020\u0001:\u00016B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003J\t\u0010 \u001a\u00020\rH\u00c6\u0003JE\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J6\u0010)\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\t\u00103\u001a\u000204H\u00d6\u0001J\t\u00105\u001a\u00020%H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00067"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PreMigrationServicesProvider;", "", "usersGroupsReportService", "Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsReportService;", "requiresAttentionPreReportService", "Lcom/atlassian/jira/migration/preflight/reports/RequiresAttentionPreReportService;", "summaryReportService", "Lcom/atlassian/jira/migration/preflight/reports/SummaryReportService;", "configItemsReportService", "Lcom/atlassian/jira/migration/preflight/reports/ConfigItemsReportService;", "duplicateEntitiesReportService", "Lcom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsReportService;Lcom/atlassian/jira/migration/preflight/reports/RequiresAttentionPreReportService;Lcom/atlassian/jira/migration/preflight/reports/SummaryReportService;Lcom/atlassian/jira/migration/preflight/reports/ConfigItemsReportService;Lcom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "getConfigItemsReportService", "()Lcom/atlassian/jira/migration/preflight/reports/ConfigItemsReportService;", "getDuplicateEntitiesReportService", "()Lcom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportService;", "getMigrationFeatures", "()Lcom/atlassian/jira/migration/features/MigrationFeatures;", "getRequiresAttentionPreReportService", "()Lcom/atlassian/jira/migration/preflight/reports/RequiresAttentionPreReportService;", "getSummaryReportService", "()Lcom/atlassian/jira/migration/preflight/reports/SummaryReportService;", "getUsersGroupsReportService", "()Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsReportService;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "deleteReportDataByExecutionId", "", "executionId", "", "equals", "", "other", "generateReportData", "reportsData", "Lcom/atlassian/jira/migration/export/ReportExportOutcome;", "isUserGroupsIncluded", "usersData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$UsersData;", "migrationData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$MigrationData;", "projectsData", "Lcom/atlassian/jira/migration/preflight/reports/PreMigrationReportsService$ProjectsData;", "hashCode", "", "toString", "Companion", "jira-migration-plugin"})
public final class PreMigrationServicesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsersGroupsReportService usersGroupsReportService;
    @NotNull
    private final RequiresAttentionPreReportService requiresAttentionPreReportService;
    @NotNull
    private final SummaryReportService summaryReportService;
    @NotNull
    private final ConfigItemsReportService configItemsReportService;
    @NotNull
    private final DuplicateEntitiesReportService duplicateEntitiesReportService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final Logger log = LoggerFactory.getLogger(PreMigrationServicesProvider.class);

    @Inject
    public PreMigrationServicesProvider(@NotNull UsersGroupsReportService usersGroupsReportService, @NotNull RequiresAttentionPreReportService requiresAttentionPreReportService, @NotNull SummaryReportService summaryReportService, @NotNull ConfigItemsReportService configItemsReportService, @NotNull DuplicateEntitiesReportService duplicateEntitiesReportService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)usersGroupsReportService, (String)"usersGroupsReportService");
        Intrinsics.checkNotNullParameter((Object)requiresAttentionPreReportService, (String)"requiresAttentionPreReportService");
        Intrinsics.checkNotNullParameter((Object)summaryReportService, (String)"summaryReportService");
        Intrinsics.checkNotNullParameter((Object)configItemsReportService, (String)"configItemsReportService");
        Intrinsics.checkNotNullParameter((Object)duplicateEntitiesReportService, (String)"duplicateEntitiesReportService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.usersGroupsReportService = usersGroupsReportService;
        this.requiresAttentionPreReportService = requiresAttentionPreReportService;
        this.summaryReportService = summaryReportService;
        this.configItemsReportService = configItemsReportService;
        this.duplicateEntitiesReportService = duplicateEntitiesReportService;
        this.migrationFeatures = migrationFeatures;
    }

    @NotNull
    public final UsersGroupsReportService getUsersGroupsReportService() {
        return this.usersGroupsReportService;
    }

    @NotNull
    public final RequiresAttentionPreReportService getRequiresAttentionPreReportService() {
        return this.requiresAttentionPreReportService;
    }

    @NotNull
    public final SummaryReportService getSummaryReportService() {
        return this.summaryReportService;
    }

    @NotNull
    public final ConfigItemsReportService getConfigItemsReportService() {
        return this.configItemsReportService;
    }

    @NotNull
    public final DuplicateEntitiesReportService getDuplicateEntitiesReportService() {
        return this.duplicateEntitiesReportService;
    }

    @NotNull
    public final MigrationFeatures getMigrationFeatures() {
        return this.migrationFeatures;
    }

    public final void generateReportData(@NotNull String executionId, @NotNull ReportExportOutcome reportsData, boolean isUserGroupsIncluded, @NotNull PreMigrationReportsService.UsersData usersData, @NotNull PreMigrationReportsService.MigrationData migrationData, @NotNull PreMigrationReportsService.ProjectsData projectsData) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)reportsData, (String)"reportsData");
        Intrinsics.checkNotNullParameter((Object)usersData, (String)"usersData");
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        Intrinsics.checkNotNullParameter((Object)projectsData, (String)"projectsData");
        if (isUserGroupsIncluded) {
            log.info("User pre migration report started for execution id: " + executionId);
            this.usersGroupsReportService.generateReportData(executionId, usersData.getUsersGroupsMigrationOption(), usersData.getUsersAndGroups());
        }
        log.info("Requires attention pre migration report started for execution id: " + executionId);
        this.requiresAttentionPreReportService.generateReportData(executionId, reportsData.getUnsupportedEntities(), migrationData.getPreflightChecksResult());
        log.info("Summary pre migration report started for execution id: " + executionId);
        this.summaryReportService.generateReportData(executionId, reportsData.getProjectEntityTypeCounts(), reportsData.getGlobalEntityMRIs(), usersData.getUsersAndGroups(), usersData.getCustomers());
        log.info("Config Items pre migration report started for execution id: " + executionId);
        this.configItemsReportService.generateReportData(executionId, reportsData.getConfigItems());
        if (this.migrationFeatures.getEnableDuplicateEntityReports()) {
            log.info("Duplicate entity pre migration report started for execution id: " + executionId);
            this.duplicateEntitiesReportService.generateReportData(executionId, migrationData.getCloudId(), projectsData.getProjectKeys(), usersData.getLoggedInUser());
        } else {
            log.info("Duplicate entity pre migration report skipped for execution id: " + executionId);
        }
    }

    public final void deleteReportDataByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.usersGroupsReportService.deleteReportDataByExecutionId(executionId);
        this.configItemsReportService.deleteReportDataByExecutionId(executionId);
        this.requiresAttentionPreReportService.deleteReportDataByExecutionId(executionId);
        this.summaryReportService.deleteReportDataByExecutionId(executionId);
        if (this.migrationFeatures.getEnableDuplicateEntityReports()) {
            this.duplicateEntitiesReportService.deleteReportDataByExecutionId(executionId);
        }
    }

    @NotNull
    public final UsersGroupsReportService component1() {
        return this.usersGroupsReportService;
    }

    @NotNull
    public final RequiresAttentionPreReportService component2() {
        return this.requiresAttentionPreReportService;
    }

    @NotNull
    public final SummaryReportService component3() {
        return this.summaryReportService;
    }

    @NotNull
    public final ConfigItemsReportService component4() {
        return this.configItemsReportService;
    }

    @NotNull
    public final DuplicateEntitiesReportService component5() {
        return this.duplicateEntitiesReportService;
    }

    @NotNull
    public final MigrationFeatures component6() {
        return this.migrationFeatures;
    }

    @NotNull
    public final PreMigrationServicesProvider copy(@NotNull UsersGroupsReportService usersGroupsReportService, @NotNull RequiresAttentionPreReportService requiresAttentionPreReportService, @NotNull SummaryReportService summaryReportService, @NotNull ConfigItemsReportService configItemsReportService, @NotNull DuplicateEntitiesReportService duplicateEntitiesReportService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)usersGroupsReportService, (String)"usersGroupsReportService");
        Intrinsics.checkNotNullParameter((Object)requiresAttentionPreReportService, (String)"requiresAttentionPreReportService");
        Intrinsics.checkNotNullParameter((Object)summaryReportService, (String)"summaryReportService");
        Intrinsics.checkNotNullParameter((Object)configItemsReportService, (String)"configItemsReportService");
        Intrinsics.checkNotNullParameter((Object)duplicateEntitiesReportService, (String)"duplicateEntitiesReportService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        return new PreMigrationServicesProvider(usersGroupsReportService, requiresAttentionPreReportService, summaryReportService, configItemsReportService, duplicateEntitiesReportService, migrationFeatures);
    }

    public static /* synthetic */ PreMigrationServicesProvider copy$default(PreMigrationServicesProvider preMigrationServicesProvider, UsersGroupsReportService usersGroupsReportService, RequiresAttentionPreReportService requiresAttentionPreReportService, SummaryReportService summaryReportService, ConfigItemsReportService configItemsReportService, DuplicateEntitiesReportService duplicateEntitiesReportService, MigrationFeatures migrationFeatures, int n, Object object) {
        if ((n & 1) != 0) {
            usersGroupsReportService = preMigrationServicesProvider.usersGroupsReportService;
        }
        if ((n & 2) != 0) {
            requiresAttentionPreReportService = preMigrationServicesProvider.requiresAttentionPreReportService;
        }
        if ((n & 4) != 0) {
            summaryReportService = preMigrationServicesProvider.summaryReportService;
        }
        if ((n & 8) != 0) {
            configItemsReportService = preMigrationServicesProvider.configItemsReportService;
        }
        if ((n & 0x10) != 0) {
            duplicateEntitiesReportService = preMigrationServicesProvider.duplicateEntitiesReportService;
        }
        if ((n & 0x20) != 0) {
            migrationFeatures = preMigrationServicesProvider.migrationFeatures;
        }
        return preMigrationServicesProvider.copy(usersGroupsReportService, requiresAttentionPreReportService, summaryReportService, configItemsReportService, duplicateEntitiesReportService, migrationFeatures);
    }

    @NotNull
    public String toString() {
        return "PreMigrationServicesProvider(usersGroupsReportService=" + this.usersGroupsReportService + ", requiresAttentionPreReportService=" + this.requiresAttentionPreReportService + ", summaryReportService=" + this.summaryReportService + ", configItemsReportService=" + this.configItemsReportService + ", duplicateEntitiesReportService=" + this.duplicateEntitiesReportService + ", migrationFeatures=" + this.migrationFeatures + ')';
    }

    public int hashCode() {
        int result2 = this.usersGroupsReportService.hashCode();
        result2 = result2 * 31 + this.requiresAttentionPreReportService.hashCode();
        result2 = result2 * 31 + this.summaryReportService.hashCode();
        result2 = result2 * 31 + this.configItemsReportService.hashCode();
        result2 = result2 * 31 + this.duplicateEntitiesReportService.hashCode();
        result2 = result2 * 31 + this.migrationFeatures.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PreMigrationServicesProvider)) {
            return false;
        }
        PreMigrationServicesProvider preMigrationServicesProvider = (PreMigrationServicesProvider)other;
        if (!Intrinsics.areEqual((Object)this.usersGroupsReportService, (Object)preMigrationServicesProvider.usersGroupsReportService)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.requiresAttentionPreReportService, (Object)preMigrationServicesProvider.requiresAttentionPreReportService)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.summaryReportService, (Object)preMigrationServicesProvider.summaryReportService)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.configItemsReportService, (Object)preMigrationServicesProvider.configItemsReportService)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.duplicateEntitiesReportService, (Object)preMigrationServicesProvider.duplicateEntitiesReportService)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.migrationFeatures, (Object)preMigrationServicesProvider.migrationFeatures);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/PreMigrationServicesProvider$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

