/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.migration.preflight.reports.UsersGroupsExtraction;
import com.atlassian.jira.migration.preflight.reports.UsersGroupsExtractionRepository;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.UserAnonymizationHandler;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/ReportUserAnonymizationHandler;", "Lcom/atlassian/jira/user/anonymize/UserAnonymizationHandler;", "usersGroupsExtractionRepository", "Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsExtractionRepository;", "(Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsExtractionRepository;)V", "getAffectedEntities", "", "Lcom/atlassian/jira/user/anonymize/AffectedEntity;", "parameter", "Lcom/atlassian/jira/user/anonymize/UserAnonymizationParameter;", "update", "Lcom/atlassian/jira/bc/ServiceResult;", "jira-migration-plugin"})
public final class ReportUserAnonymizationHandler
implements UserAnonymizationHandler {
    @NotNull
    private final UsersGroupsExtractionRepository usersGroupsExtractionRepository;

    public ReportUserAnonymizationHandler(@NotNull UsersGroupsExtractionRepository usersGroupsExtractionRepository) {
        Intrinsics.checkNotNullParameter((Object)usersGroupsExtractionRepository, (String)"usersGroupsExtractionRepository");
        this.usersGroupsExtractionRepository = usersGroupsExtractionRepository;
    }

    @NotNull
    public ServiceResult update(@NotNull UserAnonymizationParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        String string = parameter.getUserKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserKey(...)");
        this.usersGroupsExtractionRepository.deleteByUserKey(string);
        return (ServiceResult)new ServiceResultImpl();
    }

    @NotNull
    public Collection<AffectedEntity> getAffectedEntities(@NotNull UserAnonymizationParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        String string = parameter.getUserKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserKey(...)");
        List<UsersGroupsExtraction> records = this.usersGroupsExtractionRepository.findByUserKey(string);
        return CollectionsKt.toMutableList((Collection)(records.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.REMOVE).descriptionKey("Users and Groups Report").numberOfOccurrences(Long.valueOf(records.size())).build())));
    }
}

