/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.SummaryEntitiesCalculatedEvent;
import com.atlassian.jira.migration.events.SummaryEntityCount;
import com.atlassian.jira.migration.export.model.ExpectedProjectEntityTypeCount;
import com.atlassian.jira.migration.export.model.UnsupportedEntity;
import com.atlassian.jira.migration.export.utils.JsdExportUtil;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.reports.AbstractReportService;
import com.atlassian.jira.migration.preflight.reports.ExpectedMigrationCounts;
import com.atlassian.jira.migration.preflight.reports.ExpectedMigrationCountsRepository;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatusRepository;
import com.atlassian.jira.migration.preflight.reports.ModelKt;
import com.atlassian.jira.migration.preflight.reports.ProblemType;
import com.atlassian.jira.migration.preflight.reports.ReportType;
import com.atlassian.jira.migration.preflight.reports.SummaryReportOutput;
import com.atlassian.jira.migration.preflight.reports.SummaryReportRow;
import com.atlassian.jira.migration.preflight.reports.UnsupportedEntityRepository;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.core.MigrationCoreMriRegistry;
import com.atlassian.migration.jira.advancedroadmaps.Plan;
import com.atlassian.migration.jira.classic.customfield.CustomField;
import com.atlassian.migration.jira.classic.notification.NotificationScheme;
import com.atlassian.migration.jira.classic.permission.PermissionScheme;
import com.atlassian.migration.jira.classic.software.rapidview.RapidView;
import com.atlassian.migration.jira.classic.workflow.Workflow;
import com.atlassian.migration.jira.core.Filter;
import com.atlassian.migration.jira.core.Issue;
import com.atlassian.migration.jira.core.attachment.FileAttachment;
import com.atlassian.migration.jira.core.portalpage.PortalPage;
import com.atlassian.migration.jira.core.portalpage.PortletConfiguration;
import com.atlassian.migration.jira.core.projectrole.ProjectRole;
import com.atlassian.migration.jira.servicedesk.Calendar;
import com.atlassian.migration.jira.servicedesk.Queue;
import com.atlassian.migration.jira.servicedesk.TimeMetric;
import com.atlassian.migration.jira.servicedesk.automation.AutomationRules;
import com.atlassian.migration.jira.servicedesk.report.Report;
import com.atlassian.migration.jira.servicedesk.requestype.RequestType;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0001?BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0002J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0018H\u0002J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001eH\u0002J2\u0010(\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0*\u0012\u0004\u0012\u00020+0)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0018H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u00100\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u001bJH\u00102\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dJ\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\b\u00105\u001a\u0004\u0018\u00010\u001bJ\u001e\u00106\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u001b2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J:\u00108\u001a\u0002012\"\u00109\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0*\u0012\u0004\u0012\u00020+0:2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0018H\u0002J:\u0010;\u001a\u0002012\"\u00109\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0*\u0012\u0004\u0012\u00020+0:2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0018H\u0002J\u0018\u0010<\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020>H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/SummaryReportService;", "Lcom/atlassian/jira/migration/preflight/reports/AbstractReportService;", "reportStatusRepository", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "expectedMigrationCountsRepository", "Lcom/atlassian/jira/migration/preflight/reports/ExpectedMigrationCountsRepository;", "unsupportedEntityRepository", "Lcom/atlassian/jira/migration/preflight/reports/UnsupportedEntityRepository;", "summaryReportOutput", "Lcom/atlassian/jira/migration/preflight/reports/SummaryReportOutput;", "executor", "Ljava/util/concurrent/Executor;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/preflight/reports/ExpectedMigrationCountsRepository;Lcom/atlassian/jira/migration/preflight/reports/UnsupportedEntityRepository;Lcom/atlassian/jira/migration/preflight/reports/SummaryReportOutput;Ljava/util/concurrent/Executor;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "reportType", "Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "getReportType", "()Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "buildCustomerCounts", "", "Lcom/atlassian/jira/migration/preflight/reports/ExpectedMigrationCounts;", "executionId", "", "customers", "Ljava/util/concurrent/CompletableFuture;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "buildGlobalEntityCounts", "allGlobalEntityMRIs", "", "Lcom/atlassian/migration/base/mri/MRI;", "buildProjectCounts", "allProjectsEntityCounts", "Lcom/atlassian/jira/migration/export/model/ExpectedProjectEntityTypeCount;", "buildUsersGroupsCounts", "usersGroupsResult", "calculateUnsupportedEntityTypeCounts", "", "Lkotlin/Pair;", "", "unsupportedEntities", "Lcom/atlassian/jira/migration/export/model/UnsupportedEntity;", "createReportRows", "Lcom/atlassian/jira/migration/preflight/reports/SummaryReportRow;", "deleteReportDataByExecutionId", "", "generateReportData", "usersAndGroups", "getProjectSpecificEntityTypesByProjectKey", "projectKey", "trackAnalytics", "globalEntityCounts", "updateIssueCounts", "actualUnsupportedCounts", "", "updatePortletCounts", "writeReportToStream", "outputStream", "Ljava/io/OutputStream;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nSummaryReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummaryReportService.kt\ncom/atlassian/jira/migration/preflight/reports/SummaryReportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,378:1\n1549#2:379\n1620#2,3:380\n1477#2:383\n1502#2,3:384\n1505#2,3:394\n1549#2:401\n1620#2,3:402\n1603#2,9:405\n1855#2:414\n1856#2:416\n1612#2:417\n1360#2:418\n1446#2,2:419\n1549#2:421\n1620#2,3:422\n1448#2,3:425\n1549#2:428\n1620#2,3:429\n766#2:432\n857#2,2:433\n1549#2:435\n1620#2,3:436\n1549#2:439\n1620#2,2:440\n1622#2:443\n766#2:444\n857#2,2:445\n1855#2,2:447\n766#2:449\n857#2,2:450\n1855#2:452\n1856#2:460\n1549#2:461\n1620#2,3:462\n1655#2,8:465\n1549#2:473\n1620#2,3:474\n1536#2:477\n372#3,7:387\n372#3,7:453\n125#4:397\n152#4,3:398\n1#5:415\n1#5:442\n*S KotlinDebug\n*F\n+ 1 SummaryReportService.kt\ncom/atlassian/jira/migration/preflight/reports/SummaryReportService\n*L\n151#1:379\n151#1:380,3\n161#1:383\n161#1:384,3\n161#1:394,3\n171#1:401\n171#1:402,3\n188#1:405,9\n188#1:414\n188#1:416\n188#1:417\n188#1:418\n188#1:419,2\n189#1:421\n189#1:422,3\n188#1:425,3\n192#1:428\n192#1:429,3\n194#1:432\n194#1:433,2\n194#1:435\n194#1:436,3\n195#1:439\n195#1:440,2\n195#1:443\n219#1:444\n219#1:445,2\n220#1:447,2\n236#1:449\n236#1:450,2\n237#1:452\n237#1:460\n253#1:461\n253#1:462,3\n256#1:465,8\n257#1:473\n257#1:474,3\n258#1:477\n161#1:387,7\n240#1:453,7\n163#1:397\n163#1:398,3\n188#1:415\n*E\n"})
public final class SummaryReportService
extends AbstractReportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExpectedMigrationCountsRepository expectedMigrationCountsRepository;
    @NotNull
    private final UnsupportedEntityRepository unsupportedEntityRepository;
    @NotNull
    private final SummaryReportOutput summaryReportOutput;
    @NotNull
    private final Executor executor;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ReportType reportType;
    @NotNull
    private static final List<String> projectSpecificEntityTypes;
    @NotNull
    private static final List<String> jsdProjectSpecificEntityTypes;
    @NotNull
    private static final List<String> jsmSpecificContents;
    @NotNull
    private static final List<String> globalEntityTypes;
    @NotNull
    private static final Set<String> entityTypesWithPartialCounts;
    @NotNull
    private static final Set<String> entityTypesWithFailCounts;
    @NotNull
    private static final Map<String, String> entityTypeToDisplayName;
    @NotNull
    private static final Map<ProblemType, String> unsupportedProblemTypeToSummaryEntity;

    @Inject
    public SummaryReportService(@NotNull MigrationReportStatusRepository reportStatusRepository, @NotNull MigrationEventBus migrationEventBus, @NotNull ExpectedMigrationCountsRepository expectedMigrationCountsRepository, @NotNull UnsupportedEntityRepository unsupportedEntityRepository, @NotNull SummaryReportOutput summaryReportOutput, @NotNull Executor executor, @NotNull ProjectManager projectManager, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)reportStatusRepository, (String)"reportStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)expectedMigrationCountsRepository, (String)"expectedMigrationCountsRepository");
        Intrinsics.checkNotNullParameter((Object)unsupportedEntityRepository, (String)"unsupportedEntityRepository");
        Intrinsics.checkNotNullParameter((Object)summaryReportOutput, (String)"summaryReportOutput");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        super(reportStatusRepository, migrationEventBus);
        this.expectedMigrationCountsRepository = expectedMigrationCountsRepository;
        this.unsupportedEntityRepository = unsupportedEntityRepository;
        this.summaryReportOutput = summaryReportOutput;
        this.executor = executor;
        this.projectManager = projectManager;
        this.migrationFeatures = migrationFeatures;
        this.reportType = ReportType.SUMMARY;
    }

    @Override
    @NotNull
    protected ReportType getReportType() {
        return this.reportType;
    }

    @Override
    public void writeReportToStream(@NotNull String executionId, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        List<SummaryReportRow> summaryReportRows = this.createReportRows(executionId);
        this.summaryReportOutput.write(outputStream, summaryReportRows);
    }

    public final void generateReportData(@NotNull String executionId, @NotNull List<ExpectedProjectEntityTypeCount> allProjectsEntityCounts, @NotNull Set<MRI> allGlobalEntityMRIs, @NotNull CompletableFuture<UsersGroupsExtractionResult> usersAndGroups, @Nullable CompletableFuture<UsersGroupsExtractionResult> customers) {
        CompletableFuture<Object> completableFuture;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(allProjectsEntityCounts, (String)"allProjectsEntityCounts");
        Intrinsics.checkNotNullParameter(allGlobalEntityMRIs, (String)"allGlobalEntityMRIs");
        Intrinsics.checkNotNullParameter(usersAndGroups, (String)"usersAndGroups");
        if (customers == null) {
            completableFuture = usersAndGroups;
        } else {
            CompletableFuture[] completableFutureArray = new CompletableFuture[]{usersAndGroups, customers};
            completableFuture = CompletableFuture.allOf(completableFutureArray);
        }
        CompletableFuture<UsersGroupsExtractionResult> userGroupCustomerFuture = completableFuture;
        ((CompletableFuture)userGroupCustomerFuture.thenApplyAsync(arg_0 -> SummaryReportService.generateReportData$lambda$0(this, executionId, allGlobalEntityMRIs, allProjectsEntityCounts, usersAndGroups, customers, arg_0), this.executor)).exceptionally(arg_0 -> SummaryReportService.generateReportData$lambda$1(this, executionId, arg_0));
    }

    private final List<ExpectedMigrationCounts> buildUsersGroupsCounts(String executionId, UsersGroupsExtractionResult usersGroupsResult) {
        Object[] objectArray = new ExpectedMigrationCounts[]{new ExpectedMigrationCounts(executionId, null, MigrationCoreMriRegistry.INSTANCE.getUser().getType(), usersGroupsResult.getUsersWithReferences().getUsers().size()), new ExpectedMigrationCounts(executionId, null, MigrationCoreMriRegistry.INSTANCE.getGroup().getType(), usersGroupsResult.getGroupsWithReferences().getGroups().size())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<ExpectedMigrationCounts> buildCustomerCounts(String executionId, CompletableFuture<UsersGroupsExtractionResult> customers) {
        return customers == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new ExpectedMigrationCounts(executionId, null, "Customers", customers.get().getUsersWithReferences().getUsers().size()));
    }

    /*
     * WARNING - void declaration
     */
    private final void trackAnalytics(String executionId, List<ExpectedMigrationCounts> globalEntityCounts) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = globalEntityCounts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExpectedMigrationCounts expectedMigrationCounts = (ExpectedMigrationCounts)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SummaryEntityCount(it.getEntityType(), (int)it.getEntityTypeCount()));
        }
        List analyticsCounts = (List)destination$iv$iv;
        this.getMigrationEventBus().post(new SummaryEntitiesCalculatedEvent(executionId, analyticsCounts));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ExpectedMigrationCounts> buildGlobalEntityCounts(String executionId, Set<MRI> allGlobalEntityMRIs) {
        void $this$mapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = allGlobalEntityMRIs;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            MRI it = (MRI)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getEntityType();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            String entityType = (String)entry.getKey();
            List mris = (List)entry.getValue();
            object.add(new ExpectedMigrationCounts(executionId, null, entityType, mris.size()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ExpectedMigrationCounts> buildProjectCounts(String executionId, List<ExpectedProjectEntityTypeCount> allProjectsEntityCounts) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = allProjectsEntityCounts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void projectEntityTypeCount;
            ExpectedProjectEntityTypeCount expectedProjectEntityTypeCount = (ExpectedProjectEntityTypeCount)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ExpectedMigrationCounts(executionId, projectEntityTypeCount.getProjectKey(), projectEntityTypeCount.getEntityType().getType(), projectEntityTypeCount.getCount()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SummaryReportRow> createReportRows(String executionId) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$flatMapTo$iv$iv;
        Object it;
        Iterable $this$mapNotNullTo$iv$iv;
        List<ExpectedMigrationCounts> summaries = this.expectedMigrationCountsRepository.findByExecutionId(executionId);
        List<UnsupportedEntity> unsupportedEntities = this.unsupportedEntityRepository.findByExecutionId(executionId);
        Map<Pair<String, String>, Integer> unsupportedCounts = this.calculateUnsupportedEntityTypeCounts(unsupportedEntities);
        Map actualUnsupportedCounts = MapsKt.toMutableMap(unsupportedCounts);
        this.updatePortletCounts(actualUnsupportedCounts, unsupportedEntities);
        this.updateIssueCounts(actualUnsupportedCounts, unsupportedEntities);
        Iterable $this$mapNotNull$iv = summaries;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            it = (ExpectedMigrationCounts)element$iv$iv;
            boolean bl2 = false;
            if (((ExpectedMigrationCounts)it).getProjectKey() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            String projectKey = (String)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = this.getProjectSpecificEntityTypesByProjectKey(projectKey);
            boolean $i$f$map = false;
            it = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                collection2.add(TuplesKt.to((Object)it2, (Object)projectKey));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List projectSpecific = (List)destination$iv$iv;
        Iterable $this$map$iv3 = globalEntityTypes;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv3;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl5 = false;
            collection.add(TuplesKt.to((Object)it3, null));
        }
        List globals = (List)destination$iv$iv3;
        Iterable $this$filter$iv = summaries;
        boolean $i$f$filter = false;
        destination$iv$iv3 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExpectedMigrationCounts it4 = (ExpectedMigrationCounts)element$iv$iv;
            boolean bl = false;
            if (!jsmSpecificContents.contains(it4.getEntityType())) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv4;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ExpectedMigrationCounts it4 = (ExpectedMigrationCounts)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it4.getEntityType(), null));
        }
        List jsmEntity = (List)destination$iv$iv4;
        $this$map$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)projectSpecific, (Iterable)globals), (Iterable)jsmEntity);
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ExpectedMigrationCounts summaryForType;
            Object v0;
            String projectKey;
            String entityType;
            block9: {
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl = false;
                entityType = (String)pair.component1();
                projectKey = (String)pair.component2();
                Iterable $i$f$mapTo3 = summaries;
                for (Object t : $i$f$mapTo3) {
                    ExpectedMigrationCounts summary = (ExpectedMigrationCounts)t;
                    boolean bl6 = false;
                    if (!(Intrinsics.areEqual((Object)summary.getEntityType(), (Object)entityType) && Intrinsics.areEqual((Object)summary.getProjectKey(), (Object)projectKey))) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            ExpectedMigrationCounts expectedMigrationCounts = summaryForType = (ExpectedMigrationCounts)v0;
            Integer n = (Integer)actualUnsupportedCounts.get(new Pair((Object)entityType, (Object)(expectedMigrationCounts != null ? expectedMigrationCounts.getProjectKey() : null)));
            int unsupportedCount = n != null ? n : 0;
            Long expectedPartial = entityTypesWithPartialCounts.contains(entityType) ? Long.valueOf(unsupportedCount) : null;
            long expectedFail = entityTypesWithFailCounts.contains(entityType) ? (long)unsupportedCount : 0L;
            ExpectedMigrationCounts expectedMigrationCounts2 = summaryForType;
            long total = (expectedMigrationCounts2 != null ? expectedMigrationCounts2.getEntityTypeCount() : 0L) + (Intrinsics.areEqual((Object)entityType, (Object)MigrationCoreMriRegistry.INSTANCE.getUser().getType()) ? 0L : expectedFail);
            ExpectedMigrationCounts expectedMigrationCounts3 = summaryForType;
            long expectedSuccessful = (expectedMigrationCounts3 != null ? expectedMigrationCounts3.getEntityTypeCount() : 0L) - (Intrinsics.areEqual((Object)entityType, (Object)MigrationCoreMriRegistry.INSTANCE.getUser().getType()) ? expectedFail : 0L);
            String string = entityTypeToDisplayName.get(entityType);
            if (string == null) {
                string = "";
            }
            collection.add(new SummaryReportRow(string, projectKey, total, expectedSuccessful, expectedPartial, expectedFail));
        }
        return (List)destination$iv$iv4;
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePortletCounts(Map<Pair<String, String>, Integer> actualUnsupportedCounts, List<UnsupportedEntity> unsupportedEntities) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        int count2 = 0;
        Iterable iterable = unsupportedEntities;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UnsupportedEntity it = (UnsupportedEntity)element$iv$iv;
            boolean bl = false;
            if (!(ModelKt.getProblemType(it) == ProblemType.UNSUPPORTED_PORTLET_CONFIGURATION)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnsupportedEntity it = (UnsupportedEntity)element$iv;
            boolean bl = false;
            if (it.getReferencedBy() == null) {
                ++count2;
                continue;
            }
            count2 += StringExtensionsKt.splitBy(it.getReferencedBy(), ",").size();
        }
        actualUnsupportedCounts.put((Pair<String, String>)new Pair((Object)PortletConfiguration.Companion.getEntityType().getType(), null), count2);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateIssueCounts(Map<Pair<String, String>, Integer> actualUnsupportedCounts, List<UnsupportedEntity> unsupportedEntities) {
        if (this.migrationFeatures.getEnableAggregateUnsupportedCustomFieldValue()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = unsupportedEntities;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UnsupportedEntity it = (UnsupportedEntity)element$iv$iv;
                boolean bl = false;
                if (!(ModelKt.getProblemType(it) == ProblemType.CUSTOM_FIELD_VALUE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UnsupportedEntity it = (UnsupportedEntity)element$iv;
                boolean bl = false;
                Integer n = it.getCount();
                if (n != null) {
                    Integer n2;
                    int count2 = ((Number)n).intValue();
                    boolean bl2 = false;
                    Pair key = new Pair((Object)Issue.Companion.getEntityType().getType(), (Object)it.getProjectKey());
                    Map<Pair<String, String>, Integer> $this$getOrPut$iv = actualUnsupportedCounts;
                    boolean $i$f$getOrPut = false;
                    Integer value$iv = $this$getOrPut$iv.get(key);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        Integer answer$iv = 1;
                        $this$getOrPut$iv.put((Pair<String, String>)key, answer$iv);
                        n2 = answer$iv;
                    } else {
                        n2 = value$iv;
                    }
                    int existingCount = ((Number)n2).intValue();
                    actualUnsupportedCounts.put((Pair<String, String>)key, existingCount + count2 - 1);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Pair<String, String>, Integer> calculateUnsupportedEntityTypeCounts(List<UnsupportedEntity> unsupportedEntities) {
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = unsupportedEntities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UnsupportedEntity unsupportedEntity = (UnsupportedEntity)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triple((Object)it.getImpactedEntityId(), (Object)unsupportedProblemTypeToSummaryEntity.get((Object)ModelKt.getProblemType((UnsupportedEntity)it)), (Object)it.getProjectKey()));
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        Iterable<Triple> set$iv = new HashSet();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Triple it = (Triple)e$iv;
            boolean bl = false;
            Triple key$iv = it;
            if (!((HashSet)set$iv).add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$map$iv = list$iv;
        $i$f$map = false;
        set$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Triple bl = (Triple)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new Pair(it.getSecond(), it.getThird()));
        }
        Iterable $this$groupingBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupingBy = false;
        return GroupingKt.eachCount((Grouping)((Grouping)new Grouping<Pair<? extends String, ? extends String>, Pair<? extends String, ? extends String>>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<Pair<? extends String, ? extends String>> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                Pair it = (Pair)element;
                boolean bl = false;
                return var2_2;
            }
        }));
    }

    @NotNull
    public final List<String> getProjectSpecificEntityTypesByProjectKey(@Nullable String projectKey) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        if (project != null) {
            String string = project.getProjectTypeKey().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            if (JsdExportUtil.Companion.isJsdProjectEligibleForMigration(string)) {
                return CollectionsKt.plus((Collection)projectSpecificEntityTypes, (Iterable)jsdProjectSpecificEntityTypes);
            }
        }
        return projectSpecificEntityTypes;
    }

    public final void deleteReportDataByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.expectedMigrationCountsRepository.deleteByExecutionId(executionId);
    }

    private static final Unit generateReportData$lambda$0(SummaryReportService this$0, String $executionId, Set $allGlobalEntityMRIs, List $allProjectsEntityCounts, CompletableFuture $usersAndGroups, CompletableFuture $customers, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)$allGlobalEntityMRIs, (String)"$allGlobalEntityMRIs");
        Intrinsics.checkNotNullParameter((Object)$allProjectsEntityCounts, (String)"$allProjectsEntityCounts");
        Intrinsics.checkNotNullParameter((Object)$usersAndGroups, (String)"$usersAndGroups");
        try {
            List<ExpectedMigrationCounts> globalEntityCounts = this$0.buildGlobalEntityCounts($executionId, $allGlobalEntityMRIs);
            this$0.trackAnalytics($executionId, globalEntityCounts);
            ExpectedMigrationCountsRepository expectedMigrationCountsRepository = this$0.expectedMigrationCountsRepository;
            Collection collection = this$0.buildProjectCounts($executionId, $allProjectsEntityCounts);
            Object t = $usersAndGroups.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            expectedMigrationCountsRepository.saveOrReplaceAll($executionId, CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)this$0.buildUsersGroupsCounts($executionId, (UsersGroupsExtractionResult)t)), (Iterable)this$0.buildCustomerCounts($executionId, $customers)), (Iterable)globalEntityCounts));
            AbstractReportService.setReportGenerationCompleted$default(this$0, $executionId, null, 2, null);
        }
        catch (Exception e) {
            AbstractReportService.setReportGenerationFailed$default(this$0, $executionId, e, null, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateReportData$lambda$1(SummaryReportService this$0, String $executionId, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        AbstractReportService abstractReportService = this$0;
        Intrinsics.checkNotNull((Object)it);
        AbstractReportService.setReportGenerationFailed$default(abstractReportService, $executionId, it, null, 4, null);
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{Issue.Companion.getEntityType().getType(), FileAttachment.Companion.getEntityType().getType()};
        projectSpecificEntityTypes = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{Queue.Companion.getEntityType().getType(), AutomationRules.Companion.getEntityType().getType(), TimeMetric.Companion.getEntityType().getType(), Calendar.Companion.getEntityType().getType(), RequestType.Companion.getEntityType().getType(), Report.Companion.getEntityType().getType()};
        jsdProjectSpecificEntityTypes = CollectionsKt.listOf((Object[])objectArray);
        jsmSpecificContents = CollectionsKt.listOf((Object)"Customers");
        objectArray = new String[]{MigrationCoreMriRegistry.INSTANCE.getUser().getType(), MigrationCoreMriRegistry.INSTANCE.getGroup().getType(), Plan.Companion.getEntityType().getType(), RapidView.Companion.getEntityType().getType(), CustomField.Companion.getEntityType().getType(), NotificationScheme.Companion.getEntityType().getType(), PermissionScheme.Companion.getEntityType().getType(), ProjectRole.Companion.getEntityType().getType(), Workflow.Companion.getEntityType().getType(), PortalPage.Companion.getEntityType().getType(), PortletConfiguration.Companion.getEntityType().getType(), Filter.Companion.getEntityType().getType()};
        globalEntityTypes = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{Issue.Companion.getEntityType().getType(), Workflow.Companion.getEntityType().getType(), PortalPage.Companion.getEntityType().getType()};
        entityTypesWithPartialCounts = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{MigrationCoreMriRegistry.INSTANCE.getUser().getType(), CustomField.Companion.getEntityType().getType(), RapidView.Companion.getEntityType().getType(), NotificationScheme.Companion.getEntityType().getType(), PortletConfiguration.Companion.getEntityType().getType(), Filter.Companion.getEntityType().getType()};
        entityTypesWithFailCounts = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)Issue.Companion.getEntityType().getType(), (Object)"Issues"), TuplesKt.to((Object)FileAttachment.Companion.getEntityType().getType(), (Object)"Attachments"), TuplesKt.to((Object)Workflow.Companion.getEntityType().getType(), (Object)"Workflows"), TuplesKt.to((Object)CustomField.Companion.getEntityType().getType(), (Object)"Custom fields"), TuplesKt.to((Object)RapidView.Companion.getEntityType().getType(), (Object)"Boards"), TuplesKt.to((Object)PermissionScheme.Companion.getEntityType().getType(), (Object)"Permission schemes"), TuplesKt.to((Object)ProjectRole.Companion.getEntityType().getType(), (Object)"Roles"), TuplesKt.to((Object)NotificationScheme.Companion.getEntityType().getType(), (Object)"Notification schemes"), TuplesKt.to((Object)MigrationCoreMriRegistry.INSTANCE.getUser().getType(), (Object)"Users"), TuplesKt.to((Object)MigrationCoreMriRegistry.INSTANCE.getGroup().getType(), (Object)"Groups"), TuplesKt.to((Object)"Customers", (Object)"Customers"), TuplesKt.to((Object)Queue.Companion.getEntityType().getType(), (Object)"Queue"), TuplesKt.to((Object)AutomationRules.Companion.getEntityType().getType(), (Object)"Automation rules"), TuplesKt.to((Object)TimeMetric.Companion.getEntityType().getType(), (Object)"SLAs"), TuplesKt.to((Object)Calendar.Companion.getEntityType().getType(), (Object)"Calendars"), TuplesKt.to((Object)RequestType.Companion.getEntityType().getType(), (Object)"Request Types"), TuplesKt.to((Object)Report.Companion.getEntityType().getType(), (Object)"Reports"), TuplesKt.to((Object)Plan.Companion.getEntityType().getType(), (Object)"Advanced Roadmaps plans"), TuplesKt.to((Object)PortalPage.Companion.getEntityType().getType(), (Object)"Dashboards"), TuplesKt.to((Object)PortletConfiguration.Companion.getEntityType().getType(), (Object)"Gadgets"), TuplesKt.to((Object)Filter.Companion.getEntityType().getType(), (Object)"Filters")};
        entityTypeToDisplayName = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)((Object)ProblemType.CUSTOM_FIELD_VALUE), (Object)Issue.Companion.getEntityType().getType()), TuplesKt.to((Object)((Object)ProblemType.WORKFLOW_CONDITION), (Object)Workflow.Companion.getEntityType().getType()), TuplesKt.to((Object)((Object)ProblemType.WORKFLOW_VALIDATOR), (Object)Workflow.Companion.getEntityType().getType()), TuplesKt.to((Object)((Object)ProblemType.WORKFLOW_POST_FUNCTION), (Object)Workflow.Companion.getEntityType().getType()), TuplesKt.to((Object)((Object)ProblemType.CUSTOM_FIELD_CONFIG), (Object)CustomField.Companion.getEntityType().getType()), TuplesKt.to((Object)((Object)ProblemType.CROSS_PROJECT_BOARD), (Object)RapidView.Companion.getEntityType().getType()), TuplesKt.to((Object)((Object)ProblemType.NOTIFICATION_SCHEME), (Object)NotificationScheme.Companion.getEntityType().getType()), TuplesKt.to((Object)((Object)ProblemType.USER), (Object)MigrationCoreMriRegistry.INSTANCE.getUser().getType()), TuplesKt.to((Object)((Object)ProblemType.UNSUPPORTED_PORTLET_CONFIGURATION), (Object)PortletConfiguration.Companion.getEntityType().getType())};
        unsupportedProblemTypeToSummaryEntity = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/SummaryReportService$Companion;", "", "()V", "entityTypeToDisplayName", "", "", "getEntityTypeToDisplayName", "()Ljava/util/Map;", "entityTypesWithFailCounts", "", "getEntityTypesWithFailCounts", "()Ljava/util/Set;", "entityTypesWithPartialCounts", "getEntityTypesWithPartialCounts", "globalEntityTypes", "", "getGlobalEntityTypes", "()Ljava/util/List;", "jsdProjectSpecificEntityTypes", "getJsdProjectSpecificEntityTypes", "jsmSpecificContents", "getJsmSpecificContents", "projectSpecificEntityTypes", "getProjectSpecificEntityTypes", "unsupportedProblemTypeToSummaryEntity", "Lcom/atlassian/jira/migration/preflight/reports/ProblemType;", "getUnsupportedProblemTypeToSummaryEntity", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getProjectSpecificEntityTypes() {
            return projectSpecificEntityTypes;
        }

        @NotNull
        public final List<String> getJsdProjectSpecificEntityTypes() {
            return jsdProjectSpecificEntityTypes;
        }

        @NotNull
        public final List<String> getJsmSpecificContents() {
            return jsmSpecificContents;
        }

        @NotNull
        public final List<String> getGlobalEntityTypes() {
            return globalEntityTypes;
        }

        @NotNull
        public final Set<String> getEntityTypesWithPartialCounts() {
            return entityTypesWithPartialCounts;
        }

        @NotNull
        public final Set<String> getEntityTypesWithFailCounts() {
            return entityTypesWithFailCounts;
        }

        @NotNull
        public final Map<String, String> getEntityTypeToDisplayName() {
            return entityTypeToDisplayName;
        }

        @NotNull
        public final Map<ProblemType, String> getUnsupportedProblemTypeToSummaryEntity() {
            return unsupportedProblemTypeToSummaryEntity;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

