/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.TableRecordsDeletedEvent;
import com.atlassian.jira.migration.events.TableRecordsInsertedEvent;
import com.atlassian.jira.migration.export.model.UnsupportedEntity;
import com.atlassian.jira.migration.preflight.reports.UnsupportedEntityTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/UnsupportedEntityRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "deleteByExecutionId", "", "executionId", "", "findByExecutionId", "", "Lcom/atlassian/jira/migration/export/model/UnsupportedEntity;", "saveOrReplaceAll", "unsupportedEntities", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUnsupportedEntityRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsupportedEntityRepository.kt\ncom/atlassian/jira/migration/preflight/reports/UnsupportedEntityRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1855#2,2:186\n1549#2:188\n1620#2,3:189\n*S KotlinDebug\n*F\n+ 1 UnsupportedEntityRepository.kt\ncom/atlassian/jira/migration/preflight/reports/UnsupportedEntityRepository\n*L\n44#1:186,2\n91#1:188\n91#1:189,3\n*E\n"})
public final class UnsupportedEntityRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private static final Logger log = LoggerFactory.getLogger(UnsupportedEntityRepository.class);
    @NotNull
    private static final String ANALYTICS_TABLE_NAME = "unsupportedEntity";

    @Inject
    public UnsupportedEntityRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.databaseAccessor = databaseAccessor;
        this.migrationEventBus = migrationEventBus;
    }

    public final void saveOrReplaceAll(@NotNull String executionId, @NotNull List<UnsupportedEntity> unsupportedEntities) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter(unsupportedEntities, (String)"unsupportedEntities");
        try {
            Ref.LongRef numberOfRecordsDeleted = new Ref.LongRef();
            Long numberOfRecordsInserted = (Long)this.databaseAccessor.run(arg_0 -> UnsupportedEntityRepository.saveOrReplaceAll$lambda$2(numberOfRecordsDeleted, executionId, unsupportedEntities, arg_0), UnsupportedEntityRepository::saveOrReplaceAll$lambda$3);
            this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsDeleted.element));
            Intrinsics.checkNotNull((Object)numberOfRecordsInserted);
            this.migrationEventBus.post(new TableRecordsInsertedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsInserted));
        }
        catch (RuntimeException e) {
            log.error("Could not save unsupported entities.", (Throwable)e);
        }
    }

    @NotNull
    public final List<UnsupportedEntity> findByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        NumberExpression impactedEntityTypeOrder = (NumberExpression)new CaseBuilder().when((Predicate)UnsupportedEntityTable.INSTANCE.getPROBLEM_TYPE_AND_DETAILS().startsWith("ARCHIVED_ISSUES")).then((Number)0).when((Predicate)UnsupportedEntityTable.INSTANCE.getPROBLEM_TYPE_AND_DETAILS().startsWith("CROSS_PROJECT_BOARD")).then((Object)1).when((Predicate)UnsupportedEntityTable.INSTANCE.getPROBLEM_TYPE_AND_DETAILS().startsWith("CUSTOM_FIELD_CONFIG")).then((Object)2).when((Predicate)UnsupportedEntityTable.INSTANCE.getPROBLEM_TYPE_AND_DETAILS().startsWith("CUSTOM_FIELD_VALUE")).then((Object)3).when((Predicate)UnsupportedEntityTable.INSTANCE.getPROBLEM_TYPE_AND_DETAILS().startsWith("ISSUE_TYPE")).then((Object)4).when((Predicate)UnsupportedEntityTable.INSTANCE.getPROBLEM_TYPE_AND_DETAILS().startsWith("NOTIFICATION_SCHEME")).then((Object)5).when((Predicate)UnsupportedEntityTable.INSTANCE.getPROBLEM_TYPE_AND_DETAILS().startsWith("WORKFLOW_CONDITION")).then((Object)6).when((Predicate)UnsupportedEntityTable.INSTANCE.getPROBLEM_TYPE_AND_DETAILS().startsWith("WORKFLOW_VALIDATOR")).then((Object)6).when((Predicate)UnsupportedEntityTable.INSTANCE.getPROBLEM_TYPE_AND_DETAILS().startsWith("WORKFLOW_POST_FUNCTION")).then((Object)6).otherwise((Object)99);
        Object object = this.databaseAccessor.run(arg_0 -> UnsupportedEntityRepository.findByExecutionId$lambda$4(executionId, impactedEntityTypeOrder, arg_0), UnsupportedEntityRepository::findByExecutionId$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    public final void deleteByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        try {
            Long numberOfRecordsDeleted = (Long)this.databaseAccessor.run(arg_0 -> UnsupportedEntityRepository.deleteByExecutionId$lambda$6(executionId, arg_0), UnsupportedEntityRepository::deleteByExecutionId$lambda$7);
            Intrinsics.checkNotNull((Object)numberOfRecordsDeleted);
            this.migrationEventBus.post(new TableRecordsDeletedEvent(ANALYTICS_TABLE_NAME, executionId, numberOfRecordsDeleted));
        }
        catch (RuntimeException e) {
            log.error("Could not delete unsupported entities by executionId: " + executionId + '.', (Throwable)e);
        }
    }

    private static final Long saveOrReplaceAll$lambda$2(Ref.LongRef $numberOfRecordsDeleted, String $executionId, List $unsupportedEntities, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$numberOfRecordsDeleted, (String)"$numberOfRecordsDeleted");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)$unsupportedEntities, (String)"$unsupportedEntities");
        $numberOfRecordsDeleted.element = db.delete((RelationalPath)UnsupportedEntityTable.INSTANCE).where((Predicate)UnsupportedEntityTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
        if (!((Collection)$unsupportedEntities).isEmpty()) {
            SQLInsertClause sQLInsertClause;
            SQLInsertClause $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241 = sQLInsertClause = db.insert((RelationalPath)UnsupportedEntityTable.INSTANCE);
            boolean bl = false;
            Iterable $this$forEach$iv = $unsupportedEntities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UnsupportedEntity it = (UnsupportedEntity)element$iv;
                boolean bl2 = false;
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)UnsupportedEntityTable.INSTANCE.getEXECUTION_ID(), (Object)$executionId);
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)UnsupportedEntityTable.INSTANCE.getPROJECT_KEY(), (Object)it.getProjectKey());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)UnsupportedEntityTable.INSTANCE.getIMPACTED_ENTITY_ID(), (Object)it.getImpactedEntityId());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)UnsupportedEntityTable.INSTANCE.getIMPACTED_ENTITY_NAME(), (Object)it.getImpactedEntityName());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)UnsupportedEntityTable.INSTANCE.getPROBLEM_TYPE_AND_DETAILS(), (Object)it.getProblemTypeAndDetails());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)UnsupportedEntityTable.INSTANCE.getPROBLEM_ENTITY_NAME(), (Object)it.getProblemEntityName());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)UnsupportedEntityTable.INSTANCE.getREFERENCED_BY(), (Object)it.getReferencedBy());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.set((Path)UnsupportedEntityTable.INSTANCE.getCOUNT(), (Object)it.getCount());
                $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.addBatch();
            }
            $this$saveOrReplaceAll_u24lambda_u242_u24lambda_u241.execute();
        }
        return $unsupportedEntities.size();
    }

    private static final void saveOrReplaceAll$lambda$3() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List findByExecutionId$lambda$4(String $executionId, NumberExpression $impactedEntityTypeOrder, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Object object = UnsupportedEntityTable.INSTANCE.all();
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)UnsupportedEntityTable.INSTANCE)).where((Predicate)UnsupportedEntityTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId));
        object = new OrderSpecifier[]{$impactedEntityTypeOrder.asc(), UnsupportedEntityTable.INSTANCE.getIMPACTED_ENTITY_NAME().asc()};
        List list = ((SQLQuery)sQLQuery.orderBy((OrderSpecifier[])object)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = UnsupportedEntityTable.INSTANCE;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((UnsupportedEntityTable)((Object)object)).toUnsupportedEntity((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void findByExecutionId$lambda$5() {
    }

    private static final Long deleteByExecutionId$lambda$6(String $executionId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        return db.delete((RelationalPath)UnsupportedEntityTable.INSTANCE).where((Predicate)UnsupportedEntityTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
    }

    private static final void deleteByExecutionId$lambda$7() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/UnsupportedEntityRepository$Companion;", "", "()V", "ANALYTICS_TABLE_NAME", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

